/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import gnu.java.locale.LocaleHelper;
import gnu.java.text.CharacterBreakIterator;
import gnu.java.text.LineBreakIterator;
import gnu.java.text.SentenceBreakIterator;
import gnu.java.text.WordBreakIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.text.spi.BreakIteratorProvider;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.ServiceLoader;

public abstract class BreakIterator
implements Cloneable {
    public static final int DONE = -1;

    protected BreakIterator() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public abstract int current();

    public abstract int first();

    public abstract int following(int var1);

    public static synchronized Locale[] getAvailableLocales() {
        Locale[] l = new Locale[]{Locale.US};
        return l;
    }

    private static BreakIterator getInstance(String type, Locale loc) {
        String className;
        try {
            ResourceBundle res = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", loc, ClassLoader.getSystemClassLoader());
            className = res.getString(type);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
        try {
            Class<?> k = Class.forName(className);
            return (BreakIterator)k.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public static BreakIterator getCharacterInstance() {
        return BreakIterator.getCharacterInstance(Locale.getDefault());
    }

    public static BreakIterator getCharacterInstance(Locale locale) {
        BreakIterator r = BreakIterator.getInstance("CharacterIterator", locale);
        if (r != null) {
            return r;
        }
        block0: for (BreakIteratorProvider p : ServiceLoader.load(BreakIteratorProvider.class)) {
            Locale[] localeArray = p.getAvailableLocales();
            int n = localeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Locale loc = localeArray[n2];
                if (loc.equals(locale)) {
                    BreakIterator bi = p.getCharacterInstance(locale);
                    if (bi == null) continue block0;
                    return bi;
                }
                ++n2;
            }
        }
        if (locale.equals(Locale.ROOT)) {
            return new CharacterBreakIterator();
        }
        return BreakIterator.getCharacterInstance(LocaleHelper.getFallbackLocale(locale));
    }

    public static BreakIterator getLineInstance() {
        return BreakIterator.getLineInstance(Locale.getDefault());
    }

    public static BreakIterator getLineInstance(Locale locale) {
        BreakIterator r = BreakIterator.getInstance("LineIterator", locale);
        if (r != null) {
            return r;
        }
        block0: for (BreakIteratorProvider p : ServiceLoader.load(BreakIteratorProvider.class)) {
            Locale[] localeArray = p.getAvailableLocales();
            int n = localeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Locale loc = localeArray[n2];
                if (loc.equals(locale)) {
                    BreakIterator bi = p.getLineInstance(locale);
                    if (bi == null) continue block0;
                    return bi;
                }
                ++n2;
            }
        }
        if (locale.equals(Locale.ROOT)) {
            return new LineBreakIterator();
        }
        return BreakIterator.getLineInstance(LocaleHelper.getFallbackLocale(locale));
    }

    public static BreakIterator getSentenceInstance() {
        return BreakIterator.getSentenceInstance(Locale.getDefault());
    }

    public static BreakIterator getSentenceInstance(Locale locale) {
        BreakIterator r = BreakIterator.getInstance("SentenceIterator", locale);
        if (r != null) {
            return r;
        }
        block0: for (BreakIteratorProvider p : ServiceLoader.load(BreakIteratorProvider.class)) {
            Locale[] localeArray = p.getAvailableLocales();
            int n = localeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Locale loc = localeArray[n2];
                if (loc.equals(locale)) {
                    BreakIterator bi = p.getSentenceInstance(locale);
                    if (bi == null) continue block0;
                    return bi;
                }
                ++n2;
            }
        }
        if (locale.equals(Locale.ROOT)) {
            return new SentenceBreakIterator();
        }
        return BreakIterator.getSentenceInstance(LocaleHelper.getFallbackLocale(locale));
    }

    public abstract CharacterIterator getText();

    public static BreakIterator getWordInstance() {
        return BreakIterator.getWordInstance(Locale.getDefault());
    }

    public static BreakIterator getWordInstance(Locale locale) {
        BreakIterator r = BreakIterator.getInstance("WordIterator", locale);
        if (r != null) {
            return r;
        }
        block0: for (BreakIteratorProvider p : ServiceLoader.load(BreakIteratorProvider.class)) {
            Locale[] localeArray = p.getAvailableLocales();
            int n = localeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Locale loc = localeArray[n2];
                if (loc.equals(locale)) {
                    BreakIterator bi = p.getWordInstance(locale);
                    if (bi == null) continue block0;
                    return bi;
                }
                ++n2;
            }
        }
        if (locale.equals(Locale.ROOT)) {
            return new WordBreakIterator();
        }
        return BreakIterator.getWordInstance(LocaleHelper.getFallbackLocale(locale));
    }

    public boolean isBoundary(int pos) {
        if (pos == 0) {
            return true;
        }
        return this.following(pos - 1) == pos;
    }

    public abstract int last();

    public abstract int next();

    public abstract int next(int var1);

    public int preceding(int pos) {
        if (this.following(pos) == -1) {
            this.last();
        }
        while (this.previous() >= pos) {
        }
        return this.current();
    }

    public abstract int previous();

    public void setText(String newText) {
        this.setText(new StringCharacterIterator(newText));
    }

    public abstract void setText(CharacterIterator var1);
}

