/*
 * Decompiled with CFR 0.152.
 */
package java.awt.color;

import gnu.java.awt.color.ProfileHeader;
import gnu.java.awt.color.TagEntry;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_ProfileGray;
import java.awt.color.ICC_ProfileRGB;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Hashtable;

public class ICC_Profile
implements Serializable {
    private static final long serialVersionUID = -3938515861990936766L;
    public static final int CLASS_INPUT = 0;
    public static final int CLASS_DISPLAY = 1;
    public static final int CLASS_OUTPUT = 2;
    public static final int CLASS_DEVICELINK = 3;
    public static final int CLASS_COLORSPACECONVERSION = 4;
    public static final int CLASS_ABSTRACT = 5;
    public static final int CLASS_NAMEDCOLOR = 6;
    public static final int icSigInputClass = 1935896178;
    public static final int icSigDisplayClass = 1835955314;
    public static final int icSigOutputClass = 1886549106;
    public static final int icSigLinkClass = 1818848875;
    public static final int icSigColorSpaceClass = 1936744803;
    public static final int icSigAbstractClass = 1633842036;
    public static final int icSigNamedColorClass = 1852662636;
    public static final int icSigXYZData = 1482250784;
    public static final int icSigLabData = 1281450528;
    public static final int icSigLuvData = 1282766368;
    public static final int icSigYCbCrData = 1497588338;
    public static final int icSigYxyData = 1501067552;
    public static final int icSigRgbData = 1380401696;
    public static final int icSigGrayData = 1196573017;
    public static final int icSigHsvData = 1213421088;
    public static final int icSigHlsData = 1212961568;
    public static final int icSigCmykData = 1129142603;
    public static final int icSigCmyData = 1129142560;
    public static final int icSigSpace2CLR = 843271250;
    public static final int icSigSpace3CLR = 860048466;
    public static final int icSigSpace4CLR = 876825682;
    public static final int icSigSpace5CLR = 893602898;
    public static final int icSigSpace6CLR = 910380114;
    public static final int icSigSpace7CLR = 927157330;
    public static final int icSigSpace8CLR = 943934546;
    public static final int icSigSpace9CLR = 960711762;
    public static final int icSigSpaceACLR = 1094929490;
    public static final int icSigSpaceBCLR = 1111706706;
    public static final int icSigSpaceCCLR = 1128483922;
    public static final int icSigSpaceDCLR = 1145261138;
    public static final int icSigSpaceECLR = 1162038354;
    public static final int icSigSpaceFCLR = 1178815570;
    public static final int icPerceptual = 0;
    public static final int icRelativeColorimetric = 1;
    public static final int icSaturation = 2;
    public static final int icAbsoluteColorimetric = 3;
    public static final int icSigAToB0Tag = 1093812784;
    public static final int icSigAToB1Tag = 1093812785;
    public static final int icSigAToB2Tag = 1093812786;
    public static final int icSigBlueColorantTag = 1649957210;
    public static final int icSigBlueTRCTag = 1649693251;
    public static final int icSigBToA0Tag = 1110589744;
    public static final int icSigBToA1Tag = 1110589745;
    public static final int icSigBToA2Tag = 1110589746;
    public static final int icSigCalibrationDateTimeTag = 1667329140;
    public static final int icSigCharTargetTag = 1952543335;
    public static final int icSigCopyrightTag = 1668313716;
    public static final int icSigCrdInfoTag = 1668441193;
    public static final int icSigDeviceMfgDescTag = 1684893284;
    public static final int icSigDeviceModelDescTag = 0x646D6464;
    public static final int icSigDeviceSettingsTag = 1684371059;
    public static final int icSigGamutTag = 1734438260;
    public static final int icSigGrayTRCTag = 1800688195;
    public static final int icSigGreenColorantTag = 1733843290;
    public static final int icSigGreenTRCTag = 1733579331;
    public static final int icSigLuminanceTag = 1819635049;
    public static final int icSigMeasurementTag = 1835360627;
    public static final int icSigMediaBlackPointTag = 1651208308;
    public static final int icSigMediaWhitePointTag = 0x77747074;
    public static final int icSigNamedColor2Tag = 1852009522;
    public static final int icSigOutputResponseTag = 1919251312;
    public static final int icSigPreview0Tag = 1886545200;
    public static final int icSigPreview1Tag = 1886545201;
    public static final int icSigPreview2Tag = 1886545202;
    public static final int icSigProfileDescriptionTag = 1684370275;
    public static final int icSigProfileSequenceDescTag = 1886610801;
    public static final int icSigPs2CRD0Tag = 1886610480;
    public static final int icSigPs2CRD1Tag = 1886610481;
    public static final int icSigPs2CRD2Tag = 1886610482;
    public static final int icSigPs2CRD3Tag = 1886610483;
    public static final int icSigPs2CSATag = 1886597747;
    public static final int icSigPs2RenderingIntentTag = 1886597737;
    public static final int icSigRedColorantTag = 1918392666;
    public static final int icSigRedTRCTag = 1918128707;
    public static final int icSigScreeningDescTag = 1935897188;
    public static final int icSigScreeningTag = 1935897198;
    public static final int icSigTechnologyTag = 1952801640;
    public static final int icSigUcrBgTag = 1650877472;
    public static final int icSigViewingCondDescTag = 1987405156;
    public static final int icSigViewingConditionsTag = 1986618743;
    public static final int icSigChromaticityTag = 1667789421;
    public static final int icSigHead = 1751474532;
    public static final int icHdrSize = 0;
    public static final int icHdrCmmId = 4;
    public static final int icHdrVersion = 8;
    public static final int icHdrDeviceClass = 12;
    public static final int icHdrColorSpace = 16;
    public static final int icHdrPcs = 20;
    public static final int icHdrDate = 24;
    public static final int icHdrMagic = 36;
    public static final int icHdrPlatform = 40;
    public static final int icHdrFlags = 44;
    public static final int icHdrManufacturer = 48;
    public static final int icHdrModel = 52;
    public static final int icHdrAttributes = 56;
    public static final int icHdrRenderingIntent = 64;
    public static final int icHdrIlluminant = 68;
    public static final int icHdrCreator = 80;
    public static final int icTagType = 0;
    public static final int icTagReserved = 4;
    public static final int icCurveCount = 8;
    public static final int icCurveData = 12;
    public static final int icXYZNumberX = 8;
    private static final int tagTableOffset = 128;
    private static final int iccProfileSerializedDataVersion = 1;
    private static final String copyrightNotice = "Generated by GNU Classpath.";
    private static final int TRC_POINTS = 1024;
    private static final float[] D50 = new float[]{0.96422f, 1.0f, 0.82521f};
    private transient int profileID;
    private transient ProfileHeader header;
    private transient Hashtable tagTable;

    ICC_Profile(int profileID) {
        this.header = null;
        this.tagTable = null;
        this.createProfile(profileID);
    }

    ICC_Profile(ProfileHeader h, Hashtable tags) throws IllegalArgumentException {
        this.header = h;
        this.tagTable = tags;
        this.profileID = -1;
    }

    ICC_Profile(byte[] data) throws IllegalArgumentException {
        this.header = new ProfileHeader(data);
        this.header.verifyHeader(data.length);
        this.tagTable = ICC_Profile.createTagTable(data);
        this.profileID = -1;
    }

    protected void finalize() {
    }

    public static ICC_Profile getInstance(byte[] data) {
        ProfileHeader header = new ProfileHeader(data);
        header.verifyHeader(data.length);
        Hashtable tags = ICC_Profile.createTagTable(data);
        if (ICC_Profile.isRGBProfile(header, tags)) {
            return new ICC_ProfileRGB(data);
        }
        if (ICC_Profile.isGrayProfile(header, tags)) {
            return new ICC_ProfileGray(data);
        }
        return new ICC_Profile(header, tags);
    }

    public static ICC_Profile getInstance(int cspace) {
        if (cspace == 1000 || cspace == 1004) {
            return new ICC_ProfileRGB(cspace);
        }
        if (cspace == 1003) {
            return new ICC_ProfileGray(cspace);
        }
        return new ICC_Profile(cspace);
    }

    public static ICC_Profile getInstance(String filename) throws IOException {
        return ICC_Profile.getInstance(new FileInputStream(filename));
    }

    public static ICC_Profile getInstance(InputStream in) throws IOException {
        int totalBytes;
        byte[] headerData = new byte[128];
        if (in.read(headerData) != 128) {
            throw new IllegalArgumentException("Invalid profile header");
        }
        ProfileHeader header = new ProfileHeader(headerData);
        header.verifyHeader(-1);
        byte[] data = new byte[header.getSize()];
        System.arraycopy(headerData, 0, data, 0, 128);
        int bytesLeft = totalBytes = header.getSize() - 128;
        while (bytesLeft > 0) {
            int read = in.read(data, 128 + (totalBytes - bytesLeft), bytesLeft);
            bytesLeft -= read;
        }
        return ICC_Profile.getInstance(data);
    }

    public int getMajorVersion() {
        return this.header.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.header.getMinorVersion();
    }

    public int getProfileClass() {
        return this.header.getProfileClass();
    }

    public int getColorSpaceType() {
        return this.header.getColorSpace();
    }

    public int getPCSType() {
        return this.header.getProfileColorSpace();
    }

    public void write(String filename) throws IOException {
        FileOutputStream out = new FileOutputStream(filename);
        this.write(out);
        out.flush();
        out.close();
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.getData());
    }

    public byte[] getData() {
        int size = this.getSize();
        byte[] data = new byte[size];
        System.arraycopy(this.header.getData(size), 0, data, 0, 128);
        byte[] tt = this.getTagTable();
        System.arraycopy(tt, 0, data, 128, tt.length);
        Enumeration e = this.tagTable.elements();
        while (e.hasMoreElements()) {
            TagEntry tag = (TagEntry)e.nextElement();
            System.arraycopy(tag.getData(), 0, data, tag.getOffset(), tag.getSize());
        }
        return data;
    }

    public byte[] getData(int tagSignature) {
        if (tagSignature == 1751474532) {
            return this.header.getData(this.getSize());
        }
        TagEntry t = (TagEntry)this.tagTable.get(TagEntry.tagHashKey(tagSignature));
        if (t == null) {
            return null;
        }
        return t.getData();
    }

    public void setData(int tagSignature, byte[] data) {
        this.profileID = -1;
        if (tagSignature == 1751474532) {
            this.header = new ProfileHeader(data);
        } else {
            TagEntry t = new TagEntry(tagSignature, data);
            this.tagTable.put(t.hashKey(), t);
        }
    }

    public int getNumComponents() {
        int[] nArray = new int[50];
        nArray[0] = 5;
        nArray[1] = 3;
        nArray[2] = 11;
        nArray[3] = 3;
        nArray[4] = 9;
        nArray[5] = 4;
        nArray[6] = 6;
        nArray[7] = 1;
        nArray[8] = 3;
        nArray[9] = 3;
        nArray[11] = 3;
        nArray[12] = 1;
        nArray[13] = 3;
        nArray[14] = 7;
        nArray[15] = 3;
        nArray[16] = 12;
        nArray[17] = 2;
        nArray[18] = 2;
        nArray[19] = 3;
        nArray[20] = 4;
        nArray[21] = 3;
        nArray[22] = 8;
        nArray[23] = 3;
        nArray[24] = 13;
        nArray[25] = 3;
        nArray[26] = 14;
        nArray[27] = 4;
        nArray[28] = 15;
        nArray[29] = 5;
        nArray[30] = 16;
        nArray[31] = 6;
        nArray[32] = 17;
        nArray[33] = 7;
        nArray[34] = 18;
        nArray[35] = 8;
        nArray[36] = 19;
        nArray[37] = 9;
        nArray[38] = 20;
        nArray[39] = 10;
        nArray[40] = 21;
        nArray[41] = 11;
        nArray[42] = 22;
        nArray[43] = 12;
        nArray[44] = 23;
        nArray[45] = 13;
        nArray[46] = 24;
        nArray[47] = 14;
        nArray[48] = 25;
        nArray[49] = 15;
        int[] lookup = nArray;
        int i = 0;
        while (i < lookup.length) {
            if (this.header.getColorSpace() == lookup[i]) {
                return lookup[i + 1];
            }
            i += 2;
        }
        return 3;
    }

    protected Object readResolve() throws ObjectStreamException {
        if (ICC_Profile.isRGBProfile(this.header, this.tagTable)) {
            return new ICC_ProfileRGB(this.getData());
        }
        if (ICC_Profile.isGrayProfile(this.header, this.tagTable)) {
            return new ICC_ProfileGray(this.getData());
        }
        return this;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        String predef = (String)s.readObject();
        byte[] data = (byte[])s.readObject();
        if (data != null) {
            this.header = new ProfileHeader(data);
            this.tagTable = ICC_Profile.createTagTable(data);
            this.profileID = -1;
        }
        if (predef != null) {
            if ((predef = predef.intern()).equals("CS_sRGB")) {
                this.createProfile(1000);
            }
            if (predef.equals("CS_LINEAR_RGB")) {
                this.createProfile(1004);
            }
            if (predef.equals("CS_CIEXYZ")) {
                this.createProfile(1001);
            }
            if (predef.equals("CS_GRAY")) {
                this.createProfile(1003);
            }
            if (predef.equals("CS_PYCC")) {
                this.createProfile(1002);
            }
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.profileID == 1000) {
            s.writeObject("CS_sRGB");
        } else if (this.profileID == 1004) {
            s.writeObject("CS_LINEAR_RGB");
        } else if (this.profileID == 1001) {
            s.writeObject("CS_CIEXYZ");
        } else if (this.profileID == 1003) {
            s.writeObject("CS_GRAY");
        } else if (this.profileID == 1002) {
            s.writeObject("CS_PYCC");
        } else {
            s.writeObject(null);
            s.writeObject(this.getData());
            return;
        }
        s.writeObject(null);
    }

    private static Hashtable createTagTable(byte[] data) throws IllegalArgumentException {
        ByteBuffer buf = ByteBuffer.wrap(data);
        int nTags = buf.getInt(128);
        Hashtable<String, TagEntry> tagTable = new Hashtable<String, TagEntry>();
        int i = 0;
        while (i < nTags) {
            TagEntry te = new TagEntry(buf.getInt(128 + i * 12 + 4), buf.getInt(128 + i * 12 + 8), buf.getInt(128 + i * 12 + 12), data);
            if (tagTable.put(te.hashKey(), te) != null) {
                throw new IllegalArgumentException("Duplicate tag in profile:" + te);
            }
            ++i;
        }
        return tagTable;
    }

    private int getSize() {
        int totalSize = 128;
        int tagTableSize = 4 + this.tagTable.size() * 12;
        if ((tagTableSize & 3) != 0) {
            tagTableSize += 4 - (tagTableSize & 3);
        }
        totalSize += tagTableSize;
        Enumeration e = this.tagTable.elements();
        while (e.hasMoreElements()) {
            int tagSize = ((TagEntry)e.nextElement()).getSize();
            if ((tagSize & 3) != 0) {
                tagSize += 4 - (tagSize & 3);
            }
            totalSize += tagSize;
        }
        return totalSize;
    }

    private byte[] getTagTable() {
        int tagTableSize = 4 + this.tagTable.size() * 12;
        if ((tagTableSize & 3) != 0) {
            tagTableSize += 4 - (tagTableSize & 3);
        }
        int offset = 4;
        int tagOffset = 128 + tagTableSize;
        ByteBuffer buf = ByteBuffer.allocate(tagTableSize);
        buf.putInt(this.tagTable.size());
        Enumeration e = this.tagTable.elements();
        while (e.hasMoreElements()) {
            TagEntry tag = (TagEntry)e.nextElement();
            buf.putInt(offset, tag.getSignature());
            buf.putInt(offset + 4, tagOffset);
            buf.putInt(offset + 8, tag.getSize());
            tag.setOffset(tagOffset);
            int tagSize = tag.getSize();
            if ((tagSize & 3) != 0) {
                tagSize += 4 - (tagSize & 3);
            }
            tagOffset += tagSize;
            offset += 12;
        }
        return buf.array();
    }

    private static boolean isRGBProfile(ProfileHeader header, Hashtable tags) {
        if (header.getColorSpace() != 5) {
            return false;
        }
        if (tags.get(TagEntry.tagHashKey(1918392666)) == null) {
            return false;
        }
        if (tags.get(TagEntry.tagHashKey(1733843290)) == null) {
            return false;
        }
        if (tags.get(TagEntry.tagHashKey(1649957210)) == null) {
            return false;
        }
        if (tags.get(TagEntry.tagHashKey(1918128707)) == null) {
            return false;
        }
        if (tags.get(TagEntry.tagHashKey(1733579331)) == null) {
            return false;
        }
        if (tags.get(TagEntry.tagHashKey(1649693251)) == null) {
            return false;
        }
        return tags.get(TagEntry.tagHashKey(0x77747074)) != null;
    }

    private static boolean isGrayProfile(ProfileHeader header, Hashtable tags) {
        if (header.getColorSpace() != 6) {
            return false;
        }
        if (tags.get(TagEntry.tagHashKey(1800688195)) == null) {
            return false;
        }
        return tags.get(TagEntry.tagHashKey(0x77747074)) != null;
    }

    short[] getCurve(int signature) {
        byte[] data = this.getData(signature);
        if (data == null) {
            return null;
        }
        ByteBuffer buf = ByteBuffer.wrap(data);
        if (buf.getInt(0) != 1668641398) {
            return null;
        }
        int count = buf.getInt(8);
        if (count == 0) {
            short[] curve = new short[]{256};
            return curve;
        }
        if (count == 1) {
            short[] curve = new short[]{buf.getShort(12)};
            return curve;
        }
        short[] curve = new short[count];
        int i = 0;
        while (i < count) {
            curve[i] = buf.getShort(12 + i * 2);
            ++i;
        }
        return curve;
    }

    float[] getXYZData(int signature) {
        byte[] data = this.getData(signature);
        if (data == null) {
            return null;
        }
        ByteBuffer buf = ByteBuffer.wrap(data);
        if (buf.getInt(0) != 1482250784) {
            return null;
        }
        float[] point = new float[]{(float)buf.getInt(8) / 65536.0f, (float)buf.getInt(12) / 65536.0f, (float)buf.getInt(16) / 65536.0f};
        return point;
    }

    int isPredefined() {
        return this.profileID;
    }

    private byte[] makeXYZData(float[] values) {
        ByteBuffer buf = ByteBuffer.allocate(20);
        buf.putInt(0, 1482250784);
        buf.putInt(4, 0);
        buf.putInt(8, (int)((double)values[0] * 65536.0));
        buf.putInt(12, (int)((double)values[1] * 65536.0));
        buf.putInt(16, (int)((double)values[2] * 65536.0));
        return buf.array();
    }

    private byte[] makeTextTag(String text) {
        byte[] data;
        int length = text.length();
        ByteBuffer buf = ByteBuffer.allocate(8 + length + 1);
        try {
            data = text.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            data = new byte[length];
        }
        buf.putInt(0, 1952807028);
        buf.putInt(4, 0);
        int i = 0;
        while (i < length) {
            buf.put(8 + i, data[i]);
            ++i;
        }
        buf.put(8 + length, (byte)0);
        return buf.array();
    }

    private byte[] makeDescTag(String text) {
        byte[] data;
        int length = text.length();
        ByteBuffer buf = ByteBuffer.allocate(90 + length + 1);
        buf.putInt(0, 1684370275);
        buf.putInt(4, 0);
        buf.putInt(8, length + 1);
        try {
            data = text.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            data = new byte[length];
        }
        int i = 0;
        while (i < length) {
            buf.put(12 + i, data[i]);
            ++i;
        }
        buf.put(12 + length, (byte)0);
        i = 0;
        while (i < 39) {
            buf.putShort(13 + length + i * 2, (short)0);
            ++i;
        }
        return buf.array();
    }

    private byte[] makeTRC() {
        ByteBuffer buf = ByteBuffer.allocate(12);
        buf.putInt(0, 1668641398);
        buf.putInt(4, 0);
        buf.putInt(8, 0);
        return buf.array();
    }

    private byte[] makeTRC(float gamma) {
        short gammaValue = (short)(gamma * 256.0f);
        ByteBuffer buf = ByteBuffer.allocate(14);
        buf.putInt(0, 1668641398);
        buf.putInt(4, 0);
        buf.putInt(8, 1);
        buf.putShort(12, gammaValue);
        return buf.array();
    }

    private byte[] makeTRC(float[] trc) {
        ByteBuffer buf = ByteBuffer.allocate(12 + 2 * trc.length);
        buf.putInt(0, 1668641398);
        buf.putInt(4, 0);
        buf.putInt(8, trc.length);
        int i = 0;
        while (i < trc.length) {
            buf.putShort(12 + i * 2, (short)(trc[i] * 65535.0f));
            ++i;
        }
        return buf.array();
    }

    private byte[] makeIdentityClut() {
        ByteBuffer buf = ByteBuffer.allocate(27700);
        buf.putInt(0, 1835430962);
        buf.putInt(4, 0);
        buf.put(8, (byte)3);
        buf.put(9, (byte)3);
        buf.put(10, (byte)16);
        buf.put(11, (byte)0);
        buf.putInt(12, 65536);
        buf.putInt(16, 0);
        buf.putInt(20, 0);
        buf.putInt(24, 0);
        buf.putInt(28, 65536);
        buf.putInt(32, 0);
        buf.putInt(36, 0);
        buf.putInt(40, 0);
        buf.putInt(44, 65536);
        buf.putShort(48, (short)256);
        buf.putShort(50, (short)256);
        int channel = 0;
        while (channel < 3) {
            int i = 0;
            while (i < 256) {
                short n = (short)(i << 8 | i);
                buf.putShort(52 + (channel * 256 + i) * 2, n);
                ++i;
            }
            ++channel;
        }
        int clutOffset = 1588;
        int x = 0;
        while (x < 16) {
            int y = 0;
            while (y < 16) {
                int z = 0;
                while (z < 16) {
                    int offset = clutOffset + z * 2 * 3 + y * 16 * 2 * 3 + x * 16 * 16 * 2 * 3;
                    double xf = (double)x / 15.0;
                    double yf = (double)y / 15.0;
                    double zf = (double)z / 15.0;
                    buf.putShort(offset, (short)(xf * 65535.0));
                    buf.putShort(offset + 2, (short)(yf * 65535.0));
                    buf.putShort(offset + 4, (short)(zf * 65535.0));
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        int channel2 = 0;
        while (channel2 < 3) {
            int i = 0;
            while (i < 256) {
                short n = (short)(i << 8 | i);
                buf.putShort(clutOffset + 24576 + (channel2 * 256 + i) * 2, n);
                ++i;
            }
            ++channel2;
        }
        return buf.array();
    }

    private void createProfile(int colorSpace) throws IllegalArgumentException {
        this.profileID = colorSpace;
        this.header = new ProfileHeader();
        this.tagTable = new Hashtable();
        switch (colorSpace) {
            case 1000: {
                this.createRGBProfile();
                return;
            }
            case 1004: {
                this.createLinearRGBProfile();
                return;
            }
            case 1001: {
                this.createCIEProfile();
                return;
            }
            case 1003: {
                this.createGrayProfile();
                return;
            }
            case 1002: {
                this.createPyccProfile();
                return;
            }
        }
        throw new IllegalArgumentException("Not a predefined color space!");
    }

    private void createRGBProfile() {
        this.header.setColorSpace(5);
        this.header.setProfileColorSpace(0);
        ICC_ColorSpace cs = new ICC_ColorSpace(this);
        float[] r = new float[]{1.0f, 0.0f, 0.0f};
        float[] g = new float[]{0.0f, 1.0f, 0.0f};
        float[] b = new float[]{0.0f, 0.0f, 1.0f};
        float[] black = new float[]{0.0f, 0.0f, 0.0f};
        float[] white = D50;
        r = cs.toCIEXYZ(r);
        g = cs.toCIEXYZ(g);
        b = cs.toCIEXYZ(b);
        cs = new ICC_ColorSpace(ICC_Profile.getInstance(1004));
        float[] points = new float[1024];
        float[] in = new float[3];
        int i = 0;
        while (i < 1024) {
            in[1] = in[2] = (float)i / 1023.0f;
            in[0] = in[2];
            in = cs.fromRGB(in);
            points[i] = in[0];
            ++i;
        }
        this.setData(1918392666, this.makeXYZData(r));
        this.setData(1733843290, this.makeXYZData(g));
        this.setData(1649957210, this.makeXYZData(b));
        this.setData(0x77747074, this.makeXYZData(white));
        this.setData(1651208308, this.makeXYZData(black));
        this.setData(1918128707, this.makeTRC(points));
        this.setData(1733579331, this.makeTRC(points));
        this.setData(1649693251, this.makeTRC(points));
        this.setData(1668313716, this.makeTextTag(copyrightNotice));
        this.setData(1684370275, this.makeDescTag("Generic sRGB"));
        this.profileID = 1000;
    }

    private void createLinearRGBProfile() {
        this.header.setColorSpace(5);
        this.header.setProfileColorSpace(0);
        ICC_ColorSpace cs = new ICC_ColorSpace(this);
        float[] r = new float[]{1.0f, 0.0f, 0.0f};
        float[] g = new float[]{0.0f, 1.0f, 0.0f};
        float[] b = new float[]{0.0f, 0.0f, 1.0f};
        float[] black = new float[]{0.0f, 0.0f, 0.0f};
        float[] white = D50;
        r = cs.toCIEXYZ(r);
        g = cs.toCIEXYZ(g);
        b = cs.toCIEXYZ(b);
        this.setData(1918392666, this.makeXYZData(r));
        this.setData(1733843290, this.makeXYZData(g));
        this.setData(1649957210, this.makeXYZData(b));
        this.setData(0x77747074, this.makeXYZData(white));
        this.setData(1651208308, this.makeXYZData(black));
        this.setData(1918128707, this.makeTRC());
        this.setData(1733579331, this.makeTRC());
        this.setData(1649693251, this.makeTRC());
        this.setData(1668313716, this.makeTextTag(copyrightNotice));
        this.setData(1684370275, this.makeDescTag("Linear RGB"));
        this.profileID = 1004;
    }

    private void createCIEProfile() {
        this.header.setColorSpace(0);
        this.header.setProfileColorSpace(0);
        this.header.setProfileClass(4);
        new ICC_ColorSpace(this);
        float[] white = D50;
        this.setData(0x77747074, this.makeXYZData(white));
        this.setData(1093812784, this.makeIdentityClut());
        this.setData(1110589744, this.makeIdentityClut());
        this.setData(1668313716, this.makeTextTag(copyrightNotice));
        this.setData(1684370275, this.makeDescTag("CIE XYZ identity profile"));
        this.profileID = 1001;
    }

    private void createGrayProfile() {
        this.header.setColorSpace(6);
        this.header.setProfileColorSpace(0);
        float[] white = D50;
        this.setData(0x77747074, this.makeXYZData(white));
        this.setData(1800688195, this.makeTRC(1.0f));
        this.setData(1668313716, this.makeTextTag(copyrightNotice));
        this.setData(1684370275, this.makeDescTag("Linear grayscale"));
        this.profileID = 1003;
    }

    private void createPyccProfile() {
        this.header.setColorSpace(13);
        this.header.setProfileColorSpace(0);
        this.setData(1668313716, this.makeTextTag(copyrightNotice));
        this.setData(1684370275, this.makeDescTag("Photo YCC"));
        this.profileID = 1002;
    }
}

