/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.keyring;

import gnu.javax.crypto.keyring.BaseKeyring;
import gnu.javax.crypto.keyring.CertPathEntry;
import gnu.javax.crypto.keyring.CompressedEntry;
import gnu.javax.crypto.keyring.Entry;
import gnu.javax.crypto.keyring.IPrivateKeyring;
import gnu.javax.crypto.keyring.MalformedKeyringException;
import gnu.javax.crypto.keyring.PasswordAuthenticatedEntry;
import gnu.javax.crypto.keyring.PasswordEncryptedEntry;
import gnu.javax.crypto.keyring.PrivateKeyEntry;
import gnu.javax.crypto.keyring.Properties;
import gnu.javax.crypto.keyring.PublicKeyEntry;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Logger;

public class GnuPrivateKeyring
extends BaseKeyring
implements IPrivateKeyring {
    private static final Logger log = Logger.getLogger(GnuPrivateKeyring.class.getName());
    public static final int USAGE = 3;
    protected String mac;
    protected int maclen;
    protected String cipher;
    protected String mode;
    protected int keylen;

    public GnuPrivateKeyring(String mac, int maclen, String cipher, String mode, int keylen) {
        this.keyring = new PasswordAuthenticatedEntry(mac, maclen, new Properties());
        this.keyring2 = new CompressedEntry(new Properties());
        this.keyring.add(this.keyring2);
        this.mac = mac;
        this.maclen = maclen;
        this.cipher = cipher;
        this.mode = mode;
        this.keylen = keylen;
    }

    public GnuPrivateKeyring() {
        this("HMAC-SHA-1", 20, "AES", "OFB", 16);
    }

    public boolean containsPrivateKey(String alias) {
        boolean result = false;
        if (this.containsAlias(alias)) {
            Iterator it = this.get(alias).iterator();
            while (it.hasNext()) {
                if (!(it.next() instanceof PasswordAuthenticatedEntry)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public Key getPrivateKey(String alias, char[] password) throws UnrecoverableKeyException {
        Key result = null;
        if (this.containsAlias(alias)) {
            PasswordAuthenticatedEntry e1 = null;
            for (Entry e : this.get(alias)) {
                if (!(e instanceof PasswordAuthenticatedEntry)) continue;
                e1 = (PasswordAuthenticatedEntry)e;
                break;
            }
            if (e1 != null) {
                try {
                    e1.verify(password);
                }
                catch (Exception exception) {
                    throw new UnrecoverableKeyException("authentication failed");
                }
                PasswordEncryptedEntry e2 = null;
                for (Entry e : e1.getEntries()) {
                    if (!(e instanceof PasswordEncryptedEntry)) continue;
                    e2 = (PasswordEncryptedEntry)e;
                    break;
                }
                if (e2 != null) {
                    try {
                        e2.decrypt(password);
                    }
                    catch (Exception e) {
                        log.throwing(this.getClass().getName(), "getPrivateKey", e);
                        throw new UnrecoverableKeyException("decryption failed");
                    }
                    for (Entry e : e2.get(alias)) {
                        if (!(e instanceof PrivateKeyEntry)) continue;
                        result = ((PrivateKeyEntry)e).getKey();
                        break;
                    }
                }
            }
        }
        return result;
    }

    public void putPrivateKey(String alias, Key key, char[] password) {
        if (!this.containsPrivateKey(alias)) {
            alias = this.fixAlias(alias);
            Properties p = new Properties();
            p.put("alias", alias);
            PrivateKeyEntry pke = new PrivateKeyEntry(key, new Date(), p);
            PasswordEncryptedEntry enc = new PasswordEncryptedEntry(this.cipher, this.mode, this.keylen, new Properties());
            enc.add(pke);
            try {
                enc.encode(null, password);
            }
            catch (IOException x) {
                throw new IllegalArgumentException(x.toString());
            }
            PasswordAuthenticatedEntry auth = new PasswordAuthenticatedEntry(this.mac, this.maclen, new Properties());
            auth.add(enc);
            try {
                auth.encode(null, password);
            }
            catch (IOException x) {
                throw new IllegalArgumentException(x.toString());
            }
            this.keyring.add(auth);
        }
    }

    public boolean containsPublicKey(String alias) {
        boolean result = false;
        if (this.containsAlias(alias)) {
            Iterator it = this.get(alias).iterator();
            while (it.hasNext()) {
                if (!(it.next() instanceof PublicKeyEntry)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public PublicKey getPublicKey(String alias) {
        PublicKey result = null;
        if (this.containsAlias(alias)) {
            for (Entry e : this.get(alias)) {
                if (!(e instanceof PublicKeyEntry)) continue;
                result = ((PublicKeyEntry)e).getKey();
                break;
            }
        }
        return result;
    }

    public void putPublicKey(String alias, PublicKey key) {
        if (!this.containsPublicKey(alias)) {
            Properties p = new Properties();
            p.put("alias", this.fixAlias(alias));
            this.add(new PublicKeyEntry(key, new Date(), p));
        }
    }

    public boolean containsCertPath(String alias) {
        boolean result = false;
        if (this.containsAlias(alias)) {
            Iterator it = this.get(alias).iterator();
            while (it.hasNext()) {
                if (!(it.next() instanceof CertPathEntry)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public Certificate[] getCertPath(String alias) {
        Certificate[] result = null;
        if (this.containsAlias(alias)) {
            for (Entry e : this.get(alias)) {
                if (!(e instanceof CertPathEntry)) continue;
                result = ((CertPathEntry)e).getCertPath();
                break;
            }
        }
        return result;
    }

    public void putCertPath(String alias, Certificate[] path) {
        if (!this.containsCertPath(alias)) {
            Properties p = new Properties();
            p.put("alias", this.fixAlias(alias));
            this.add(new CertPathEntry(path, new Date(), p));
        }
    }

    protected void load(InputStream in, char[] password) throws IOException {
        if (in.read() != 3) {
            throw new MalformedKeyringException("incompatible keyring usage");
        }
        if (in.read() != 3) {
            throw new MalformedKeyringException("expecting password-authenticated entry tag");
        }
        this.keyring = PasswordAuthenticatedEntry.decode(new DataInputStream(in), password);
    }

    protected void store(OutputStream out, char[] password) throws IOException {
        out.write(3);
        this.keyring.encode(new DataOutputStream(out), password);
    }
}

