/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.xlib;

import gnu.gcj.RawData;
import gnu.gcj.xlib.Colormap;
import gnu.gcj.xlib.Display;
import gnu.gcj.xlib.Visual;
import gnu.gcj.xlib.Window;

public final class Screen {
    static final int UNKNOWN = -1;
    Display display;
    int screenNumber = -1;
    RawData structure;

    Screen(Display display, RawData screenStructure) {
        this.structure = screenStructure;
        this.display = display;
    }

    public Screen(Display display) {
        this(display, display.getDefaultScreenNumber());
    }

    public Screen(Display display, int screenNumber) {
        this.display = display;
        this.screenNumber = screenNumber;
        this.initStructure();
    }

    public final Display getDisplay() {
        return this.display;
    }

    public Window getRootWindow() {
        int rootXID = this.getRootWindowXID();
        return this.display.getWindow(rootXID);
    }

    public Visual getRootVisual() {
        RawData visualStructure = this.getRootVisualStructure();
        int depth = this.getRootDepth();
        return new Visual(visualStructure, this, depth);
    }

    private native RawData getRootVisualStructure();

    public native int getRootDepth();

    public native int getRootWindowXID();

    public native int getDefaultColormapXID();

    native void initStructure();

    public Colormap getDefaultColormap() {
        return new Colormap(this, this.getDefaultColormapXID());
    }

    public final int getScreenNumber() {
        if (this.screenNumber == -1) {
            this.screenNumber = this.findScreenNumber();
        }
        return this.screenNumber;
    }

    public native int findScreenNumber();
}

