#if !defined  HAVE_FXTALLOCA_H__
#define       HAVE_FXTALLOCA_H__
// This file is part of the FXT library.
// Copyright (C) 2010, 2012, 2021 Joerg Arndt
// License: GNU General Public License version 3 or later,
// see the file COPYING.txt in the main directory.


// define to force use of alloca.h:
//#define FORCE_ALLOCA_H

#ifdef CLANG  // llvm/clang needs alloca.h:
#define FORCE_ALLOCA_H
#endif

#undef ALLOCA

#ifdef FORCE_ALLOCA_H
#include <alloca.h>
//#include <stdlib.h>  // for BSD
#define ALLOCA(Type, v, n)  Type *v = (Type *)alloca((n)*sizeof(Type))
#else
#define ALLOCA(Type, v, n)  Type v[n]
#endif

#endif  // !defined HAVE_FXTALLOCA_H__

