/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.nc.executors;

import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.experimental.ConnectionType;
import org.flywaydb.core.experimental.ExperimentalDatabase;
import org.flywaydb.core.internal.sqlscript.SqlStatement;
import org.flywaydb.nc.executors.Executor;

public class JdbcExecutor
implements Executor<SqlStatement> {
    private static final Log LOG = LogFactory.getLog(JdbcExecutor.class);

    @Override
    public void execute(ExperimentalDatabase experimentalDatabase, SqlStatement executionUnit, Configuration configuration) {
        if (configuration.isBatch()) {
            if (executionUnit.isBatchable()) {
                experimentalDatabase.addToBatch(executionUnit.getSql());
                if (experimentalDatabase.getBatchSize() >= 100) {
                    experimentalDatabase.doExecuteBatch();
                }
            } else {
                experimentalDatabase.doExecuteBatch();
                experimentalDatabase.doExecute((Object)executionUnit.getSql(), configuration.isOutputQueryResults());
            }
        } else {
            experimentalDatabase.doExecute((Object)executionUnit.getSql(), configuration.isOutputQueryResults());
        }
    }

    @Override
    public void finishExecution(ExperimentalDatabase experimentalDatabase, Configuration configuration) {
        if (configuration.isBatch()) {
            experimentalDatabase.doExecuteBatch();
        }
    }

    @Override
    public boolean canExecute(ConnectionType connectionType) {
        return connectionType == ConnectionType.JDBC;
    }

    @Override
    public void appendErrorMessage(SqlStatement executionUnit, StringBuilder messageBuilder, boolean isDebugEnabled) {
        messageBuilder.append("Line       : ").append(executionUnit.getLineNumber()).append("\n");
        messageBuilder.append("Statement  : ").append(isDebugEnabled ? executionUnit.getSql() : "Run Flyway with -X option to see the actual statement causing the problem").append("\n");
    }
}

