/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.hivecommon.core;

import com.databricks.client.dsi.core.impl.DSILogger;
import com.databricks.client.dsi.core.utilities.Variant;
import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.hivecommon.api.HiveServer2BaseBuffer;
import com.databricks.client.hivecommon.api.IHiveClientFactory;
import com.databricks.client.hivecommon.exceptions.HiveJDBCMessageKey;
import com.databricks.client.hivecommon.model.TypeCoercionMap;
import com.databricks.client.hivecommon.querytranslation.IQueryGenerator;
import com.databricks.client.hivecommon.querytranslation.IQueryTranslator;
import com.databricks.client.jdbc.core.DSDriver;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TColumnDesc;
import com.databricks.client.sqlengine.SQLEngineGenericContext;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.exceptions.ErrorException;
import com.databricks.client.support.exceptions.ExceptionBuilder;
import com.databricks.client.support.exceptions.ExceptionUtilities;
import java.text.MessageFormat;
import java.util.List;

public abstract class HiveJDBCCommonDriver
extends DSDriver {
    public static final String DRIVER_NAME = "DatabricksJDBC";
    public static final int DRIVER_MAJOR_VERSION = 2;
    public static final int DRIVER_MINOR_VERSION = 7;
    public static final int DRIVER_HOT_FIX_VERSION = 1;
    public static final int DRIVER_BUILD_NUMBER = Integer.parseInt("1004");
    public static final String RESOURCE_NAME = "messages";
    public static ExceptionBuilder s_HiveMessages = new ExceptionBuilder(101);
    public static TypeCoercionMap[] s_typeCoercionMapping;
    private DSILogger m_log;
    private String m_componentName;
    private String m_catalogName;

    protected HiveJDBCCommonDriver(String string, String string2, String string3) throws ErrorException {
        super(string);
        this.m_componentName = string;
        this.m_catalogName = string2;
        this.m_log = new DSILogger(string3);
        this.setDefaultProperties();
        StringBuilder stringBuilder = new StringBuilder(ExceptionUtilities.getPackageName(this.getHiveCommonDriverClass()));
        stringBuilder.append(".");
        stringBuilder.append(RESOURCE_NAME);
        this.m_msgSrc.registerMessages(stringBuilder.toString(), 101, this.m_componentName);
        this.m_msgSrc.setVendorName("Databricks");
        SQLEngineGenericContext.setDefaultMsgSource(this.m_msgSrc);
        this.setCustomTypeCoercion();
    }

    public HiveServer2BaseBuffer createArrowBuffer(ILogger iLogger, List<TColumnDesc> list, boolean bl, HiveJDBCSettings hiveJDBCSettings) throws ErrorException {
        throw s_HiveMessages.createGeneralException(HiveJDBCMessageKey.ARROW_NOT_SUPPORTED.name());
    }

    public String getCatalogName() {
        return this.m_catalogName;
    }

    public abstract IHiveClientFactory getClientFactory();

    public String getComponentName() {
        return this.m_componentName;
    }

    @Override
    public DSILogger getDriverLog() {
        return this.m_log;
    }

    public abstract IQueryGenerator getQueryGenerator();

    public abstract IQueryTranslator getQueryTranslator();

    public void setCustomTypeCoercion() {
        s_typeCoercionMapping = null;
    }

    public boolean supportsArrowSerialization() {
        return false;
    }

    public void unload() {
        this.m_log = null;
    }

    protected Class<?> getHiveCommonDriverClass() {
        return this.getClass().getSuperclass();
    }

    private void setDefaultProperties() throws ErrorException {
        try {
            this.setProperty(3, new Variant(0, DRIVER_NAME));
            String string = MessageFormat.format("{0,number,00}.{1,number,00}.{2,number,00}.{3,number,0000}", 2, 7, 1, DRIVER_BUILD_NUMBER);
            this.setProperty(5, new Variant(0, string));
            this.setProperty(10, new Variant(6, 1));
            this.setProperty(1000, new Variant(5, (short)1));
        }
        catch (Throwable throwable) {
            throw s_HiveMessages.createGeneralException(HiveJDBCMessageKey.DRIVER_DEFAULT_PROP_ERR.name());
        }
    }
}

