/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.sql.TIMESTAMPTZ;

public final class OsonPrimitiveConversions {
    private static final int HUNDIGMAX = 66;
    private static final int BIGINTARRAYMAX = 54;
    private static final int BIGLENMAX = 22;
    private static final byte DIGEND = 21;
    private static final int LNXSGNBT = 128;
    private static final byte LNXDIGS = 20;
    private static final int LNXBASE = 100;
    private static final int LNXEXPMX = 127;
    private static final byte LNXEXPBS = 64;
    private static final int LNXEXPMN = 0;
    private static final byte ODIGEND = 9;
    private static final byte MAX_LONG_BASE100_DIGITS = 9;
    public static int SIZE_TIMESTAMP = 11;
    public static int SIZE_TIMESTAMP_NOFRAC = 7;
    public static int SIZE_DATE = 7;
    public static int SIZE_TIMESTAMPTZ = 13;
    static int OFFSET_HOUR = 20;
    static int OFFSET_MINUTE = 60;
    private static byte REGIONIDBIT = (byte)-128;
    private static final int MAXYEAR = 9999;
    static final int INTERVAL_BYTE_OFFSET = 60;
    static final int INTERVAL_INT_OFFSET = Integer.MIN_VALUE;
    static final int SECONDS_PER_DAY = 86400;
    static final int HOURS_PER_DAY = 24;
    static final int MINUTES_PER_HOUR = 60;
    static final int SECONDS_PER_MINUTE = 60;

    private static int nanos(byte[] byArray) {
        int n2 = byArray.length == SIZE_TIMESTAMP_NOFRAC ? 0 : OsonPrimitiveConversions.getNanos(byArray, 7);
        return n2;
    }

    private static void yearError(OracleJsonExceptions.ExceptionFactory exceptionFactory, int n2) {
        if (n2 < 1 || n2 > 9999) {
            throw OracleJsonExceptions.BAD_YEAR.create(exceptionFactory, n2);
        }
    }

    public static boolean isPosInf(byte[] byArray) {
        return OsonPrimitiveConversions._isInf(byArray);
    }

    public static boolean isNegInf(byte[] byArray, int n2, int n3) {
        if (n2 != 1) {
            return false;
        }
        return byArray[n3] == 0;
    }

    private static void appendInt(StringBuilder stringBuilder, int n2, int n3) {
        if (n2 < 0) {
            stringBuilder.append("-");
            n2 = -n2;
        }
        int n4 = n2;
        while (n4 > 0) {
            n4 /= 10;
            --n3;
        }
        while (n3 > 0) {
            stringBuilder.append('0');
            --n3;
        }
        if (n2 != 0) {
            stringBuilder.append(n2);
        }
    }

    public static String timestampToString(OracleJsonExceptions.ExceptionFactory exceptionFactory, byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(27);
        int n2 = OsonPrimitiveConversions.getJavaYear(byArray[0] & 0xFF, byArray[1] & 0xFF);
        OsonPrimitiveConversions.yearError(exceptionFactory, n2);
        int n3 = byArray[2] & 0xFF;
        int n4 = byArray[3] & 0xFF;
        int n5 = (byArray[4] & 0xFF) - 1;
        int n6 = (byArray[5] & 0xFF) - 1;
        int n7 = (byArray[6] & 0xFF) - 1;
        int n8 = OsonPrimitiveConversions.nanos(byArray);
        OsonPrimitiveConversions.isoTimestamp(stringBuilder, false, n2, n3, n4, n5, n6, n7, n8);
        return stringBuilder.toString();
    }

    private static void isoTimestamp(StringBuilder stringBuilder, boolean bl, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        OsonPrimitiveConversions.appendInt(stringBuilder, n2, 4);
        stringBuilder.append("-");
        OsonPrimitiveConversions.appendInt(stringBuilder, n3, 2);
        stringBuilder.append("-");
        OsonPrimitiveConversions.appendInt(stringBuilder, n4, 2);
        stringBuilder.append("T");
        OsonPrimitiveConversions.appendInt(stringBuilder, n5, 2);
        stringBuilder.append(":");
        OsonPrimitiveConversions.appendInt(stringBuilder, n6, 2);
        stringBuilder.append(":");
        OsonPrimitiveConversions.appendInt(stringBuilder, n7, 2);
        if (n8 > 0 || bl) {
            stringBuilder.append(".");
            if (n8 % 1000 > 0) {
                OsonPrimitiveConversions.appendInt(stringBuilder, n8, 9);
            } else {
                OsonPrimitiveConversions.appendInt(stringBuilder, (int)TimeUnit.NANOSECONDS.toMicros(n8), 6);
            }
        }
    }

    public static String timestampTZToString(OracleJsonExceptions.ExceptionFactory exceptionFactory, byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        OffsetDateTime offsetDateTime = OsonPrimitiveConversions.timestamptzToOffsetDateTime(exceptionFactory, byArray);
        int n2 = offsetDateTime.getYear();
        int n3 = offsetDateTime.getMonthValue();
        int n4 = offsetDateTime.getDayOfMonth();
        int n5 = offsetDateTime.getHour();
        int n6 = offsetDateTime.getMinute();
        int n7 = offsetDateTime.getSecond();
        int n8 = offsetDateTime.getNano();
        OsonPrimitiveConversions.isoTimestamp(stringBuilder, true, n2, n3, n4, n5, n6, n7, n8);
        ZoneOffset zoneOffset = offsetDateTime.getOffset();
        int n9 = Math.abs(zoneOffset.getTotalSeconds());
        int n10 = n9 / 3600;
        int n11 = n9 % 3600 / 60;
        if (n10 == 0 && n11 == 0) {
            stringBuilder.append("Z");
            return stringBuilder.toString();
        }
        if (zoneOffset.getTotalSeconds() < 0) {
            stringBuilder.append("-");
        } else {
            stringBuilder.append("+");
        }
        OsonPrimitiveConversions.appendInt(stringBuilder, n10, 2);
        stringBuilder.append(":");
        OsonPrimitiveConversions.appendInt(stringBuilder, n11, 2);
        return stringBuilder.toString();
    }

    public static void assertNoRegionTimestampTZ(OracleJsonExceptions.ExceptionFactory exceptionFactory, byte[] byArray) {
        if ((byArray[11] & REGIONIDBIT) != 0) {
            throw OracleJsonExceptions.BAD_TIMESTAMP_TZ.create(exceptionFactory, new Object[0]);
        }
    }

    public static OffsetDateTime timestamptzToOffsetDateTime(OracleJsonExceptions.ExceptionFactory exceptionFactory, byte[] byArray) {
        OsonPrimitiveConversions.assertNoRegionTimestampTZ(exceptionFactory, byArray);
        LocalDateTime localDateTime = OsonPrimitiveConversions.timestampToLocalDateTime(exceptionFactory, byArray);
        OffsetDateTime offsetDateTime = OffsetDateTime.of(localDateTime, ZoneOffset.UTC);
        int n2 = byArray[11] - OFFSET_HOUR;
        int n3 = Math.abs(byArray[12] - OFFSET_MINUTE);
        ZoneOffset zoneOffset = ZoneOffset.ofHoursMinutes(n2, (int)Math.signum(n2) * n3);
        return offsetDateTime.withOffsetSameInstant(zoneOffset);
    }

    public static byte[] toOracleTimestampTZ(OracleJsonExceptions.ExceptionFactory exceptionFactory, OffsetDateTime offsetDateTime) {
        try {
            Timestamp timestamp = Timestamp.from(offsetDateTime.toInstant());
            return TIMESTAMPTZ.toBytes(null, timestamp, (ZoneId)offsetDateTime.getOffset());
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException(sQLException);
        }
    }

    public static LocalDateTime dateToLocalDateTime(OracleJsonExceptions.ExceptionFactory exceptionFactory, byte[] byArray) {
        int n2 = OsonPrimitiveConversions.getJavaYear(byArray[0] & 0xFF, byArray[1] & 0xFF);
        OsonPrimitiveConversions.yearError(exceptionFactory, n2);
        int n3 = byArray[2] & 0xFF;
        int n4 = byArray[3] & 0xFF;
        int n5 = (byArray[4] & 0xFF) - 1;
        int n6 = (byArray[5] & 0xFF) - 1;
        int n7 = (byArray[6] & 0xFF) - 1;
        return LocalDateTime.of(n2, n3, n4, n5, n6, n7);
    }

    public static LocalDateTime timestampToLocalDateTime(OracleJsonExceptions.ExceptionFactory exceptionFactory, byte[] byArray) {
        int n2 = OsonPrimitiveConversions.getJavaYear(byArray[0] & 0xFF, byArray[1] & 0xFF);
        OsonPrimitiveConversions.yearError(exceptionFactory, n2);
        int n3 = byArray[2] & 0xFF;
        int n4 = byArray[3] & 0xFF;
        int n5 = (byArray[4] & 0xFF) - 1;
        int n6 = (byArray[5] & 0xFF) - 1;
        int n7 = (byArray[6] & 0xFF) - 1;
        int n8 = OsonPrimitiveConversions.nanos(byArray);
        return LocalDateTime.of(n2, n3, n4, n5, n6, n7, n8);
    }

    public static byte[] toOracleDate(OracleJsonExceptions.ExceptionFactory exceptionFactory, LocalDateTime localDateTime) {
        int n2 = localDateTime.getYear();
        OsonPrimitiveConversions.yearError(exceptionFactory, n2);
        byte[] byArray = new byte[SIZE_DATE];
        byArray[0] = (byte)(n2 / 100 + 100);
        byArray[1] = (byte)(n2 % 100 + 100);
        byArray[2] = (byte)localDateTime.getMonthValue();
        byArray[3] = (byte)localDateTime.getDayOfMonth();
        byArray[4] = (byte)(localDateTime.getHour() + 1);
        byArray[5] = (byte)(localDateTime.getMinute() + 1);
        byArray[6] = (byte)(localDateTime.getSecond() + 1);
        return byArray;
    }

    public static byte[] toOracleTimestamp(OracleJsonExceptions.ExceptionFactory exceptionFactory, LocalDateTime localDateTime) {
        int n2 = localDateTime.getYear();
        OsonPrimitiveConversions.yearError(exceptionFactory, n2);
        int n3 = localDateTime.getNano();
        byte[] byArray = new byte[n3 == 0 ? SIZE_TIMESTAMP_NOFRAC : SIZE_TIMESTAMP];
        byArray[0] = (byte)(n2 / 100 + 100);
        byArray[1] = (byte)(n2 % 100 + 100);
        byArray[2] = (byte)localDateTime.getMonthValue();
        byArray[3] = (byte)localDateTime.getDayOfMonth();
        byArray[4] = (byte)(localDateTime.getHour() + 1);
        byArray[5] = (byte)(localDateTime.getMinute() + 1);
        byArray[6] = (byte)(localDateTime.getSecond() + 1);
        if (n3 > 0) {
            byArray[7] = (byte)(n3 >> 24);
            byArray[8] = (byte)(n3 >> 16 & 0xFF);
            byArray[9] = (byte)(n3 >> 8 & 0xFF);
            byArray[10] = (byte)(n3 & 0xFF);
        }
        return byArray;
    }

    public static String dateToString(OracleJsonExceptions.ExceptionFactory exceptionFactory, byte[] byArray) {
        int n2 = OsonPrimitiveConversions.getJavaYear(byArray[0] & 0xFF, byArray[1] & 0xFF);
        OsonPrimitiveConversions.yearError(exceptionFactory, n2);
        int n3 = byArray[2] & 0xFF;
        int n4 = byArray[3] & 0xFF;
        int n5 = (byArray[4] & 0xFF) - 1;
        int n6 = (byArray[5] & 0xFF) - 1;
        int n7 = (byArray[6] & 0xFF) - 1;
        StringBuilder stringBuilder = new StringBuilder(27);
        OsonPrimitiveConversions.appendInt(stringBuilder, n2, 4);
        stringBuilder.append("-");
        OsonPrimitiveConversions.appendInt(stringBuilder, n3, 2);
        stringBuilder.append("-");
        OsonPrimitiveConversions.appendInt(stringBuilder, n4, 2);
        stringBuilder.append("T");
        OsonPrimitiveConversions.appendInt(stringBuilder, n5, 2);
        stringBuilder.append(":");
        OsonPrimitiveConversions.appendInt(stringBuilder, n6, 2);
        stringBuilder.append(":");
        OsonPrimitiveConversions.appendInt(stringBuilder, n7, 2);
        return stringBuilder.toString();
    }

    public static Duration intervalDSToDuration(byte[] byArray) {
        int n2 = OsonPrimitiveConversions.getDaysFromIntervalDS(byArray);
        int n3 = OsonPrimitiveConversions.getHoursFromIntervalDS(byArray);
        int n4 = OsonPrimitiveConversions.getMinutesFromIntervalDS(byArray);
        int n5 = OsonPrimitiveConversions.getSecondsFromIntervalDS(byArray);
        int n6 = OsonPrimitiveConversions.getNanosFromIntervalDS(byArray);
        long l2 = (long)n2 * 86400L + (long)n3 * 3600L + (long)n4 * 60L + (long)n5;
        return Duration.ofSeconds(l2, n6);
    }

    public static String serializeIntervalDS(OracleJsonExceptions.ExceptionFactory exceptionFactory, byte[] byArray) {
        long l2 = OsonPrimitiveConversions.getDaysFromIntervalDS(byArray);
        long l3 = OsonPrimitiveConversions.getHoursFromIntervalDS(byArray);
        long l4 = OsonPrimitiveConversions.getMinutesFromIntervalDS(byArray);
        long l5 = OsonPrimitiveConversions.getSecondsFromIntervalDS(byArray);
        long l6 = OsonPrimitiveConversions.getNanosFromIntervalDS(byArray);
        int n2 = (int)(l6 / 1000L);
        if (l2 < 0L || l3 < 0L || l4 < 0L || l5 < 0L || n2 < 0 || (l6 %= 1000L) < 0L) {
            throw OracleJsonExceptions.NOT_IMPLEMENTED.create(exceptionFactory, new Object[0]);
        }
        boolean bl = l3 > 0L || l4 > 0L || l5 > 0L || n2 > 0 || l6 > 0L;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("P");
        if (l2 > 0L || !bl) {
            stringBuilder.append(l2);
            stringBuilder.append("D");
        }
        if (bl) {
            stringBuilder.append("T");
            if (l3 > 0L) {
                stringBuilder.append(l3).append("H");
            }
            if (l4 > 0L) {
                stringBuilder.append(l4).append("M");
            }
            if (l5 > 0L || n2 > 0 || l6 > 0L) {
                stringBuilder.append(l5);
                if (n2 > 0 || l6 > 0L) {
                    String string = String.valueOf(n2);
                    stringBuilder.append(".");
                    for (int i2 = 0; i2 < 6 - string.length(); ++i2) {
                        stringBuilder.append("0");
                    }
                    stringBuilder.append(n2);
                    if (l6 > 0L) {
                        String string2 = String.valueOf(l6);
                        for (int i3 = 0; i3 < 3 - string2.length(); ++i3) {
                            stringBuilder.append("0");
                        }
                        stringBuilder.append(l6);
                    }
                }
                stringBuilder.append("S");
            }
        }
        return stringBuilder.toString();
    }

    public static byte[] durationToIntervalDS(Duration duration) {
        long l2 = duration.getSeconds();
        long l3 = l2 / 86400L;
        long l4 = duration.toHours() % 24L;
        long l5 = duration.toMinutes() % 60L;
        long l6 = l2 % 60L;
        int n2 = duration.getNano();
        int n3 = (int)l3;
        if ((long)n3 != l3) {
            throw new IllegalArgumentException();
        }
        byte[] byArray = new byte[11];
        OsonPrimitiveConversions.writeIntervalInt(n3, 0, byArray);
        byArray[4] = (byte)(l4 + 60L);
        byArray[5] = (byte)(l5 + 60L);
        byArray[6] = (byte)(l6 + 60L);
        OsonPrimitiveConversions.writeIntervalInt(n2, 7, byArray);
        return byArray;
    }

    private static void writeIntervalInt(int n2, int n3, byte[] byArray) {
        byArray[n3++] = (byte)((0xFF000000 & (n2 -= Integer.MIN_VALUE)) >> 24);
        byArray[n3++] = (byte)((0xFF0000 & n2) >> 16);
        byArray[n3++] = (byte)((0xFF00 & n2) >> 8);
        byArray[n3++] = (byte)(0xFF & n2);
    }

    static int getDaysFromIntervalDS(byte[] byArray) {
        return ((byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF) - Integer.MIN_VALUE;
    }

    static int getHoursFromIntervalDS(byte[] byArray) {
        return byArray[4] - 60;
    }

    static int getMinutesFromIntervalDS(byte[] byArray) {
        return byArray[5] - 60;
    }

    static int getSecondsFromIntervalDS(byte[] byArray) {
        return byArray[6] - 60;
    }

    static int getNanosFromIntervalDS(byte[] byArray) {
        return ((byArray[7] & 0xFF) << 24 | (byArray[8] & 0xFF) << 16 | (byArray[9] & 0xFF) << 8 | byArray[10] & 0xFF) - Integer.MIN_VALUE;
    }

    public static Period intervalYMToPeriod(byte[] byArray) {
        int n2 = OsonPrimitiveConversions.getYearFromIntervalYM(byArray);
        int n3 = OsonPrimitiveConversions.getMonthFromIntervalYM(byArray);
        return Period.of(n2, n3, 0);
    }

    public static byte[] periodToIntervalYM(OracleJsonExceptions.ExceptionFactory exceptionFactory, Period period) {
        int n2 = period.getYears();
        int n3 = period.getMonths();
        if (n3 > 11) {
            throw OracleJsonExceptions.NOT_IMPLEMENTED.create(exceptionFactory, new Object[0]);
        }
        if (n2 < 0 || n3 < 0) {
            throw OracleJsonExceptions.NOT_IMPLEMENTED.create(exceptionFactory, new Object[0]);
        }
        if (period.getDays() != 0) {
            throw OracleJsonExceptions.NO_DAYS_ALLOWED.create(exceptionFactory, new Object[0]);
        }
        byte[] byArray = new byte[5];
        OsonPrimitiveConversions.writeIntervalInt(period.getYears(), 0, byArray);
        byArray[4] = (byte)(period.getMonths() + 60);
        return byArray;
    }

    private static int getMonthFromIntervalYM(byte[] byArray) {
        return byArray[4] - 60;
    }

    private static int getYearFromIntervalYM(byte[] byArray) {
        return ((byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF) - Integer.MIN_VALUE;
    }

    public static String serializeIntervalYM(OracleJsonExceptions.ExceptionFactory exceptionFactory, byte[] byArray) {
        int n2 = OsonPrimitiveConversions.getYearFromIntervalYM(byArray);
        int n3 = OsonPrimitiveConversions.getMonthFromIntervalYM(byArray);
        if (n2 < 0 || n3 < 0) {
            throw OracleJsonExceptions.NOT_IMPLEMENTED.create(exceptionFactory, new Object[0]);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('P');
        if (n2 > 0 || n3 == 0) {
            stringBuilder.append(n2).append('Y');
        }
        if (n3 > 0) {
            stringBuilder.append(n3).append('M');
        }
        return stringBuilder.toString();
    }

    private static final int getNanos(byte[] byArray, int n2) {
        int n3 = (byArray[n2] & 0xFF) << 24;
        n3 |= (byArray[n2 + 1] & 0xFF) << 16;
        n3 |= (byArray[n2 + 2] & 0xFF) << 8;
        return n3 |= byArray[n2 + 3] & 0xFF & 0xFF;
    }

    private static int getJavaYear(int n2, int n3) {
        int n4 = (n2 - 100) * 100 + (n3 - 100);
        if (n4 < 0) {
            ++n4;
        }
        return n4;
    }

    static byte[] doubleToCanonicalFormatBytes(double d2) {
        double d3 = d2;
        if (d3 == 0.0) {
            d3 = 0.0;
        } else if (d3 != d3) {
            d3 = Double.NaN;
        }
        long l2 = Double.doubleToLongBits(d3);
        byte[] byArray = new byte[8];
        int n2 = (int)l2;
        int n3 = (int)(l2 >> 32);
        int n4 = n2;
        int n5 = n2 >>= 8;
        int n6 = n2 >>= 8;
        int n7 = n2 >>= 8;
        int n8 = n3;
        int n9 = n3 >>= 8;
        int n10 = n3 >>= 8;
        int n11 = n3 >>= 8;
        if ((n11 & 0x80) == 0) {
            n11 |= 0x80;
        } else {
            n11 ^= 0xFFFFFFFF;
            n10 ^= 0xFFFFFFFF;
            n9 ^= 0xFFFFFFFF;
            n8 ^= 0xFFFFFFFF;
            n7 ^= 0xFFFFFFFF;
            n6 ^= 0xFFFFFFFF;
            n5 ^= 0xFFFFFFFF;
            n4 ^= 0xFFFFFFFF;
        }
        byArray[7] = (byte)n4;
        byArray[6] = (byte)n5;
        byArray[5] = (byte)n6;
        byArray[4] = (byte)n7;
        byArray[3] = (byte)n8;
        byArray[2] = (byte)n9;
        byArray[1] = (byte)n10;
        byArray[0] = (byte)n11;
        return byArray;
    }

    static double canonicalFormatBytesToDouble(byte[] byArray) {
        int n2 = byArray[0];
        int n3 = byArray[1];
        int n4 = byArray[2];
        int n5 = byArray[3];
        int n6 = byArray[4];
        int n7 = byArray[5];
        int n8 = byArray[6];
        int n9 = byArray[7];
        if ((n2 & 0x80) != 0) {
            n2 &= 0x7F;
            n3 &= 0xFF;
            n4 &= 0xFF;
            n5 &= 0xFF;
            n6 &= 0xFF;
            n7 &= 0xFF;
            n8 &= 0xFF;
            n9 &= 0xFF;
        } else {
            n2 = ~n2 & 0xFF;
            n3 = ~n3 & 0xFF;
            n4 = ~n4 & 0xFF;
            n5 = ~n5 & 0xFF;
            n6 = ~n6 & 0xFF;
            n7 = ~n7 & 0xFF;
            n8 = ~n8 & 0xFF;
            n9 = ~n9 & 0xFF;
        }
        int n10 = n2 << 24 | n3 << 16 | n4 << 8 | n5;
        int n11 = n6 << 24 | n7 << 16 | n8 << 8 | n9;
        long l2 = (long)n10 << 32 | (long)n11 & 0xFFFFFFFFL;
        return Double.longBitsToDouble(l2);
    }

    static byte[] floatToCanonicalFormatBytes(float f2) {
        float f3 = f2;
        if (f3 == 0.0f) {
            f3 = 0.0f;
        } else if (f3 != f3) {
            f3 = Float.NaN;
        }
        int n2 = Float.floatToIntBits(f3);
        byte[] byArray = new byte[4];
        int n3 = n2;
        int n4 = n2 >>= 8;
        int n5 = n2 >>= 8;
        int n6 = n2 >>= 8;
        if ((n6 & 0x80) == 0) {
            n6 |= 0x80;
        } else {
            n6 ^= 0xFFFFFFFF;
            n5 ^= 0xFFFFFFFF;
            n4 ^= 0xFFFFFFFF;
            n3 ^= 0xFFFFFFFF;
        }
        byArray[3] = (byte)n3;
        byArray[2] = (byte)n4;
        byArray[1] = (byte)n5;
        byArray[0] = (byte)n6;
        return byArray;
    }

    static float canonicalFormatBytesToFloat(byte[] byArray) {
        int n2 = byArray[0];
        int n3 = byArray[1];
        int n4 = byArray[2];
        int n5 = byArray[3];
        if ((n2 & 0x80) != 0) {
            n2 &= 0x7F;
            n3 &= 0xFF;
            n4 &= 0xFF;
            n5 &= 0xFF;
        } else {
            n2 = ~n2 & 0xFF;
            n3 = ~n3 & 0xFF;
            n4 = ~n4 & 0xFF;
            n5 = ~n5 & 0xFF;
        }
        int n6 = n2 << 24 | n3 << 16 | n4 << 8 | n5;
        return Float.intBitsToFloat(n6);
    }

    public static byte[] toNumber(BigDecimal bigDecimal) {
        int n2;
        long l2;
        int n3;
        BigDecimal bigDecimal2;
        if (bigDecimal == null) {
            throw new IllegalArgumentException();
        }
        byte[] byArray = new byte[66];
        long[] lArray = new long[54];
        long[] lArray2 = new long[22];
        int n4 = 21;
        int n5 = 0;
        int n6 = 21;
        int n7 = 0;
        int n8 = 0;
        BigDecimal bigDecimal3 = bigDecimal.abs();
        int n9 = 0;
        if (bigDecimal.signum() == 0) {
            return OsonPrimitiveConversions._makeZero();
        }
        boolean bl = bigDecimal.signum() != -1;
        int n10 = bigDecimal.scale();
        if (n10 < 0) {
            bigDecimal = bigDecimal.setScale(0);
            n10 = 0;
        }
        int n11 = bigDecimal3.compareTo(BigDecimal.valueOf(1L));
        int n12 = 0;
        if (n11 == -1) {
            while ((bigDecimal2 = bigDecimal3.movePointRight(++n12)).compareTo(BigDecimal.valueOf(1L)) < 0) {
            }
            n9 = -n12;
        } else {
            while ((bigDecimal2 = bigDecimal3.movePointLeft(++n12)).compareTo(BigDecimal.valueOf(1L)) >= 0) {
            }
            n9 = n12;
        }
        byte[] byArray2 = bigDecimal3.movePointRight(n10).toBigInteger().toByteArray();
        if (byArray2.length > 54) {
            throw new IllegalArgumentException();
        }
        for (n3 = 0; n3 < byArray2.length; ++n3) {
            lArray[n3] = byArray2[n3] < 0 ? (long)(byArray2[n3] + 256) : (long)byArray2[n3];
        }
        int n13 = byArray2.length;
        switch (n13 % 3) {
            case 2: {
                lArray2[n4] = (lArray[n5] << 8) + lArray[n5 + 1];
                n5 = (byte)(n5 + 2);
                n13 -= 2;
                break;
            }
            case 1: {
                lArray2[n4] = lArray[n5];
                n5 = (byte)(n5 + 1);
                --n13;
                break;
            }
            default: {
                l2 = (lArray[n5] << 16) + (lArray[n5 + 1] << 8) + lArray[n5 + 2];
                lArray2[n4] = l2 % 1000000L;
                lArray2[n4 - 1] = l2 / 1000000L;
                n6 = (byte)(n6 - (lArray2[n4 - 1] != 0L ? 1 : 0));
                n5 = (byte)(n5 + 3);
                n13 -= 3;
            }
        }
        while (n13 != 0) {
            l2 = (lArray[n5] << 4) + (lArray[n5 + 1] >> 4);
            for (n4 = 21; n4 >= n6; n4 = (int)((byte)(n4 - 1))) {
                lArray2[n4] = (l2 += lArray2[n4] << 12) % 1000000L;
                l2 /= 1000000L;
            }
            if (l2 != 0L) {
                n6 = (byte)(n6 - 1);
                lArray2[n6] = l2;
            }
            l2 = ((lArray[n5 + 1] & 0xFL) << 8) + lArray[n5 + 2];
            for (n4 = 21; n4 >= n6; n4 = (int)((byte)(n4 - 1))) {
                lArray2[n4] = (l2 += lArray2[n4] << 12) % 1000000L;
                l2 /= 1000000L;
            }
            if (l2 != 0L) {
                n6 = (byte)(n6 - 1);
                lArray2[n6] = l2;
            }
            n5 = (byte)(n5 + 3);
            n13 -= 3;
        }
        byArray[n7] = (byte)(lArray2[n6] / 10000L);
        if (byArray[n7] != 0) {
            n2 = 3 * (21 - n6) + 3;
            byArray[n7 + 1] = (byte)(lArray2[n6] % 10000L / 100L);
            byArray[n7 + 2] = (byte)(lArray2[n6] % 100L);
            n7 += 3;
        } else {
            byArray[n7] = (byte)(lArray2[n6] % 10000L / 100L);
            if (byArray[n7] != 0) {
                n2 = 3 * (21 - n6) + 2;
                byArray[n7 + 1] = (byte)(lArray2[n6] % 100L);
                n7 += 2;
            } else {
                byArray[n7] = (byte)lArray2[n6];
                n2 = 3 * (21 - n6) + 1;
                ++n7;
            }
        }
        for (n4 = (int)((byte)(n6 + 1)); n4 <= 21; n4 = (int)((byte)(n4 + 1))) {
            byArray[n7] = (byte)(lArray2[n4] / 10000L);
            byArray[n7 + 1] = (byte)(lArray2[n4] % 10000L / 100L);
            byArray[n7 + 2] = (byte)(lArray2[n4] % 100L);
            n7 += 3;
        }
        for (n3 = n7 - 1; n3 >= 0 && byArray[n3] == 0; --n3) {
            --n2;
        }
        if (n10 > 0 && (n10 & 1) != 0) {
            int n14 = n2;
            byte[] byArray3 = new byte[n14 + 1];
            if (byArray[0] <= 9) {
                for (n3 = 0; n3 < n14 - 1; ++n3) {
                    byArray3[n3] = (byte)(byArray[n3] % 10 * 10 + byArray[n3 + 1] / 10);
                }
                byArray3[n3] = (byte)(byArray[n3] % 10 * 10);
                if (byArray3[n14 - 1] == 0) {
                    --n2;
                }
            } else {
                byArray3[n14] = (byte)(byArray[n14 - 1] % 10 * 10);
                for (n3 = n14 - 1; n3 > 0; --n3) {
                    byArray3[n3] = (byte)(byArray[n3] / 10 + byArray[n3 - 1] % 10 * 10);
                }
                byArray3[n3] = (byte)(byArray[n3] / 10);
                if (byArray3[n14] > 0) {
                    ++n2;
                }
            }
            System.arraycopy(byArray3, 0, byArray, 0, n2);
        }
        if (n2 > 20) {
            n3 = 20;
            n2 = 20;
            if (byArray[n3] >= 50) {
                int n15 = --n3;
                byArray[n15] = (byte)(byArray[n15] + 1);
                while (byArray[n3] == 100) {
                    if (n3 == 0) {
                        ++n9;
                        byArray[n3] = 1;
                        break;
                    }
                    byArray[n3] = 0;
                    int n16 = --n3;
                    byArray[n16] = (byte)(byArray[n16] + 1);
                }
            }
            for (n3 = n2 - 1; n3 >= 0 && byArray[n3] == 0; --n3) {
                --n2;
            }
        }
        n8 = n9 <= 0 ? (byArray[0] < 10 ? -(2 - n9) / 2 + 1 : -(2 - n9) / 2) : (n9 - 1) / 2;
        if (n8 > 62) {
            throw new IllegalArgumentException();
        }
        if (n8 < -65) {
            throw new IllegalArgumentException();
        }
        byte[] byArray4 = new byte[n2 + 1];
        byArray4[0] = (byte)n8;
        System.arraycopy(byArray, 0, byArray4, 1, n2);
        return OsonPrimitiveConversions._toLnxFmt(byArray4, bl);
    }

    public static byte[] toNumber(BigInteger bigInteger) {
        int n2;
        long l2;
        int n3;
        int n4;
        byte[] byArray;
        Object object;
        if (bigInteger == null) {
            throw new IllegalArgumentException();
        }
        byte[] byArray2 = new byte[66];
        long[] lArray = new long[54];
        long[] lArray2 = new long[22];
        int n5 = 21;
        int n6 = 0;
        int n7 = 21;
        int n8 = 0;
        boolean bl = true;
        if (bigInteger.signum() == 0) {
            return OsonPrimitiveConversions._makeZero();
        }
        if (bigInteger.signum() == -1) {
            object = bigInteger.abs();
            bl = false;
            byArray = ((BigInteger)object).toByteArray();
            n4 = (int)Math.floor((double)((BigInteger)object).bitLength() * 0.1505149978319906);
        } else {
            byArray = bigInteger.toByteArray();
            n4 = (int)Math.floor((double)bigInteger.bitLength() * 0.1505149978319906);
        }
        if (bigInteger.abs().compareTo(BigInteger.valueOf(100L).pow(n4)) < 0) {
            --n4;
        }
        if (byArray.length > 54) {
            throw new IllegalArgumentException();
        }
        for (n3 = 0; n3 < byArray.length; ++n3) {
            lArray[n3] = byArray[n3] < 0 ? (long)(byArray[n3] + 256) : (long)byArray[n3];
        }
        int n9 = byArray.length;
        switch (n9 % 3) {
            case 2: {
                lArray2[n5] = (lArray[n6] << 8) + lArray[n6 + 1];
                n6 = (byte)(n6 + 2);
                n9 -= 2;
                break;
            }
            case 1: {
                lArray2[n5] = lArray[n6];
                n6 = (byte)(n6 + 1);
                --n9;
                break;
            }
            default: {
                l2 = (lArray[n6] << 16) + (lArray[n6 + 1] << 8) + lArray[n6 + 2];
                lArray2[n5] = l2 % 1000000L;
                lArray2[n5 - 1] = l2 / 1000000L;
                n7 = (byte)(n7 - (lArray2[n5 - 1] != 0L ? 1 : 0));
                n6 = (byte)(n6 + 3);
                n9 -= 3;
            }
        }
        while (n9 != 0) {
            l2 = (lArray[n6] << 4) + (lArray[n6 + 1] >> 4);
            for (n5 = 21; n5 >= n7; n5 = (int)((byte)(n5 - 1))) {
                lArray2[n5] = (l2 += lArray2[n5] << 12) % 1000000L;
                l2 /= 1000000L;
            }
            if (l2 != 0L) {
                n7 = (byte)(n7 - 1);
                lArray2[n7] = l2;
            }
            l2 = ((lArray[n6 + 1] & 0xFL) << 8) + lArray[n6 + 2];
            for (n5 = 21; n5 >= n7; n5 = (int)((byte)(n5 - 1))) {
                lArray2[n5] = (l2 += lArray2[n5] << 12) % 1000000L;
                l2 /= 1000000L;
            }
            if (l2 != 0L) {
                n7 = (byte)(n7 - 1);
                lArray2[n7] = l2;
            }
            n6 = (byte)(n6 + 3);
            n9 -= 3;
        }
        byArray2[n8] = (byte)(lArray2[n7] / 10000L);
        if (byArray2[n8] != 0) {
            n2 = 3 * (21 - n7) + 3;
            byArray2[n8 + 1] = (byte)(lArray2[n7] % 10000L / 100L);
            byArray2[n8 + 2] = (byte)(lArray2[n7] % 100L);
            n8 += 3;
        } else {
            byArray2[n8] = (byte)(lArray2[n7] % 10000L / 100L);
            if (byArray2[n8] != 0) {
                n2 = 3 * (21 - n7) + 2;
                byArray2[n8 + 1] = (byte)(lArray2[n7] % 100L);
                n8 += 2;
            } else {
                byArray2[n8] = (byte)lArray2[n7];
                n2 = 3 * (21 - n7) + 1;
                ++n8;
            }
        }
        for (n5 = (int)((byte)(n7 + 1)); n5 <= 21; n5 = (int)((byte)(n5 + 1))) {
            byArray2[n8] = (byte)(lArray2[n5] / 10000L);
            byArray2[n8 + 1] = (byte)(lArray2[n5] % 10000L / 100L);
            byArray2[n8 + 2] = (byte)(lArray2[n5] % 100L);
            n8 += 3;
        }
        for (n3 = n8 - 1; n3 >= 0 && byArray2[n3] == 0; --n3) {
            --n2;
        }
        if (n2 > 19) {
            n3 = 20;
            n2 = 19;
            if (byArray2[n3] >= 50) {
                int n10 = --n3;
                byArray2[n10] = (byte)(byArray2[n10] + 1);
                while (byArray2[n3] == 100) {
                    if (n3 == 0) {
                        ++n4;
                        byArray2[n3] = 1;
                        break;
                    }
                    byArray2[n3] = 0;
                    int n11 = --n3;
                    byArray2[n11] = (byte)(byArray2[n11] + 1);
                }
                for (n3 = n2 - 1; n3 >= 0 && byArray2[n3] == 0; --n3) {
                    --n2;
                }
            }
        }
        if (n4 > 62) {
            throw new IllegalArgumentException();
        }
        object = new byte[n2 + 1];
        object[0] = (byte)n4;
        System.arraycopy(byArray2, 0, object, 1, n2);
        return OsonPrimitiveConversions._toLnxFmt((byte[])object, bl);
    }

    static byte[] _makeZero() {
        byte[] byArray = new byte[]{-128};
        return byArray;
    }

    static byte[] _toLnxFmt(byte[] byArray, boolean bl) {
        byte[] byArray2;
        int n2 = byArray.length;
        if (bl) {
            byArray2 = new byte[n2];
            byArray2[0] = (byte)(byArray[0] + 128 + 64 + 1);
            for (int i2 = 1; i2 < n2; ++i2) {
                byArray2[i2] = (byte)(byArray[i2] + 1);
            }
        } else {
            int n3;
            byArray2 = n2 - 1 < 20 ? new byte[n2 + 1] : new byte[n2];
            byArray2[0] = (byte)(~(byArray[0] + 128 + 64 + 1));
            for (n3 = 1; n3 < n2; ++n3) {
                byArray2[n3] = (byte)(101 - byArray[n3]);
            }
            if (n3 <= 20) {
                byArray2[n3] = 102;
            }
        }
        return byArray2;
    }

    static byte[] toNumber(int n2) {
        return OsonPrimitiveConversions.lnxmin(n2);
    }

    public static byte[] toNumber(long l2) {
        return OsonPrimitiveConversions.lnxmin(l2);
    }

    public static byte[] lnxmin(long l2) {
        if (l2 <= Integer.MAX_VALUE && l2 >= Integer.MIN_VALUE) {
            return OsonPrimitiveConversions.lnxmin32((int)l2);
        }
        return OsonPrimitiveConversions.lnxmin64(l2);
    }

    private static byte[] lnxmin32(int n2) {
        byte[] byArray;
        if (n2 == 0) {
            byArray = new byte[]{-128};
        } else if (n2 < 0) {
            if (n2 == Integer.MIN_VALUE) {
                byArray = new byte[7];
                OsonPrimitiveConversions.encodeIntMinValue(byArray, 0);
            } else if (-n2 < 100) {
                byArray = new byte[]{62, (byte)(101 + n2), 102};
            } else if (-n2 < 10000) {
                int n3 = -n2 % 100;
                if (n3 != 0) {
                    byArray = new byte[4];
                    byArray[2] = (byte)(101 - n3);
                    byArray[3] = 102;
                } else {
                    byArray = new byte[3];
                    byArray[2] = 102;
                }
                byArray[0] = 61;
                byArray[1] = (byte)(101 - -n2 / 100);
            } else if (-n2 < 1000000) {
                int n4 = -n2 % 100;
                if (n4 != 0) {
                    byArray = new byte[5];
                    byArray[2] = (byte)(101 - -n2 % 10000 / 100);
                    byArray[3] = (byte)(101 - n4);
                    byArray[4] = 102;
                } else {
                    n4 = -n2 % 10000 / 100;
                    if (n4 != 0) {
                        byArray = new byte[4];
                        byArray[2] = (byte)(101 - n4);
                        byArray[3] = 102;
                    } else {
                        byArray = new byte[3];
                        byArray[2] = 102;
                    }
                }
                byArray[0] = 60;
                byArray[1] = (byte)(101 - -n2 / 10000);
            } else if (-n2 < 100000000) {
                int n5 = -n2 % 100;
                if (n5 != 0) {
                    byArray = new byte[6];
                    byArray[2] = (byte)(101 - -n2 % 1000000 / 10000);
                    byArray[3] = (byte)(101 - -n2 % 10000 / 100);
                    byArray[4] = (byte)(101 - n5);
                    byArray[5] = 102;
                } else {
                    n5 = -n2 % 10000 / 100;
                    if (n5 != 0) {
                        byArray = new byte[5];
                        byArray[2] = (byte)(101 - -n2 % 1000000 / 10000);
                        byArray[3] = (byte)(101 - n5);
                        byArray[4] = 102;
                    } else {
                        n5 = -n2 % 1000000 / 10000;
                        if (n5 != 0) {
                            byArray = new byte[4];
                            byArray[2] = (byte)(101 - n5);
                            byArray[3] = 102;
                        } else {
                            byArray = new byte[3];
                            byArray[2] = 102;
                        }
                    }
                }
                byArray[0] = 59;
                byArray[1] = (byte)(101 - -n2 / 1000000);
            } else {
                int n6 = -n2 % 100;
                if (n6 != 0) {
                    byArray = new byte[7];
                    byArray[2] = (byte)(101 - -n2 % 100000000 / 1000000);
                    byArray[3] = (byte)(101 - -n2 % 1000000 / 10000);
                    byArray[4] = (byte)(101 - -n2 % 10000 / 100);
                    byArray[5] = (byte)(101 - n6);
                    byArray[6] = 102;
                } else {
                    n6 = -n2 % 10000 / 100;
                    if (n6 != 0) {
                        byArray = new byte[6];
                        byArray[2] = (byte)(101 - -n2 % 100000000 / 1000000);
                        byArray[3] = (byte)(101 - -n2 % 1000000 / 10000);
                        byArray[4] = (byte)(101 - n6);
                        byArray[5] = 102;
                    } else {
                        n6 = -n2 % 1000000 / 10000;
                        if (n6 != 0) {
                            byArray = new byte[5];
                            byArray[2] = (byte)(101 - -n2 % 100000000 / 1000000);
                            byArray[3] = (byte)(101 - n6);
                            byArray[4] = 102;
                        } else {
                            n6 = -n2 % 100000000 / 1000000;
                            if (n6 != 0) {
                                byArray = new byte[4];
                                byArray[2] = (byte)(101 - n6);
                                byArray[3] = 102;
                            } else {
                                byArray = new byte[3];
                                byArray[2] = 102;
                            }
                        }
                    }
                }
                byArray[0] = 58;
                byArray[1] = (byte)(101 - -n2 / 100000000);
            }
        } else if (n2 < 100) {
            byArray = new byte[]{-63, (byte)(n2 + 1)};
        } else if (n2 < 10000) {
            int n7 = n2 % 100;
            if (n7 != 0) {
                byArray = new byte[3];
                byArray[2] = (byte)(n7 + 1);
            } else {
                byArray = new byte[]{-62, (byte)(n2 / 100 + 1)};
            }
        } else if (n2 < 1000000) {
            int n8 = n2 % 100;
            if (n8 != 0) {
                byArray = new byte[4];
                byArray[2] = (byte)(n2 % 10000 / 100 + 1);
                byArray[3] = (byte)(n8 + 1);
            } else {
                n8 = n2 % 10000 / 100;
                if (n8 != 0) {
                    byArray = new byte[3];
                    byArray[2] = (byte)(n8 + 1);
                } else {
                    byArray = new byte[]{-61, (byte)(n2 / 10000 + 1)};
                }
            }
        } else if (n2 < 100000000) {
            int n9 = n2 % 100;
            if (n9 != 0) {
                byArray = new byte[5];
                byArray[2] = (byte)(n2 % 1000000 / 10000 + 1);
                byArray[3] = (byte)(n2 % 10000 / 100 + 1);
                byArray[4] = (byte)(n9 + 1);
            } else {
                n9 = n2 % 10000 / 100;
                if (n9 != 0) {
                    byArray = new byte[4];
                    byArray[2] = (byte)(n2 % 1000000 / 10000 + 1);
                    byArray[3] = (byte)(n9 + 1);
                } else {
                    n9 = n2 % 1000000 / 10000;
                    if (n9 != 0) {
                        byArray = new byte[3];
                        byArray[2] = (byte)(n9 + 1);
                    } else {
                        byArray = new byte[]{-60, (byte)(n2 / 1000000 + 1)};
                    }
                }
            }
        } else {
            int n10 = n2 % 100;
            if (n10 != 0) {
                byArray = new byte[6];
                byArray[2] = (byte)(n2 % 100000000 / 1000000 + 1);
                byArray[3] = (byte)(n2 % 1000000 / 10000 + 1);
                byArray[4] = (byte)(n2 % 10000 / 100 + 1);
                byArray[5] = (byte)(n10 + 1);
            } else {
                n10 = n2 % 10000 / 100;
                if (n10 != 0) {
                    byArray = new byte[5];
                    byArray[2] = (byte)(n2 % 100000000 / 1000000 + 1);
                    byArray[3] = (byte)(n2 % 1000000 / 10000 + 1);
                    byArray[4] = (byte)(n10 + 1);
                } else {
                    n10 = n2 % 1000000 / 10000;
                    if (n10 != 0) {
                        byArray = new byte[4];
                        byArray[2] = (byte)(n2 % 100000000 / 1000000 + 1);
                        byArray[3] = (byte)(n10 + 1);
                    } else {
                        n10 = n2 % 100000000 / 1000000;
                        if (n10 != 0) {
                            byArray = new byte[3];
                            byArray[2] = (byte)(n10 + 1);
                        } else {
                            byArray = new byte[]{-59, (byte)(n2 / 100000000 + 1)};
                        }
                    }
                }
            }
        }
        return byArray;
    }

    private static void encodeIntMinValue(byte[] byArray, int n2) {
        byArray[n2] = 58;
        byArray[n2 + 1] = 80;
        byArray[n2 + 2] = 54;
        byArray[n2 + 3] = 53;
        byArray[n2 + 4] = 65;
        byArray[n2 + 5] = 53;
        byArray[n2 + 6] = 102;
    }

    private static byte[] lnxmin64(long l2) {
        int n2;
        boolean bl = l2 >= 0L;
        if (bl) {
            l2 = -l2;
        }
        int n3 = n2 = OsonPrimitiveConversions.log100(l2);
        long l3 = l2 / 100L;
        long l4 = l3 * 100L - l2;
        if (0L == l4) {
            do {
                --n3;
            } while (0L == (l4 = (l3 = (l2 = l3) / 100L) * 100L - l2));
            if (n3 == 0) {
                if (bl) {
                    byte[] byArray = new byte[2];
                    OsonPrimitiveConversions.lnxminEncodeP1((int)l4, n2, byArray, 0);
                    return byArray;
                }
                byte[] byArray = new byte[3];
                OsonPrimitiveConversions.lnxminEncodeN1((int)l4, n2, byArray, 0);
                return byArray;
            }
        }
        if (bl) {
            byte[] byArray = new byte[n3 + 2];
            OsonPrimitiveConversions.lnxminEncodeP(l3, n2, n3, (int)l4, byArray, 0);
            return byArray;
        }
        byte[] byArray = new byte[n3 + 3];
        OsonPrimitiveConversions.lnxminEncodeN(l3, n2, n3, (int)l4, byArray, 0);
        return byArray;
    }

    private static int log100(long l2) {
        return l2 > -10000000000L ? 4 : (l2 > -1000000000000L ? 5 : (l2 > -100000000000000L ? 6 : (l2 > -10000000000000000L ? 7 : (l2 > -1000000000000000000L ? 8 : 9))));
    }

    private static void lnxminEncodeP1(int n2, int n3, byte[] byArray, int n4) {
        byArray[n4] = (byte)(193 + n3);
        byArray[n4 + 1] = (byte)(1 + n2);
    }

    private static void lnxminEncodeN1(int n2, int n3, byte[] byArray, int n4) {
        byArray[n4] = (byte)(62 - n3);
        byArray[n4 + 1] = (byte)(101 - n2);
        byArray[n4 + 2] = 102;
    }

    private static void lnxminEncodeP(long l2, int n2, int n3, int n4, byte[] byArray, int n5) {
        byArray[n5] = (byte)(193 + n2);
        int n6 = n5 + n3 + 1;
        byArray[n6--] = (byte)(1 + n4);
        while (n3-- > 4) {
            long l3 = l2 / 100L;
            byArray[n6--] = (byte)(1L + l3 * 100L - l2);
            l2 = l3;
        }
        int n7 = (int)l2;
        while (n7 <= -100) {
            int n8 = n7 / 100;
            byArray[n6--] = (byte)(1 + n8 * 100 - n7);
            n7 = n8;
        }
        byArray[n6] = (byte)(1 - n7);
    }

    private static void lnxminEncodeN(long l2, int n2, int n3, int n4, byte[] byArray, int n5) {
        byArray[n5] = (byte)(64 - (2 + n2));
        int n6 = n5 + n3 + 2;
        byArray[n6--] = 102;
        byArray[n6--] = (byte)(101 - n4);
        while (n3-- > 4) {
            long l3 = l2 / 100L;
            byArray[n6--] = (byte)(101L - (l3 * 100L - l2));
            l2 = l3;
        }
        int n7 = (int)l2;
        while (n7 <= -100) {
            int n8 = n7 / 100;
            byArray[n6--] = (byte)(101 - (n8 * 100 - n7));
            n7 = n8;
        }
        byArray[n6] = (byte)(101 + n7);
    }

    public static BigDecimal toBigDecimalLong(byte[] byArray) {
        int n2;
        int n3 = OsonPrimitiveConversions.getOraNumLength(byArray) - 1;
        if (n3 > 9) {
            return null;
        }
        int n4 = OsonPrimitiveConversions.getScale(byArray) - n3 + 1;
        if (n3 + n4 > 9) {
            return null;
        }
        long l2 = 0L;
        try {
            long l3 = 1L;
            for (int i2 = n3; i2 > 0; --i2) {
                l2 += Math.multiplyExact(OsonPrimitiveConversions.unpackBase100(byArray, i2), l3);
                l3 *= 100L;
            }
        }
        catch (ArithmeticException arithmeticException) {
            return null;
        }
        for (n2 = n4 * 2; n2 > 0; --n2) {
            try {
                l2 = Math.multiplyExact(l2, 10);
                continue;
            }
            catch (ArithmeticException arithmeticException) {
                return null;
            }
        }
        while (n2 < 0 && l2 % 10L == 0L) {
            l2 /= 10L;
            ++n2;
        }
        if (!OsonPrimitiveConversions._isPositive(byArray)) {
            l2 = -l2;
        }
        return BigDecimal.valueOf(l2, -n2);
    }

    public static BigDecimal toBigDecimal(byte[] byArray) {
        if (OsonPrimitiveConversions._isZero(byArray)) {
            return BigDecimal.valueOf(0L);
        }
        if (OsonPrimitiveConversions._isInf(byArray)) {
            throw new IllegalArgumentException();
        }
        BigDecimal bigDecimal = OsonPrimitiveConversions.toBigDecimalLong(byArray);
        return bigDecimal == null ? OsonPrimitiveConversions.toBigDecimalFull(byArray) : bigDecimal;
    }

    public static BigDecimal toBigDecimalFull(byte[] byArray) {
        int n2;
        long[] lArray = new long[10];
        int n3 = 9;
        int n4 = 1;
        int n5 = 0;
        boolean bl = OsonPrimitiveConversions._isPositive(byArray);
        byte[] byArray2 = OsonPrimitiveConversions._fromLnxFmt(byArray);
        int n6 = n2 = byArray2.length - 1;
        if ((n2 & 1) == 1) {
            lArray[n3] = byArray2[n4];
            n4 = (byte)(n4 + 1);
            --n6;
        } else {
            lArray[n3] = byArray2[n4] * 100 + byArray2[n4 + 1];
            n4 = (byte)(n4 + 2);
            n6 -= 2;
        }
        int n7 = n3;
        while (n6 != 0) {
            long l2 = byArray2[n4] * 100 + byArray2[n4 + 1];
            for (n3 = 9; n3 >= n7; n3 = (int)((byte)(n3 - 1))) {
                lArray[n3] = (l2 += lArray[n3] * 10000L) & 0xFFFFL;
                l2 >>= 16;
            }
            if (l2 != 0L) {
                // empty if block
            }
            n7 = (byte)(n7 - 1);
            lArray[n7] = l2;
            n4 = (byte)(n4 + 2);
            n6 -= 2;
        }
        int n8 = lArray[n7] >> 8 != 0L ? 2 * (9 - n7) + 2 : 2 * (9 - n7) + 1;
        byte[] byArray3 = new byte[n8];
        if ((n8 & 1) == 1) {
            byArray3[n5] = (byte)lArray[n7];
            ++n5;
        } else {
            byArray3[n5] = (byte)(lArray[n7] >> 8);
            byArray3[++n5] = (byte)(lArray[n7] & 0xFFL);
            ++n5;
        }
        for (n7 = (int)((byte)(n7 + 1)); n7 <= 9; n7 = (int)((byte)(n7 + 1))) {
            byArray3[n5] = (byte)(lArray[n7] >> 8);
            byArray3[n5 + 1] = (byte)(lArray[n7] & 0xFFL);
            n5 += 2;
        }
        BigInteger bigInteger = new BigInteger(bl ? 1 : -1, byArray3);
        BigDecimal bigDecimal = new BigDecimal(bigInteger);
        int n9 = byArray2[0] - n2 + 1;
        bigDecimal = bigDecimal.movePointRight(n9 * 2);
        if (n9 < 0 && byArray2[n2] % 10 == 0) {
            bigDecimal = bigDecimal.setScale(-(n9 * 2 + 1));
        }
        return bigDecimal;
    }

    private static boolean _isZero(byte[] byArray) {
        return byArray[0] == -128 && byArray.length == 1;
    }

    private static boolean _isInf(byte[] byArray) {
        return byArray.length == 2 && byArray[0] == -1 && byArray[1] == 101 || byArray[0] == 0 && byArray.length == 1;
    }

    private static boolean _isPositive(byte[] byArray) {
        return (byArray[0] & 0xFFFFFF80) != 0;
    }

    private static int getOraNumLength(byte[] byArray) {
        int n2 = byArray.length - 1;
        return OsonPrimitiveConversions._isPositive(byArray) || n2 == 20 && byArray[n2] != 102 ? byArray.length : byArray.length - 1;
    }

    private static int getScale(byte[] byArray) {
        if (OsonPrimitiveConversions._isPositive(byArray)) {
            return (byte)((byArray[0] & 0xFFFFFF7F) - 65);
        }
        return (byte)((~byArray[0] & 0xFFFFFF7F) - 65);
    }

    private static long unpackBase100(byte[] byArray, int n2) {
        return OsonPrimitiveConversions._isPositive(byArray) ? (long)(byArray[n2] - 1) : (long)((byte)(101 - byArray[n2]));
    }

    private static byte[] _fromLnxFmt(byte[] byArray) {
        byte[] byArray2;
        int n2 = byArray.length;
        if (OsonPrimitiveConversions._isPositive(byArray)) {
            byArray2 = new byte[n2];
            byArray2[0] = (byte)((byArray[0] & 0xFFFFFF7F) - 65);
            for (int i2 = 1; i2 < n2; ++i2) {
                byArray2[i2] = (byte)(byArray[i2] - 1);
            }
        } else {
            byArray2 = n2 - 1 == 20 && byArray[n2 - 1] != 102 ? new byte[n2] : new byte[n2 - 1];
            byArray2[0] = (byte)((~byArray[0] & 0xFFFFFF7F) - 65);
            for (int i3 = 1; i3 < byArray2.length; ++i3) {
                byArray2[i3] = (byte)(101 - byArray[i3]);
            }
        }
        return byArray2;
    }
}

