#!/opt/local/bin/perl
##########################################################################
#                           f77chk  Ver.1.2.2f                           #
#                                                                        #
#           Copyright (C) 1999-2003 by Tsuguhiro TAMARIBUCHI             #
#                   tamari@spdg1.sci.shizuoka.ac.jp                      #
#                                                                        #
#               ftp://spdg1.sci.shizuoka.ac.jp/pub/f77chk                #
##########################################################################

$VERSION = "Ver.1.2.2f";
$FTPSITE = "ftp://spdg1.sci.shizuoka.ac.jp/pub/f77chk";

$DEFAULTINC = "library.def";

@HLPMSG = (
"",
"Argument Checker for f77 $VERSION",
"",
"  Usage: perl $0 [options] <file1>, ...",
"",
"Options: -l           List source code",
"         -v           Verbose output",
"         -c           Continue on fatal error",
"         -t           generate warnings along strong Typing",
"         -r[+]<fname> output a list of variable References",
"         -i[<fname>]  Include a definition file. If <fname> is not specified ",
"                      or no '-i' option specified at all, a default ",
"                      file ($DEFAULTINC) is included.",
"         -o[+]<fname> Output to a definition file for '-i' option",
"         -m           Merge definition files included (with '-o' option)",
"         -u           suppress warngs to Undefined references",
"         -w           generate miscellaneous Warnings",
"         -\'...\'       ignore lines beginning with a character appearing in",
"                      the specified string \'...\' or in \'C\*\!'",
"",
"       [ for stdin/out set '-' as <fname> (without quotation marks)]",
"       [ '+' in front of <fname> set the output append mode        ]"
);
##########################################################################

%DFLTTYPE = (
'a','R','b','R','c','R','d','R','e','R','f','R','g','R','h','R','i','I','j','I',
'k','I','l','I','m','I','n','I','o','R','p','R','q','R','r','R','s','R','t','R',
'u','R','v','R','w','R','x','R','y','R','z','R');

%FORTRAN = (
'ASSIGN', 0,
'BACKSPACE', 0,
'BLOCKDATA', 1,
'BYTE', 2,              # !f77
'CALL', 0,
'CHARACTER', 2,
'CLOSE', 0,
'COMMON', 2,
'COMPLEX', 2,
'CONTINUE', 0,
'DATA', 3,
'DIMENSION', 2,
'DOUBLECOMPLEX', 2,     # !f77
'DOUBLEPRECISION', 2,
'DOWHILE', 0,           # !f77
'DO', 0,
'ELSEIF', 0,
'ELSE', 0,
'ENDFILE', 0,
'ENDIF', 0,
'ENDDO', 0,
'END', 0,
'ENTRY', 1,
'EQUIVALENCE', 2,
'EXTERNAL', 2,
'FORMAT', 3,
'FUNCTION', 1,
'GOTO', 0,
'IF', 0,
'IMPLICIT', 2,
'INQUIRE', 0,
'INTEGER', 2,
'INTRINSIC', 2,
'LOGICAL', 2,
'OPEN', 0,
'PARAMETER', 3,
'PAUSE', 0,
'PRINT', 0,
'PROGRAM', 1,
'READ', 0,
'REAL', 2,
'RETURN', 0,
'REWIND', 0,
'SAVE', 2,
'STOP', 0,
'SUBROUTINE', 1,
'WRITE', 0,
);

@delimiters = ();   # delimiters set in &GetItemList
$nerrors = 0;       # of errors detected
$nwarnings = 0;     # of warnings detected
%ArgumentList = (); # $ArgumentList{'func'} = argument list of external 'func'
%RoutineType = ();  # $RoutineType{'func'} = type of external 'func'
                    # V(subroutine), Integer, Real, Double, Comples, String
                    # Logigal, Q(double complex), Unknown, X(generic)
#@'unit'_args       # argument list of 'unit'
#%'unit'_sclr       # $'unit'_sclr{'var'} = scalar 'var' used in 'unit'
#%'unit'_arry       # $'unit'_arry{'var'} = array 'var' declared in 'unit'
#%'unit'_cmn        # $'unit'_cmn{'name'} = COMMON /'name'/ list for 'unit'
#%'unit'_stfT       # $'unit'_stfT{'stfname'} = type of stat. func. in 'unit'
#%'unit'_stfA       # $'unit'_stfA{'stfname'} = argument list of stat. func.
#%'unit'_funcT      # $'unit'_unitT{'fname'} = type of 'fname' (external)
#%'unit'_funcA      # $'unit'_unitA{'fname'} = argument list of 'fname'
#%'unit'_IMPLICIT   # table of implicit declarations
#%'unit'_parm       # constants defined in PARAMETER

$ProgramName = '';
@OPTIONS = ();
@FILES = ();
$currentfile = '';
$currentpath = '';
$scriptdir = $0; $scriptdir =~ s/[^\/]+$//; #print "DIR = $scriptdir\n";

$semicolon = 1;     # treat ';' as beginning of a comment
$exclamation = 1;   # treat '!' as beginning of a comment
$multisttmnts = 1;  # allows multiple statements
$linebuffer = '';   # line buffer for multiple statements
$cmntchars = 'C*!'; # characters indicating comment lines as the 1-st char

$debugflg = 0;      # flag for debugging
$verboseflg = 0;    # flag for verbose output
$nonstpflg = 0;     # flag for not stopping on fatal errors
$mergeflg = 0;      # update a list of routines ($outfile must be set)
$stflg = 0;         # flag for strong typing
$warnflg = 0;       # flag for all warnings
$undefflg = 1;      # flag for warning to undefined references
$incflg = 0;        # include a specified list of routines
$listflg = 0;       # flag for listing
$outfile = '';      # file name of a list of routines defined
$reffile = '';      # file name of a list of references for each routines
$chkflg = 1;        # flag for checking
foreach $var (@ARGV) {
    if($var =~ /^-/) {
        push(@OPTIONS, $var);
        $optn = $';
        if($optn =~ /^g/i) {$debugflg = 1;}
        elsif ($optn =~ /^v/i) {$verboseflg = 1;}
        elsif ($optn =~ /^c/i) {$nonstpflg = 1;}
        elsif ($optn =~ /^m/i) {$mergeflg = 1;}
        elsif ($optn =~ /^t/i) {$stflg = 1;}
        elsif ($optn =~ /^w/i) {$warnflg = 1;}
        elsif ($optn =~ /^u/i) {$undefflg = 0;}
        elsif ($optn =~ /^i(\S*)/i) {$incflg = 1;}
        elsif ($optn =~ /^\'(.+)\'$/i) {
            $_ = $1;
            s/\'\'/\'/g;
            $cmntchars .= $_;
        }
        elsif ($optn =~ /^r(\S+)/i) {
            $reffile = $1;
            $reffile =~ s/^\+/\>/;
            if(!open(FDEC, ">$reffile")) {
                $reffile = '';
                print STDERR "Failed to open output file $reffile\n";
                &Help;
                exit(0);
            }
        }
        elsif ($optn =~ /^o(\S+)/i && $outfile eq '') {
            $outfile = $1;
            $outfile =~ s/^\+/\>/;
            if(!open(FOUT, ">$outfile")) {
                $outfile = '';
                print STDERR "Failed to open output file $outfile\n";
                &Help;
                exit(0);
            }
            local($l1) = "Definition file for f77chk $VERSION";
            local($l2) = "#  $FTPSITE  #";
            local($s2) = '#'x(length($l2));
            print FOUT "$s2\n";
            local($s1) = ' 'x(eval((length($l2)-length($l1)-2)/2));
            print FOUT "#$s1$l1";
            $s1 = ' 'x(eval(length($l2)-length("#$s1$l1")-1));
            print FOUT "$s1#\n";
            print FOUT "$l2\n";
            print FOUT "$s2\n";
            $chkflg = 0 if $optn =~ /^O/;
        }
        elsif ($optn =~ /^l/i) {}
        else {
            &Help;
            exit(0);
        }
    } else {
        if(-f $var) {
            ++$nfiles;
            push(@FILES, $var);
        } else {
            print "\nFailed to open file '$var'.\n";
        }
    }
}
die unless open(ERR, ">-");

if($nfiles == 0) {
    &Help;
    exit(1);
}

$WHERE = $0;
$WHERE = $` if $WHERE =~ /\\[^\\]+$/;   # for Windows
$WHERE = $` if $WHERE =~ /\/[^\/]+$/;
$includefile = $DEFAULTINC;
$includefile = "$WHERE/$DEFAULTINC" if $WHERE ne '';
$Nentry = &IncludeFile($includefile);
print "\nIncluding $includefile: ",$Nentry." entries\n"
    if -f $includefile && !$incflg && $verboseflg;
foreach $var (@OPTIONS) {
    if($var =~ /^-i(\S*)/i) {
        local($s) = $includefile;
        $s = $1 if $1;
        $Nentry = &IncludeFile($s);
        print "\nIncluding $s: ",$Nentry." entries\n" if $verboseflg;
    }
}

$org = '';
$unt = '';
$lin = '';
$nxt = '';
$loc = 0;
$stl = 0;
$lst = 0;
foreach $var (@FILES) {
    $inclvl = 0;
    $filehandle = 'FIN0';
    next unless(open($filehandle, "$var"));
    local(@INstat) = stat($var);
    $var =~ /[\/\\]*([\w\.]+)$/;
    $currentfile = $1;
    $currentpath = $`;
    print FDEC "\nFile name = $currentfile\n" if($reffile);
    if($outfile ne '') {
        local($l) = "# File = $currentfile  (Last Modified: ";
        $l .= &WhatTime(localtime($INstat[9])).") #";
        local($s) = '-'x(eval(length($l)-2));
        print FOUT "#$s#\n";
        print FOUT "$l\n";
        print FOUT "#$s#\n";
    }
    print "File name = $currentfile\n" if $verboseflg;
    @myroutines = ();
    &Scan;
    if($outfile) {
        foreach $var (@myroutines) {
            print FOUT "$RoutineType{$var}:$var($ArgumentList{$var})\n";
        }
    }
#    close($filehandle);
}
close(FOUT) if $reffile && $reffile ne '-';

exit(0) unless $chkflg;

foreach $var (@OPTIONS) {
    if($var =~ /^-/) {
        $optn = $';
        if($optn =~ /^g/i) {$debugflg = 1;}
        elsif ($optn =~ /^l/i) {$listflg = 1;}
        elsif ($optn =~ /^v/i) {$verboseflg = 1;}
    }
}
foreach $var (@FILES) {
    $inclvl = 0;
    $filehandle = 'FIN0';
    next unless(open($filehandle, "$var"));
    $var =~ /[\/\\]*([\w\.]+)$/;
    $currentfile = $1;
    $currentpath = $`;
    print "File name = $currentfile\n" if $verboseflg;
    &Check;
#    close($filehandle);
}
if($nerrors || $nwarnings) {
    print "\n$nerrors errors, $nwarnings warnings detected\n" if $verboseflg;
    exit(1) if $nerrors;
} else {
    print "Ok\n";
}
exit(0);
###################################################################
sub Scan
{
    $scanflg = 1;
    $org = '';
    $unt = '';
    $lin = '';
    $nxt = '';
    $loc = 0;
    $stl = 0;
    $lst = 0;
    local(@tmp) = ();
    local($s) = '';
    $nxt = '';
    $unt = '';
    while(($s = &GetLine) ne '') {
# statements for declarations
        if ($s =~ /^BLOCKDATA/) {     # skip BLOCK DATA unit
            while(($s ne '')  && !($s =~ /^END\b/)) {$s = &GetLine;}
            last if $s eq '';
            next;
        }
# beginning of a program unit
        if ($s =~ /^FUNCTION/ || $s =~ /^SUBROUTINE/) {
            local($t) = 'V';
            $t = 'U' if $s =~ /^FUNCTION/;
            grep($s =~ s/^$_//, keys(%FORTRAN));
            $unt = $s;
            local($a) = '';
            if($s =~ /\(/) {
                @tmp = &GetParentheses($s);
                if($#tmp == 2) {
                    $unt = $tmp[0];             # unit name
                    $a = $tmp[1];
                } else {
                    &ErrorMsg(-1,"Unmatched () in [$org]");
                }
            }
            &DeclareUnit($unt, $a, $t);
            print "\n$stl: Entering '$unt($a)'\n" if $verboseflg;
            push(@myroutines, $unt);
            print "$stl: $t : $unt($ArgumentList{$unt})\n" if $debugflg;
            next;
        }
        if ($s =~ /^ENTRY/) {
            $s = $';
            local($t) = $RoutineType{$unt};
            local($a) = '';
            if($s =~ /\(/) {
                @tmp = &GetParentheses($s);
                if($#tmp == 2) {
                    $a = $tmp[1];
                } else {
                    &ErrorMsg(-1,"Unmatched () in [$org]");
                }
            } else {
                @tmp = ($s);
            }
            &DeclareUnit($tmp[0], $a, $t);
            print "\n$stl: Entering '$tmp[0]($a)'\n" if $verboseflg;
            push(@myroutines, $tmp[0]);
            print "$stl: $t : $tmp[0]($ArgumentList{$tmp[0]})\n" 
                if $debugflg;
            next;
        }
        if($unt eq '') {        # main
            $unt = 'main';
            &DeclareUnit($unt, '', 'V');
            if($s =~ /^PROGRAM/) {
                $ProgramName = $';
                next;
            }
        }
        if ($s =~ /^IMPLICIT/) {
            local(@dcl) = &GetItemList(',',$');
            if($dcl[0] =~ /^none$/i) {
                eval '%'.$v.'_IMPLICIT = ()';
                next;
            }
            foreach $var (@dcl) {
                grep($var =~ s/^$_/$_/i, keys(%FORTRAN));
                $t = &WhichType($var);
                @tmp = &GetParentheses($var);
                @tmp = &GetItemList(',',$tmp[1]);
                for(local($i) = 0; $i <= $#tmp; ++$i) {
                    local($c) = $tmp[$i];
                    if($c =~ /^[a-z]$/) {
                        eval '$'.$unt.'_IMPLICIT{$c} = $t';
                    } elsif ($tmp[$i] =~ /^([a-z])\-([a-z])$/) {
                        $c = $1;
                        local($d) = $2;
                        for(; ord($c) <= ord($d); $c = chr(ord($c)+1)) {
                            eval '$'.$unt.'_IMPLICIT{$c} = $t';
                        }
                    }
                }
            }
            next;
        }
        if( ($s =~ /^CHARACTER/) ||
            ($s =~ s/^BYTE/CHARACTER/) ||     # !f77
            ($s =~ /^DIMENSION/) ||
            ($s =~ /^REAL/) ||
            ($s =~ /^COMPLEX/) ||
            ($s =~ /^DOUBLECOMPLEX/) ||
            ($s =~ /^DOUBLEPRECISION/) ||
            ($s =~ /^INTEGER/) ||
            ($s =~ /^LOGICAL/)) {
            local($ss) = $';
            $t = &WhichType($s);
#           grep($s =~ s/^$_//, keys(%FORTRAN));
            $s = $ss;
            $s =~ s/^[\*\(\)\d]*//;
            if($s =~ /^function/) {
                @tmp = &GetParentheses($');
                if($#tmp == 2) {
                    $unt = $tmp[0];             # unit name
                    push(@myroutines, $unt);
                    &DeclareUnit($unt, $tmp[1], $t);
                    print "$stl: $unt($ArgumentList{$unt})\n" if $debugflg;
                } else {
                    $s =~ s/^function/FUNCTION /;
                    &ErrorMsg(1, "Invalid function definition [$org].");
                }
                next;
            }
            @VARS = GetItemList(',',$s);
            foreach $var (@VARS) {
                if($var eq $unt) {    # type declaration for the unit
                    $RoutineType{$var} = $t;
                    eval '$'.$var.'_sclr{$var} = $t';
                } else {
                    &DeclareVariable($var, $t);
                }
            }
            next;
        }
        if ($s =~ /^PARAMETER/) {
            @tmp = &GetParentheses($');
            if($#tmp == 2) {
                @tmp = &GetItemList(',',$tmp[1]);
                foreach $var (@tmp) {
                    $var =~ /=/;
                    local($v) = $`;     # constant name
                    $_ = $';            # r.h.s.
                    local($d) = &Parameters($_);
                    local($t) = '';
                    $t = &ImplicitType($v) unless($t = &GetType($v));
                    if($t =~ /^D/ && $d =~ /[\+\-]?\d*\.?\d*e[\+\-]?\d*/i) {
                        $d =~ s/e/d/i;  # double
                    }
#                    print "  $stl: (PARAMETER) $v = $d\n" 
#                        if $verboseflg;
                    eval '$'.$unt.'_parm{$v} = $d';
                    &RegScalar($v,&ImplicitType($v));
                }
            } else {
                &ErrorMsg(1,"Invalid PARAMETER statement [$org].");
            }
            next;
        }
        if ($s =~ /^EXTERNAL/) {
            @tmp = &GetItemList(',',$');
            foreach $var (@tmp) {
                &RegExtern($var,'U','?');
            }
            next;
        }
        if ($s =~ /^COMMON/) {
            $_ = $';
            if(/\//) {      # named common
                @tmp = &GetItemList('/',$_);
                shift(@tmp);
                while($#tmp > -1) {
                    local($cname) = shift(@tmp);
                    local($cdclr) = shift(@tmp);
                    chop $cdclr if $cdclr =~ /,$/;
                    &CommonBlock($cname, $cdclr);
                }
            } else {
                &CommonBlock('_noname_', $_);
            }
            next;
        }
        if (($s =~ /^EQUIVALENCE/) ||
            ($s =~ /^INTRINSIC/) ||
            ($s =~ /^SAVE/) ||
            ($s =~ /^DATA/) ||
            ($s =~ /^FORMAT/)) {
            next;
        }
#
# executable statements
#
        while(($s ne '')  && !($s =~ /^END\b/)) {
            local($t) = '';
            local($l) = 0;
            local($dim) = '';
            local(@VARS) = ();
            if ($s =~ /^([a-z][a-z_\d]*)=/i) {
# assignment to a scalar / DO
                local($v) = "\L$1\E";
                @tmp = &ScanExpr($');
                $v =~ s/^do\d*// if($s =~ /^DO/ && $#tmp > 0);  # DO statement
                $t = &ImplicitType($v) unless($t = &GetType($v));
                &RegScalar($v,$t) unless $stflg;
                $s = &GetLine;              # goto next line
                next;
            }
            @tmp = &GetParentheses($s);
            if(($#tmp == 2) && $tmp[2] =~ /^=/) {   # assignment to an array, etc
# assignment statement
                local($rhs) = $';
                local($v) = "\L$tmp[0]\E";          # left had side
                if(&TypeReg('arry', $v)) {          # array element
                    &ScanExpr($tmp[1]);             # subcheck
                } elsif(($t = &TypeReg('sclr', $v)) && ($t =~ /^S/)) {
                    # assignment to a partial string (no check)
                } else {                            # statement function
                    print "$stl: Statement function [$s]\n" if $debugflg;
                    @tmp = &GetItemList(',',$tmp[1]);
                    if($t = &TypeReg('sclr', $v)) {
#                       ptint "$stl: scalar '$v = $t' deleted\n" if $debugflg;
                        eval 'delete($'.$unt.'_sclr{$v})';
                    } else {
                        $t = &ImplicitType($v);
                    }
                    eval '$'.$unt.'_stfA{$v} = ""';
                    eval '$'.$unt.'_stfT{$v} = $t';
                    for(local($i) = 0; $i <= $#tmp; ++$i) {
                        $t = &ImplicitType($tmp[$i]) 
                            unless($t = &GetType($tmp[$i]));
                        eval '$'.$unt.'_stfA{$v} .= $t';
                    }
                    eval '$'.$unt.'_stfA{$v} =~ s/,$//';
#                   print "  $stl: ".eval('$'.$unt.'_stfT{$v}').
#                       ":$v(".eval('$'.$unt.'_stfA{$v}').") = $rhs\n"
#                           if $debugflg;
                }
                &ScanExpr($rhs);
            } elsif ($s =~ /^ASSIGN/) {
            } elsif ($s =~ /^BACKSPACE/) {
            } elsif ($s =~ /^CALL/) {
                $s = $';
                if($s =~ /\(/) {            # subroutine with arguments
                    @tmp = &GetParentheses($s);
                    local(@tmp2) = &ScanExpr($tmp[1]);
                    &RegExtern($tmp[0],'V',join(',',@tmp2));
                } else {                    # subroutine with no argument
                    &RegExtern($s,'V','');
                }
            } elsif ($s =~ /^CLOSE/) {
            } elsif ($s =~ /^CONTINUE/) {
            } elsif ($s =~ /^DATA/) {
            } elsif ($s =~ /^DO/) {
            } elsif ($s =~ /^ENDDO/) {
            } elsif ($s =~ /^ENDFILE/) {
            } elsif ($s =~ /^ENDIF/) {
            } elsif ($s =~ /^ELSE/) {
            } elsif ($s =~ /^ENTRY/) {
                $s = $';
                $t = $RoutineType{$unt};
                local($a) = '';
                if($s =~ /\(/) {
                    @tmp = &GetParentheses($s);
                    if($#tmp == 2) {
                        $a = $tmp[1];
                    } else {
                        &ErrorMsg(-1,"Unmatched () in [$org]");
                    }
                } else {
                    @tmp = ($s);
                }
                &DeclareUnit($tmp[0], $a, $t);
                print "\n$stl: Entering '$tmp[0]($a)'\n" if $verboseflg;
                push(@myroutines, $tmp[0]);
                print "$stl: $t : $tmp[0]($ArgumentList{$tmp[0]})\n" 
                    if $debugflg;
            } elsif ($s =~ /^FORMAT/) {
            } elsif ($s =~ /^GOTO/) {
            } elsif (($s =~ /^IF/) || ($s =~ /^ELSEIF/) || ($s =~ /^DOWHILE/)){
                @tmp = &GetParentheses($s);
                $t = &ScanExpr($tmp[1]) if($#tmp == 2);
            } elsif ($s =~ /^INQUIRE/) {
            } elsif ($s =~ /^OPEN/) {
            } elsif ($s =~ /^PAUSE/) {
            } elsif ($s =~ /^PRINT/) {
            } elsif ($s =~ /^READ/) {
            } elsif ($s =~ /^RETURN/) {
            } elsif ($s =~ /^REWIND/) {
            } elsif ($s =~ /^STOP/) {
            } elsif ($s =~ /^WRITE/) {
            } else {
#               &ErrorMsg(1,"??? [$org].");
            }
            $s = &GetLine;  # goto next line
        }
# the end of a unit
# replace types of variables with implicitly declared ones if not declared
        $RoutineType{$unt} = &ImplicitType($unt) 
            if($RoutineType{$unt} && $RoutineType{$unt} eq 'U');
        foreach $var (eval 'sort keys(%'.$unt.'_sclr)') {
            local($t) = &TypeReg('sclr', $var);
            if($t =~ /^U/) {
                substr($t,0,1) = &ImplicitType($var);
                eval '$'.$unt.'_sclr{$var} = $t';
            }
        }
        foreach $var (eval 'sort keys(%'.$unt.'_arry)') {
            local($t) = &TypeReg('arry', $var);
            if($t =~ /^U/) {
                substr($t,0,1) = &ImplicitType($var);
                eval '$'.$unt.'_arry{$var} = $t';
            }
        }
        foreach $var (eval 'sort keys(%'.$unt.'_funcT)') {
            local($t) = &TypeReg('funcT', $var);
            if($t =~ /^U/) {
                substr($t,0,1) = &ImplicitType($var);
                eval '$'.$unt.'_funcT{$var} = $t';
            }
        }
        foreach $var (eval 'sort keys(%'.$unt.'_stfT)') {
            local($t) = &TypeReg('stfT', $var);
            if($t =~ /^U/) {
                substr($t,0,1) = &ImplicitType($var);
                eval '$'.$unt.'_stfT{$var} = $t';
            }
        }
        foreach $var (eval 'sort keys(%'.$unt.'_cmn)') {
            local($t) = &TypeReg('cmn', $var);
            if($t =~ /^U/) {
                substr($t,0,1) = &ImplicitType($var);
                eval '$'.$unt.'_cmn{$var} = $t';
            }
        }
# determine types of the dummy arguments
        local(@VARS) = GetItemList(',',$ArgumentList{$unt});
        foreach $var (@VARS) {
            local($t) = '';
            if($t = &TypeReg('funcT', $var)) {
#                $t .= "(".&TypeReg('funcA', $var).")"; # R(?) or V(?), etc.
                $t = 'E';
            } elsif(($t = &TypeReg('arry', $var)) || 
                    ($t = &TypeReg('sclr', $var))) {
            } else {
                $t = ImplicitType($var);
                &ErrorMsg(0,"Assumed '$t : $var' for an argument of '$unt'.") if($stflg || $warnflg);
            }
            $var = $t;
        }
        $ArgumentList{$unt} = join(',',@VARS);
# output a list of all variables declared in this unit
        & RefTable if $reffile;
# ???
        if(!($s =~ /^END\b/)) {
            &ErrorMsg(1,"No 'END' in $unt. [$s]");
            exit(1) unless $nonstpflg;  # ERROR
        }
        $unt = '';
    }
}

sub ScanExpr
#
#  &ScanExpr(<flag>, <expression>[, <expression>, ...])
#
#      <expression> = array indices  : <flag> != 0
#                   = arguments      : otherwise
#      return value = a list of types of entries in the expression
{
    local(@ITEMS) = &GetItemList(',',@_);
    print "$stl: [".join(',',@ITEMS)."] => " if $debugflg;
    foreach $var (@ITEMS) {
        local($s) = &Constants($var);
#local($varlast) = $s;
        local($v) = '';
        local($t) = '';
        local($l) = '';
        local($r) = '';
        local(@tmp) = &GetParentheses($s);
# evaluate parentheses first
        while($#tmp == 2) {
            $s = $tmp[2];
            local(@tmp2) = ();
            local($a) = '';
            $t = '';
            if($tmp[0] =~ /([a-z_][a-z_\d]*)$/) {
                $v = $1;                # name
                $r .= $`;
                local($tt) = '';
                if(($tt = &TypeReg('sclr', $v)) && $tt =~ /^S/) {
                    @tmp2 = &GetItemList(':',$tmp[1]);# partial string
                    if($#tmp2 == 1) {
                        ($tmp2[0]) = &ScanExpr($tmp2[0]);
                        ($tmp2[1]) = &ScanExpr($tmp2[1]);
                    }
                    $r .= $tt;
                    @tmp = &GetParentheses($s);
                    next;
                }
                if($tt = &TypeReg('arry', $v)) {                # array elemet
                    $t = $tt;
                    $t =~ /\(/;
                    $r .= $`;
                    &ScanExpr($tmp[1]);     # subcheck
                    @tmp = &GetParentheses($s);
                    next;
                }
                $t = &ImplicitType($v) unless($t = &GetType($v));
                @tmp2 = &ScanExpr($tmp[1]);     # argcheck
                $a = join(',',@tmp2);
                if($tt = &TypeReg('args', $v)) {            # dummy
                    $t = $tt;
                } elsif($tt = &TypeReg('sclr', $v)) {       # a type declared
                    $t = $tt;
                } elsif ($tt = &TypeReg('stfT', $v)) {      # st.function
                    $t = $tt;
                } elsif (eval '$tt = $RoutineType{$v}') {   # external
                    $tt = $tmp2[0] if $tt eq 'X';
                    $t = $tt;
                }
                &RegExtern($v,$t,$a) unless $RoutineType{$v};
                $r .= $t;
            } else {
                $r .= $tmp[0];
                local(@tmp2) = &ScanExpr($tmp[1]);
                if($#tmp2 == 0) {           # an arithmetic expression
                    $r .= "($tmp2[0])";
                } elsif($#tmp2 == 1) {      # complex constant
                    ($tmp2[0]) = &ScanExpr($tmp2[0]);
                    ($tmp2[1]) = &ScanExpr($tmp2[1]);
                    $t = "($tmp2[0],$tmp2[1])";
                    $t = &Reduction($t);
                    $r .= $t;
                } else {
                    &ErrorMsg(1,"Invalid arithmetic expression '$tmp[1]'".
                        " in [$org].");
                    $r .= "($tmp[1])";
                }
            }
            @tmp = &GetParentheses($s);
        }
        $r .= $s;
# evaluate scalars
        $s = $r;
        $r = '';
        $l = '';
        while(($s ne '') && ($s ne $l)) {   # while lower cases && changes
            $l = $s;
            if(($s =~ /^([A-Z])/) || ($s =~ /^([\+\-\*\/\(\)])/)) {
                $r .= $1;
                $s = $';
                next;
            }
            if($s =~ /^(\.[EOP]\.)/) {
                $r .= $1;
                $s = $';
                $s =~ s/^[\+\-]//;
                if($s =~ s/^\d+//) {
                    $r .= 'I';
                }
                next;
            }
            next unless $s =~ /^([a-z_][a-z_\d_]*)/;
            $v = $1;
            $s = $';
            if($t = &TypeReg('parm', $v)) {
                ($t) = &ScanExpr(&Parameters($t));
                $r .= $t;
                next;
            } elsif($tt = &TypeReg('funcT', $v)) {       # chane type of func
                if($tt =~ /^U/) {
                    $t = &ImplicitType($v);
                    $tt =~ s/^./$t/;
                    if($stflg) {
                        &ErrorMsg(1,"Type undeclared for external function $v used in $unt.\n");
                    } else {
                        eval '$'.$unt.'_funcT{$v} = $tt';
                    }
                }
                $t = $tt;
                $t .= "(".&TypeReg('funcA', $v).")";
            } elsif($t = &TypeReg('sclr', $v)) {
                if($t =~ /^U/) {
                    substr($t,0,1) = &ImplicitType($v);
                    if($stflg) {
                        &ErrorMsg(1,"Type undeclared for scalar variable $v used in $unt.\n");
                    } else {
                        eval '$'.$unt.'_sclr{$v} = $t';
                    }
                }
            } elsif($t = &TypeReg('arry', $v)) {
                if($t =~ /^U/) {
                    substr($t,0,1) = &ImplicitType($v);
                    if($stflg) {
                        &ErrorMsg(1,"Type undeclared for array variable $v used in $unt.\n");
                    } else {
                        eval '$'.$unt.'_arry{$v} = $t';
                    }
                }
            } elsif($tt = &TypeReg('stfT', $v)) {
                if($tt =~ /^U/) {
                    $t = &ImplicitType($v);
                    $tt =~ s/^./$t/;
                    if($stflg) {
                        &ErrorMsg(1,"Type undeclared for statement function $v used in $unt.\n");
                    } else {
                        eval '$'.$unt.'_stfT{$v} = $tt';
                    }
                }
                $t = $tt;
                $t .= "(".&TypeReg('stfA', $v).")";
            } else {              # not declared
                $t = &ImplicitType($v);
                &RegScalar($v,$t) unless $stflg;
                if($stflg) {
                    &ErrorMsg(1,"Undeclared variable $v used as $t.\n") 
                } elsif($verboseflg) {
                    &ErrorMsg(0,"Undeclared variable $v used as $t.\n") 
                }
            }
            $r .= $t;
            $v = '';
        }
        $r .= $s;
        $s = &Reduction($r);
        $r = '';
        $var = $s;
    }
    print "[".join(',',@ITEMS)."]\n" if $debugflg;
    return @ITEMS;
}

sub Check
{
    $scanflg = 0 if $#FILES < 1;
    $org = '';
    $unt = '';
    $lin = '';
    $nxt = '';
    $loc = 0;
    $stl = 0;
    $lst = 0;
    local(@tmp) = ();
    local($s) = '';
    $nxt = '';
    $unt = '';
    while(($s = &GetLine) ne '') {
# statements for declarations
        if ($s =~ /^BLOCKDATA/) {     # skip BLOCK DATA unit
            while(($s ne '')  && !($s =~ /^END\b/)) {$s = &GetLine;}
            last if $s eq '';
            next;
        }
# beginning of a program unit
        if ($s =~ /^FUNCTION/i || $s =~ /^SUBROUTINE/) {
            @tmp = &GetParentheses($');
            $unt = $tmp[0];             # unit name
            print "\n$stl: Entering '$unt($tmp[1])$tmp[2]'\n" if $verboseflg;
            next;
        }
        if( ($s =~ /^CHARACTER/) ||
            ($s =~ s/^BYTE/CHARACTER/) ||     # !f77
            ($s =~ /^REAL/) ||
            ($s =~ /^COMPLEX/) ||
            ($s =~ /^DOUBLECOMPLEX/) ||
            ($s =~ /^DOUBLEPRECISION/) ||
            ($s =~ /^INTEGER/) ||
            ($s =~ /^LOGICAL/)) {
            $s = $';
            $s =~ s/^[\*\(\)\d]*//;
            $unt = $1 if $s =~ /^function([a-z_][a-z_\d]*)/;
            next;
        }
        if($unt eq '') {
            $unt = 'main';
            print "\n$stl: Entering main: Program Name = '$ProgramName'\n" 
                if $verboseflg;
        }
        if (($s =~ /^PROGRAM/) ||
            ($s =~ /^IMPLICIT/) ||
            ($s =~ /^DATA/) ||
            ($s =~ /^FORMAT/) ||
            ($s =~ /^DIMENSION/) ||
            ($s =~ /^PARAMETER/) ||
            ($s =~ /^EXTERNAL/) ||
            ($s =~ /^COMMON/) ||
            ($s =~ /^EQUIVALENCE/) ||
            ($s =~ /^INTRINSIC/) ||
            ($s =~ /^SAVE/)) {
            next;
        }
#
# executable statements
#
        while(($s ne '')  && !($s =~ /^END\b/)) {
            local($t) = '';
            local($l) = 0;
            local($dim) = '';
            local(@VARS) = ();
            if ($s =~ /^([a-z][a-z_\d]*)=/i) {
# assignment to a scalar or DO
                $v = "\L$1\E";
                @tmp = &CheckExpr($');      # check r.h.s.
                $v =~ s/^do\d*// if($s =~ /^DO/ && $#tmp > 0);  # DO statement
                &CheckExpr($v);
                $s = &GetLine;              # goto next line
                next;
            }
            @tmp = &GetParentheses($s);
            local $Exper = '';
            if($tmp[2] =~ /^(\(\w+\:\w+\))\s*/) {
                $Exper = $1;
                $tmp[2] = $';
            }
            if($#tmp == 2 && $tmp[2] =~ /^=/) {
# assignment to an array element
                local($v) = "\L$tmp[0]\E";                  # left had side
                local($rhs) = $';
                &CheckExpr($rhs);
                if(&TypeReg('arry', $v)) {  # array element
                    &CheckExpr("$v($tmp[1])$Exper");
                } elsif(($t = &TypeReg('sclr', $v)) && ($t =~ /^S/)) {
                                                # partial string (no check)
                } else {                        # statement function
                    print "$stl: Statement function [$s]\n" if $debugflg;
                    @tmp = &GetItemList(',',$tmp[1]);
#                   print "  $stl: ".&TypeReg('stfT', $v)).
#                       ":$v(".&TypeReg('stfA', $v)).") = $rhs\n"
#                           if $debugflg;
                }
            } elsif ($s =~ /^ASSIGN/) {
            } elsif ($s =~ /^BACKSPACE/) {
            } elsif ($s =~ /^CALL/) {
                $s = $';
                local($v) = '';
                local($a) = '';
                if($s =~ /\(/) {
                    $v = $`;
                    $a = $';
                    $a =~ s/\)$//;
                    local($tt) = '';
                    if($ArgumentList{$v}) {
                        &ArgCheck($v,$ArgumentList{$v},$a);
                    } else {
                        $a = $org;
                        $a =~ /($v)/i;
                        &ErrorMsg(1,
                            "Undefined reference to '\L$1\E' in [$org].") 
                                if $undefflg;
                    }
                } else {
                    local($tt) = '';
                    if($tt = $RoutineType{$s}){
                        &ArgCheck($s,$ArgumentList{$s},'');
                    } else {
                        &ErrorMsg(1,
                            "Undefined reference to '\L$s\E' in [$org].") 
                                if $undefflg;
                    }
                }
            } elsif ($s =~ /^CLOSE/) {
            } elsif ($s =~ /^CONTINUE/) {
            } elsif ($s =~ /^DATA/) {
            } elsif ($s =~ /^DOWHILE/) {
            } elsif ($s =~ /^DO/) {
            } elsif ($s =~ /^ENDDO/) {
            } elsif ($s =~ /^ENDFILE/) {
            } elsif ($s =~ /^ENDIF/) {
            } elsif ($s =~ /^ELSE/) {
            } elsif ($s =~ /^ENTRY/) {
            } elsif ($s =~ /^FORMAT/) {
            } elsif ($s =~ /^GOTO/) {
            } elsif(($s =~ /^IF/) || ($s =~ /^ELSEIF/) || ($s =~ /^DOWHILE/)) {
                @tmp = &GetParentheses($s);
                if($#tmp == 2) {
                    ($t) = &CheckExpr($tmp[1]);
                    if($tmp[2] =~ /\d+\,\d+\,\d+/) {    # arithmetic IF
                        &ErrorMsg(1,"Invalid arithmetic expression".
                            " in IF statement [$org].") unless $t =~ /^[IRDCQ]/;
                    } else {
                        &ErrorMsg(1,"Invalid logical expression ($tmp[1]) = $t".
                            " in [$org].") if($t ne 'L');
                    }
                } else {
                    &ErrorMsg(1,"Invalid statement [$org].");
                }
            } elsif ($s =~ /^INQUIRE/) {
            } elsif ($s =~ /^OPEN/) {
            } elsif ($s =~ /^PAUSE/) {
            } elsif ($s =~ /^PRINT/) {
            } elsif ($s =~ /^READ/) {
            } elsif ($s =~ /^RETURN/) {
            } elsif ($s =~ /^REWIND/) {
            } elsif ($s =~ /^STOP/) {
            } elsif ($s =~ /^WRITE/) {
            } else {
                &ErrorMsg(1,"Unknown statement [$org].");
            }
            $s = &GetLine;  # goto next line
        }
        print "\n$stl: End of '$unt'\n" if $debugflg;
# ???
        if(!($s =~ /^END\b/)) {
            &ErrorMsg(-1,"No 'END' in $unt. [$org]");
        }
        $unt = '';
    }
}

sub CheckExpr
{
    local(@ITEMS) = &GetItemList(',',@_);
    print "$stl: [".join(',',@ITEMS)."] => " if $debugflg;
    foreach $var (@ITEMS) {
        local($s) = &Constants($var);
        if( $s =~ /^([IRDCQ])$/ || 
            $s =~ /^([\+\-][IRDCQ])$/ || 
            $s =~ /^(S\d*)$/) {
            $var = $1;
            next;
        }
        local($v) = '';
        local($t) = '';
        local($l) = '';
        local($r) = '';
        while(($s ne '') && $s ne $l) {
            $l = $s;
            if(($s =~ /^([A-Z])/) || ($s =~ /^([\+\-\*\/\(\)\,])/)) {
                $r .= $1;
                $s = $';
                next;
            }
            if($s =~ /^(\.[EOP]\.)/) {
                $r .= $1;
                $s = $';
                $s =~ s/^[\+\-]//;
                if($s =~ s/^\d+//) {
                    $r .= 'I';
                }
                next;
            }
            $s =~ /([a-z_][a-z_\d]*)/;
            $r .= $`;
            $v = $1;
            next if $v && $v eq '';
            $s = $';
            $t = '';
            local($tt) = '';
            if($tt = &TypeReg('parm', $v)) {        # parameter constant
                ($t) = &CheckExpr(&Parameters($tt));
            } elsif($s =~ /^\(/) {                      # abc(...)
                local(@tmp) = &GetParentheses($s);
                local(@tmp2) = ();
                if($#tmp == 2) {
                    $s = $tmp[2];
                    if(($tt = &TypeReg('sclr', $v)) && $tt =~ /^S/) {  # partial string
                        @tmp2 = &GetItemList(':',$tmp[1]);
                        if(($#tmp2 == 0) && ($tmp[1] =~ /\:$/)) {
                            ($tmp2[0]) = &CheckExpr($tmp2[0]);
                            $tmp2[0] =~ s/^\+//;
                            if(($tmp2[0] && ($tmp2[0] ne 'I'))) {
                                &ErrorMsg(1, "Invalid partial string '$var' ".
                                    "($tmp2[0]:) != (I:)");
                            }
                        } elsif($#tmp2 == 1) {
                            ($tmp2[0]) = &CheckExpr($tmp2[0]);
                            $tmp2[0] =~ s/^\+//;
                            ($tmp2[1]) = &CheckExpr($tmp2[1]);
                            $tmp2[1] =~ s/^\+//;
                            if(($tmp2[0] && ($tmp2[0] ne 'I')) || 
                               ($tmp2[1] && ($tmp2[1] ne 'I'))) {
                                &ErrorMsg(1, "Invalid partial string '$var' ".
                                    "($tmp2[0]:$tmp2[1]) != (I:I)");
                            }
                        } else {
                            &ErrorMsg(1, "Invalid partial string $var");
                        }
                        $t = $tt;
                    } else {
                        @tmp2 = &CheckExpr($tmp[1]);
                        if ($tt = &TypeReg('stfT', $v)) {   # st.function
                            $t = $tt;
                        } elsif ($tt = &TypeReg('arry', $v)) {  # array
                            $t = $tt;
                            $t =~ s/\(.*$//;
                        } elsif((eval 'grep($v =~ /^$_$/,@'.$unt.'_args)') && 
                                ($tt = &TypeReg('funcT', $v))) { # dmy fn.
                            $t = $tt;
                        } elsif (eval '$tt = $RoutineType{$v}') {   # external
                            local(@t1) = &CheckExpr($tmp[1]);
                            local($insA) = join(',',@t1);
                            local($defA) = eval '$'.$unt.'_funcA{$v}';
                            $defA = $ArgumentList{$v} unless length($defA);
                            local(@t2) = &GetItemList(',',$defA);
                            $tt = $t1[0] if $tt eq 'X';
                            $tt =~ s/^[\+\-]//;
                            $t = $tt;
                            if(($t2[$#t2] ne '.') && ($#t1 != $#t2)) {
                                &ErrorMsg(1,"Inconsistent # of arguments in ".
                                    "[$v($tmp[1])]: ".eval("$#t1+1")." != ".
                                    eval("$#t2+1"));
                            } elsif(($t2[$#t2] eq '.') && ($#t1 < $#t2 - 1)) {
                                &ErrorMsg(1,"Inconsistent # of arguments in ".
                                    "[$v($tmp[1])]: ".eval("$#t1+1")." != ".
                                    eval("$#t2+1"));
                            } elsif($insA ne $defA) {
                                for(local($i) = 0; $i <= $#t1; ++$i) {
                                    local($v1) = &Reduction($t1[$i]);
                                    local($v2) = &Reduction($t2[$i]);
                                    if(($v1 =~ /\(/) && ($v2 =~ /\(/)) {
                                        local(@tv1) = &GetParentheses($v1);
                                        local(@tv2) = &GetParentheses($v2);
                                        if($#tv1 != $#tv2) {
                                            &ErrorMsg(1,
                                                "Type mismatch at ".&OrdNum($i).
                                                " arg of \"$v($tmp[1])\": ".
                                                "$v1 != $v2");
                                        } else {
                                            local($tverr) = 0;
                                            for(local($tvj) = 1; $tvj <= $#tv1; ++$tvj) {
                                                if($tv1[$tvj] || $tv2[$tvj]) {
                                                    (++ $tverr) unless($tv1[$tvj] eq '*' || $tv2[$tvj] eq '*');
                                                }
                                            }
                                            &ErrorMsg(1,
                                                "Type mismatch at ".&OrdNum($i).
                                                " arg of \"$v($tmp[1])\": ".
                                                "$v1 != $v2") if $tverr;
                                        }
                                    } elsif(($v1 =~ /^U/) || ($v2 =~ /^U/)) {
                                        &ErrorMsg(1,
                                            "Type mismatch at ".&OrdNum($i).
                                            " arg of \"$v($tmp[1])\": ".
                                            "$v1 != $v2") 
                                            if(substr($v1,1) ne substr($v2,1));
                                    } elsif(($v2 ne 'X') && ($v2 ne '?') && ($v2 !~ /^\./)) {
                                        &ErrorMsg(1,
                                            "Type mismatch at ".&OrdNum($i).
                                            " arg of \"$v($tmp[1])\": ".
                                            "$v1 != $v2") if($v1 ne $v2);
                                    }
                                }
                            }
                        } else {
                            $t = &ImplicitType($v) unless($t = &GetType($v));
                            local($a) = $org;
                            $a =~ /($v)/i;
                            &ErrorMsg(1,
                                "Undefined reference to '\L$1\E' in [$org].") 
                                    if $undefflg;
                        }
                    }
                    $r .= $t;
                    next;
                } else {
                    &ErrorMsg(1,"Unmatched () in '$var'.");
                    $s = '';
                    @tmp2 = ();
                }
                if($tt = &TypeReg('stfT', $v)) {        # statement function
                    $t = $tt;
                    &ArgCheck($v, &TypeReg('stfA', $v), $tmp[1]);
                } elsif($tt = &TypeReg('arry', $v)) {   # array element
                    $tt =~ /\(/;
                    $t = $`;
                    $tt = $';
                    $tt =~ s/\)$//;
                    &SubCheck($v,$tt,$tmp[1]);
                } elsif((eval 'grep($v =~ /^$_$/,@'.$unt.'_args)') && 
                    ($tt = &TypeReg('funcT', $v))) {    # dummy function
                    $t = $tt;
                    $t =~ s/\(.*//;
                } elsif(eval '$tt = $RoutineType{$v}') {    # external
                    $t = $tt;
                    if($t eq 'X') {
                        if($v eq 'abs' && $tmp2[0] eq 'C') {
                            $t = 'R';
                        } else {
                            $t = $tmp2[0];
                        }
                    }
                    &ArgCheck($v,$ArgumentList{$v},$tmp[1]);
                } elsif($tt = &TypeReg('arry', $v)) {   # array element
                    $tt =~ /\(/;
                    $t = $`;
                    $tt = $';
                    $tt =~ s/\)$//;
                    &SubCheck($v,$tt,$tmp[1]);
                } else {
                    local($a) = $org;
                    $a =~ /($v)/i;
                    &ErrorMsg(0,"Undefined reference to '\L$1\E' in [$org].") 
                        if $undefflg;
                }
            } else {                                        # no ()
                if($tt = &TypeReg('sclr', $v)) {            # scalar
                    $t = $tt;
                } elsif($tt = &TypeReg('arry', $v)) {       # array
                    $t = $tt;
                } elsif((eval 'grep($v =~ /^$_$/,@'.$unt.'_args)') && 
                    ($tt = &TypeReg('funcT', $v))) {        # dummy function
                    $t = $tt;
                } elsif(eval '$tt = $RoutineType{$v}') {    # external
                    $t = $tt;
                    $t .= "($ArgumentList{$v})";
                } else {                                    # undeclared var.
                    &ErrorMsg(0,"Variable '$v' is not declared in '$unt'.") 
                        if($stflg);
                    $t = &ImplicitType($v) unless($t = &GetType($v));
                }
            }
            $r .= $t;
        }
        $r .= $s;
        $s = &Reduction($r);
        $r = '';
        $var = $s;
    }
    print "[".join(',',@ITEMS)."]\n" if $debugflg;
    return @ITEMS;
}

sub ArgCheck
{
    local($name, $Decl, $Expr) = @_;
    local(@Dargs) = &GetItemList(',', $Decl);       # declaration as a reference
    local(@Exprs) = &GetItemList(',', $Expr);       # arg list to be checked
    local(@Eargs) = &CheckExpr($Expr);              # types to be checked
    local(@Dtmp) = ();
    local(@Etmp) = ();
    local($Dt) = $Dargs[0];
    if(($Decl =~ /\,\./) || ($#Dargs == $#Eargs)) { # ',.' variable # of args.
        local($s) = '';
        for(local($i) = 0; $i <= $#Eargs; ++$i) {
            $s = &OrdNum($i);
            $Eargs[$i] =~ s/^[\+\-]//;
            local($Et) = $Eargs[$i];
            local($En) = $Exprs[$i];
            $Dt = $Dargs[$i] if $Decl !~ /\,\./;
            if($Dt =~ /^E/) {
                print "$stl: '$En' in '$name($Expr)' = $Eargs[$i]\n" if $debugflg;
                &ErrorMsg(1,"The $s arg '$En' in '$name($Expr)' is not ".
                    "defined as an external.") unless $RoutineType{$En};
            } elsif(($Dt ne 'X') && (substr($Et,0,1) ne substr($Dt,0,1))) {
                &ErrorMsg(1,"Type mismatch at the $s arg. ".
                    "$Eargs[$i] (!= $Dt) in '$name($Expr)'.");
            } elsif(($Dt =~ /\([a-z_\d\*]/) && 
                    ($Et =~ /\([a-z_\d\*]/)) { # array
                if(($Dt =~ /\(/) && ($Et =~ /\(/)) {
                    local(@tDt) = &GetParentheses($Dt);
                    local(@tEt) = &GetParentheses($Et);
                    if($#tDt != $#tEt) {
                        &ErrorMsg(1,
                            "Type mismatch at ".&OrdNum($i).
                            " arg of \"$v($tmp[1])\": ".
                            "$Dt != $Et");
                    } else {
                        local($tverr) = 0;
                        local($tvwrn) = 0;
                        for(local($tvj) = 1; $tvj <= $#tDt; ++$tvj) {
                            if(($tDt[$tvj] || $tEt[$tvj]) && 
                                $tDt[$tvj] ne '*' && $tEt[$tvj] ne '*') {
                                if($tDt[$tvj] =~ /\:/ && $tEt[$tvj] =~ /\:/) {
                                    local(@aDt) = split(':',$tDt[$tvj]);
                                    local(@aEt) = split(':',$tEt[$tvj]);
                                    if($#aDt != $#aEt) {
                                        ++ $tverr;
                                    } else {
                                        for(local($iXt) = 0; $iXt <= $#aDt; ++$iXt) {
                                            local($raDt) = $aDt[$iXt];
                                            local($raEt) = $aEt[$iXt];
                                            if($raDt ne $raEt && $raDt ne '*' && $raEt ne '*') {
                                                ++ $tverr;
                                                $raDt =~ s/[a-z_][a-z_\d]*/I/g;
                                                if($raDt =~ /^([\w\d]+)\:([\w\d]+)$/) {
                                                    $raDt = "$2-$1+1";
                                                }
                                                $raDt = &Reduction($raDt);
                                                $raEt =~ s/[a-z_][a-z_\d]*/I/g;
                                                if($raEt =~ /^([\w\d]+)\:([\w\d]+)$/) {
                                                    $raEt = "$2-$1+1";
                                                }
                                                $raEt = &Reduction($raEt);
                                                ++ $tvwrn if $raDt eq $raEt;
                                            }
                                        }
                                    }
                                } elsif($tDt[$tvj] =~ /\,/ && $tEt[$tvj] =~ /\,/) {
                                    local(@aDt) = split(',',$tDt[$tvj]);
                                    local(@aEt) = split(',',$tEt[$tvj]);
                                    if($#aDt != $#aEt) {
                                        ++ $tverr;
                                    } else {
                                        for(local($iXt) = 0; $iXt <= $#aDt; ++$iXt) {
                                            local($raDt) = $aDt[$iXt];
                                            local($raEt) = $aEt[$iXt];
                                            if($raDt ne $raEt && $raDt ne '*' && $raEt ne '*') {
                                                ++ $tverr;
                                                $raDt =~ s/[a-z_][a-z_\d]*/I/g;
                                                if($raDt =~ /^([\w\d]+)\:([\w\d]+)$/) {
                                                    $raDt = "$2-$1+1";
                                                }
                                                $raDt = &Reduction($raDt);
                                                $raEt =~ s/[a-z_][a-z_\d]*/I/g;
                                                if($raEt =~ /^([\w\d]+)\:([\w\d]+)$/) {
                                                    $raEt = "$2-$1+1";
                                                }
                                                $raEt = &Reduction($raEt);
                                                ++ $tvwrn if $raDt eq $raEt;
                                            }
                                        }
                                    }
                                } else {
                                ++ $tverr;
                                local($rDt) = $tDt[$tvj];
                                $rDt =~ s/[a-z_][a-z_\d]*/I/g;
                                $rDt = &Reduction($rDt);
                                local($rEt) = $tEt[$tvj];
                                $rEt =~ s/[a-z_][a-z_\d]*/I/g;
                                $rEt = &Reduction($rEt);
                                ++ $tvwrn if $rDt eq $rEt;
                                }
                            }
                        }
                        &ErrorMsg(1,
                            "Dimensions mismatch at ".&OrdNum($i).
                            " arg of \"$v($tmp[1])\": ".
                            "$Dt != $Et") if $tverr > $tvwrn;
                        &ErrorMsg(0,
                            "Unable to check dimensions at ".&OrdNum($i).
                            " arg of \"$v($tmp[1])\": ".
                            "$Dt != $Et") if $tvwrn;
                    }
                } else {
                $Dt =~ /\(/;
                $Dt = $`;
                local($Ds) = $';
                $Ds =~ s/\)//;
                $Et =~ /\(/;
                $Et = $`;
                local($Es) = $';
                $Es =~ s/\)//;
                &ErrorMsg(1,"Unmatched length at the $s arg. ".
                    "$Et (!= $Dt) in [$org]'.") if ($Et ne $Dt) && 
                    !($Et eq 'S' && $Dt =~ /^S\d*/) && 
                    !($Dt eq 'S' && $Et =~ /^S\d*/);
                local($s1,$s2,$ss) = ($Es,$Ds,'\d*');
#                $s1 =~ s/[a-z_][a-z_\d]*/I/g;
                $s1 =~ s/\*/$ss/g;
                $s1 =~ s/\,/\\\,/g if $s1 =~ /[a-z_\*]/;
                $s1 =~ s/\:/\\\:/g if $s1 =~ /[a-z_\*]/;
#                local($r1) = &Reduction($s1);
#                $s2 =~ s/[a-z_][a-z_\d]*/I/g;
                $s2 =~ s/\*/$ss/g;
                $s2 =~ s/\,/\\\,/g if $s2 =~ /[a-z_\*]/;
                $s2 =~ s/\:/\\\:/g if $s2 =~ /[a-z_\*]/;
#                local($r2) = &Reduction($s2);
                if(($Es ne $Ds) && ($s1 !~ /$s2/) && ($s2 !~ /$s1/)) {
                    &ErrorMsg(0,"Unmatched dimension at the $s arg. ".
                        "($Es) (!= ($Ds)) in [$org]'.") if $Es ne $Ds;
                }
                }
            } elsif(($Dt ne 'X') && ($Et ne $Dt) && 
                !($Et eq 'S' || $Dt eq 'S')) {  # 'X' = generic type
                local($err) = 0;
                if($Et =~ /\(/ && $Dt =~ /\(/) {
                    @Etmp = &GetParentheses($Et);
                    @Etmp = &GetItemList(',',$Etmp[1]);
                    @Dtmp = &GetParentheses($Dt);
                    @Dtmp = &GetItemList(',',$Dtmp[1]);
                    if ($#Etmp == $#Dtmp) {
                        for(local($j) = 0; $j <= $#Etmp; ++$j) {
                            ++ $err if( $Etmp[$j] ne $Dtmp[$j] );
                        }
                    } else {
                           if($#Etmp == 0 && $Etmp[0] eq '*' && $#Dtmp > -1) {}
                        elsif($#Dtmp == 0 && $Dtmp[0] eq '*' && $#Etmp > -1) {}
                        else {$err = 1 if($#Etmp > -1);}
                    }
                } elsif($Et =~ /[a-z_\d\*]/ || $Dt =~ /[a-z_\d\*]/) {
                    &ErrorMsg(0,"Unmatched dimension at the $s arg. ".
                        "$Eargs[$i] (!= $Dt) in '$name($Expr)'.");
                } else {
                    &ErrorMsg(0,"Unmatched length at the $s arg. ".
                        "$Eargs[$i] (!= $Dt) in '$name($Expr)'.");
                }
                if($err) {
                    &ErrorMsg(1,"Incompatible routine/array at the $s arg. ".
                        "$Eargs[$i] (!= $Dt) in '$name($Expr)'.");
                }
            }
        }
    } else {
        &ErrorMsg(1,"Inconsistent # of arguments ".
            eval($#Eargs+1)." (!= ".eval($#Dargs+1).") for '$name($Expr)'.");
    }
}

sub SubCheck
{
    local($name, $Decl, $Expr) = @_;
    local(@Dargs) = &GetItemList(',', $Decl);   # declaration as a reference
    local(@Eargs) = &CheckExpr($Expr);          # expression to be checked
    if($#Dargs == $#Eargs) {
        for(local($i) = 0; $i <= $#Eargs; ++$i) {
            local($s) = &OrdNum($i);
            $Eargs[$i] =~ s/^[\+\-]//;
            if($Eargs[$i] !~ /^I/) {
                &ErrorMsg(1,"Type of the $s subscript '$Eargs[$i]' != 'I' ".
                    "in '$name($Expr)'.");
            }
        }
    } else {
        &ErrorMsg(1,"Inconsistent # of subscripts of array '$name' (".
            eval($#Eargs+1)." != ".eval($#Dargs+1).") in '$name($Expr)'.");
    }
}

sub OrdNum
{
    local($i) = @_;
    local($s) = '';
    if($i == 0) {
        $s = '1st';
    } elsif ($i == 1) {
        $s = '2nd';
    } elsif ($i == 2) {
        $s = '3rd';
    } else {
        $s = eval($i+1);
        $s .= 'th';
    }
    return $s;
}

sub CommonBlock
{
    local($cname, $cdclr) = @_;
    $common{$cname} = $cdclr unless $common{$cname};
    eval '$'.$unt.'_cmn{$cname} = $cdclr';
    local(@tmp) = &GetItemList(',',$cdclr);
    for(local($i) = 0; $i <= $#tmp; ++$i) {
        local($d) = $tmp[$i];
        local($v) = $d;
        local($t) = '';
        local($a) = '';
        local($tt) = '';
        local($dim) = '';
        if($d =~ /\((.*)\)$/) {     # dimension
            $v = $`;
            $a = $1;
            $t = 'U';
            if(eval '$tt = $'.$unt.'_sclr{$v}') {       # REAL, etc. => COMMON
                $t = $tt;
                eval 'delete($'.$unt.'_sclr{$v})';
            }
            &RegArray($v,$t,"($a)");
        } else {
            &RegScalar($v,'U') unless eval '$tt = $'.$unt.'_arry{$v}';
        }
    }
}

sub DeclareUnit
{
    local($v,$a,$t) = @_;
    local(@tmp) = &GetItemList(',',$a);
    $RoutineType{$v} = $t;
    $ArgumentList{$v} = $a;
    eval '@'.$v.'_args = @tmp';
    eval '$'.$v.'_sclr{$v} = $t unless $'.$v.'_sclr{$v}' if($t ne 'V');
    eval '%'.$v.'_IMPLICIT = %DFLTTYPE';    # set implicit type decralations
}

sub DeclareVariable
# set declared variable to internal arrays
{
    local($s, $t) = @_;
        # $s = entry in declaration: (ex) abc(-10:4,4), a(0:*), xyz(3)*5, xyz*(*)
        # $t = type determined from declaration statement: [IRDCL], Sn or S*
    print "$stl: D[$t $s => " if $debugflg;
    local($name, $sub) = ('','');
    if($s =~ /^[a-z][a-z_\d]*\(/) {  # abc(-10:4,4), a(0:*), xyz(3)*5
        local(@tmp) = &GetParentheses($s);
        if($#tmp >= 2) {
            $name = $tmp[0].$tmp[2];
            $sub = $tmp[1];
        }
    } else {    # xyz*(*), abc*3, x, aaa*(I*3)
        $name = $s;
    }
    if($t =~ /^S/) {
        if($name =~ /^([a-z][a-z_\d]*)\*/) {
            local($len) = $';                  #retrieve length for string
            $name = $1;
            $len =~ s/^\(//;
            $len =~ s/\)$//;
            $len = &Parameters($len);
            if($len !~ /^\d+$/ && $len !~ /^\*$/) {
                &ErrorMsg(1,
                    "Invalid length '$len' of a string '$name' in [$org].");
                $len = '';
            }
            substr($t,1) = $len if($len ne '');
        }
        $t = 'S1' if $t eq 'S';
        $t = 'S' if $t eq 'S*';
    }
#retrieve dimension for array
    if($sub) {             # an array
        local(@tmp) = &GetItemList(',',$sub);
        for(local($i) = 0; $i <= $#tmp; ++$i) {
            if($tmp[$i] =~ /\:/) {
                $tmp[$i] = &Parameters($`).':'.&Parameters($');
            } else {
                $tmp[$i] = &Parameters($tmp[$i]);
            }
        }
        $sub = "(".join(',',@tmp).")";
        $t = &RegArray($name, $t, $sub);
    } else {                                    # a scalar
        $t = &RegScalar($name, $t);
    }
    print "$t]\n" if $debugflg;
    return $t;
}

sub RegScalar
{
    local($v, $t) = @_;
    local($tt) = '';
    if(eval '$tt = $'.$unt.'_arry{$v}') {       # already declared as an array
        if($tt =~ /^U/) {
            local($p) = 1;
            $p = index($tt,'(');
            $t =~ s/\(.*//;
            substr($tt,0,$p) = $t;
            $t = $tt;
            eval '$'.$unt.'_arry{$v} = $t';
            eval 'print "\$'.$unt.'_arry{$v} = $'.$unt.'_arry{$v}\n"' 
                if $debugflg;
        }
    } elsif(eval '$tt = $'.$unt.'_funcT{$v}') { # already declared as a function
        if($tt =~ /^U/) {
            $t = $tt;
            eval '$'.$unt.'_funcT{$v} = $t';
            eval 'print "\$'.$unt.'_funcT{$v} = $'.$unt.'_funcT{$v}\n"' 
                if $debugflg;
        }
    } elsif(eval '$tt = $'.$unt.'_sclr{$v}') {  # already declared as a scalar
        if($tt =~ /^U/) {
            $t = $tt;
            eval '$'.$unt.'_sclr{$v} = $t';
            eval 'print "\$'.$unt.'_sclr{$v} = $'.$unt.'_sclr{$v}\n"' 
                if $debugflg;
        }
    } else {
        $t = 'S' if $t eq 'S*';
        eval '$'.$unt.'_sclr{$v} = "$t"';
        eval 'print "\$'.$unt.'_sclr{$v} = $'.$unt.'_sclr{$v}\n"' 
            if $debugflg;
    }
    return $t;
}

sub RegArray
{
    local($v, $t, $sub) = @_;
    local($tt) = '';
    if(eval '$tt = $'.$unt.'_sclr{$v}') {   # declared wrongly as a scalar
        eval 'delete($'.$unt.'_sclr{$v})';  # delete
        $t = $tt;
    }
    $t .= $sub;
    if(eval '$tt = $'.$unt.'_arry{$v}') {   # already declared as an array
        &ErrorMsg(0,"Inconsistent duplicate definition of array '$v' ".
            "[$t != $tt].") if ($t ne $tt) && $verboseflg;
    }
    eval '$'.$unt.'_arry{$v} = $t';
    eval 'print "\$'.$unt.'_arry{$v} = $'.$unt.'_arry{$v}\n"' if $debugflg;
    return $t;
}

sub RegExtern
{
    local($v,$t,$a) = @_;
    $a =~ s/([IRDCQLSEX]\(\?\))/E/g;
    local($tt) = '';
    if(eval '$tt = $'.$unt.'_sclr{$v}') {
        eval 'delete($'.$unt.'_sclr{$v})';
        $t = $tt;
    }
    if(eval '$tt = $'.$unt.'_funcT{$v}') {
        eval '$'.$unt.'_funcT{$v} = $t' if  $tt =~ /^U/ && $t !~ /^U/;
    } else {
        eval '$'.$unt.'_funcT{$v} = $t';
    }
    eval '$'.$unt.'_funcA{$v} = $a' unless eval '$tt = $'.$unt.'_funcA{$v}';
    eval 'print "\$'.$unt.'_funcT{$v} = $'.$unt.'_funcT{$v}\n"' if $debugflg;
    eval 'print "\$'.$unt.'_funcA{$v} = $'.$unt.'_funcA{$v}\n"' if $debugflg;
    return $t;
}

sub GetType         # return type of a variable
{
    local($v) = @_;
    local($t) = '';
    return $t if(eval '$t = $'.$unt.'_sclr{$v}');
    return $t if(eval '$t = $'.$unt.'_arry{$v}');
    return $t if(eval '$t = $'.$unt.'_cmn{$v}');
    return $t if(eval '$t = $'.$unt.'_funcT{$v}');
    return $t if(eval '$t = $'.$unt.'_stfT{$v}');
    return $t;
}

sub ImplicitType        # return a type of a variable implicitly declared
{
    local($v) = @_;
    local($t) = '';
    print "I[$v => " if $debugflg;
    $t = substr($v,0,1);
    &ErrorMsg(-1, 
        "Internal Error: variable '$v' not declared in '$unt'.") 
            unless($t = &TypeReg('IMPLICIT', $t));
    print "$t] " if $debugflg;
    return $t;
}

sub TypeReg
{
    local($s,$v) = @_;
    local($t) = '';
    return $t if(eval '$t = $'.$unt.'_'.$s.'{$v}');
    return '';
}

sub Constants
{
    local($s) = @_;
    local($l,$r,$v) = ('','','');
    print "Cs[$s => " if $debugflg;
    while(($s ne '') && ($s ne $l)) {
        $l = $s;
        $s = &Constant($s);
        if($s =~ m#^(//)#) {
            $r .= $1;
            $s = $';
        } elsif($s =~ /^([\+\-\*\/\(\)])/) {
            $r .= $1;
            $s = $';
        } elsif($s =~ /^(\.[EOP]\.)/) {
            $r .= $1;
            $s = $';
        } elsif($s =~ /^(\.NOT\.)/) {
            $r .= $1;
            $s = $';
        } elsif($s =~ /^([A-Z])/) {
            $r .= $1;
            $s = $';
        } elsif($s =~ /^([a-z_][a-z_\d]*)\(/) {
            local(@tmp) = &GetParentheses($s);
            if($#tmp == 2) {
                $r .= "$tmp[0]($tmp[1])";
                $s = $tmp[2];
            } else {
                &ErrorMsg(1,"Unmatched () in [$org].");
                $s =~ /^([a-z_][a-z_\d]*)/;
                $r .= $1;
                $s = $';
            }
        } elsif($s =~ /^([a-z_][a-z_\d]*)/) {
            $r .= $`;
            $v = $1;
            $s = $';
            $v = &Parameters($v);
            $v = &Constant($v);
            $r .= $v;
            if($s =~ /^\:/) {   # character
                $s = $';
                $r .= ':';
            }
        } elsif($s ne '') {
            &ErrorMsg(1,"Invalid expression '$s' in [$org].");
            $r .= $s;
            $s = '';
        }
    }
    $r .= $s;
    print "$r]\n" if $debugflg;
    return $r;
}

sub Constant
{
    local($s) = @_;
    print "C[$s => " if $debugflg;
#local($t) = $s;
# string constant
    return &StringConstant($s) if($s =~ /^\'/);
    return &StringConstant($s) if($s =~ /^\"/);
    if($s =~ /^\(/) {
        local(@tmp) = &GetParentheses($s);
        if($#tmp == 2) {
            if($tmp[1] =~ /\w+\:\w+/) {
                return $tmp[2];
            }
            local(@tmp2) = &GetItemList(',',$tmp[1]);
            if($#tmp2 == 1) {   # complex constant
                $tmp2[0] = &Constant(&Parameters($tmp2[0]));
                $tmp2[1] = &Constant(&Parameters($tmp2[1]));
                if( ($tmp2[0] =~ /^D$/ && $tmp2[1] =~ /^[IRD]$/) ||
                    ($tmp2[1] =~ /^D$/ && $tmp2[0] =~ /^[IRD]$/)) {
                    return "Q$tmp[2]";
                }
                if($tmp2[0] =~ /^[IR]$/ && $tmp2[1] =~ /^[IR]$/) {
                    return "C$tmp[2]";
                }
                &ErrorMsg(1,"Invalid expression '($tmp[1])' in [$org]");
            }
        } else {
            &ErrorMsg(1,"Unmatched () in [$org].");
        }
    }
# including decimal points
    $s =~ s/^\d+\.([EOP])\./I\.$1\./;   # *.EQ. => I.EQ.
    $s =~ s/^\d*\.\d*d[\+\-]?\d*/D/;    # *.*d[+-]* => D
    $s =~ s/^\d*\.\d*e[\+\-]?\d*/R/;    # *.*e[+-]* => R
    $s =~ s/^\d*\.\d+/R/;               # *.* => R
    $s =~ s/^\d+\.\d*/R/;               # *.* => R
# no decimal points
    $s =~ s/^\d+d[\+\-]?\d*/D/;         # double constant
    $s =~ s/^\d+e[\+\-]?\d*/R/;         # real constant
    $s =~ s/^\d+d\d+/D/;                # double constant
    $s =~ s/^\d+e\d+/R/;                # real constant
    $s =~ s/^\d+/I/;                    # integer
    print "$s] " if $debugflg;
    return $s;
}

sub Reduction
{
    local($s) = @_;
    print "$stl: R[$s] => " if $debugflg;
    $s =~ s/\'S\'/S/g;
    $s =~ s/S\d+/S/g;
    local($l) = '';
    while(($s ne '') && ($s ne $l)) {
        $l = $s;
        if($s =~ s/\(([IRDCQU])\)/$1/) {
            next;
        }
        if($s =~ s/([IRDCQU])\^U/U/) {
            next;
        }
        if($s =~ s/([IRDCQU])\^I/$1/) {
            next;
        }
        if($s =~ s/([IR])\^R/R/) {
            next;
        }
        if($s =~ s/([DCQ])\^R/$1/) {
            next;
        }
        if($s =~ s/([IRD])\^D/D/) {
            next;
        }
        if($s =~ s/([CQ])\^D/$1/) {
            next;
        }
        if($s =~ s/([IRDC])\^C/C/) {
            next;
        }
        if($s =~ s/Q\^C/Q/) {
            next;
        }
        if($s =~ s/([IRDCQ])\^Q/Q/) {
            next;
        }
        $s =~ s/\([\+\-](.)\)/\($1\)/g;             #
        $s =~ s/^[\+\-]//;                          #
        $s =~ s/^\d+/I/;                            #
        $s =~ s/^\((.)\)/$1/;                       #
# complex constant
        $s =~ s/^\([IR]\,[IR]\)/C/g;
        $s =~ s/^\(D\,[IRD]\)/Q/g;
        $s =~ s/^\([IR]\,D\)/Q/g;
#
        $s =~ s/\(\((.)\)\)/\($1\)/g;               # ((...)) => (...)
        $s =~ s/([IRDCQU][\+\-\*\/])\d+/$1I/g;
        $s =~ s/([\+\-\*\/])\((.)\)/$1$2/g;
        $s =~ s/([\(\.\+\-\*\/])\((.)\)/$1$2/g;
        $s =~ s/S\(I\:I\)/S/g;                      # partial string
# power
        local($p) = rindex($s,'**');
        while($p >=0) {
            substr($s,$p,2) = '^';
            $s =~ s/I\^([IRDCQ])/$1/;
            $s =~ s/([RDCQ])\^I/$1/;
            $s =~ s/R\^([RDCQ])/$1/;
            $s =~ s/([DCQ])\^R/$1/;
            $s =~ s/D\^([DCQ])/$1/;
            $s =~ s/([CQ])\^D/$1/;
            $s =~ s/C\^([CQ])/$1/;
            $s =~ s/Q\^([CQ])/Q/;
            $p = rindex($s,'**');
        }
# * /
        local($b) = '';
        while($s =~ /[\*\/]/ && $s ne $b) {
            $b = $s;
            $s =~ s/I[\*\/]([IRDCQ])/$1/g;
            $s =~ s/R[\*\/][IR]/R/g;
            $s =~ s/R[\*\/]([DCQ])/$1/g;
            $s =~ s/D[\*\/][IRD]/D/g;
            $s =~ s/D[\*\/]([CQ])/$1/g;
            $s =~ s/C[\*\/][IRDC]/C/g;
            $s =~ s/C[\*\/]Q/Q/g;
            $s =~ s/Q[\*\/][IRDCQ]/Q/g;
            $s =~ s/U[\*\/][IRDCQU]/U/g;
            $s =~ s/[IRDCQU][\*\/]U/U/g;
        }
# + -
        $b = '';
        while($s =~ /[\+\-]/ && $s ne $b) {
            $b = $s;
            $s =~ s/I[\+\-]([IRDCQ])/$1/g;
            $s =~ s/R[\+\-][IR]/R/g;
            $s =~ s/R[\+\-]([DCQ])/$1/g;
            $s =~ s/D[\+\-]([IRD])/D/g;
            $s =~ s/D[\+\-]([CQ])/$1/g;
            $s =~ s/C[\+\-][IRDC]/C/g;
            $s =~ s/C[\+\-]Q/Q/g;
            $s =~ s/Q[\+\-][IRDCQ]/Q/g;
            $s =~ s/U[\+\-][IRDCQU]/U/g;
            $s =~ s/[IRDCQ][\+\-]U/U/g;
        }
# string
        $b = '';
        while($s =~ /\/\// && $s ne $b) {
            $b = $s;
            $s =~ s/S\/\/S/S/g;             # combine strings
        }
# relation
        $b = '';
        while($s =~ /\.[EO]\./ && $s ne $b) {
            $b = $s;
            $s =~ s/[IRDCQS]\.E\.[IRDCQS]/L/g;
            $s =~ s/[IRD]\.O\.[IRD]/L/g;
            $s =~ s/S\.O\.S/L/g;
        }
# logical
        $b = '';
        while($s =~ /\.NOT\./ && $s ne $b) {
            $b = $s;
            $s =~ s/\.NOT\.L/L/g;
        }
        $b = '';
        while($s =~ /\.P\./ && $s ne $b) {
            $b = $s;
            $s =~ s/L\.P\.L/L/g;
        }
    }
    print "[$s]\n" if $debugflg;
    return $s;
}

sub FormLine
{
    local($s) = @_;
    $s =~ s/\s//g;
    $s = "\L$s\E";
    grep($s =~ s/^$_/$_/i, keys(%FORTRAN));
    $s =~ s/\.eq\./\.E\./g unless &TypeReg('sclr', 'eq');
    $s =~ s/\.ne\./\.E\./g unless &TypeReg('sclr', 'ne');
    $s =~ s/\.lt\./\.O\./g unless &TypeReg('sclr', 'lt');
    $s =~ s/\.le\./\.O\./g unless &TypeReg('sclr', 'le');
    $s =~ s/\.gt\./\.O\./g unless &TypeReg('sclr', 'gt');
    $s =~ s/\.ge\./\.O\./g unless &TypeReg('sclr', 'ge');
    $s =~ s/\.true./L/g unless &TypeReg('sclr', 'true');
    $s =~ s/\.false\./L/g unless &TypeReg('sclr', 'false');
    $s =~ s/\.not\./\.NOT\./g unless &TypeReg('sclr', 'not');
    $s =~ s/\.or\./\.P\./g unless &TypeReg('sclr', 'or');
    $s =~ s/\.and\./\.P\./g unless &TypeReg('sclr', 'and');
    $s =~ s/\.eqv\./\.P\./g unless &TypeReg('sclr', 'eqv');
    $s =~ s/\.neqv\./\.P\./g unless &TypeReg('sclr', 'neqv');
    return $s;
}

sub Parameters      # evaluates the RHS of an entry of a PARAMETER statement
{
    local($r) = @_;
    local($v,$s) = ('','');
    print "$stl: Pr[$r => " if $debugflg;
    while($r =~ /([a-z_][a-z_\d]*)/) {     # retrieves an identifier
        $v .= $`;
        $r = $';
        $s = $1;
        if(eval 'grep($s eq $_, keys(%'.$unt.'_parm))') {
            local($t) = eval('$'.$unt.'_sclr{$s}');
            if($t =~ /^C/ || $t =~ /^Q/) {
                $s = $t;                   # does not evaluate complex values
            } else {     # converts the expression to one compatible with Perl
                $s = eval('$'.$unt.'_parm{$s}');
            }
        }
        $v .= $s;
    }
    $v .= $r;
    if($v =~ /^[a-z_][a-z_\d]*$/) {
    } elsif($v =~ /^[-+]?\d+[-+\*\/\d]*$/) {
       $v = eval($v);
    } else {
       $v =~ s/^[-+]?([0-9]*\.)?[0-9]+(e[-+]?[0-9]+)/R/;
       $v =~ s/^[-+]?([0-9]*\.)?[0-9]+(d[-+]?[0-9]+)/D/;
       $v =~ s/^[-+]?([0-9]*\.)?[0-9]+(q[-+]?[0-9]+)/Q/;
       $v =~ s/^[-+]?([0-9]*\.)?[0-9]+(e[-+]?[0-9]+)?/R/;
       $v =~ s/^[-+]?([0-9]*\.)?[0-9]+(d[-+]?[0-9]+)?/D/;
       $v =~ s/^[-+]?([0-9]*\.)?[0-9]+(q[-+]?[0-9]+)?/Q/;
       $v =~ s/([0-9]*\.)?[0-9]+(e[-+]?[0-9]+)?/R/;
       $v =~ s/([0-9]*\.)?[0-9]+(d[-+]?[0-9]+)?/D/;
       $v =~ s/([0-9]*\.)?[0-9]+(q[-+]?[0-9]+)?/Q/;
    }
    print "$v] " if $debugflg;
    return $v;
}

sub GetLine
{
    local($lin) = $nxt;
    local($len) = 72;
    while($inclvl > -1) {
        if(eof($filehandle)) {
            close($filehandle);
            last if(--$inclvl < 0);
            $filehandle = "FIN$inclvl";
        }
        if($linebuffer) {
            $_ = $linebuffer;
            $linebuffer = '';
        } else {
            $_ = <$filehandle>;
        }
        if(/^[^$cmntchars]\s*I\s*N\s*C\s*L\s*U\s*D\s*E\s+\'([^\']+)\'/i) {   
            # INCLUDE
            $auxfile = $1;
            ++$inclvl;
            $filehandle = "FIN$inclvl";
            if(!open($filehandle, "<$currentpath/$auxfile")) {
                if(!open($filehandle, "<$auxfile")) {
                    --$inclvl;
                    &ErrorMsg(1,"Cannot open INCLUDE file '$auxfile'.");
                }
            } else {
            }
            s/^/C**/;            # commented out
        }
        ++$loc;
        chop;
        print "$loc: $_\n" if $listflg;
        next if(($_ = &StripComment($_)) eq '');
# If a tab is the first character on a line, the next character determines
# how the line is interpreted. A nonzero digit indicates a continuation line.
# Otherwise, this line is the initial line of a statement.
# A statement label, if present, must precede the first tab.
        s/^\t([1-9])/     $1/;  # tab followed by a nonzero digit indicates 
                                # a continuation line
        s/^\t/      /;          # tab as an indent to the 7th column
        if(/^(\s*\d+)\t/) {
            local($stn) = $1;
            local($add) = $';
            $_ = substr("      $stn ",-6,6).$add if(length($stn) < 6);
        } elsif(/^\s*\t/) {
            $_ = "      ".$';
        }
# Any character (including ! and ;) other than blank or 0 in position 6
# indicates that the line is a continuation of the previous line. Such a
# line is called a continuation line. The text on the continuation line
# begins in position 7. The first line of a continued statement is called
# the initial line.
       if(!/^.....0/ && /^.....(\S)/) {
            local($add) = $';
            $lin .= ' 'x$len;
            $lin =~ /^(.{$len})/;
            $lin = $1.$add;
            $len += 66;
            next;
        } elsif ($lin eq '') {
            $lst = $loc;
            $lin = $_;
            next;
        }
        $nxt = $_;
        $stl = $lst;
        $lst = $loc;
        $lin =~ s/^t/      /;
        $lin =~ /^(.....)./;
        $lin = $';
        $lin =~ s/^\s*//;
        $lin =~ s/\s*$//;
        $lin =~ s/\s+/ /g;
        $org = $lin;
        return &FormLine($org);
    }
    $nxt = '';
    if($lst > 0) {
        $stl = $lst;
        $lst = -1;
        $lin =~ s/^t/      /;
        $lin =~ /^(.....)./;
        $lin = $';
        $lin =~ s/^\s*//;
        $lin =~ s/\s*$//;
        $lin =~ s/ \s*/ /g;
        $org = $lin;
        return &FormLine($org);
    }
    return '';
}

sub StripComment
# A C or * in position 1 identifies a comment. In this case, the entire line is 
# a comment and is called a comment line. A ! in any position except position 6 
# and not in a character context indicates that a comment follows to the end of 
# the line. Comments are not significant.
#
# A line with only blank characters or with no characters is treated as a 
# comment line.
{
    local($s) = @_;
#    $s = $_;
    return '' if /^\s*$/i;                  # blank
    return '' if /^[$cmntchars]/i;          # Comment
    return '' if $semicolon && /^\;/i;      # Comment start with ';'
    return '' if $exclamation && /^\!/i;    # Comment start with '!'
    if($exclamation && /(\!)/) {            # ignore ';'s after '!' as 
        $_ = &LeftOf('!',$s);               # separators for multiple statements
        s/\s*$//;
    }
# Multiple statements on a line are separated by one or more semicolons.
# Semicolons can occur at the end of a line, and these are ignored.
    if($multisttmnts && /(\;)/) {
        $_ = &LeftOf(';',$s);
        s/\s*$//;
    }
    return $_;
}

sub LeftOf
{
    local($cm, $s) = @_;
    return $s unless($s =~ /$cm/);
    local($ll) = $`;
    local($lr) = $';
    while(($ll =~ s/\'/\'/g)%2 || ($ll =~ s/\"/\"/g)%2) {
        $ll =~ /([\'\"])/;
        local($q) = $1;                                     # $q = ' or "
        if($lr =~ /$q/) {                                   # $cm is in a string
            $ll .= "$cm$`$q";
            $lr = $';
            return "$ll$lr" unless ($lr =~ /$cm/);
            $ll .= $`;
            $lr = $';
        } else {
            &ErrorMsg(1,"Invalid comment beginning with '$cm' in [$s].");
            return "$ll$cm$lr";
        }
    }
    $linebuffer = $lr if($cm eq ';' && $multisttmnts);
    return $ll;
}

sub WhichType
{
    local($declare) = @_;
    local($typ) = '';
    if ($declare =~ /^DOUBLECOMPLEX/ || $declare =~ /^COMPLEX\*16/) {
        $typ = 'Q';
    } elsif($declare =~ /^COMPLEX/) {
        $typ = 'C';
    } elsif ($declare =~ /^DOUBLEPRECISION/ || $declare =~ /^REAL\*8/) {
        $typ = 'D';
    } elsif ($declare =~ /^REAL/ || $declare =~ /^REAL\*4/) {
        $typ = 'R';
    } elsif ($declare =~ /^INTEGER/) {
        $typ = 'I';
    } elsif ($declare =~ /^LOGICAL/) {
        $typ = 'L';
    } elsif(($declare =~ /^CHARACTER\*\((\*)\)/) || # CHARACTER*(*)
            ($declare =~ /^CHARACTER\*(\d+)/)) {    # CHARACTER*n
        $typ = "S$1";
    } elsif($declare =~ /^CHARACTER/) {             # CHARACTER
        $typ = 'S';
    } elsif($declare =~ /^DIMENSION/) {             # Unknown type
        $typ = 'U';
    } else {
        &ErrorMsg(1,"Something is wrong with a declaration '$declare'.");
    }
    return $typ;
}

sub IncludeFile
{
    local($fname) = @_;
    local($n) = 0;
    if(!open(INC, "$scriptdir$fname")) {
        if(!open(INC, $fname)) {
            return 0;
        }
    }
    while(<INC>)
    {
        print FOUT if($outfile && $mergeflg);
        chop;
        s/\#.*$//g;
        s/\s*//g;
        next if /^$/;
        ++$n;
        /(\w+)\:(\w+)\(/;
        local($typ) = $1;
        local($unt) = $2;
        local($agl) = $';
        $agl =~ s/\)$//;
        $ArgumentList{$unt} = $agl;
        $RoutineType{$unt} = $typ;
    }
    close(INC);
    return $n;
}

sub StringConstant
{
    local($s) = @_;
    return $s unless ($s =~ /^(\')/ || $s =~ /^(\")/);
    local($q) = $1;
    $s = $';
    while($s =~ /$q/) {
        $s = $';
        return "S$s" unless $s =~ /^$q/;
        $s = $';
        $s = $' if $s =~ /$q$q/;
    }
    &ErrorMsg(1,"Unmatched $q in [$org].");
    return "S$s";
}

sub GetItemList # 'xx,a(yy,"zz)a,"),bb,cc' => ('xx','a(yy,"zz)a")','bb','cc')
{
    local($c, $s) = @_;
#   print "$stl: GetItemList(\'$c\', \"$s\")\n" if $debugflg;
    return () if $s eq '';
#   print "GetItemList($stl): [$s]\n" if $debugflg;
    local(@inpar) = ();
    local(@tmp) = &GetParentheses($s);  # @tmp = ('xx,a','yy,"zz)a,"',',bb,cc')
    while($#tmp == 2) {
        push(@inpar, $tmp[1]);
        @tmp = &GetParentheses($tmp[0].'!'.$tmp[2]);
            # replace pairs of parentheses by '!''s
    }
    local($r) = $tmp[0];
    for(local($i) = 1; $i <= $#tmp; ++ $i) {    # $#tmp < 2
        $r .= $tmp[$i];             # $r = 'xx,a!,bb,cc')
        &ErrorMsg(1,"Unmatched () in '$r'.");
    }
    $r =~ s/\'\'/\'S\'/g;
    $r =~ s/\"\"/\"S\"/g;
    local(@tmp2) = ();
    while($r =~ /([\'\"])/) {
        local($rd) = $1;
        local($r1) = $`;
        local($r2) = $';
        while($r2 =~ s/^[^$rd]+//) {
            $r2 =~ s/$rd$rd//;
        }
        if($r2 =~ /^$rd/) {
            $r = $r1.'#'.$';
        } else {
            &ErrorMsg(-1,"Unmatched $rd in [$org]");
            $r = $r1.'#'.$r2;
        }
    }
    $r =~ s/\#\/\/\#/\#/g;
    $r =~ s/\#/\'S\'/g;
    local(@tmp) = split(/($c)/,$r);
    while($#tmp > -1) {
        local($t) = shift(@tmp);
        if($t =~ /^\s*\'/) {
            while(($#tmp > -1) && ($t =~ /\'/) &&
                ((($t =~ s/\'/\'/g) - ($t =~ s/\\\'/\\\'/g))%2)) {
                $t .= shift(@tmp);
            }
        }
        push(@tmp2, $t);
    }
    local($j) = 0;
    @tmp = ();
    @delimiters = ();
    push(@delimiters, '');
    while($#tmp2 > -1) {
        local($ts) = '';
        local($itm) = shift(@tmp2);
        while($itm =~ /!/) {$itm =~ s/!/\($inpar[$j++]\)/o;}
        $delimiters[$#delimiters] .= $1 if $itm =~ /^(\s*)/;
        $itm =~ s/^(\s*)//;
        $ts = $1 if $itm =~ /(\s*)$/;
        $itm =~ s/(\s*)$//;
        push(@tmp, $itm);
        push(@delimiters, $ts);
        $delimiters[$#delimiters] .= shift(@tmp2) if($#tmp2 > -1);
    }
    if(($tmp[$#tmp] eq '') && !$delimiters[$#delimiters]) {
        $_ = pop(@tmp);
        $_ = pop(@delimiters);
    }
#   if($debugflg) {
#       print "GetItemList($stl): [$delimiters[0]";
#       for(local($i) = 0; $i <= $#tmp; ++$i) {
#           print "$tmp[$i]$delimiters[$i+1]";
#       }
#       print "]\n";
#       print "GetItemList($stl): [$delimiters[0]";
#       for(local($i) = 0; $i <= $#tmp; ++$i) {
#           print "<$tmp[$i]>$delimiters[$i+1]";
#       }
#       print "]\n";
#   }
    return @tmp;
}

sub GetParentheses  # 'xx,a(yy,"zz)a,"),bb,cc' => ('xx,a','yy,"zz)a"','bb,cc')
{
    local($s) = @_;
    local(@dlms) = ('!','|',';',':','.','+','-','=','}','{','[',']');
    return ($s) unless $s =~ /\(/;      # ErrorMsg: no parenthesis included
    local($head) = '';
    local($mid) = '';
    local($tail) = $s;
    if($s =~ /^([^\(]*)\(\)/) {         # null parentheses
        $head = $1;
        $mid = '';
        $tail = $';
        return ($head, $mid, $tail);
    }
    local($d) = shift(@dlms);
    while($s =~ /$d/) {
        if($#dlms < 0) {
            &ErrorMsg(-1,"Too many sorts of special characters. [$org]");
            return ($s);
        }
        $d = shift(@dlms);
    }
    local(@pdev) = ();
    local($q) = "'";
    while($tail =~ /$q/) {
        if($tail =~ /$q([^$q]*)$q/) {
            $head .= "$`$d";
            $tail = $';
            push(@pdev, "$q$1$q");
        } else {                # unmatched '' as a string
            $head = '';
            $tail = $s;
            @pdev = ();
            $q = '"';
            last;
        }
    }
    if($head eq '') {
        while($tail =~ /$q/) {
            if($tail =~ /$q([^$q]*)$q/) {
                $head .= "$`$d";
                $tail = $';
                push(@pdev, "$q$1$q");
            } else {                # unmatched "" as a string
                &ErrorMsg(-1,
                    "Trapped.  Something is wrong with a string in [$org].");
                return ($s);
            }
        }
    }
    $head .= $tail;
    return ($s) unless $head =~ /(\()/;     # no parenthesis included
    $head = $`;                     # left of '('
    $mid = $1.$';                   # right of '(' with '(' inclusive

    while(($#pdev > -1) && $head =~ /$d/) {
        local($s) = shift(@pdev);
        $head =~ s/$d/$s/;  # restore strings on the left of '('
    }

    if($mid =~ /(\))/) {
        $mid = $`.$1;               # inside '(' and ')' with ')' inclusive
        $tail = $';                 # right of ')'
    } else {
        while(($#pdev > -1) && $mid =~ /$d/) {
            local($s) = shift(@pdev);
            $mid =~ s/$d/$s/;   # restore strings on the right of ')'
        }
        &ErrorMsg(1,"Unmatched () in [$org].");
        return ($head,$mid);        # ErrorMsg: the parentheses not completed
    }
    while(($mid =~ s/\(/\(/g) > ($mid =~ s/\)/\)/g)) {    # pairing '(' with ')'
        if($tail =~ /(\))/) {
            $mid .= $`.$1;          # inside of '(' and ')' with ')' inclusive
            $tail = $';             # right of ')'
        } else {
            while(($#pdev > -1) && $mid =~ /$d/) {
                local($s) = shift(@pdev);
                $mid =~ s/$d/$s/;
            }
            &ErrorMsg(1,"Unmatched () in [$org].");
            return ($head,$mid);    # ErrorMsg: the parentheses not completed
        }
    }
    while(($#pdev > -1) && $mid =~ /$d/) {
        local($s) = shift(@pdev);
        $mid =~ s/$d/$s/;       # restore strings whithin '(' and ')'
    }
    while(($#pdev > -1) && $tail =~ /$d/) {
        local($s) = shift(@pdev);
        $tail =~ s/$d/$s/;      # restore strings whithin '(' and ')'
    }
    $mid =~ s/^\(//;                # strip off the parentheses
    $mid =~ s/\)$//;
    return ($head, $mid, $tail);    # succeeded
}

sub WhatTime
{
   local($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = @_;
#    local($sec,$min,$hour,$mday,$mon,$year) = @_;
    local(@MONTH) = ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug',
        'Sep','Oct','Nov','Dec');
    $year += 1900;
    return "$mday ".eval($MONTH[$mon])." $year ".
        substr('00'.$hour,-2,2).':'.
        substr('00'.$min,-2,2).':'.
        substr('00'.$sec,-2,2);
}

sub ErrorMsg
{
    local($flg) = shift;
    local($s) = @_;
    if($flg<0) {
        if($scanflg) {
            $s = " F.$currentfile\($stl): $s";
        } else {
            $s = " F.$stl: $s";
        }
        print ERR "$s\n";
        exit(1) unless $nonstpflg;
        return;
    } elsif($flg>0) {
        ++$nerrors;
        if($scanflg) {
            $s = " E.$currentfile\($stl): $s";
        } else {
            $s = " E.$stl: $s";
        }
        print "$s\n";
    } else {
        ++$nwarnings;
        if($scanflg) {
            $s = " W.$currentfile\($stl): $s";
        } else {
            $s = " W.$stl: $s";
        }
        print "$s\n" if $warnflg;
    }
}

sub RefTable
{
    print FDEC "\n  NAME: $RoutineType{$unt} : $unt";
    if(eval '$#'.$unt.'_args > -1') {
        print FDEC "(".eval('join(", ",@'.$unt.'_args)').")\n";
        local(@tmp) = &GetItemList(',',$ArgumentList{$unt});
        for(local($i) = 0; $i <= $#tmp; ++$i) {
            print FDEC "        $tmp[$i] : ".eval('$'.$unt.'_args[$i]')."\n";
        }
    } else {
        print FDEC "\n";
    }
    if(eval '%'.$unt.'_parm') {
        print FDEC "  Parameters:\n";
        foreach $var (eval 'sort keys(%'.$unt.'_parm)') {
            print FDEC "        ".eval('$'.$unt.'_sclr{$var}')." : $var = ".
                eval('$'.$unt.'_parm{$var}')."\n";
        }
    }
    if(eval '%'.$unt.'_stfT') {
        print FDEC "  Statement functions:\n";
        foreach $var (eval 'sort keys(%'.$unt.'_stfT)') {
            print FDEC "        ".eval('$'.$unt.'_stfT{$var}')." : $var(".
                eval('$'.$unt.'_stfA{$var}').")\n";
        }
    }
    if(eval '%'.$unt.'_funcT') {
        print FDEC "  Calling routines:\n";
        foreach $var (eval 'sort keys(%'.$unt.'_funcT)') {
            print FDEC "        ".eval('$'.$unt.'_funcT{$var}')." : $var(".
                eval('$'.$unt.'_funcA{$var}').")\n";
        }
    }
    if(eval '%'.$unt.'_cmn') {
        print FDEC "  Common blocks:\n";
        foreach $var (eval 'sort keys(%'.$unt.'_cmn)') {
            print FDEC "        /$var/ ".eval('$'.$unt.'_cmn{$var}')."\n";
        }
    }
    if(eval '%'.$unt.'_arry') {
        print FDEC "  Arrays:\n";
        foreach $var (eval 'sort keys(%'.$unt.'_arry)') {
            print FDEC "        ".eval('$'.$unt.'_arry{$var}')." : $var\n"
                unless eval 'grep($var =~ /^$_$/, @'.$unt.'_args)';
        }
    }
    if(eval '%'.$unt.'_sclr') {
        print FDEC "  Variables:\n";
        foreach $var (eval 'sort keys(%'.$unt.'_sclr)') {
            print FDEC "        ".eval('$'.$unt.'_sclr{$var}')." : $var\n"
                unless eval('$'.$unt.'_parm{$var} || '.
                    'grep($var =~ /^$_$/, @'.$unt.'_args)');
        }
    }
}

sub Help
{
    for(local($i) = 0; $i <= $#HLPMSG; ++$i) {print STDERR "$HLPMSG[$i]\n";}
}
