/**
 * Copyright (C) 2024-2025 the Eask authors.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

"use strict";

exports.command = ['loc [files..]'];
exports.desc = UTIL.hide_cmd('Print LOC information');
exports.builder = yargs => yargs
  .positional(
    '[files..]', {
      description: 'files to print LOC information',
      type: 'array',
    });

exports.handler = async (argv) => {
  await UTIL.e_call(argv, 'core/loc', argv.files);
};
