/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.PasswordStore;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.ftp.FTPConnectMode;
import ch.cyberduck.core.importer.XmlBookmarkCollection;
import ch.cyberduck.core.preferences.PreferencesFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;

public class FilezillaBookmarkCollection
extends XmlBookmarkCollection {
    private static final Logger log = Logger.getLogger(FilezillaBookmarkCollection.class);
    private static final long serialVersionUID = -4612895793983093594L;

    public FilezillaBookmarkCollection() {
    }

    public FilezillaBookmarkCollection(PasswordStore keychain) {
        super(keychain);
    }

    @Override
    public String getBundleIdentifier() {
        return "de.filezilla";
    }

    @Override
    public String getName() {
        return "FileZilla";
    }

    @Override
    public Local getFile() {
        return LocalFactory.get((String)PreferencesFactory.get().getProperty("bookmark.import.filezilla.location"));
    }

    @Override
    protected XmlBookmarkCollection.AbstractHandler getHandler(ProtocolFactory protocols) {
        return new ServerHandler(protocols);
    }

    private class ServerHandler
    extends XmlBookmarkCollection.AbstractHandler {
        private final ProtocolFactory protocols;
        private Host current = null;
        private Attributes attrs;

        public ServerHandler(ProtocolFactory protocols) {
            this.protocols = protocols;
        }

        @Override
        public void startElement(String name, Attributes attrs) {
            this.attrs = attrs;
            if (name.equals("Server")) {
                this.current = new Host(this.protocols.forScheme(Scheme.ftp));
            }
        }

        @Override
        public void endElement(String name, String elementText) {
            switch (name) {
                case "Host": {
                    this.current.setHostname(elementText);
                    break;
                }
                case "Protocol": {
                    try {
                        switch (Integer.parseInt(elementText)) {
                            case 0: {
                                this.current.setProtocol(this.protocols.forScheme(Scheme.ftp));
                                break;
                            }
                            case 3: 
                            case 4: {
                                this.current.setProtocol(this.protocols.forScheme(Scheme.ftps));
                                break;
                            }
                            case 1: {
                                this.current.setProtocol(this.protocols.forScheme(Scheme.sftp));
                            }
                        }
                        this.current.setPort(-1);
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("Unknown protocol:" + e.getMessage()));
                    }
                    break;
                }
                case "Port": {
                    try {
                        this.current.setPort(Integer.parseInt(elementText));
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("Invalid Port:" + e.getMessage()));
                    }
                    break;
                }
                case "User": {
                    this.current.getCredentials().setUsername(elementText);
                    break;
                }
                case "Logontype": {
                    try {
                        switch (Integer.parseInt(elementText)) {
                            case 0: {
                                this.current.getCredentials().setUsername(PreferencesFactory.get().getProperty("connection.login.anon.name"));
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("Invalid Logontype:" + e.getMessage()));
                    }
                    break;
                }
                case "Pass": {
                    if (this.attrs.getIndex("encoding") == 0 && this.attrs.getValue(0).equals("base64")) {
                        if (!Base64.isBase64((String)elementText)) break;
                        this.current.getCredentials().setPassword(new String(Base64.decodeBase64((String)elementText)));
                        break;
                    }
                    this.current.getCredentials().setPassword(elementText);
                    break;
                }
                case "Name": {
                    this.current.setNickname(elementText);
                    break;
                }
                case "EncodingType": {
                    if ("Auto".equals(elementText)) {
                        this.current.setEncoding(null);
                        break;
                    }
                    this.current.setEncoding(elementText);
                    break;
                }
                case "PasvMode": {
                    if ("MODE_PASSIVE".equals(elementText)) {
                        this.current.setFTPConnectMode(FTPConnectMode.passive);
                        break;
                    }
                    if (!"MODE_ACTIVE".equals(elementText)) break;
                    this.current.setFTPConnectMode(FTPConnectMode.active);
                    break;
                }
                case "Comments": {
                    this.current.setComment(elementText);
                    break;
                }
                case "LocalDir": {
                    this.current.setDownloadFolder(LocalFactory.get((String)elementText));
                    break;
                }
                case "RemoteDir": {
                    if (!StringUtils.isNotBlank((CharSequence)elementText)) break;
                    StringBuilder b = new StringBuilder();
                    int i = 0;
                    for (String component : elementText.substring(3).split("\\s")) {
                        if (i % 2 == 0) {
                            b.append(component);
                        } else {
                            b.append('/');
                        }
                        ++i;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)b.toString())) break;
                    this.current.setDefaultPath(b.toString());
                    break;
                }
                case "TimezoneOffset": {
                    break;
                }
                case "Server": {
                    FilezillaBookmarkCollection.this.add(this.current);
                }
            }
        }
    }
}

