/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.library.Native;
import ch.cyberduck.core.local.QuarantineService;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public final class LaunchServicesQuarantineService
implements QuarantineService {
    private static final Logger log = Logger.getLogger(LaunchServicesQuarantineService.class);
    private static final Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQuarantine(Local file, String originUrl, String dataUrl) throws LocalAccessDeniedException {
        if (StringUtils.isEmpty((CharSequence)originUrl)) {
            log.warn((Object)"No origin url given for quarantine");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)dataUrl)) {
            log.warn((Object)"No data url given for quarantine");
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (!this.setQuarantine(file.getAbsolute(), originUrl, dataUrl)) {
                throw new LocalAccessDeniedException(file.getAbsolute());
            }
        }
    }

    private native boolean setQuarantine(String var1, String var2, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWhereFrom(Local file, String dataUrl) throws LocalAccessDeniedException {
        Object object = lock;
        synchronized (object) {
            if (StringUtils.isBlank((CharSequence)dataUrl)) {
                log.warn((Object)"No data url given");
                return;
            }
            if (!this.setWhereFrom(file.getAbsolute(), dataUrl)) {
                throw new LocalAccessDeniedException(file.getAbsolute());
            }
        }
    }

    private native boolean setWhereFrom(String var1, String var2);

    static {
        Native.load((String)"core");
        lock = new Object();
    }
}

