/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.spectra;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledCancelCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Resolver;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.exception.RetriableAccessDeniedException;
import ch.cyberduck.core.features.Bulk;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.spectra.SpectraClientBuilder;
import ch.cyberduck.core.spectra.SpectraDeleteFeature;
import ch.cyberduck.core.spectra.SpectraExceptionMappingService;
import ch.cyberduck.core.spectra.SpectraSession;
import ch.cyberduck.core.threading.CancelCallback;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.commands.spectrads3.CancelAllActiveJobsSpectraS3Request;
import com.spectralogic.ds3client.commands.spectrads3.CancelJobSpectraS3Request;
import com.spectralogic.ds3client.commands.spectrads3.GetBulkJobSpectraS3Request;
import com.spectralogic.ds3client.commands.spectrads3.GetBulkJobSpectraS3Response;
import com.spectralogic.ds3client.commands.spectrads3.GetJobChunksReadyForClientProcessingSpectraS3Request;
import com.spectralogic.ds3client.commands.spectrads3.GetJobChunksReadyForClientProcessingSpectraS3Response;
import com.spectralogic.ds3client.commands.spectrads3.PutBulkJobSpectraS3Request;
import com.spectralogic.ds3client.commands.spectrads3.PutBulkJobSpectraS3Response;
import com.spectralogic.ds3client.models.BulkObject;
import com.spectralogic.ds3client.models.JobNode;
import com.spectralogic.ds3client.models.MasterObjectList;
import com.spectralogic.ds3client.models.Objects;
import com.spectralogic.ds3client.models.bulk.Ds3Object;
import com.spectralogic.ds3client.networking.FailedRequestException;
import com.spectralogic.ds3client.serializer.XmlProcessingException;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestStorageService;

public class SpectraBulkService
implements Bulk<Set<UUID>> {
    private static final Logger log = Logger.getLogger(SpectraBulkService.class);
    private final SpectraSession session;
    private Delete delete;
    private final PathContainerService containerService = new S3PathContainerService();
    private static final String REQUEST_PARAMETER_JOBID_IDENTIFIER = "job";
    private static final String REQUEST_PARAMETER_OFFSET = "offset";

    public SpectraBulkService(SpectraSession session) {
        this.session = session;
        this.delete = new SpectraDeleteFeature(session);
    }

    public Bulk<Set<UUID>> withDelete(Delete delete) {
        this.delete = delete;
        return this;
    }

    public Bulk<Set<UUID>> withCache(Cache<Path> cache) {
        return this;
    }

    public void post(Transfer.Type type, Map<TransferItem, TransferStatus> files, ConnectionCallback callback) {
    }

    public Set<UUID> pre(Transfer.Type type, Map<TransferItem, TransferStatus> files, ConnectionCallback callback) throws BackgroundException {
        Ds3Client client = new SpectraClientBuilder().wrap((RestStorageService)this.session.getClient(), this.session.getHost());
        HashMap objects = new HashMap();
        for (Map.Entry<TransferItem, TransferStatus> item : files.entrySet()) {
            Path file = item.getKey().remote;
            Path container = this.containerService.getContainer(file);
            if (!objects.containsKey(container)) {
                objects.put(container, new ArrayList());
            }
            if (file.isFile()) {
                TransferStatus status = item.getValue();
                switch (type) {
                    case upload: {
                        if (!status.isExists()) break;
                        log.warn((Object)String.format("Delete existing file %s", file));
                        this.delete.delete(Collections.singletonMap(file, status), (PasswordCallback)callback, (Delete.Callback)new Delete.DisabledCallback());
                    }
                }
                Ds3Object o = new Ds3Object(this.containerService.getKey(file), status.getLength());
                o.setVersionId(file.attributes().getVersionId());
                ((List)objects.get(container)).add(o);
            }
            if (!file.isDirectory()) continue;
            switch (type) {
                case upload: {
                    ((List)objects.get(container)).add(new Ds3Object(this.containerService.getKey(file), 0L));
                }
            }
        }
        try {
            HashSet<UUID> jobs = new HashSet<UUID>();
            for (Map.Entry container : objects.entrySet()) {
                MasterObjectList master;
                if (((List)container.getValue()).isEmpty()) continue;
                switch (type) {
                    case download: {
                        GetBulkJobSpectraS3Response getResponse = client.getBulkJobSpectraS3(new GetBulkJobSpectraS3Request(((Path)container.getKey()).getName(), (Iterable)container.getValue()));
                        master = getResponse.getMasterObjectList();
                        break;
                    }
                    case upload: {
                        PutBulkJobSpectraS3Response putResponse = client.putBulkJobSpectraS3(new PutBulkJobSpectraS3Request(((Path)container.getKey()).getName(), (Iterable)container.getValue()).withMaxUploadSize(Long.MAX_VALUE));
                        master = putResponse.getMasterObjectList();
                        break;
                    }
                    default: {
                        throw new NotfoundException(String.format("Unsupported transfer type %s", type));
                    }
                }
                jobs.add(master.getJobId());
                Map<String, Integer> counters = this.getNumberOfObjects(master);
                for (Map.Entry<TransferItem, TransferStatus> item : files.entrySet()) {
                    if (!((Path)container.getKey()).equals((Object)this.containerService.getContainer(item.getKey().remote))) continue;
                    TransferStatus status = item.getValue();
                    HashMap<String, String> parameters = new HashMap<String, String>(status.getParameters());
                    parameters.put(REQUEST_PARAMETER_JOBID_IDENTIFIER, master.getJobId().toString());
                    status.withParameters(parameters);
                    status.setPart(counters.get(this.containerService.getKey(item.getKey().remote)));
                }
            }
            return jobs;
        }
        catch (XmlProcessingException e) {
            throw new DefaultExceptionMappingService().map((Throwable)e);
        }
        catch (FailedRequestException e) {
            throw new SpectraExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    private Map<String, Integer> getNumberOfObjects(MasterObjectList objects) {
        HashMap<String, Integer> counters = new HashMap<String, Integer>();
        for (Objects object : objects.getObjects()) {
            for (BulkObject bulkObject : object.getObjects()) {
                counters.merge(bulkObject.getName(), 1, Integer::sum);
            }
        }
        return counters;
    }

    public void cancel(Transfer.Type type, Path file, TransferStatus status) throws BackgroundException {
        try {
            if (!status.getParameters().containsKey(REQUEST_PARAMETER_JOBID_IDENTIFIER)) {
                throw new NotfoundException(String.format("Missing job id parameter in status for %s", file.getName()));
            }
            String job = (String)status.getParameters().get(REQUEST_PARAMETER_JOBID_IDENTIFIER);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Cancel job %s", job));
            }
            Ds3Client client = new SpectraClientBuilder().wrap((RestStorageService)this.session.getClient(), this.session.getHost());
            client.cancelJobSpectraS3(new CancelJobSpectraS3Request(job));
        }
        catch (FailedRequestException e) {
            throw new SpectraExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public List<TransferStatus> query(Transfer.Type type, Path file, TransferStatus status) throws BackgroundException {
        try {
            List<TransferStatus> chunks;
            if (!status.getParameters().containsKey(REQUEST_PARAMETER_JOBID_IDENTIFIER)) {
                throw new NotfoundException(String.format("Missing job id parameter in status for %s", file.getName()));
            }
            String job = (String)status.getParameters().get(REQUEST_PARAMETER_JOBID_IDENTIFIER);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Query status for job %s", job));
            }
            Ds3Client client = new SpectraClientBuilder().wrap((RestStorageService)this.session.getClient(), this.session.getHost());
            GetJobChunksReadyForClientProcessingSpectraS3Response response = client.getJobChunksReadyForClientProcessingSpectraS3(new GetJobChunksReadyForClientProcessingSpectraS3Request(UUID.fromString(job)).withPreferredNumberOfChunks(Integer.MAX_VALUE));
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Job status %s for job %s", response.getStatus(), job));
            }
            switch (response.getStatus()) {
                case RETRYLATER: {
                    Duration delay = Duration.ofSeconds(response.getRetryAfterSeconds());
                    throw new RetriableAccessDeniedException(String.format("Job %s not yet loaded into cache", job), delay);
                }
            }
            MasterObjectList master = response.getMasterObjectListResult();
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Master object list with %d objects for %s", master.getObjects().size(), file));
                log.info((Object)String.format("Master object list status %s for %s", master.getStatus(), file));
            }
            if ((chunks = this.query(file, status, job, master)).isEmpty()) {
                log.info((Object)String.format("Still missing chunks for file %s for job %s", file.getName(), job));
                throw new RetriableAccessDeniedException(String.format("Missing chunks for job %s", job), Duration.ofSeconds(PreferencesFactory.get().getInteger("spectra.retry.delay")));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Server returned %d chunks for %s", chunks.size(), file));
            }
            return chunks;
        }
        catch (FailedRequestException e) {
            throw new SpectraExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    private List<TransferStatus> query(Path file, TransferStatus status, String job, MasterObjectList master) throws BackgroundException {
        ArrayList<TransferStatus> chunks = new ArrayList<TransferStatus>();
        int counter = 0;
        for (Objects objects : master.getObjects()) {
            UUID nodeId = objects.getNodeId();
            if (null == nodeId) {
                log.warn((Object)String.format("No node returned in master object list for file %s", file));
            } else if (log.isInfoEnabled()) {
                log.info((Object)String.format("Determined node %s for %s", nodeId, file));
            }
            for (JobNode node : master.getNodes()) {
                if (!node.getId().equals(nodeId)) continue;
                Host host = this.session.getHost();
                if (StringUtils.equals((CharSequence)node.getEndPoint(), (CharSequence)host.getHostname()) || StringUtils.equals((CharSequence)node.getEndPoint(), (CharSequence)new Resolver().resolve(host.getHostname(), (CancelCallback)new DisabledCancelCallback()).getHostAddress())) break;
                log.warn((Object)String.format("Redirect to %s for file %s", node.getEndPoint(), file));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Object list with %d objects for job %s", objects.getObjects().size(), job));
            }
            for (BulkObject object : objects.getObjects()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Found object %s looking for %s", object, file));
                }
                if (!object.getName().equals(this.containerService.getKey(file))) continue;
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Found chunk %s matching file %s", object, file));
                }
                TransferStatus chunk = new TransferStatus().exists(status.isExists()).withMetadata(status.getMetadata()).withParameters(status.getParameters());
                if (object.getOffset() > 0L) {
                    chunk.setAppend(true);
                }
                chunk.setLength(object.getLength());
                chunk.setOffset(object.getOffset());
                HashMap<String, String> parameters = new HashMap<String, String>(chunk.getParameters());
                parameters.put(REQUEST_PARAMETER_OFFSET, Long.toString(chunk.getOffset()));
                chunk.setParameters(parameters);
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Add chunk %s for file %s", chunk, file));
                }
                chunks.add(chunk);
                ++counter;
            }
        }
        if (counter < status.getPart()) {
            return Collections.emptyList();
        }
        return chunks;
    }

    protected void clear() throws BackgroundException {
        try {
            Ds3Client ds3Client = new SpectraClientBuilder().wrap((RestStorageService)this.session.getClient(), this.session.getHost());
            ds3Client.cancelAllActiveJobsSpectraS3(new CancelAllActiveJobsSpectraS3Request());
            RequestEntityRestStorageService client = (RequestEntityRestStorageService)this.session.getClient();
            HttpPut request = new HttpPut(String.format("%s://%s:%s/_rest_/cache_filesystem?reclaim", this.session.getHost().getProtocol().getScheme(), this.session.getHost().getHostname(), this.session.getHost().getPort()));
            client.authorizeHttpRequest((HttpUriRequest)request, null, null);
            HttpResponse response = client.getHttpClient().execute((HttpUriRequest)request);
            if (204 != response.getStatusLine().getStatusCode()) {
                throw new HttpResponseException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase());
            }
        }
        catch (HttpResponseException e) {
            throw new DefaultHttpResponseExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map(e);
        }
    }
}

