/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.team.UserSelectorArg;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

class MembersSetProfileArg {
    protected final UserSelectorArg user;
    protected final String newEmail;
    protected final String newExternalId;
    protected final String newGivenName;
    protected final String newSurname;
    protected final String newPersistentId;
    protected final Boolean newIsDirectoryRestricted;

    public MembersSetProfileArg(UserSelectorArg user, String newEmail, String newExternalId, String newGivenName, String newSurname, String newPersistentId, Boolean newIsDirectoryRestricted) {
        if (user == null) {
            throw new IllegalArgumentException("Required value for 'user' is null");
        }
        this.user = user;
        if (newEmail != null) {
            if (newEmail.length() > 255) {
                throw new IllegalArgumentException("String 'newEmail' is longer than 255");
            }
            if (!Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*\\.[A-Za-z]{2,15}$", newEmail)) {
                throw new IllegalArgumentException("String 'newEmail' does not match pattern");
            }
        }
        this.newEmail = newEmail;
        if (newExternalId != null && newExternalId.length() > 64) {
            throw new IllegalArgumentException("String 'newExternalId' is longer than 64");
        }
        this.newExternalId = newExternalId;
        if (newGivenName != null) {
            if (newGivenName.length() > 100) {
                throw new IllegalArgumentException("String 'newGivenName' is longer than 100");
            }
            if (!Pattern.matches("[^/:?*<>\"|]*", newGivenName)) {
                throw new IllegalArgumentException("String 'newGivenName' does not match pattern");
            }
        }
        this.newGivenName = newGivenName;
        if (newSurname != null) {
            if (newSurname.length() > 100) {
                throw new IllegalArgumentException("String 'newSurname' is longer than 100");
            }
            if (!Pattern.matches("[^/:?*<>\"|]*", newSurname)) {
                throw new IllegalArgumentException("String 'newSurname' does not match pattern");
            }
        }
        this.newSurname = newSurname;
        this.newPersistentId = newPersistentId;
        this.newIsDirectoryRestricted = newIsDirectoryRestricted;
    }

    public MembersSetProfileArg(UserSelectorArg user) {
        this(user, null, null, null, null, null, null);
    }

    public UserSelectorArg getUser() {
        return this.user;
    }

    public String getNewEmail() {
        return this.newEmail;
    }

    public String getNewExternalId() {
        return this.newExternalId;
    }

    public String getNewGivenName() {
        return this.newGivenName;
    }

    public String getNewSurname() {
        return this.newSurname;
    }

    public String getNewPersistentId() {
        return this.newPersistentId;
    }

    public Boolean getNewIsDirectoryRestricted() {
        return this.newIsDirectoryRestricted;
    }

    public static Builder newBuilder(UserSelectorArg user) {
        return new Builder(user);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.user, this.newEmail, this.newExternalId, this.newGivenName, this.newSurname, this.newPersistentId, this.newIsDirectoryRestricted});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            MembersSetProfileArg other = (MembersSetProfileArg)obj;
            return (this.user == other.user || this.user.equals(other.user)) && (this.newEmail == other.newEmail || this.newEmail != null && this.newEmail.equals(other.newEmail)) && (this.newExternalId == other.newExternalId || this.newExternalId != null && this.newExternalId.equals(other.newExternalId)) && (this.newGivenName == other.newGivenName || this.newGivenName != null && this.newGivenName.equals(other.newGivenName)) && (this.newSurname == other.newSurname || this.newSurname != null && this.newSurname.equals(other.newSurname)) && (this.newPersistentId == other.newPersistentId || this.newPersistentId != null && this.newPersistentId.equals(other.newPersistentId)) && (this.newIsDirectoryRestricted == other.newIsDirectoryRestricted || this.newIsDirectoryRestricted != null && this.newIsDirectoryRestricted.equals(other.newIsDirectoryRestricted));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<MembersSetProfileArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(MembersSetProfileArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("user");
            UserSelectorArg.Serializer.INSTANCE.serialize(value.user, g);
            if (value.newEmail != null) {
                g.writeFieldName("new_email");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.newEmail, g);
            }
            if (value.newExternalId != null) {
                g.writeFieldName("new_external_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.newExternalId, g);
            }
            if (value.newGivenName != null) {
                g.writeFieldName("new_given_name");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.newGivenName, g);
            }
            if (value.newSurname != null) {
                g.writeFieldName("new_surname");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.newSurname, g);
            }
            if (value.newPersistentId != null) {
                g.writeFieldName("new_persistent_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.newPersistentId, g);
            }
            if (value.newIsDirectoryRestricted != null) {
                g.writeFieldName("new_is_directory_restricted");
                StoneSerializers.nullable(StoneSerializers.boolean_()).serialize(value.newIsDirectoryRestricted, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public MembersSetProfileArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_newIsDirectoryRestricted;
            String f_newPersistentId;
            String f_newSurname;
            String f_newGivenName;
            String f_newExternalId;
            String f_newEmail;
            UserSelectorArg f_user;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_user = null;
                f_newEmail = null;
                f_newExternalId = null;
                f_newGivenName = null;
                f_newSurname = null;
                f_newPersistentId = null;
                f_newIsDirectoryRestricted = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("user".equals(field)) {
                        f_user = UserSelectorArg.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("new_email".equals(field)) {
                        f_newEmail = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("new_external_id".equals(field)) {
                        f_newExternalId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("new_given_name".equals(field)) {
                        f_newGivenName = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("new_surname".equals(field)) {
                        f_newSurname = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("new_persistent_id".equals(field)) {
                        f_newPersistentId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("new_is_directory_restricted".equals(field)) {
                        f_newIsDirectoryRestricted = StoneSerializers.nullable(StoneSerializers.boolean_()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_user == null) {
                    throw new JsonParseException(p, "Required field \"user\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            MembersSetProfileArg value = new MembersSetProfileArg(f_user, f_newEmail, f_newExternalId, f_newGivenName, f_newSurname, f_newPersistentId, f_newIsDirectoryRestricted);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final UserSelectorArg user;
        protected String newEmail;
        protected String newExternalId;
        protected String newGivenName;
        protected String newSurname;
        protected String newPersistentId;
        protected Boolean newIsDirectoryRestricted;

        protected Builder(UserSelectorArg user) {
            if (user == null) {
                throw new IllegalArgumentException("Required value for 'user' is null");
            }
            this.user = user;
            this.newEmail = null;
            this.newExternalId = null;
            this.newGivenName = null;
            this.newSurname = null;
            this.newPersistentId = null;
            this.newIsDirectoryRestricted = null;
        }

        public Builder withNewEmail(String newEmail) {
            if (newEmail != null) {
                if (newEmail.length() > 255) {
                    throw new IllegalArgumentException("String 'newEmail' is longer than 255");
                }
                if (!Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*\\.[A-Za-z]{2,15}$", newEmail)) {
                    throw new IllegalArgumentException("String 'newEmail' does not match pattern");
                }
            }
            this.newEmail = newEmail;
            return this;
        }

        public Builder withNewExternalId(String newExternalId) {
            if (newExternalId != null && newExternalId.length() > 64) {
                throw new IllegalArgumentException("String 'newExternalId' is longer than 64");
            }
            this.newExternalId = newExternalId;
            return this;
        }

        public Builder withNewGivenName(String newGivenName) {
            if (newGivenName != null) {
                if (newGivenName.length() > 100) {
                    throw new IllegalArgumentException("String 'newGivenName' is longer than 100");
                }
                if (!Pattern.matches("[^/:?*<>\"|]*", newGivenName)) {
                    throw new IllegalArgumentException("String 'newGivenName' does not match pattern");
                }
            }
            this.newGivenName = newGivenName;
            return this;
        }

        public Builder withNewSurname(String newSurname) {
            if (newSurname != null) {
                if (newSurname.length() > 100) {
                    throw new IllegalArgumentException("String 'newSurname' is longer than 100");
                }
                if (!Pattern.matches("[^/:?*<>\"|]*", newSurname)) {
                    throw new IllegalArgumentException("String 'newSurname' does not match pattern");
                }
            }
            this.newSurname = newSurname;
            return this;
        }

        public Builder withNewPersistentId(String newPersistentId) {
            this.newPersistentId = newPersistentId;
            return this;
        }

        public Builder withNewIsDirectoryRestricted(Boolean newIsDirectoryRestricted) {
            this.newIsDirectoryRestricted = newIsDirectoryRestricted;
            return this;
        }

        public MembersSetProfileArg build() {
            return new MembersSetProfileArg(this.user, this.newEmail, this.newExternalId, this.newGivenName, this.newSurname, this.newPersistentId, this.newIsDirectoryRestricted);
        }
    }
}

