/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.strategy.transferstrategy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.spectralogic.ds3client.commands.GetObjectRequest;
import com.spectralogic.ds3client.commands.GetObjectResponse;
import com.spectralogic.ds3client.helpers.JobPart;
import com.spectralogic.ds3client.helpers.strategy.channelstrategy.ChannelStrategy;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.EventDispatcher;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.TransferMethod;
import com.spectralogic.ds3client.models.BulkObject;
import com.spectralogic.ds3client.models.common.Range;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;

public class GetJobPartialBlobTransferMethod
implements TransferMethod {
    private final ChannelStrategy channelStrategy;
    private final String bucketName;
    private final String jobId;
    private final EventDispatcher eventDispatcher;
    private final ImmutableCollection<Range> blobRanges;
    private final long destinationChannelOffset;

    public GetJobPartialBlobTransferMethod(ChannelStrategy channelStrategy, String bucketName, String jobId, EventDispatcher eventDispatcher, ImmutableCollection<Range> blobRanges, long destinationChannelOffset) {
        Preconditions.checkNotNull(blobRanges, (Object)"blobRanges may not be null.");
        Preconditions.checkState((destinationChannelOffset >= 0L ? 1 : 0) != 0, (Object)"destinationChannelOffset must be >= 0.");
        this.channelStrategy = channelStrategy;
        this.bucketName = bucketName;
        this.jobId = jobId;
        this.eventDispatcher = eventDispatcher;
        this.blobRanges = blobRanges;
        this.destinationChannelOffset = destinationChannelOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferJobPart(JobPart jobPart) throws IOException {
        BulkObject blob = jobPart.getBlob();
        SeekableByteChannel seekableByteChannel = this.channelStrategy.acquireChannelForBlob(blob);
        seekableByteChannel.position(this.destinationChannelOffset);
        try {
            GetObjectResponse getObjectResponse = jobPart.getClient().getObject(this.makeGetObjectRequest(seekableByteChannel, blob));
            this.eventDispatcher.emitChecksumEvent(blob, getObjectResponse.getChecksumType(), getObjectResponse.getChecksum());
            this.eventDispatcher.emitMetaDataReceivedEvent(blob.getName(), getObjectResponse.getMetadata());
            this.eventDispatcher.emitBlobTransferredEvent(blob);
            this.eventDispatcher.emitDataTransferredEvent(blob);
        }
        finally {
            this.channelStrategy.releaseChannelForBlob(seekableByteChannel, blob);
        }
    }

    private GetObjectRequest makeGetObjectRequest(SeekableByteChannel seekableByteChannel, BulkObject blob) {
        GetObjectRequest getObjectRequest = new GetObjectRequest(this.bucketName, blob.getName(), (WritableByteChannel)seekableByteChannel, this.jobId, blob.getOffset());
        if (blob.getVersionId() != null) {
            getObjectRequest.withVersionId(blob.getVersionId());
        }
        getObjectRequest.withByteRanges((Collection<Range>)this.blobRanges);
        return getObjectRequest;
    }
}

