/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractPaginationRequest;
import com.spectralogic.ds3client.models.TapeFailureType;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class GetTapeFailuresSpectraS3Request
extends AbstractPaginationRequest {
    private String errorMessage;
    private boolean lastPage;
    private int pageLength;
    private int pageOffset;
    private String pageStartMarker;
    private String tapeDriveId;
    private String tapeId;
    private TapeFailureType type;

    public GetTapeFailuresSpectraS3Request withErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        this.updateQueryParam("error_message", errorMessage);
        return this;
    }

    public GetTapeFailuresSpectraS3Request withLastPage(boolean lastPage) {
        this.lastPage = lastPage;
        if (this.lastPage) {
            this.getQueryParams().put("last_page", null);
        } else {
            this.getQueryParams().remove("last_page");
        }
        return this;
    }

    public GetTapeFailuresSpectraS3Request withPageLength(int pageLength) {
        this.pageLength = pageLength;
        this.updateQueryParam("page_length", pageLength);
        return this;
    }

    public GetTapeFailuresSpectraS3Request withPageOffset(int pageOffset) {
        this.pageOffset = pageOffset;
        this.updateQueryParam("page_offset", pageOffset);
        return this;
    }

    public GetTapeFailuresSpectraS3Request withPageStartMarker(UUID pageStartMarker) {
        this.pageStartMarker = pageStartMarker.toString();
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetTapeFailuresSpectraS3Request withPageStartMarker(String pageStartMarker) {
        this.pageStartMarker = pageStartMarker;
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetTapeFailuresSpectraS3Request withTapeDriveId(UUID tapeDriveId) {
        this.tapeDriveId = tapeDriveId.toString();
        this.updateQueryParam("tape_drive_id", tapeDriveId);
        return this;
    }

    public GetTapeFailuresSpectraS3Request withTapeDriveId(String tapeDriveId) {
        this.tapeDriveId = tapeDriveId;
        this.updateQueryParam("tape_drive_id", tapeDriveId);
        return this;
    }

    public GetTapeFailuresSpectraS3Request withTapeId(UUID tapeId) {
        this.tapeId = tapeId.toString();
        this.updateQueryParam("tape_id", tapeId);
        return this;
    }

    public GetTapeFailuresSpectraS3Request withTapeId(String tapeId) {
        this.tapeId = tapeId;
        this.updateQueryParam("tape_id", tapeId);
        return this;
    }

    public GetTapeFailuresSpectraS3Request withType(TapeFailureType type) {
        this.type = type;
        this.updateQueryParam("type", type);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    @Override
    public String getPath() {
        return "/_rest_/tape_failure";
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean getLastPage() {
        return this.lastPage;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public String getPageStartMarker() {
        return this.pageStartMarker;
    }

    public String getTapeDriveId() {
        return this.tapeDriveId;
    }

    public String getTapeId() {
        return this.tapeId;
    }

    public TapeFailureType getType() {
        return this.type;
    }
}

