/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.PutPoolPartitionSpectraS3Response;
import com.spectralogic.ds3client.models.PoolPartition;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class PutPoolPartitionSpectraS3ResponseParser
extends AbstractResponseParser<PutPoolPartitionSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{201};

    @Override
    public PutPoolPartitionSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 201: {
                    try (InputStream inputStream = response.getResponseStream();){
                        PoolPartition result = XmlOutput.fromXml(inputStream, PoolPartition.class);
                        PutPoolPartitionSpectraS3Response putPoolPartitionSpectraS3Response = new PutPoolPartitionSpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return putPoolPartitionSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

