/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.GetSuspectBlobS3TargetsSpectraS3Response;
import com.spectralogic.ds3client.models.SuspectBlobS3TargetList;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class GetSuspectBlobS3TargetsSpectraS3ResponseParser
extends AbstractResponseParser<GetSuspectBlobS3TargetsSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{200};

    @Override
    public GetSuspectBlobS3TargetsSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        Integer pagingTruncated = this.parseIntHeader("page-truncated");
        Integer pagingTotalResultCount = this.parseIntHeader("total-result-count");
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        SuspectBlobS3TargetList result = XmlOutput.fromXml(inputStream, SuspectBlobS3TargetList.class);
                        GetSuspectBlobS3TargetsSpectraS3Response getSuspectBlobS3TargetsSpectraS3Response = new GetSuspectBlobS3TargetsSpectraS3Response(result, pagingTotalResultCount, pagingTruncated, this.getChecksum(), this.getChecksumType());
                        return getSuspectBlobS3TargetsSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

