/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.GetStorageDomainCapacitySummarySpectraS3Response;
import com.spectralogic.ds3client.models.CapacitySummaryContainer;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class GetStorageDomainCapacitySummarySpectraS3ResponseParser
extends AbstractResponseParser<GetStorageDomainCapacitySummarySpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{200};

    @Override
    public GetStorageDomainCapacitySummarySpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        CapacitySummaryContainer result = XmlOutput.fromXml(inputStream, CapacitySummaryContainer.class);
                        GetStorageDomainCapacitySummarySpectraS3Response getStorageDomainCapacitySummarySpectraS3Response = new GetStorageDomainCapacitySummarySpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return getStorageDomainCapacitySummarySpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

