/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.GetDegradedBlobsSpectraS3Response;
import com.spectralogic.ds3client.models.DegradedBlobList;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class GetDegradedBlobsSpectraS3ResponseParser
extends AbstractResponseParser<GetDegradedBlobsSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{200};

    @Override
    public GetDegradedBlobsSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        Integer pagingTruncated = this.parseIntHeader("page-truncated");
        Integer pagingTotalResultCount = this.parseIntHeader("total-result-count");
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        DegradedBlobList result = XmlOutput.fromXml(inputStream, DegradedBlobList.class);
                        GetDegradedBlobsSpectraS3Response getDegradedBlobsSpectraS3Response = new GetDegradedBlobsSpectraS3Response(result, pagingTotalResultCount, pagingTruncated, this.getChecksum(), this.getChecksumType());
                        return getDegradedBlobsSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

