/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class AbortMultiPartUploadRequest
extends AbstractRequest {
    private final String bucketName;
    private final String objectName;
    private final String uploadId;

    public AbortMultiPartUploadRequest(String bucketName, String objectName, UUID uploadId) {
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.uploadId = uploadId.toString();
        this.updateQueryParam("upload_id", uploadId);
    }

    public AbortMultiPartUploadRequest(String bucketName, String objectName, String uploadId) {
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.uploadId = uploadId;
        this.updateQueryParam("upload_id", uploadId);
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.DELETE;
    }

    @Override
    public String getPath() {
        return "/" + this.bucketName + "/" + this.objectName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getUploadId() {
        return this.uploadId;
    }
}

