/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.utils;

public final class Host {
    public static final int CHAR = 0;
    public static final int SHORT = 1;
    public static final int INT = 2;
    public static final int LONG = 3;
    public static final int LONGLONG = 4;
    public static final int FLOAT = 5;
    public static final int DOUBLE = 6;
    public static final int LONGDOUBLE = 7;
    public static final int NUMBER_TYPES = 8;
    public static final int MAX_TYPE_SIZE = 64;
    private static boolean isMBF = true;
    private static final String[] typeName = new String[]{"char", "short", "int", "long", "long long", "float", "double", "long double"};
    private static final byte[] typeSize = new byte[]{1, 2, 4, 8, 8, 4, 8, 8};
    private static final short[] typeBits = new short[]{8, 16, 32, 64, 64, 32, 64, 64};
    private static final byte[] typeCompilerAlignment = new byte[]{1, 2, 4, 8, 8, 4, 8, 8};

    public static final boolean isMBFByteOrder() {
        return isMBF;
    }

    public static final boolean isLBFByteOrder() {
        return !isMBF;
    }

    public static final String getName(int type) {
        return typeName[type];
    }

    public static final byte getStorageSize(int type) {
        return typeSize[type];
    }

    public static final int getSignificantBits(int type) {
        return typeBits[type];
    }

    public static final int getCompilerAlignment(int type) {
        return typeCompilerAlignment[type];
    }

    public static final void swap(byte[] bytes, int nBytes) {
        switch (nBytes) {
            case 1: {
                return;
            }
            case 2: {
                byte tmp = bytes[0];
                bytes[0] = bytes[1];
                bytes[1] = tmp;
                return;
            }
            case 4: {
                byte tmp = bytes[0];
                bytes[0] = bytes[3];
                bytes[3] = tmp;
                tmp = bytes[1];
                bytes[1] = bytes[2];
                bytes[2] = tmp;
                return;
            }
            case 8: {
                byte tmp = bytes[0];
                bytes[0] = bytes[7];
                bytes[7] = tmp;
                tmp = bytes[1];
                bytes[1] = bytes[6];
                bytes[6] = tmp;
                tmp = bytes[2];
                bytes[2] = bytes[5];
                bytes[5] = tmp;
                tmp = bytes[3];
                bytes[3] = bytes[4];
                bytes[4] = tmp;
                return;
            }
        }
        int nb2 = nBytes >>> 1;
        int i = 0;
        int j = nBytes - 1;
        while (i < nb2) {
            byte tmp = bytes[i];
            bytes[i] = bytes[j];
            bytes[j] = tmp;
            ++i;
            --j;
        }
    }

    public static final void swap(byte[] bytes, int offset, int nBytes) {
        switch (nBytes) {
            case 1: {
                return;
            }
            case 2: {
                byte tmp = bytes[offset + 0];
                bytes[offset + 0] = bytes[offset + 1];
                bytes[offset + 1] = tmp;
                return;
            }
            case 4: {
                byte tmp = bytes[offset + 0];
                bytes[offset + 0] = bytes[offset + 3];
                bytes[offset + 3] = tmp;
                tmp = bytes[offset + 1];
                bytes[offset + 1] = bytes[offset + 2];
                bytes[offset + 2] = tmp;
                return;
            }
            case 8: {
                byte tmp = bytes[offset + 0];
                bytes[offset + 0] = bytes[offset + 7];
                bytes[offset + 7] = tmp;
                tmp = bytes[offset + 1];
                bytes[offset + 1] = bytes[offset + 6];
                bytes[offset + 6] = tmp;
                tmp = bytes[offset + 2];
                bytes[offset + 2] = bytes[offset + 5];
                bytes[offset + 5] = tmp;
                tmp = bytes[offset + 3];
                bytes[offset + 3] = bytes[offset + 4];
                bytes[offset + 4] = tmp;
                return;
            }
        }
        int nb2 = nBytes >>> 1;
        int i = 0;
        int j = nBytes - 1;
        while (i < nb2) {
            byte tmp = bytes[offset + i];
            bytes[offset + i] = bytes[offset + j];
            bytes[offset + j] = tmp;
            ++i;
            --j;
        }
    }

    public static final void swapMultiple(byte[] bytes, int nBytes, int nTimes) {
        int offset = 0;
        for (int i = 0; i < nTimes; ++i) {
            Host.swap(bytes, offset, nBytes);
            offset += nBytes;
        }
    }

    public static final void swapMultiple(byte[] bytes, int offset, int nBytes, int nTimes) {
        for (int i = 0; i < nTimes; ++i) {
            Host.swap(bytes, offset, nBytes);
            offset += nBytes;
        }
    }

    public static final short castToByte(byte[] bytes) {
        return (short)(bytes[0] & 0xFF);
    }

    public static final short castToShort(byte[] bytes) {
        return (short)((bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF);
    }

    public static final int castToUnsignedShort(byte[] bytes) {
        return (bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF;
    }

    public static final int castToInt(byte[] bytes) {
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    public static final long castToUnsignedInt(byte[] bytes) {
        return ((long)bytes[0] & 0xFFL) << 24 | ((long)bytes[1] & 0xFFL) << 16 | ((long)bytes[2] & 0xFFL) << 8 | (long)bytes[3] & 0xFFL;
    }

    public static final long castToLong(byte[] bytes) {
        return ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | (long)bytes[7] & 0xFFL;
    }

    public static final long castToUnsignedLong(byte[] bytes) {
        return ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | (long)bytes[7] & 0xFFL;
    }

    public static final long castToLongLong(byte[] bytes) {
        return ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | (long)bytes[7] & 0xFFL;
    }

    public static final long castToUnsignedLongLong(byte[] bytes) {
        return ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | (long)bytes[7] & 0xFFL;
    }

    public static final float castToFloat(byte[] bytes) {
        int i = (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
        return Float.intBitsToFloat(i);
    }

    public static final double castToDouble(byte[] bytes) {
        long l = ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | (long)bytes[7] & 0xFFL;
        return Double.longBitsToDouble(l);
    }

    public static final double castToLongDouble(byte[] bytes) {
        long l = ((long)bytes[0] & 0xFFL) << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | (long)bytes[7] & 0xFFL;
        return Double.longBitsToDouble(l);
    }

    public static final short castToByte(byte[] bytes, int offset) {
        return (short)(bytes[offset] & 0xFF);
    }

    public static final short castToShort(byte[] bytes, int offset) {
        return (short)((bytes[offset + 0] & 0xFF) << 8 | bytes[offset + 1] & 0xFF);
    }

    public static final int castToUnsignedShort(byte[] bytes, int offset) {
        return (bytes[offset + 0] & 0xFF) << 8 | bytes[offset + 1] & 0xFF;
    }

    public static final int castToInt(byte[] bytes, int offset) {
        return (bytes[offset + 0] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    public static final long castToUnsignedInt(byte[] bytes, int offset) {
        return ((long)bytes[offset + 0] & 0xFFL) << 24 | ((long)bytes[offset + 1] & 0xFFL) << 16 | ((long)bytes[offset + 2] & 0xFFL) << 8 | (long)bytes[offset + 3] & 0xFFL;
    }

    public static final long castToLong(byte[] bytes, int offset) {
        return ((long)bytes[offset + 0] & 0xFFL) << 56 | ((long)bytes[offset + 1] & 0xFFL) << 48 | ((long)bytes[offset + 2] & 0xFFL) << 40 | ((long)bytes[offset + 3] & 0xFFL) << 32 | ((long)bytes[offset + 4] & 0xFFL) << 24 | ((long)bytes[offset + 5] & 0xFFL) << 16 | ((long)bytes[offset + 6] & 0xFFL) << 8 | (long)bytes[offset + 7] & 0xFFL;
    }

    public static final long castToUnsignedLong(byte[] bytes, int offset) {
        return ((long)bytes[offset + 0] & 0xFFL) << 56 | ((long)bytes[offset + 1] & 0xFFL) << 48 | ((long)bytes[offset + 2] & 0xFFL) << 40 | ((long)bytes[offset + 3] & 0xFFL) << 32 | ((long)bytes[offset + 4] & 0xFFL) << 24 | ((long)bytes[offset + 5] & 0xFFL) << 16 | ((long)bytes[offset + 6] & 0xFFL) << 8 | (long)bytes[offset + 7] & 0xFFL;
    }

    public static final long castToLongLong(byte[] bytes, int offset) {
        return ((long)bytes[offset + 0] & 0xFFL) << 56 | ((long)bytes[offset + 1] & 0xFFL) << 48 | ((long)bytes[offset + 2] & 0xFFL) << 40 | ((long)bytes[offset + 3] & 0xFFL) << 32 | ((long)bytes[offset + 4] & 0xFFL) << 24 | ((long)bytes[offset + 5] & 0xFFL) << 16 | ((long)bytes[offset + 6] & 0xFFL) << 8 | (long)bytes[offset + 7] & 0xFFL;
    }

    public static final long castToUnsignedLongLong(byte[] bytes, int offset) {
        return ((long)bytes[offset + 0] & 0xFFL) << 56 | ((long)bytes[offset + 1] & 0xFFL) << 48 | ((long)bytes[offset + 2] & 0xFFL) << 40 | ((long)bytes[offset + 3] & 0xFFL) << 32 | ((long)bytes[offset + 4] & 0xFFL) << 24 | ((long)bytes[offset + 5] & 0xFFL) << 16 | ((long)bytes[offset + 6] & 0xFFL) << 8 | (long)bytes[offset + 7] & 0xFFL;
    }

    public static final float castToFloat(byte[] bytes, int offset) {
        int i = (bytes[offset + 0] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
        return Float.intBitsToFloat(i);
    }

    public static final double castToDouble(byte[] bytes, int offset) {
        long l = ((long)bytes[offset + 0] & 0xFFL) << 56 | ((long)bytes[offset + 1] & 0xFFL) << 48 | ((long)bytes[offset + 2] & 0xFFL) << 40 | ((long)bytes[offset + 3] & 0xFFL) << 32 | ((long)bytes[offset + 4] & 0xFFL) << 24 | ((long)bytes[offset + 5] & 0xFFL) << 16 | ((long)bytes[offset + 6] & 0xFFL) << 8 | (long)bytes[offset + 7] & 0xFFL;
        return Double.longBitsToDouble(l);
    }

    public static final double castToLongDouble(byte[] bytes, int offset) {
        long l = ((long)bytes[offset + 0] & 0xFFL) << 56 | ((long)bytes[offset + 1] & 0xFFL) << 48 | ((long)bytes[offset + 2] & 0xFFL) << 40 | ((long)bytes[offset + 3] & 0xFFL) << 32 | ((long)bytes[offset + 4] & 0xFFL) << 24 | ((long)bytes[offset + 5] & 0xFFL) << 16 | ((long)bytes[offset + 6] & 0xFFL) << 8 | (long)bytes[offset + 7] & 0xFFL;
        return Double.longBitsToDouble(l);
    }

    public static final void copyShort(byte value, byte[] bytes) {
        short s = value;
        bytes[0] = (byte)(s >> 8);
        bytes[1] = (byte)s;
    }

    public static final void copyShort(short value, byte[] bytes) {
        bytes[0] = (byte)(value >> 8);
        bytes[1] = (byte)value;
    }

    public static final void copyShort(int value, byte[] bytes) {
        bytes[0] = (byte)(value >> 8);
        bytes[1] = (byte)value;
    }

    public static final void copyShort(long value, byte[] bytes) {
        bytes[0] = (byte)(value >> 8);
        bytes[1] = (byte)value;
    }

    public static final void copyUnsignedShort(byte value, byte[] bytes) {
        bytes[0] = 0;
        bytes[1] = value;
    }

    public static final void copyUnsignedShort(short value, byte[] bytes) {
        bytes[0] = (byte)(value >>> 8);
        bytes[1] = (byte)value;
    }

    public static final void copyUnsignedShort(int value, byte[] bytes) {
        bytes[0] = (byte)(value >>> 8);
        bytes[1] = (byte)value;
    }

    public static final void copyUnsignedShort(long value, byte[] bytes) {
        bytes[0] = (byte)(value >>> 8);
        bytes[1] = (byte)value;
    }

    public static final void copyInt(byte value, byte[] bytes) {
        byte i = value;
        bytes[0] = (byte)(i >> 24);
        bytes[1] = (byte)(i >> 16);
        bytes[2] = (byte)(i >> 8);
        bytes[3] = i;
    }

    public static final void copyInt(short value, byte[] bytes) {
        short i = value;
        bytes[0] = (byte)(i >> 24);
        bytes[1] = (byte)(i >> 16);
        bytes[2] = (byte)(i >> 8);
        bytes[3] = (byte)i;
    }

    public static final void copyInt(int value, byte[] bytes) {
        bytes[0] = (byte)(value >> 24);
        bytes[1] = (byte)(value >> 16);
        bytes[2] = (byte)(value >> 8);
        bytes[3] = (byte)value;
    }

    public static final void copyInt(long value, byte[] bytes) {
        bytes[0] = (byte)(value >> 24);
        bytes[1] = (byte)(value >> 16);
        bytes[2] = (byte)(value >> 8);
        bytes[3] = (byte)value;
    }

    public static final void copyUnsignedInt(byte value, byte[] bytes) {
        bytes[0] = 0;
        bytes[1] = 0;
        bytes[2] = 0;
        bytes[3] = value;
    }

    public static final void copyUnsignedInt(short value, byte[] bytes) {
        bytes[0] = 0;
        bytes[1] = 0;
        bytes[2] = (byte)(value >>> 8);
        bytes[3] = (byte)value;
    }

    public static final void copyUnsignedInt(int value, byte[] bytes) {
        bytes[0] = (byte)(value >>> 24);
        bytes[1] = (byte)(value >>> 16);
        bytes[2] = (byte)(value >>> 8);
        bytes[3] = (byte)value;
    }

    public static final void copyUnsignedInt(long value, byte[] bytes) {
        bytes[0] = (byte)(value >>> 24);
        bytes[1] = (byte)(value >>> 16);
        bytes[2] = (byte)(value >>> 8);
        bytes[3] = (byte)value;
    }

    public static final void copyLong(byte value, byte[] bytes) {
        long lng = value;
        bytes[0] = (byte)(lng >> 56);
        bytes[1] = (byte)(lng >> 48);
        bytes[2] = (byte)(lng >> 40);
        bytes[3] = (byte)(lng >> 32);
        bytes[4] = (byte)(lng >> 24);
        bytes[5] = (byte)(lng >> 16);
        bytes[6] = (byte)(lng >> 8);
        bytes[7] = (byte)lng;
    }

    public static final void copyLong(short value, byte[] bytes) {
        long lng = value;
        bytes[0] = (byte)(lng >> 56);
        bytes[1] = (byte)(lng >> 48);
        bytes[2] = (byte)(lng >> 40);
        bytes[3] = (byte)(lng >> 32);
        bytes[4] = (byte)(lng >> 24);
        bytes[5] = (byte)(lng >> 16);
        bytes[6] = (byte)(lng >> 8);
        bytes[7] = (byte)lng;
    }

    public static final void copyLong(int value, byte[] bytes) {
        long lng = value;
        bytes[0] = (byte)(lng >> 56);
        bytes[1] = (byte)(lng >> 48);
        bytes[2] = (byte)(lng >> 40);
        bytes[3] = (byte)(lng >> 32);
        bytes[4] = (byte)(lng >> 24);
        bytes[5] = (byte)(lng >> 16);
        bytes[6] = (byte)(lng >> 8);
        bytes[7] = (byte)lng;
    }

    public static final void copyLong(long value, byte[] bytes) {
        bytes[0] = (byte)(value >> 56);
        bytes[1] = (byte)(value >> 48);
        bytes[2] = (byte)(value >> 40);
        bytes[3] = (byte)(value >> 32);
        bytes[4] = (byte)(value >> 24);
        bytes[5] = (byte)(value >> 16);
        bytes[6] = (byte)(value >> 8);
        bytes[7] = (byte)value;
    }

    public static final void copyUnsignedLong(byte value, byte[] bytes) {
        bytes[0] = 0;
        bytes[1] = 0;
        bytes[2] = 0;
        bytes[3] = 0;
        bytes[4] = 0;
        bytes[5] = 0;
        bytes[6] = 0;
        bytes[7] = value;
    }

    public static final void copyUnsignedLong(short value, byte[] bytes) {
        bytes[0] = 0;
        bytes[1] = 0;
        bytes[2] = 0;
        bytes[3] = 0;
        bytes[4] = 0;
        bytes[5] = 0;
        bytes[6] = (byte)(value >>> 8);
        bytes[7] = (byte)value;
    }

    public static final void copyUnsignedLong(int value, byte[] bytes) {
        bytes[0] = 0;
        bytes[1] = 0;
        bytes[2] = 0;
        bytes[3] = 0;
        bytes[4] = (byte)(value >>> 24);
        bytes[5] = (byte)(value >>> 16);
        bytes[6] = (byte)(value >>> 8);
        bytes[7] = (byte)value;
    }

    public static final void copyUnsignedLong(long value, byte[] bytes) {
        bytes[0] = (byte)(value >>> 56);
        bytes[1] = (byte)(value >>> 48);
        bytes[2] = (byte)(value >>> 40);
        bytes[3] = (byte)(value >>> 32);
        bytes[4] = (byte)(value >>> 24);
        bytes[5] = (byte)(value >>> 16);
        bytes[6] = (byte)(value >>> 8);
        bytes[7] = (byte)value;
    }

    public static final void copyLongLong(byte value, byte[] bytes) {
        long lng = value;
        bytes[0] = (byte)(lng >> 56);
        bytes[1] = (byte)(lng >> 48);
        bytes[2] = (byte)(lng >> 40);
        bytes[3] = (byte)(lng >> 32);
        bytes[4] = (byte)(lng >> 24);
        bytes[5] = (byte)(lng >> 16);
        bytes[6] = (byte)(lng >> 8);
        bytes[7] = (byte)lng;
    }

    public static final void copyLongLong(short value, byte[] bytes) {
        long lng = value;
        bytes[0] = (byte)(lng >> 56);
        bytes[1] = (byte)(lng >> 48);
        bytes[2] = (byte)(lng >> 40);
        bytes[3] = (byte)(lng >> 32);
        bytes[4] = (byte)(lng >> 24);
        bytes[5] = (byte)(lng >> 16);
        bytes[6] = (byte)(lng >> 8);
        bytes[7] = (byte)lng;
    }

    public static final void copyLongLong(int value, byte[] bytes) {
        long lng = value;
        bytes[0] = (byte)(lng >> 56);
        bytes[1] = (byte)(lng >> 48);
        bytes[2] = (byte)(lng >> 40);
        bytes[3] = (byte)(lng >> 32);
        bytes[4] = (byte)(lng >> 24);
        bytes[5] = (byte)(lng >> 16);
        bytes[6] = (byte)(lng >> 8);
        bytes[7] = (byte)lng;
    }

    public static final void copyLongLong(long value, byte[] bytes) {
        bytes[0] = (byte)(value >> 56);
        bytes[1] = (byte)(value >> 48);
        bytes[2] = (byte)(value >> 40);
        bytes[3] = (byte)(value >> 32);
        bytes[4] = (byte)(value >> 24);
        bytes[5] = (byte)(value >> 16);
        bytes[6] = (byte)(value >> 8);
        bytes[7] = (byte)value;
    }

    public static final void copyUnsignedLongLong(byte value, byte[] bytes) {
        bytes[0] = 0;
        bytes[1] = 0;
        bytes[2] = 0;
        bytes[3] = 0;
        bytes[4] = 0;
        bytes[5] = 0;
        bytes[6] = 0;
        bytes[7] = value;
    }

    public static final void copyUnsignedLongLong(short value, byte[] bytes) {
        bytes[0] = 0;
        bytes[1] = 0;
        bytes[2] = 0;
        bytes[3] = 0;
        bytes[4] = 0;
        bytes[5] = 0;
        bytes[6] = (byte)(value >>> 8);
        bytes[7] = (byte)value;
    }

    public static final void copyUnsignedLongLong(int value, byte[] bytes) {
        bytes[0] = 0;
        bytes[1] = 0;
        bytes[2] = 0;
        bytes[3] = 0;
        bytes[4] = (byte)(value >>> 24);
        bytes[5] = (byte)(value >>> 16);
        bytes[6] = (byte)(value >>> 8);
        bytes[7] = (byte)value;
    }

    public static final void copyUnsignedLongLong(long value, byte[] bytes) {
        bytes[0] = (byte)(value >>> 56);
        bytes[1] = (byte)(value >>> 48);
        bytes[2] = (byte)(value >>> 40);
        bytes[3] = (byte)(value >>> 32);
        bytes[4] = (byte)(value >>> 24);
        bytes[5] = (byte)(value >>> 16);
        bytes[6] = (byte)(value >>> 8);
        bytes[7] = (byte)value;
    }

    public static final void copyFloat(float value, byte[] bytes) {
        int v = Float.floatToIntBits(value);
        bytes[0] = (byte)(v >> 24);
        bytes[1] = (byte)(v >> 16);
        bytes[2] = (byte)(v >> 8);
        bytes[3] = (byte)v;
    }

    public static final void copyFloat(double value, byte[] bytes) {
        int v = Float.floatToIntBits((float)value);
        bytes[0] = (byte)(v >> 24);
        bytes[1] = (byte)(v >> 16);
        bytes[2] = (byte)(v >> 8);
        bytes[3] = (byte)v;
    }

    public static final void copyDouble(double value, byte[] bytes) {
        long v = Double.doubleToLongBits(value);
        bytes[0] = (byte)(v >> 56);
        bytes[1] = (byte)(v >> 48);
        bytes[2] = (byte)(v >> 40);
        bytes[3] = (byte)(v >> 32);
        bytes[4] = (byte)(v >> 24);
        bytes[5] = (byte)(v >> 16);
        bytes[6] = (byte)(v >> 8);
        bytes[7] = (byte)v;
    }

    public static final void copyLongDouble(double value, byte[] bytes) {
        long v = Double.doubleToLongBits(value);
        bytes[0] = (byte)(v >> 56);
        bytes[1] = (byte)(v >> 48);
        bytes[2] = (byte)(v >> 40);
        bytes[3] = (byte)(v >> 32);
        bytes[4] = (byte)(v >> 24);
        bytes[5] = (byte)(v >> 16);
        bytes[6] = (byte)(v >> 8);
        bytes[7] = (byte)v;
    }

    public static final void copyShort(byte value, byte[] bytes, int offset) {
        short s = value;
        bytes[offset + 0] = (byte)(s >> 8);
        bytes[offset + 1] = (byte)s;
    }

    public static final void copyShort(short value, byte[] bytes, int offset) {
        bytes[offset + 0] = (byte)(value >> 8);
        bytes[offset + 1] = (byte)value;
    }

    public static final void copyShort(int value, byte[] bytes, int offset) {
        bytes[offset + 0] = (byte)(value >> 8);
        bytes[offset + 1] = (byte)value;
    }

    public static final void copyShort(long value, byte[] bytes, int offset) {
        bytes[offset + 0] = (byte)(value >> 8);
        bytes[offset + 1] = (byte)value;
    }

    public static final void copyUnsignedShort(byte value, byte[] bytes, int offset) {
        bytes[offset + 0] = 0;
        bytes[offset + 1] = value;
    }

    public static final void copyUnsignedShort(short value, byte[] bytes, int offset) {
        bytes[offset + 0] = (byte)(value >>> 8);
        bytes[offset + 1] = (byte)value;
    }

    public static final void copyUnsignedShort(int value, byte[] bytes, int offset) {
        bytes[offset + 0] = (byte)(value >>> 8);
        bytes[offset + 1] = (byte)value;
    }

    public static final void copyUnsignedShort(long value, byte[] bytes, int offset) {
        bytes[offset + 0] = (byte)(value >>> 8);
        bytes[offset + 1] = (byte)value;
    }

    public static final void copyInt(byte value, byte[] bytes, int offset) {
        byte i = value;
        bytes[offset + 0] = (byte)(i >> 24);
        bytes[offset + 1] = (byte)(i >> 16);
        bytes[offset + 2] = (byte)(i >> 8);
        bytes[offset + 3] = i;
    }

    public static final void copyInt(short value, byte[] bytes, int offset) {
        short i = value;
        bytes[offset + 0] = (byte)(i >> 24);
        bytes[offset + 1] = (byte)(i >> 16);
        bytes[offset + 2] = (byte)(i >> 8);
        bytes[offset + 3] = (byte)i;
    }

    public static final void copyInt(int value, byte[] bytes, int offset) {
        bytes[offset + 0] = (byte)(value >> 24);
        bytes[offset + 1] = (byte)(value >> 16);
        bytes[offset + 2] = (byte)(value >> 8);
        bytes[offset + 3] = (byte)value;
    }

    public static final void copyInt(long value, byte[] bytes, int offset) {
        bytes[offset + 0] = (byte)(value >> 24);
        bytes[offset + 1] = (byte)(value >> 16);
        bytes[offset + 2] = (byte)(value >> 8);
        bytes[offset + 3] = (byte)value;
    }

    public static final void copyUnsignedInt(byte value, byte[] bytes, int offset) {
        bytes[offset + 0] = 0;
        bytes[offset + 1] = 0;
        bytes[offset + 2] = 0;
        bytes[offset + 3] = value;
    }

    public static final void copyUnsignedInt(short value, byte[] bytes, int offset) {
        bytes[offset + 0] = 0;
        bytes[offset + 1] = 0;
        bytes[offset + 2] = (byte)(value >>> 8);
        bytes[offset + 3] = (byte)value;
    }

    public static final void copyUnsignedInt(int value, byte[] bytes, int offset) {
        bytes[offset + 0] = (byte)(value >>> 24);
        bytes[offset + 1] = (byte)(value >>> 16);
        bytes[offset + 2] = (byte)(value >>> 8);
        bytes[offset + 3] = (byte)value;
    }

    public static final void copyUnsignedInt(long value, byte[] bytes, int offset) {
        bytes[offset + 0] = (byte)(value >>> 24);
        bytes[offset + 1] = (byte)(value >>> 16);
        bytes[offset + 2] = (byte)(value >>> 8);
        bytes[offset + 3] = (byte)value;
    }

    public static final void copyLong(byte value, byte[] bytes, int offset) {
        long lng = value;
        bytes[offset + 0] = (byte)(lng >> 56);
        bytes[offset + 1] = (byte)(lng >> 48);
        bytes[offset + 2] = (byte)(lng >> 40);
        bytes[offset + 3] = (byte)(lng >> 32);
        bytes[offset + 4] = (byte)(lng >> 24);
        bytes[offset + 5] = (byte)(lng >> 16);
        bytes[offset + 6] = (byte)(lng >> 8);
        bytes[offset + 7] = (byte)lng;
    }

    public static final void copyLong(short value, byte[] bytes, int offset) {
        long lng = value;
        bytes[offset + 0] = (byte)(lng >> 56);
        bytes[offset + 1] = (byte)(lng >> 48);
        bytes[offset + 2] = (byte)(lng >> 40);
        bytes[offset + 3] = (byte)(lng >> 32);
        bytes[offset + 4] = (byte)(lng >> 24);
        bytes[offset + 5] = (byte)(lng >> 16);
        bytes[offset + 6] = (byte)(lng >> 8);
        bytes[offset + 7] = (byte)lng;
    }

    public static final void copyLong(int value, byte[] bytes, int offset) {
        long lng = value;
        bytes[offset + 0] = (byte)(lng >> 56);
        bytes[offset + 1] = (byte)(lng >> 48);
        bytes[offset + 2] = (byte)(lng >> 40);
        bytes[offset + 3] = (byte)(lng >> 32);
        bytes[offset + 4] = (byte)(lng >> 24);
        bytes[offset + 5] = (byte)(lng >> 16);
        bytes[offset + 6] = (byte)(lng >> 8);
        bytes[offset + 7] = (byte)lng;
    }

    public static final void copyLong(long value, byte[] bytes, int offset) {
        bytes[offset + 0] = (byte)(value >> 56);
        bytes[offset + 1] = (byte)(value >> 48);
        bytes[offset + 2] = (byte)(value >> 40);
        bytes[offset + 3] = (byte)(value >> 32);
        bytes[offset + 4] = (byte)(value >> 24);
        bytes[offset + 5] = (byte)(value >> 16);
        bytes[offset + 6] = (byte)(value >> 8);
        bytes[offset + 7] = (byte)value;
    }

    public static final void copyUnsignedLong(byte value, byte[] bytes, int offset) {
        bytes[offset + 0] = 0;
        bytes[offset + 1] = 0;
        bytes[offset + 2] = 0;
        bytes[offset + 3] = 0;
        bytes[offset + 4] = 0;
        bytes[offset + 5] = 0;
        bytes[offset + 6] = 0;
        bytes[offset + 7] = value;
    }

    public static final void copyUnsignedLong(short value, byte[] bytes, int offset) {
        bytes[offset + 0] = 0;
        bytes[offset + 1] = 0;
        bytes[offset + 2] = 0;
        bytes[offset + 3] = 0;
        bytes[offset + 4] = 0;
        bytes[offset + 5] = 0;
        bytes[offset + 6] = (byte)(value >>> 8);
        bytes[offset + 7] = (byte)value;
    }

    public static final void copyUnsignedLong(int value, byte[] bytes, int offset) {
        bytes[offset + 0] = 0;
        bytes[offset + 1] = 0;
        bytes[offset + 2] = 0;
        bytes[offset + 3] = 0;
        bytes[offset + 4] = (byte)(value >>> 24);
        bytes[offset + 5] = (byte)(value >>> 16);
        bytes[offset + 6] = (byte)(value >>> 8);
        bytes[offset + 7] = (byte)value;
    }

    public static final void copyUnsignedLong(long value, byte[] bytes, int offset) {
        bytes[offset + 0] = (byte)(value >>> 56);
        bytes[offset + 1] = (byte)(value >>> 48);
        bytes[offset + 2] = (byte)(value >>> 40);
        bytes[offset + 3] = (byte)(value >>> 32);
        bytes[offset + 4] = (byte)(value >>> 24);
        bytes[offset + 5] = (byte)(value >>> 16);
        bytes[offset + 6] = (byte)(value >>> 8);
        bytes[offset + 7] = (byte)value;
    }

    public static final void copyLongLong(byte value, byte[] bytes, int offset) {
        long lng = value;
        bytes[offset + 0] = (byte)(lng >> 56);
        bytes[offset + 1] = (byte)(lng >> 48);
        bytes[offset + 2] = (byte)(lng >> 40);
        bytes[offset + 3] = (byte)(lng >> 32);
        bytes[offset + 4] = (byte)(lng >> 24);
        bytes[offset + 5] = (byte)(lng >> 16);
        bytes[offset + 6] = (byte)(lng >> 8);
        bytes[offset + 7] = (byte)lng;
    }

    public static final void copyLongLong(short value, byte[] bytes, int offset) {
        long lng = value;
        bytes[offset + 0] = (byte)(lng >> 56);
        bytes[offset + 1] = (byte)(lng >> 48);
        bytes[offset + 2] = (byte)(lng >> 40);
        bytes[offset + 3] = (byte)(lng >> 32);
        bytes[offset + 4] = (byte)(lng >> 24);
        bytes[offset + 5] = (byte)(lng >> 16);
        bytes[offset + 6] = (byte)(lng >> 8);
        bytes[offset + 7] = (byte)lng;
    }

    public static final void copyLongLong(int value, byte[] bytes, int offset) {
        long lng = value;
        bytes[offset + 0] = (byte)(lng >> 56);
        bytes[offset + 1] = (byte)(lng >> 48);
        bytes[offset + 2] = (byte)(lng >> 40);
        bytes[offset + 3] = (byte)(lng >> 32);
        bytes[offset + 4] = (byte)(lng >> 24);
        bytes[offset + 5] = (byte)(lng >> 16);
        bytes[offset + 6] = (byte)(lng >> 8);
        bytes[offset + 7] = (byte)lng;
    }

    public static final void copyLongLong(long value, byte[] bytes, int offset) {
        bytes[offset + 0] = (byte)(value >> 56);
        bytes[offset + 1] = (byte)(value >> 48);
        bytes[offset + 2] = (byte)(value >> 40);
        bytes[offset + 3] = (byte)(value >> 32);
        bytes[offset + 4] = (byte)(value >> 24);
        bytes[offset + 5] = (byte)(value >> 16);
        bytes[offset + 6] = (byte)(value >> 8);
        bytes[offset + 7] = (byte)value;
    }

    public static final void copyUnsignedLongLong(byte value, byte[] bytes, int offset) {
        bytes[offset + 0] = 0;
        bytes[offset + 1] = 0;
        bytes[offset + 2] = 0;
        bytes[offset + 3] = 0;
        bytes[offset + 4] = 0;
        bytes[offset + 5] = 0;
        bytes[offset + 6] = 0;
        bytes[offset + 7] = value;
    }

    public static final void copyUnsignedLongLong(short value, byte[] bytes, int offset) {
        bytes[offset + 0] = 0;
        bytes[offset + 1] = 0;
        bytes[offset + 2] = 0;
        bytes[offset + 3] = 0;
        bytes[offset + 4] = 0;
        bytes[offset + 5] = 0;
        bytes[offset + 6] = (byte)(value >>> 8);
        bytes[offset + 7] = (byte)value;
    }

    public static final void copyUnsignedLongLong(int value, byte[] bytes, int offset) {
        bytes[offset + 0] = 0;
        bytes[offset + 1] = 0;
        bytes[offset + 2] = 0;
        bytes[offset + 3] = 0;
        bytes[offset + 4] = (byte)(value >>> 24);
        bytes[offset + 5] = (byte)(value >>> 16);
        bytes[offset + 6] = (byte)(value >>> 8);
        bytes[offset + 7] = (byte)value;
    }

    public static final void copyUnsignedLongLong(long value, byte[] bytes, int offset) {
        bytes[offset + 0] = (byte)(value >>> 56);
        bytes[offset + 1] = (byte)(value >>> 48);
        bytes[offset + 2] = (byte)(value >>> 40);
        bytes[offset + 3] = (byte)(value >>> 32);
        bytes[offset + 4] = (byte)(value >>> 24);
        bytes[offset + 5] = (byte)(value >>> 16);
        bytes[offset + 6] = (byte)(value >>> 8);
        bytes[offset + 7] = (byte)value;
    }

    public static final void copyFloat(float value, byte[] bytes, int offset) {
        int v = Float.floatToIntBits(value);
        bytes[offset + 0] = (byte)(v >> 24);
        bytes[offset + 1] = (byte)(v >> 16);
        bytes[offset + 2] = (byte)(v >> 8);
        bytes[offset + 3] = (byte)v;
    }

    public static final void copyFloat(double value, byte[] bytes, int offset) {
        int v = Float.floatToIntBits((float)value);
        bytes[offset + 0] = (byte)(v >> 24);
        bytes[offset + 1] = (byte)(v >> 16);
        bytes[offset + 2] = (byte)(v >> 8);
        bytes[offset + 3] = (byte)v;
    }

    public static final void copyDouble(double value, byte[] bytes, int offset) {
        long v = Double.doubleToLongBits(value);
        bytes[offset + 0] = (byte)(v >> 56);
        bytes[offset + 1] = (byte)(v >> 48);
        bytes[offset + 2] = (byte)(v >> 40);
        bytes[offset + 3] = (byte)(v >> 32);
        bytes[offset + 4] = (byte)(v >> 24);
        bytes[offset + 5] = (byte)(v >> 16);
        bytes[offset + 6] = (byte)(v >> 8);
        bytes[offset + 7] = (byte)v;
    }

    public static final void copyLongDouble(double value, byte[] bytes, int offset) {
        long v = Double.doubleToLongBits(value);
        bytes[offset + 0] = (byte)(v >> 56);
        bytes[offset + 1] = (byte)(v >> 48);
        bytes[offset + 2] = (byte)(v >> 40);
        bytes[offset + 3] = (byte)(v >> 32);
        bytes[offset + 4] = (byte)(v >> 24);
        bytes[offset + 5] = (byte)(v >> 16);
        bytes[offset + 6] = (byte)(v >> 8);
        bytes[offset + 7] = (byte)v;
    }

    public static final void print() {
        System.out.println("Host attributes:");
        System.out.println("  Type            Size Bits CC align");
        for (int i = 0; i < 8; ++i) {
            int j;
            StringBuffer sb = new StringBuffer("  ");
            sb.append(typeName[i]);
            int len = 15 - typeName[i].length();
            for (j = 0; j < len; ++j) {
                sb.append(' ');
            }
            sb.append(' ');
            String s = String.valueOf(typeSize[i]);
            sb.append(s);
            len = 4 - s.length();
            for (j = 0; j < len; ++j) {
                sb.append(' ');
            }
            sb.append(' ');
            s = String.valueOf(typeBits[i]);
            sb.append(s);
            len = 4 - s.length();
            for (j = 0; j < len; ++j) {
                sb.append(' ');
            }
            sb.append(' ');
            s = String.valueOf(typeCompilerAlignment[i]);
            sb.append(s);
            len = 4 - s.length();
            for (j = 0; j < len; ++j) {
                sb.append(' ');
            }
            System.out.println(sb);
        }
    }
}

