/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.transfer;

import org.irods.jargon.core.transfer.FileRestartInfo;

public class FileRestartInfoIdentifier {
    private String irodsAccountIdentifier;
    private FileRestartInfo.RestartType restartType = FileRestartInfo.RestartType.PUT;
    private String absolutePath = "";

    public static FileRestartInfoIdentifier instanceFromFileRestartInfo(FileRestartInfo fileRestartInfo) {
        if (fileRestartInfo == null) {
            throw new IllegalArgumentException("null fileRestartInfo");
        }
        FileRestartInfoIdentifier identifier = new FileRestartInfoIdentifier();
        identifier.setAbsolutePath(fileRestartInfo.getIrodsAbsolutePath());
        identifier.setIrodsAccountIdentifier(fileRestartInfo.getIrodsAccountIdentifier());
        identifier.setRestartType(fileRestartInfo.getRestartType());
        return identifier;
    }

    public String getIrodsAccountIdentifier() {
        return this.irodsAccountIdentifier;
    }

    public void setIrodsAccountIdentifier(String irodsAccountIdentifier) {
        this.irodsAccountIdentifier = irodsAccountIdentifier;
    }

    public FileRestartInfo.RestartType getRestartType() {
        return this.restartType;
    }

    public void setRestartType(FileRestartInfo.RestartType restartType) {
        this.restartType = restartType;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public void setAbsolutePath(String absolutePath) {
        this.absolutePath = absolutePath;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileRestartInfoIdentifier)) {
            return false;
        }
        FileRestartInfoIdentifier other = (FileRestartInfoIdentifier)obj;
        return this.absolutePath.equals(other.getAbsolutePath()) && this.irodsAccountIdentifier.equals(other.getIrodsAccountIdentifier()) && this.getRestartType() == other.getRestartType();
    }

    public int hashCode() {
        return this.absolutePath.hashCode() + this.irodsAccountIdentifier.hashCode() + this.restartType.hashCode();
    }
}

