/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.transfer;

import java.io.File;
import org.irods.jargon.core.connection.ConnectionProgressStatusListener;
import org.irods.jargon.core.connection.JargonProperties;
import org.irods.jargon.core.connection.NegotiatedClientServerConfiguration;
import org.irods.jargon.core.connection.PipelineConfiguration;
import org.irods.jargon.core.connection.SettableJargonProperties;
import org.irods.jargon.core.exception.ClientServerNegotiationException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.IRODSAccessObjectFactory;
import org.irods.jargon.core.transfer.AbstractRestartManager;
import org.irods.jargon.core.transfer.FileRestartInfo;
import org.irods.jargon.core.transfer.TransferControlBlock;
import org.irods.jargon.core.transfer.TransferStatusCallbackListener;
import org.irods.jargon.core.transfer.encrypt.EncryptionWrapperFactory;
import org.irods.jargon.core.transfer.encrypt.ParallelDecryptionCipherWrapper;
import org.irods.jargon.core.transfer.encrypt.ParallelEncryptionCipherWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParallelFileTransferStrategy {
    public static final Logger log = LoggerFactory.getLogger(AbstractParallelFileTransferStrategy.class);
    protected final String host;
    protected final int port;
    protected final int numberOfThreads;
    protected final int password;
    protected final File localFile;
    protected final long transferLength;
    private final PipelineConfiguration pipelineConfiguration;
    private final FileRestartInfo fileRestartInfo;
    private NegotiatedClientServerConfiguration negotiatedClientServerConfiguration;
    private final IRODSAccessObjectFactory irodsAccessObjectFactory;
    private final TransferControlBlock transferControlBlock;
    private final TransferStatusCallbackListener transferStatusCallbackListener;
    private ConnectionProgressStatusListener connectionProgressStatusListener = null;
    private final int parallelSocketTimeoutInSecs;
    private final JargonProperties jargonProperties;

    public abstract void transfer() throws JargonException;

    protected AbstractParallelFileTransferStrategy(String host, int port, int numberOfThreads, int password, File localFile, IRODSAccessObjectFactory irodsAccessObjectFactory, long transferLength, TransferControlBlock transferControlBlock, TransferStatusCallbackListener transferStatusCallbackListener, FileRestartInfo fileRestartInfo, NegotiatedClientServerConfiguration negotiatedClientServerConfiguration) throws JargonException {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("host is null or empty");
        }
        if (port < 1) {
            throw new IllegalArgumentException("port must be supplied");
        }
        if (numberOfThreads == 0) {
            throw new IllegalArgumentException("this is not a parallel transfer, the number of threads supplied is zero");
        }
        if (password <= 0) {
            throw new IllegalArgumentException("password is invalid");
        }
        if (localFile == null) {
            throw new IllegalArgumentException("Local file is null");
        }
        if (irodsAccessObjectFactory == null) {
            throw new IllegalArgumentException("irodsAccessObjectFactory is null");
        }
        if (transferControlBlock == null) {
            throw new IllegalArgumentException("null transferControlBlock");
        }
        if (negotiatedClientServerConfiguration == null) {
            throw new IllegalArgumentException("null negotiatedClientServerConfiguration");
        }
        this.host = host;
        this.port = port;
        this.numberOfThreads = numberOfThreads;
        this.password = password;
        this.localFile = localFile;
        this.irodsAccessObjectFactory = irodsAccessObjectFactory;
        this.transferControlBlock = transferControlBlock;
        this.transferStatusCallbackListener = transferStatusCallbackListener;
        this.transferLength = transferLength;
        this.jargonProperties = new SettableJargonProperties(irodsAccessObjectFactory.getIrodsSession().getJargonProperties());
        this.pipelineConfiguration = irodsAccessObjectFactory.getIrodsSession().buildPipelineConfigurationBasedOnJargonProperties();
        this.fileRestartInfo = fileRestartInfo;
        this.parallelSocketTimeoutInSecs = this.jargonProperties.getIRODSParallelTransferSocketTimeout();
        this.negotiatedClientServerConfiguration = negotiatedClientServerConfiguration;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AbstractParallelFileTransferStrategy [");
        if (this.host != null) {
            builder.append("host=");
            builder.append(this.host);
            builder.append(", ");
        }
        builder.append("port=");
        builder.append(this.port);
        builder.append(", numberOfThreads=");
        builder.append(this.numberOfThreads);
        builder.append(", password=");
        builder.append(this.password);
        builder.append(", ");
        if (this.localFile != null) {
            builder.append("localFile=");
            builder.append(this.localFile);
            builder.append(", ");
        }
        builder.append("transferLength=");
        builder.append(this.transferLength);
        builder.append(", ");
        if (this.pipelineConfiguration != null) {
            builder.append("pipelineConfiguration=");
            builder.append(this.pipelineConfiguration);
            builder.append(", ");
        }
        if (this.fileRestartInfo != null) {
            builder.append("fileRestartInfo=");
            builder.append(this.fileRestartInfo);
            builder.append(", ");
        }
        if (this.negotiatedClientServerConfiguration != null) {
            builder.append("negotiatedClientServerConfiguration=");
            builder.append(this.negotiatedClientServerConfiguration);
            builder.append(", ");
        }
        if (this.irodsAccessObjectFactory != null) {
            builder.append("irodsAccessObjectFactory=");
            builder.append(this.irodsAccessObjectFactory);
            builder.append(", ");
        }
        if (this.transferControlBlock != null) {
            builder.append("transferControlBlock=");
            builder.append(this.transferControlBlock);
            builder.append(", ");
        }
        if (this.transferStatusCallbackListener != null) {
            builder.append("transferStatusCallbackListener=");
            builder.append(this.transferStatusCallbackListener);
            builder.append(", ");
        }
        if (this.connectionProgressStatusListener != null) {
            builder.append("connectionProgressStatusListener=");
            builder.append(this.connectionProgressStatusListener);
            builder.append(", ");
        }
        builder.append("parallelSocketTimeoutInSecs=");
        builder.append(this.parallelSocketTimeoutInSecs);
        builder.append(", ");
        if (this.jargonProperties != null) {
            builder.append("jargonProperties=");
            builder.append(this.jargonProperties);
        }
        builder.append("]");
        return builder.toString();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public int getPassword() {
        return this.password;
    }

    public File getLocalFile() {
        return this.localFile;
    }

    protected IRODSAccessObjectFactory getIrodsAccessObjectFactory() {
        return this.irodsAccessObjectFactory;
    }

    protected TransferControlBlock getTransferControlBlock() {
        return this.transferControlBlock;
    }

    protected TransferStatusCallbackListener getTransferStatusCallbackListener() {
        return this.transferStatusCallbackListener;
    }

    protected synchronized ConnectionProgressStatusListener getConnectionProgressStatusListener() {
        return this.connectionProgressStatusListener;
    }

    protected synchronized void setConnectionProgressStatusListener(ConnectionProgressStatusListener connectionProgressStatusListener) {
        this.connectionProgressStatusListener = connectionProgressStatusListener;
    }

    protected long getTransferLength() {
        return this.transferLength;
    }

    protected int getParallelSocketTimeoutInSecs() {
        return this.parallelSocketTimeoutInSecs;
    }

    protected JargonProperties getJargonProperties() {
        return this.jargonProperties;
    }

    public FileRestartInfo getFileRestartInfo() {
        return this.fileRestartInfo;
    }

    public AbstractRestartManager getRestartManager() {
        return this.getIrodsAccessObjectFactory().getIrodsSession().getRestartManager();
    }

    boolean doEncryption() {
        return this.negotiatedClientServerConfiguration.isSslConnection();
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipelineConfiguration;
    }

    ParallelEncryptionCipherWrapper initializeCypherForEncryption() throws ClientServerNegotiationException {
        log.debug("initializeCypherForEncryption()");
        if (!this.negotiatedClientServerConfiguration.isSslConnection()) {
            log.error("should not be trying to encrypt, is not ssl configured");
            throw new ClientServerNegotiationException("attempt to encrypt a transfer when SSL not configured");
        }
        return EncryptionWrapperFactory.instanceEncrypt(this.pipelineConfiguration, this.negotiatedClientServerConfiguration);
    }

    ParallelDecryptionCipherWrapper initializeCypherForDecryption() throws ClientServerNegotiationException {
        log.debug("initializeCypherForDecryption()");
        if (!this.negotiatedClientServerConfiguration.isSslConnection()) {
            log.error("should not be trying to decrypt, is not ssl configured");
            throw new ClientServerNegotiationException("attempt to decrypt a transfer when SSL not configured");
        }
        return EncryptionWrapperFactory.instanceDecrypt(this.pipelineConfiguration, this.negotiatedClientServerConfiguration);
    }

    public static enum TransferType {
        GET_TRANSFER,
        PUT_TRANSFER;

    }
}

