/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.transfer;

import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import org.irods.jargon.core.connection.NegotiatedClientServerConfiguration;
import org.irods.jargon.core.connection.PipelineConfiguration;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractParallelCipherWrapper {
    public static final Logger log = LoggerFactory.getLogger(AbstractParallelCipherWrapper.class);
    private Cipher cipher;
    private final PipelineConfiguration pipelineConfiguration;
    private final NegotiatedClientServerConfiguration negotiatedClientServerConfiguration;

    AbstractParallelCipherWrapper(PipelineConfiguration pipelineConfiguration, NegotiatedClientServerConfiguration negotiatedClientServerConfiguration) {
        this.pipelineConfiguration = pipelineConfiguration;
        this.negotiatedClientServerConfiguration = negotiatedClientServerConfiguration;
    }

    synchronized PipelineConfiguration getPipelineConfiguration() {
        return this.pipelineConfiguration;
    }

    synchronized NegotiatedClientServerConfiguration getNegotiatedClientServerConfiguration() {
        return this.negotiatedClientServerConfiguration;
    }

    synchronized Cipher getCipher() {
        return this.cipher;
    }

    synchronized void setCipher(Cipher cipher) {
        this.cipher = cipher;
    }

    byte[] generateSalt() throws JargonException {
        if (!this.negotiatedClientServerConfiguration.isSslConnection()) {
            throw new JargonRuntimeException("salt should not be generated when SSL not configured");
        }
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[this.pipelineConfiguration.getEncryptionSaltSize()];
        random.nextBytes(bytes);
        String s = new String(bytes);
        try {
            return s.getBytes(this.pipelineConfiguration.getDefaultEncoding());
        }
        catch (UnsupportedEncodingException e) {
            log.error("unsupported encoding:{}", (Object)this.pipelineConfiguration.getDefaultEncoding(), (Object)e);
            throw new JargonException("Cannot encode salt value", e);
        }
    }
}

