/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.query;

import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.connection.AbstractIRODSMidLevelProtocol;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.GenQueryInp;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.pub.IRODSGenQueryExecutorImpl;
import org.irods.jargon.core.query.AbstractIRODSGenQuery;
import org.irods.jargon.core.query.GenQueryBuilderException;
import org.irods.jargon.core.query.GenQuerySelectField;
import org.irods.jargon.core.query.IRODSGenQuery;
import org.irods.jargon.core.query.IRODSGenQueryFromBuilder;
import org.irods.jargon.core.query.IRODSGenQueryTranslator;
import org.irods.jargon.core.query.IRODSQueryResultRow;
import org.irods.jargon.core.query.IRODSQueryResultSet;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.QueryResultProcessingUtils;
import org.irods.jargon.core.query.TranslatedIRODSGenQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenQueryProcessor {
    private final AbstractIRODSMidLevelProtocol irodsCommands;
    private static final Logger log = LoggerFactory.getLogger(GenQueryProcessor.class);

    public GenQueryProcessor(AbstractIRODSMidLevelProtocol irodsCommands) {
        if (irodsCommands == null) {
            throw new IllegalArgumentException("null irodsCommands");
        }
        this.irodsCommands = irodsCommands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRODSQueryResultSet executeTranslatedIRODSQuery(TranslatedIRODSGenQuery translatedIRODSQuery, int continueIndex, int partialStartIndex, IRODSGenQueryExecutorImpl.QueryCloseBehavior queryCloseBehavior, String zoneName) throws JargonException {
        IRODSQueryResultSet iRODSQueryResultSet;
        block9: {
            if (continueIndex < 0) {
                throw new JargonException("continue index must be >= 0");
            }
            if (partialStartIndex < 0) {
                throw new JargonException("partial start index cannot be less than zero");
            }
            GenQueryInp genQueryInp = partialStartIndex == 0 ? GenQueryInp.instance(translatedIRODSQuery, continueIndex, zoneName) : GenQueryInp.instanceWithPartialStart(translatedIRODSQuery, partialStartIndex, zoneName);
            Tag response = null;
            List<IRODSQueryResultRow> result = null;
            IRODSQueryResultSet resultSet = null;
            try {
                response = this.sendGenQueryAndReturnResponse(genQueryInp);
                int continuation = QueryResultProcessingUtils.getContinuationValue(response);
                log.info("continuation value: {}", (Object)continuation);
                ArrayList<String> columnNames = new ArrayList<String>();
                for (GenQuerySelectField selectField : translatedIRODSQuery.getSelectFields()) {
                    columnNames.add(selectField.getSelectFieldColumnName());
                }
                int totalRecords = response.getTag("totalRowCount").getIntValue();
                log.info("total records:{}", (Object)totalRecords);
                result = QueryResultProcessingUtils.translateResponseIntoResultSet(response, columnNames, continuation, partialStartIndex);
                resultSet = IRODSQueryResultSet.instance(translatedIRODSQuery, result, continuation, totalRecords);
                if (resultSet.isHasMoreRecords() && queryCloseBehavior == IRODSGenQueryExecutorImpl.QueryCloseBehavior.AUTO_CLOSE) {
                    log.info("auto closing result set");
                    this.closeResults(resultSet);
                }
                iRODSQueryResultSet = resultSet;
                if (resultSet == null || queryCloseBehavior != IRODSGenQueryExecutorImpl.QueryCloseBehavior.AUTO_CLOSE) break block9;
            }
            catch (DataNotFoundException dnf) {
                IRODSQueryResultSet iRODSQueryResultSet2;
                block10: {
                    try {
                        log.info("response from IRODS call indicates no rows found");
                        result = new ArrayList<IRODSQueryResultRow>();
                        iRODSQueryResultSet2 = resultSet = IRODSQueryResultSet.instance(translatedIRODSQuery, result, 0, 0);
                        if (resultSet == null || queryCloseBehavior != IRODSGenQueryExecutorImpl.QueryCloseBehavior.AUTO_CLOSE) break block10;
                    }
                    catch (Throwable throwable) {
                        if (resultSet != null && queryCloseBehavior == IRODSGenQueryExecutorImpl.QueryCloseBehavior.AUTO_CLOSE) {
                            log.info("auto closing result set");
                            this.closeResults(resultSet);
                        }
                        throw throwable;
                    }
                    log.info("auto closing result set");
                    this.closeResults(resultSet);
                }
                return iRODSQueryResultSet2;
            }
            log.info("auto closing result set");
            this.closeResults(resultSet);
        }
        return iRODSQueryResultSet;
    }

    public Tag sendGenQueryAndReturnResponse(GenQueryInp genQueryInp) throws JargonException, DataNotFoundException {
        Tag response = this.irodsCommands.irodsFunction("RODS_API_REQ", genQueryInp.getParsedTags(), 702);
        return response;
    }

    public void closeResults(IRODSQueryResultSet irodsQueryResultSet) throws JargonException {
        log.info("getting more results for query");
        if (irodsQueryResultSet == null) {
            throw new JargonException("null irodsQueryResultSet");
        }
        if (!irodsQueryResultSet.isHasMoreRecords()) {
            log.info("no results to close, ignore");
            return;
        }
        GenQueryInp genQueryInp = GenQueryInp.instanceForCloseQuery(irodsQueryResultSet.getTranslatedIRODSQuery(), irodsQueryResultSet.getContinuationIndex());
        this.sendGenQueryAndReturnResponse(genQueryInp);
    }

    public TranslatedIRODSGenQuery translateProvidedQuery(AbstractIRODSGenQuery irodsQuery) throws JargonException, JargonQueryException {
        TranslatedIRODSGenQuery translatedIRODSQuery = null;
        if (irodsQuery instanceof IRODSGenQuery) {
            IRODSGenQueryTranslator irodsQueryTranslator = new IRODSGenQueryTranslator(this.irodsCommands.getIRODSServerProperties());
            translatedIRODSQuery = irodsQueryTranslator.getTranslatedQuery((IRODSGenQuery)irodsQuery);
        } else if (irodsQuery instanceof IRODSGenQueryFromBuilder) {
            try {
                translatedIRODSQuery = ((IRODSGenQueryFromBuilder)irodsQuery).convertToTranslatedIRODSGenQuery();
            }
            catch (GenQueryBuilderException e) {
                throw new JargonException("invalid builder query", e);
            }
        } else {
            throw new JargonException("unknown type of irodsGenQuery");
        }
        return translatedIRODSQuery;
    }
}

