/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.io.InputStream;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.RemoteExecutionOfCommandsAO;
import org.irods.jargon.core.remoteexecute.RemoteExecuteServiceImpl;
import org.irods.jargon.core.remoteexecute.RemoteExecutionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteExecutionOfCommandsAOImpl
extends IRODSGenericAO
implements RemoteExecutionOfCommandsAO {
    private static final Logger log = LoggerFactory.getLogger(RemoteExecutionOfCommandsAOImpl.class);

    protected RemoteExecutionOfCommandsAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
    }

    @Override
    public InputStream executeARemoteCommandAndGetStreamGivingCommandNameAndArgs(String commandToExecuteWithoutArguments, String argumentsToPassWithCommand) throws JargonException {
        log.info("executing remote command");
        RemoteExecutionService remoteExecuteService = RemoteExecuteServiceImpl.instance(this.getIRODSProtocol(), commandToExecuteWithoutArguments, argumentsToPassWithCommand, "");
        if (this.isAbleToStreamLargeResults()) {
            return remoteExecuteService.executeAndStream();
        }
        return remoteExecuteService.execute();
    }

    @Override
    public InputStream executeARemoteCommandAndGetStreamGivingCommandNameAndArgsAndHost(String commandToExecuteWithoutArguments, String argumentsToPassWithCommand, String executionHost) throws JargonException {
        log.info("executing remote command");
        RemoteExecutionService remoteExecuteService = RemoteExecuteServiceImpl.instance(this.getIRODSProtocol(), commandToExecuteWithoutArguments, argumentsToPassWithCommand, executionHost);
        if (this.isAbleToStreamLargeResults()) {
            return remoteExecuteService.executeAndStream();
        }
        return remoteExecuteService.execute();
    }

    @Override
    public InputStream executeARemoteCommandAndGetStreamAddingPhysicalPathAsFirstArgumentToRemoteScript(String commandToExecuteWithoutArguments, String argumentsToPassWithCommand, String absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn) throws JargonException {
        log.info("executing remote command");
        RemoteExecutionService remoteExecuteService = RemoteExecuteServiceImpl.instanceWhenUsingAbsPathToSetCommandArg(this.getIRODSProtocol(), commandToExecuteWithoutArguments, argumentsToPassWithCommand, "", absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn);
        if (this.isAbleToStreamLargeResults()) {
            return remoteExecuteService.executeAndStream();
        }
        return remoteExecuteService.execute();
    }

    @Override
    public InputStream executeARemoteCommandAndGetStreamUsingAnIRODSFileAbsPathToDetermineHost(String commandToExecuteWithoutArguments, String argumentsToPassWithCommand, String absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn) throws JargonException {
        log.info("executing remote command");
        RemoteExecutionService remoteExecuteService = RemoteExecuteServiceImpl.instanceWhenUsingAbsPathToFindExecutionHost(this.getIRODSProtocol(), commandToExecuteWithoutArguments, argumentsToPassWithCommand, "", absolutePathOfIrodsFileThatWillBeUsedToFindHostToExecuteOn);
        if (this.isAbleToStreamLargeResults()) {
            return remoteExecuteService.executeAndStream();
        }
        return remoteExecuteService.execute();
    }

    protected boolean isAbleToStreamLargeResults() throws JargonException {
        return this.getIRODSServerProperties().isTheIrodsServerAtLeastAtTheGivenReleaseVersion("rods2.4.1");
    }
}

