/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.io.File;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.CollectionNotEmptyException;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.DuplicateDataException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.CollInp;
import org.irods.jargon.core.packinstr.DataObjInpForReg;
import org.irods.jargon.core.packinstr.DataObjInpForUnregister;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.protovalues.ChecksumEncodingEnum;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.IRODSRegistrationOfFilesAO;
import org.irods.jargon.core.utils.LocalFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRODSRegistrationOfFilesAOImpl
extends IRODSGenericAO
implements IRODSRegistrationOfFilesAO {
    static Logger log = LoggerFactory.getLogger(IRODSRegistrationOfFilesAOImpl.class);

    protected IRODSRegistrationOfFilesAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
    }

    @Override
    public void registerPhysicalCollectionRecursivelyToIRODS(String physicalPath, String irodsAbsolutePath, boolean force, String destinationResource, String resourceGroup) throws DataNotFoundException, DuplicateDataException, JargonException {
        log.info("registerPhysicalCollectionRecursivelyToIRODS()");
        if (physicalPath == null || physicalPath.isEmpty()) {
            throw new IllegalArgumentException("null or empty physical path");
        }
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        if (destinationResource == null || destinationResource.isEmpty()) {
            throw new IllegalArgumentException("null or empty destination resource");
        }
        if (resourceGroup == null) {
            throw new IllegalArgumentException("null resourceGroup, set to blank if not used");
        }
        log.info("physicalPath:{}", (Object)physicalPath);
        log.info("irodsAbsolutePath:{}", (Object)irodsAbsolutePath);
        log.info("force:{}", (Object)force);
        log.info("destinationResource:{}", (Object)destinationResource);
        log.info("resourceGroup:{}", (Object)resourceGroup);
        File localFile = new File(physicalPath);
        if (!localFile.exists()) {
            log.error("cannot find local file");
            throw new DataNotFoundException("file to register does not exist");
        }
        if (localFile.isFile()) {
            throw new JargonException("given file is a file, not a collection");
        }
        DataObjInpForReg.ChecksumHandling checksumHandling = DataObjInpForReg.ChecksumHandling.NONE;
        DataObjInpForReg dataObjInp = DataObjInpForReg.instance(physicalPath, irodsAbsolutePath, resourceGroup, destinationResource, force, true, checksumHandling, false, "");
        this.getIRODSProtocol().irodsFunction(dataObjInp);
    }

    @Override
    public void registerPhysicalDataFileToIRODS(String physicalPath, String irodsAbsolutePath, String destinationResource, String resourceGroup, boolean generateChecksumInIRODS) throws DataNotFoundException, DuplicateDataException, JargonException {
        log.info("registerPhysicalDataToFileInIRODS()");
        if (physicalPath == null || physicalPath.isEmpty()) {
            throw new IllegalArgumentException("null or empty physical path");
        }
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        if (destinationResource == null || destinationResource.isEmpty()) {
            throw new IllegalArgumentException("null or empty destination resource");
        }
        if (resourceGroup == null) {
            throw new IllegalArgumentException("null resourceGroup, set to blank if not used");
        }
        log.info("physicalPath:{}", (Object)physicalPath);
        log.info("irodsAbsolutePath:{}", (Object)irodsAbsolutePath);
        log.info("destinationResource:{}", (Object)destinationResource);
        log.info("resourceGroup:{}", (Object)resourceGroup);
        log.info("generateChecksumInIrods:{}", (Object)generateChecksumInIRODS);
        File localFile = new File(physicalPath);
        if (!localFile.exists()) {
            log.error("cannot find local file");
            throw new DataNotFoundException("file to register does not exist");
        }
        if (!localFile.isFile()) {
            throw new JargonException("given file is a collection, not a data object");
        }
        DataObjInpForReg.ChecksumHandling checksumHandling = generateChecksumInIRODS ? DataObjInpForReg.ChecksumHandling.REGISTER_CHECKSUM : DataObjInpForReg.ChecksumHandling.NONE;
        DataObjInpForReg dataObjInp = DataObjInpForReg.instance(physicalPath, irodsAbsolutePath, resourceGroup, destinationResource, false, false, checksumHandling, false, "");
        this.getIRODSProtocol().irodsFunction(dataObjInp);
    }

    @Override
    public String registerPhysicalDataFileToIRODSWithVerifyLocalChecksum(String physicalPath, String irodsAbsolutePath, String destinationResource, String resourceGroup) throws DataNotFoundException, DuplicateDataException, JargonException {
        log.info("registerPhysicalDataFileToIRODSWithVerifyLocalChecksum()");
        if (physicalPath == null || physicalPath.isEmpty()) {
            throw new IllegalArgumentException("null or empty physical path");
        }
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        if (destinationResource == null || destinationResource.isEmpty()) {
            throw new IllegalArgumentException("null or empty destination resource");
        }
        if (resourceGroup == null) {
            throw new IllegalArgumentException("null resourceGroup, set to blank if not used");
        }
        log.info("physicalPath:{}", (Object)physicalPath);
        log.info("irodsAbsolutePath:{}", (Object)irodsAbsolutePath);
        log.info("destinationResource:{}", (Object)destinationResource);
        log.info("resourceGroup:{}", (Object)resourceGroup);
        File localFile = new File(physicalPath);
        if (!localFile.exists()) {
            log.error("cannot find local file");
            throw new DataNotFoundException("file to register does not exist");
        }
        if (!localFile.isFile()) {
            throw new JargonException("given file is a collection, not a data object");
        }
        log.info("calculating local checksum..");
        DataObjInpForReg.ChecksumHandling checksumHandling = DataObjInpForReg.ChecksumHandling.VERFIY_CHECKSUM;
        String localChecksum = LocalFileUtils.digestByteArrayToString(LocalFileUtils.computeMD5FileCheckSumViaAbsolutePath(physicalPath));
        log.info("local file checksum:{}", (Object)localChecksum);
        DataObjInpForReg dataObjInp = DataObjInpForReg.instance(physicalPath, irodsAbsolutePath, resourceGroup, destinationResource, false, false, checksumHandling, false, localChecksum);
        this.getIRODSProtocol().irodsFunction(dataObjInp);
        return localChecksum;
    }

    public String registerPhysicalDataFileToIRODSWithVerifyLocalChecksum(String physicalPath, String irodsAbsolutePath, String destinationResource, String resourceGroup, ChecksumEncodingEnum checksumEncoding) throws DataNotFoundException, DuplicateDataException, JargonException {
        String localFileChecksum;
        log.info("registerPhysicalDataFileToIRODSWithVerifyLocalChecksum()");
        if (physicalPath == null || physicalPath.isEmpty()) {
            throw new IllegalArgumentException("null or empty physical path");
        }
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        if (destinationResource == null || destinationResource.isEmpty()) {
            throw new IllegalArgumentException("null or empty destination resource");
        }
        if (resourceGroup == null) {
            throw new IllegalArgumentException("null resourceGroup, set to blank if not used");
        }
        if (checksumEncoding == null) {
            throw new IllegalArgumentException("null checksum encoding");
        }
        log.info("physicalPath:{}", (Object)physicalPath);
        log.info("irodsAbsolutePath:{}", (Object)irodsAbsolutePath);
        log.info("destinationResource:{}", (Object)destinationResource);
        log.info("resourceGroup:{}", (Object)resourceGroup);
        log.info("checksumEncoding:{}", (Object)checksumEncoding);
        File localFile = new File(physicalPath);
        if (!localFile.exists()) {
            log.error("cannot find local file");
            throw new DataNotFoundException("file to register does not exist");
        }
        if (!localFile.isFile()) {
            throw new JargonException("given file is a collection, not a data object");
        }
        log.info("calculating local checksum..");
        DataObjInpForReg.ChecksumHandling checksumHandling = DataObjInpForReg.ChecksumHandling.VERFIY_CHECKSUM;
        if (checksumEncoding == ChecksumEncodingEnum.MD5 || checksumEncoding == ChecksumEncodingEnum.DEFAULT) {
            localFileChecksum = LocalFileUtils.digestByteArrayToString(LocalFileUtils.computeMD5FileCheckSumViaAbsolutePath(physicalPath));
        } else if (checksumEncoding == ChecksumEncodingEnum.SHA256) {
            localFileChecksum = LocalFileUtils.digestByteArrayToString(LocalFileUtils.computeSHA256FileCheckSumViaAbsolutePath(physicalPath));
        } else {
            throw new JargonException("unsupported checksum type");
        }
        log.info("local file checksum:{}", (Object)localFileChecksum);
        DataObjInpForReg dataObjInp = DataObjInpForReg.instance(physicalPath, irodsAbsolutePath, resourceGroup, destinationResource, false, false, checksumHandling, false, localFileChecksum);
        this.getIRODSProtocol().irodsFunction(dataObjInp);
        return localFileChecksum;
    }

    @Override
    public boolean unregisterDataObject(String irodsAbsolutePath) throws JargonException {
        log.info("unregisterButDoNotDeletePhysicalFile()");
        boolean success = true;
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath");
        }
        log.info("irodsAbsolutePath:{}", (Object)irodsAbsolutePath);
        DataObjInpForUnregister dataObjInp = DataObjInpForUnregister.instanceForDelete(irodsAbsolutePath, false);
        try {
            Tag response = this.getIRODSProtocol().irodsFunction(dataObjInp);
            if (response != null) {
                log.warn("unexpected response from irods, expected null message - logged and ignored ");
            }
        }
        catch (DuplicateDataException dde) {
            log.warn("duplicate data exception logged and ignored, see GForge: [#639] 809000 errors on delete operations when trash file already exists");
        }
        catch (DataNotFoundException dnf) {
            success = false;
        }
        return success;
    }

    @Override
    public boolean unregisterCollection(String irodsAbsolutePath, boolean recursive) throws CollectionNotEmptyException, JargonException {
        log.info("unregisterCollection()");
        boolean success = true;
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePath");
        }
        log.info("irodsAbsolutePath:{}", (Object)irodsAbsolutePath);
        CollInp collInp = CollInp.instanceForUnregisterCollection(irodsAbsolutePath, false, recursive);
        try {
            Tag response = this.getIRODSProtocol().irodsFunction("RODS_API_REQ", collInp.getParsedTags(), 679);
            if (response != null) {
                log.warn("unexpected response from irods, expected null message - logged and ignored ");
            }
            log.debug("process any client status messages");
            this.getIRODSProtocol().processClientStatusMessages(response);
        }
        catch (DuplicateDataException dde) {
            log.warn("duplicate data exception logged and ignored, see GForge: [#639] 809000 errors on delete operations when trash file already exists");
        }
        catch (DataNotFoundException dnf) {
            success = false;
        }
        return success;
    }

    @Override
    public void registerPhysicalDataFileToIRODSAsAReplica(String physicalPath, String irodsAbsolutePath, String destinationResource, String resourceGroup, boolean generateChecksumInIRODS) throws DataNotFoundException, DuplicateDataException, JargonException {
        log.info("registerPhysicalDataFileToIRODSAsAReplica()");
        if (physicalPath == null || physicalPath.isEmpty()) {
            throw new IllegalArgumentException("null or empty physical path");
        }
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        if (destinationResource == null || destinationResource.isEmpty()) {
            throw new IllegalArgumentException("null or empty destination resource");
        }
        if (resourceGroup == null) {
            throw new IllegalArgumentException("null resourceGroup, set to blank if not used");
        }
        log.info("physicalPath:{}", (Object)physicalPath);
        log.info("irodsAbsolutePath:{}", (Object)irodsAbsolutePath);
        log.info("destinationResource:{}", (Object)destinationResource);
        log.info("resourceGroup:{}", (Object)resourceGroup);
        log.info("generateChecksumInIrods:{}", (Object)generateChecksumInIRODS);
        File localFile = new File(physicalPath);
        if (!localFile.exists()) {
            log.error("cannot find local file");
            throw new DataNotFoundException("file to register does not exist");
        }
        if (!localFile.isFile()) {
            throw new JargonException("given file is a collection, not a data object");
        }
        DataObjInpForReg.ChecksumHandling checksumHandling = generateChecksumInIRODS ? DataObjInpForReg.ChecksumHandling.REGISTER_CHECKSUM : DataObjInpForReg.ChecksumHandling.NONE;
        DataObjInpForReg dataObjInp = DataObjInpForReg.instance(physicalPath, irodsAbsolutePath, resourceGroup, destinationResource, false, false, checksumHandling, true, "");
        this.getIRODSProtocol().irodsFunction(dataObjInp);
    }
}

