/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.IRODSGenQueryExecutor;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.query.AbstractIRODSGenQuery;
import org.irods.jargon.core.query.GenQueryProcessor;
import org.irods.jargon.core.query.IRODSQueryResultSet;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.TranslatedIRODSGenQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IRODSGenQueryExecutorImpl
extends IRODSGenericAO
implements IRODSGenQueryExecutor {
    private static final Logger log = LoggerFactory.getLogger(IRODSGenQueryExecutorImpl.class);

    public IRODSGenQueryExecutorImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
    }

    @Override
    public IRODSQueryResultSet executeIRODSQuery(AbstractIRODSGenQuery irodsQuery, int continueIndex) throws JargonException, JargonQueryException {
        log.info("executeIRODSQuery()");
        return this.executeIRODSQueryInZone(irodsQuery, continueIndex, null);
    }

    @Override
    public IRODSQueryResultSet executeIRODSQueryInZone(AbstractIRODSGenQuery irodsQuery, int continueIndex, String zoneName) throws JargonException, JargonQueryException {
        log.info("executeIRODSQueryInZone()");
        if (irodsQuery == null) {
            throw new IllegalArgumentException("null irodsQuery");
        }
        if (continueIndex < 0) {
            throw new IllegalArgumentException("continue index must be > 0");
        }
        log.info("query: {}", (Object)irodsQuery);
        GenQueryProcessor genQueryProcessor = new GenQueryProcessor(this.getIRODSProtocol());
        TranslatedIRODSGenQuery translatedIRODSQuery = genQueryProcessor.translateProvidedQuery(irodsQuery);
        return genQueryProcessor.executeTranslatedIRODSQuery(translatedIRODSQuery, continueIndex, 0, QueryCloseBehavior.MANUAL_CLOSE, zoneName);
    }

    @Override
    public IRODSQueryResultSet executeIRODSQueryAndCloseResult(AbstractIRODSGenQuery irodsQuery, int partialStartIndex) throws JargonException, JargonQueryException {
        log.info("executeIRODSQueryAndCloseResult()");
        return this.executeIRODSQueryAndCloseResultInZone(irodsQuery, partialStartIndex, null);
    }

    @Override
    public IRODSQueryResultSet executeIRODSQueryAndCloseResultInZone(AbstractIRODSGenQuery irodsQuery, int partialStartIndex, String zoneName) throws JargonException, JargonQueryException {
        log.info("executeIRODSQueryAndCloseResultInZone()");
        if (irodsQuery == null) {
            throw new IllegalArgumentException("null irodsQuery");
        }
        if (partialStartIndex < 0) {
            throw new IllegalArgumentException("continueIndex is < 0");
        }
        log.info("query: {}", (Object)irodsQuery);
        GenQueryProcessor genQueryProcessor = new GenQueryProcessor(this.getIRODSProtocol());
        TranslatedIRODSGenQuery translatedIRODSQuery = genQueryProcessor.translateProvidedQuery(irodsQuery);
        return genQueryProcessor.executeTranslatedIRODSQuery(translatedIRODSQuery, 0, partialStartIndex, QueryCloseBehavior.AUTO_CLOSE, zoneName);
    }

    @Override
    public IRODSQueryResultSet executeIRODSQueryWithPaging(AbstractIRODSGenQuery irodsQuery, int partialStartIndex) throws JargonException, JargonQueryException {
        log.info("executeIRODSQueryWithPaging()");
        return this.executeIRODSQueryWithPagingInZone(irodsQuery, partialStartIndex, null);
    }

    @Override
    public IRODSQueryResultSet executeIRODSQueryWithPagingInZone(AbstractIRODSGenQuery irodsQuery, int partialStartIndex, String zoneName) throws JargonException, JargonQueryException {
        log.info("executeIRODSQueryWithPagingInZone()");
        if (irodsQuery == null) {
            throw new IllegalArgumentException("null irodsQuery");
        }
        log.info("query: {}", (Object)irodsQuery);
        GenQueryProcessor genQueryProcessor = new GenQueryProcessor(this.getIRODSProtocol());
        TranslatedIRODSGenQuery translatedIRODSQuery = genQueryProcessor.translateProvidedQuery(irodsQuery);
        return genQueryProcessor.executeTranslatedIRODSQuery(translatedIRODSQuery, 0, partialStartIndex, QueryCloseBehavior.AUTO_CLOSE, zoneName);
    }

    @Override
    public IRODSQueryResultSet getMoreResults(IRODSQueryResultSet irodsQueryResultSet) throws JargonException, JargonQueryException {
        log.info("getting more results for query");
        if (irodsQueryResultSet == null) {
            throw new JargonException("null irodsQueryResultSet");
        }
        if (!irodsQueryResultSet.isHasMoreRecords()) {
            throw new JargonQueryException("no more results");
        }
        GenQueryProcessor genQueryProcessor = new GenQueryProcessor(this.getIRODSProtocol());
        return genQueryProcessor.executeTranslatedIRODSQuery(irodsQueryResultSet.getTranslatedIRODSQuery(), irodsQueryResultSet.getContinuationIndex(), 0, QueryCloseBehavior.MANUAL_CLOSE, null);
    }

    @Override
    public IRODSQueryResultSet getMoreResultsInZone(IRODSQueryResultSet irodsQueryResultSet, String zoneName) throws JargonException, JargonQueryException {
        log.info("getting more results for query");
        if (irodsQueryResultSet == null) {
            throw new JargonException("null irodsQueryResultSet");
        }
        if (!irodsQueryResultSet.isHasMoreRecords()) {
            throw new JargonQueryException("no more results");
        }
        GenQueryProcessor genQueryProcessor = new GenQueryProcessor(this.getIRODSProtocol());
        return genQueryProcessor.executeTranslatedIRODSQuery(irodsQueryResultSet.getTranslatedIRODSQuery(), irodsQueryResultSet.getContinuationIndex(), 0, QueryCloseBehavior.MANUAL_CLOSE, zoneName);
    }

    @Override
    public void closeResults(IRODSQueryResultSet irodsQueryResultSet) throws JargonException {
        log.info("closeResults()");
        GenQueryProcessor genQueryProcessor = new GenQueryProcessor(this.getIRODSProtocol());
        genQueryProcessor.closeResults(irodsQueryResultSet);
    }

    public static enum QueryCloseBehavior {
        AUTO_CLOSE,
        MANUAL_CLOSE;

    }
}

