/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.util.List;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.exception.FileNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.DataObjInp;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.pub.CollectionAndDataObjectListAndSearchAO;
import org.irods.jargon.core.pub.DataObjectAO;
import org.irods.jargon.core.pub.FileCatalogObjectAO;
import org.irods.jargon.core.pub.IRODSGenericAO;
import org.irods.jargon.core.pub.domain.ObjStat;
import org.irods.jargon.core.pub.domain.Resource;
import org.irods.jargon.core.pub.domain.UserFilePermission;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.utils.MiscIRODSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileCatalogObjectAOImpl
extends IRODSGenericAO
implements FileCatalogObjectAO {
    protected final transient CollectionAndDataObjectListAndSearchAO collectionAndDataObjectListAndSearchAO;
    public static final Logger log = LoggerFactory.getLogger(FileCatalogObjectAOImpl.class);
    public static final String STR_PI = "STR_PI";
    public static final String MY_STR = "myStr";
    public static final String USE_THIS_ADDRESS = "thisAddress";

    protected FileCatalogObjectAOImpl(IRODSSession irodsSession, IRODSAccount irodsAccount) throws JargonException {
        super(irodsSession, irodsAccount);
        this.collectionAndDataObjectListAndSearchAO = this.getIRODSAccessObjectFactory().getCollectionAndDataObjectListAndSearchAO(irodsAccount);
    }

    @Override
    public String getHostForGetOperation(String sourceAbsolutePath, String resourceName) throws JargonException {
        IRODSFile fileToGet;
        if (sourceAbsolutePath == null || sourceAbsolutePath.length() == 0) {
            throw new IllegalArgumentException("Null or empty sourceAbsolutePath");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("null resourceName");
        }
        log.info("getHostForGetOperation with sourceAbsolutePath: {}", (Object)sourceAbsolutePath);
        log.info("resourceName:{}", (Object)resourceName);
        if (resourceName.isEmpty() && (fileToGet = this.getIRODSFileFactory().instanceIRODSFile(sourceAbsolutePath)).isFile()) {
            log.debug("this is a file, look for resource it is stored on to retrieve host");
            DataObjectAO dataObjectAO = this.getIRODSAccessObjectFactory().getDataObjectAO(this.getIRODSAccount());
            List<Resource> resources = dataObjectAO.getResourcesForDataObject(fileToGet.getParent(), fileToGet.getName());
            if (resources.isEmpty()) {
                return null;
            }
            String thisHostName = this.getIRODSAccount().getHost();
            for (Resource resource : resources) {
                if (!resource.getLocation().equals(thisHostName)) continue;
                log.info("file replica is on current host:{}", (Object)thisHostName);
                return null;
            }
            log.info("file is not on this host, so reroute to another host (first found)");
            return resources.get(0).getLocation();
        }
        DataObjInp dataObjInp = DataObjInp.instanceForGetHostForGet(sourceAbsolutePath, resourceName);
        return this.evaluateGetHostResponseAndReturnReroutingHost(dataObjInp);
    }

    @Override
    public String getHostForPutOperation(String targetAbsolutePath, String resourceName) throws JargonException {
        if (targetAbsolutePath == null || targetAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("Null or empty targetAbsolutePath");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("null resourceName");
        }
        log.info("getHostForPutOperation with targetAbsolutePath: {}", (Object)targetAbsolutePath);
        log.info("resourceName:{}", (Object)resourceName);
        DataObjInp dataObjInp = DataObjInp.instanceForGetHostForPut(targetAbsolutePath, resourceName);
        return this.evaluateGetHostResponseAndReturnReroutingHost(dataObjInp);
    }

    private String evaluateGetHostResponseAndReturnReroutingHost(DataObjInp dataObjInp) throws JargonException {
        Tag result = this.getIRODSProtocol().irodsFunction(dataObjInp);
        if (result == null) {
            throw new JargonException("null response from lookup of resource for get operation");
        }
        Tag temp = result.getTag(MY_STR);
        if (temp == null) {
            throw new JargonException("no host name info in response to lookup of resource for get operation");
        }
        String hostResponse = temp.getStringValue();
        log.debug("result of get host lookup:{}", (Object)hostResponse);
        if (hostResponse.equals(USE_THIS_ADDRESS)) {
            log.info("return null indicating no host rerouting");
            hostResponse = null;
        }
        return hostResponse;
    }

    @Override
    public ObjStat getObjectStatForAbsolutePath(String irodsAbsolutePath) throws FileNotFoundException, JargonException {
        CollectionAndDataObjectListAndSearchAO collectionAndDataObjectListAndSearchAO = this.getIRODSAccessObjectFactory().getCollectionAndDataObjectListAndSearchAO(this.getIRODSAccount());
        return collectionAndDataObjectListAndSearchAO.retrieveObjectStatForPath(irodsAbsolutePath);
    }

    protected ObjStat retrieveObjStat(String irodsAbsolutePath) throws FileNotFoundException, JargonException {
        log.info("retrieveObjStat()");
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        log.info("irodsAbsolutePath:{}", (Object)irodsAbsolutePath);
        ObjStat objStat = this.collectionAndDataObjectListAndSearchAO.retrieveObjectStatForPath(irodsAbsolutePath);
        MiscIRODSUtils.evaluateSpecCollSupport(objStat);
        return objStat;
    }

    protected ObjStat retrieveObjStat(String parentPath, String fileName) throws FileNotFoundException, JargonException {
        if (parentPath == null || parentPath.isEmpty()) {
            throw new IllegalArgumentException("null or empty parentPath");
        }
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("null or empty fileName");
        }
        IRODSFile irodsFile = this.getIRODSFileFactory().instanceIRODSFile(parentPath, fileName);
        return this.retrieveObjStat(irodsFile.getAbsolutePath());
    }

    protected String resolveAbsolutePathGivenObjStat(ObjStat objStat) throws JargonException {
        if (objStat == null) {
            throw new IllegalArgumentException("null objStat");
        }
        MiscIRODSUtils.evaluateSpecCollSupport(objStat);
        return MiscIRODSUtils.determineAbsolutePathBasedOnCollTypeInObjectStat(objStat);
    }

    protected String resolveAbsolutePathViaObjStat(String irodsAbsolutePath) throws JargonException {
        log.info("resoveAbsolutePathViaObjStat()");
        ObjStat objStat = this.retrieveObjStat(MiscIRODSUtils.checkPathSizeForMax(irodsAbsolutePath));
        return this.resolveAbsolutePathGivenObjStat(objStat);
    }

    @Override
    public abstract boolean isUserHasAccess(String var1, String var2) throws JargonException;

    protected UserFilePermission scoreAndReturnHighestPermission(UserFilePermission userFilePermission, UserFilePermission groupFilePermission) {
        int userScore = -1;
        int groupScore = -1;
        if (userFilePermission != null) {
            userScore = userFilePermission.getFilePermissionEnum().getPermissionNumericValue();
        }
        if (groupFilePermission != null) {
            groupScore = groupFilePermission.getFilePermissionEnum().getPermissionNumericValue();
        }
        if (userScore >= groupScore && userScore > -1) {
            log.info("user file permission greater, using this:{}", (Object)userFilePermission);
            return userFilePermission;
        }
        if (groupScore > -1) {
            log.info("returning groupFilePermission:{}", (Object)groupFilePermission);
            return groupFilePermission;
        }
        return null;
    }
}

