/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AbstractIRODSPackingInstruction;
import org.irods.jargon.core.packinstr.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataObjRead
extends AbstractIRODSPackingInstruction {
    public static final String PI_TAG = "DataObjRead_PI";
    public static final String CREATE_MODE = "createMode";
    public static final String L1DESCINX = "l1descInx";
    public static final String LEN = "len";
    public static final int READ_FILE_API_NBR = 603;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final int fileDescriptor;
    private final long length;

    public static final DataObjRead instance(int fileDescriptor, long length) throws JargonException {
        return new DataObjRead(fileDescriptor, length);
    }

    private DataObjRead(int fileDescriptor, long length) throws JargonException {
        if (fileDescriptor < 1) {
            throw new JargonException("invalid fileDescriptor:" + fileDescriptor);
        }
        if (length < 1L) {
            throw new JargonException("zero or negative read length");
        }
        this.fileDescriptor = fileDescriptor;
        this.length = length;
        this.setApiNumber(603);
    }

    @Override
    public String getParsedTags() throws JargonException {
        Tag message = this.getTagValue();
        String tagOut = message.parseTag();
        if (this.log.isDebugEnabled()) {
            this.log.debug("tag created:" + tagOut);
        }
        return tagOut;
    }

    @Override
    public Tag getTagValue() throws JargonException {
        Tag message = new Tag("dataObjReadInp_PI", new Tag[]{new Tag(L1DESCINX, this.fileDescriptor), new Tag(LEN, this.length)});
        return message;
    }

    protected int getFileDescriptor() {
        return this.fileDescriptor;
    }

    public long getLength() {
        return this.length;
    }
}

