/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection.auth;

import java.io.File;
import java.io.IOException;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.irods.jargon.core.connection.GSIIRODSAccount;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.utils.LocalFileUtils;

public class GSIUtilities {
    public static GSIIRODSAccount createGSIIRODSAccountFromCredential(File credentialFile, String host, int port, String defaultStorageResource) throws JargonException {
        if (credentialFile == null) {
            throw new IllegalArgumentException("null credentialFile");
        }
        if (!credentialFile.exists()) {
            throw new IllegalArgumentException("credentialFile not found");
        }
        try {
            byte[] certBytes = LocalFileUtils.getBytesFromFile(credentialFile);
            return GSIUtilities.createGSIIRODSAccountFromCredential(host, port, certBytes, defaultStorageResource);
        }
        catch (IOException e) {
            throw new JargonException("io exception reading bytes from credential file", e);
        }
    }

    public static GSIIRODSAccount createGSIIRODSAccountFromCredential(String host, int port, String certificate, String defaultStorageResource) throws JargonException {
        if (certificate == null || certificate.isEmpty()) {
            throw new IllegalArgumentException("null or empty certificate");
        }
        if (!certificate.startsWith("-----BEGIN CERTIFICATE-----")) {
            throw new IllegalArgumentException("unrecognized certificate format, does not start with -----BEGIN CERTIFICATE-----");
        }
        byte[] data = certificate.getBytes();
        return GSIUtilities.createGSIIRODSAccountFromCredential(host, port, data, defaultStorageResource);
    }

    public static GSIIRODSAccount createGSIIRODSAccountFromCredential(String host, int port, byte[] certificate, String defaultStorageResource) throws JargonException {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("null or empty host");
        }
        if (certificate == null || certificate.length == 0) {
            throw new IllegalArgumentException("null or empty certificate");
        }
        ExtendedGSSManager manager = (ExtendedGSSManager)ExtendedGSSManager.getInstance();
        try {
            GSSCredential credential = manager.createCredential(certificate, 0, 0, null, 0);
            GSIIRODSAccount gsiIRODSAccount = GSIIRODSAccount.instance(host, port, credential, defaultStorageResource);
            return gsiIRODSAccount;
        }
        catch (GSSException e) {
            throw new JargonException("GSSException creating credential", e);
        }
    }

    public static String getDN(GSIIRODSAccount account) throws JargonException {
        StringBuffer dn = null;
        int index = -1;
        int index2 = -1;
        dn = new StringBuffer(account.getDistinguishedName());
        index = dn.indexOf("UID");
        if (index >= 0 && (index2 = dn.lastIndexOf("CN")) > index) {
            dn = dn.delete(index2 - 1, dn.length());
        }
        index = dn.indexOf(",");
        while (index >= 0) {
            dn = dn.replace(index, index + 1, "/");
            index = dn.indexOf(",");
        }
        if (dn.indexOf("/") != 0) {
            return "/" + dn;
        }
        return dn.toString();
    }
}

