/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.exceptions;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.output.StringBuilderWriter;

public class AggregateException
extends RuntimeException {
    private final List<Throwable> exceptions;

    public AggregateException(Iterable<Throwable> exceptions) {
        super("One or more exceptions were aggregated together");
        this.exceptions = AggregateException.exceptionList(exceptions);
    }

    private static List<Throwable> exceptionList(Iterable<Throwable> exceptions) {
        ArrayList<Throwable> exceptionList = new ArrayList<Throwable>();
        for (Throwable t : exceptions) {
            exceptionList.add(t);
        }
        return exceptionList;
    }

    public Iterable<Throwable> getExceptions() {
        return this.exceptions;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("One or more exceptions were aggregated:");
        try (StringBuilderWriter writer = new StringBuilderWriter(builder);
             PrintWriter printWriter = new PrintWriter((Writer)writer);){
            for (Throwable t : this.exceptions) {
                printWriter.append("Exception: ").append(t.getMessage());
                t.printStackTrace(printWriter);
            }
        }
        return builder.toString();
    }
}

