/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.binding;

import ch.cyberduck.binding.WindowController;
import ch.cyberduck.binding.application.AlertSheetReturnCodeMapper;
import ch.cyberduck.binding.application.AppKitFunctionsLibrary;
import ch.cyberduck.binding.application.NSApplication;
import ch.cyberduck.binding.application.NSButton;
import ch.cyberduck.binding.application.SheetCallback;
import ch.cyberduck.ui.InputValidator;
import org.apache.log4j.Logger;
import org.rococoa.ID;

public abstract class SheetController
extends WindowController
implements SheetCallback,
InputValidator {
    private static final Logger log = Logger.getLogger(SheetController.class);
    private final NSApplication application = NSApplication.sharedApplication();
    private SheetCallback callback = new SheetCallback(){

        @Override
        public void callback(int returncode) {
            if (-1 == returncode) {
                SheetController.this.window.orderOut(null);
            }
        }
    };
    private InputValidator validator;

    public SheetController() {
        this(new InputValidator(){

            public boolean validate() {
                return true;
            }
        });
    }

    public SheetController(InputValidator callback) {
        this.validator = callback;
    }

    public void setValidator(InputValidator validator) {
        this.validator = validator;
    }

    public void setCallback(SheetCallback callback) {
        this.callback = callback;
    }

    public boolean validate() {
        return this.validator.validate();
    }

    public void closeSheet(NSButton sender) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Close sheet with button %s", sender.title()));
        }
        int option = new AlertSheetReturnCodeMapper().getOption(sender);
        this.closeSheetWithOption(option);
    }

    public void closeSheetWithOption(int option) {
        this.window.endEditingFor(null);
        if (!(option != 1 && option != 0 || this.validate())) {
            AppKitFunctionsLibrary.beep();
            return;
        }
        this.callback.callback(option);
        this.application.endSheet(this.window, option);
    }

    public void cancel(ID sender) {
        this.closeSheetWithOption(-1);
    }
}

