/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.model.cloudfront;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.jets3t.service.model.cloudfront.CacheBehavior;
import org.jets3t.service.model.cloudfront.LoggingStatus;
import org.jets3t.service.model.cloudfront.Origin;
import org.jets3t.service.model.cloudfront.S3Origin;

public class DistributionConfig {
    private Origin[] origins = null;
    private String callerReference = null;
    private String[] cnames = new String[0];
    private String comment = null;
    private boolean enabled = false;
    private String etag = null;
    private LoggingStatus loggingStatus = null;
    private CacheBehavior defaultCacheBehavior = new CacheBehavior();
    private CacheBehavior[] cacheBehaviors = new CacheBehavior[0];
    private String defaultRootObject;

    public DistributionConfig() {
    }

    public DistributionConfig(Origin[] origins, String callerReference, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus, String defaultRootObject, CacheBehavior defaultCacheBehavior, CacheBehavior[] cacheBehaviors) {
        this.origins = origins;
        this.callerReference = callerReference;
        this.cnames = null == cnames ? new String[]{} : cnames;
        this.comment = comment;
        this.enabled = enabled;
        this.loggingStatus = loggingStatus;
        this.defaultRootObject = defaultRootObject;
        this.defaultCacheBehavior = null == defaultCacheBehavior ? new CacheBehavior() : defaultCacheBehavior;
        this.cacheBehaviors = null == cacheBehaviors ? new CacheBehavior[]{} : cacheBehaviors;
    }

    @Deprecated
    public DistributionConfig(Origin origin, String callerReference, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus, boolean trustedSignerSelf, String[] trustedSignerAwsAccountNumbers, String[] requiredProtocols, String defaultRootObject, Long minTTL) {
        Origin[] originArray;
        if (null == origin) {
            originArray = new Origin[]{};
        } else {
            Origin[] originArray2 = new Origin[1];
            originArray = originArray2;
            originArray2[0] = origin;
        }
        this.origins = originArray;
        this.callerReference = callerReference;
        this.cnames = cnames;
        this.comment = comment;
        this.enabled = enabled;
        this.loggingStatus = loggingStatus;
        this.defaultRootObject = defaultRootObject;
        ArrayList<String> myTrustedSignerAwsAccountNumber = new ArrayList<String>();
        if (trustedSignerSelf) {
            myTrustedSignerAwsAccountNumber.add("self");
        }
        if (trustedSignerAwsAccountNumbers != null) {
            Collections.addAll(myTrustedSignerAwsAccountNumber, trustedSignerAwsAccountNumbers);
        }
        this.getDefaultCacheBehavior().setTrustedSignerAwsAccountNumbers(myTrustedSignerAwsAccountNumber.toArray(new String[myTrustedSignerAwsAccountNumber.size()]));
        this.setRequiredProtocols(requiredProtocols);
        this.getDefaultCacheBehavior().setMinTTL(minTTL);
    }

    @Deprecated
    public DistributionConfig(Origin origin, String callerReference, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus) {
        this(origin, callerReference, cnames, comment, enabled, loggingStatus, false, null, null, null, null);
    }

    @Deprecated
    public Origin getOrigin() {
        return this.origins[0];
    }

    public Origin[] getOrigins() {
        return this.origins;
    }

    public void setOrigins(Origin[] value) {
        this.origins = value;
    }

    public String getCallerReference() {
        return this.callerReference;
    }

    public String[] getCNAMEs() {
        return this.cnames;
    }

    public void setCNAMEs(String[] value) {
        this.cnames = value;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String value) {
        this.comment = value;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public String getEtag() {
        return this.etag;
    }

    public void setEtag(String etag) {
        this.etag = etag;
    }

    public LoggingStatus getLoggingStatus() {
        return this.loggingStatus;
    }

    public boolean isLoggingEnabled() {
        return this.loggingStatus.isEnabled();
    }

    public CacheBehavior getDefaultCacheBehavior() {
        return this.defaultCacheBehavior;
    }

    public CacheBehavior[] getCacheBehaviors() {
        return this.cacheBehaviors;
    }

    public boolean hasCacheBehaviors() {
        return this.cacheBehaviors != null && this.cacheBehaviors.length > 0;
    }

    public boolean isStreamingDistributionConfig() {
        return false;
    }

    public String getDefaultRootObject() {
        return this.defaultRootObject;
    }

    @Deprecated
    public boolean isPrivate() {
        return this.getOrigin() instanceof S3Origin && ((S3Origin)this.getOrigin()).getOriginAccessIdentity() != null;
    }

    @Deprecated
    public String[] getTrustedSignerAwsAccountNumbers() {
        return this.getDefaultCacheBehavior().getTrustedSignerAwsAccountNumbers();
    }

    @Deprecated
    public boolean isTrustedSignerSelf() {
        return this.getDefaultCacheBehavior().isTrustedSignerSelf();
    }

    @Deprecated
    public boolean hasTrustedSignerAwsAccountNumbers() {
        return this.getTrustedSignerAwsAccountNumbers() != null && this.getTrustedSignerAwsAccountNumbers().length > 0;
    }

    @Deprecated
    public boolean isUrlSigningRequired() {
        return this.isTrustedSignerSelf() || this.hasTrustedSignerAwsAccountNumbers();
    }

    @Deprecated
    public void setRequiredProtocols(String[] protocols) {
        if (protocols != null && protocols.length > 0) {
            if (protocols.length > 1 || !"https".equals(protocols[0])) {
                throw new IllegalArgumentException("if set, the requiredProtocols argument may contain only a single string value \"https\"");
            }
            this.getDefaultCacheBehavior().setViewerProtocolPolicy(CacheBehavior.ViewerProtocolPolicy.HTTPS_ONLY);
        } else {
            this.getDefaultCacheBehavior().setViewerProtocolPolicy(CacheBehavior.ViewerProtocolPolicy.ALLOW_ALL);
        }
    }

    @Deprecated
    public String[] getRequiredProtocols() {
        if (this.getDefaultCacheBehavior().getViewerProtocolPolicy() == CacheBehavior.ViewerProtocolPolicy.HTTPS_ONLY) {
            return new String[]{"https"};
        }
        return null;
    }

    @Deprecated
    public boolean isHttpsProtocolRequired() {
        return this.getRequiredProtocols() != null && this.getRequiredProtocols().length == 1 && "https".equals(this.getRequiredProtocols()[0]);
    }

    @Deprecated
    public void setHttpsProtocolRequired(boolean value) {
        if (value) {
            this.setRequiredProtocols(new String[]{"https"});
        } else {
            this.setRequiredProtocols(null);
        }
    }

    @Deprecated
    public void setMinTTL(Long minTTL) {
        this.getDefaultCacheBehavior().setMinTTL(minTTL);
    }

    @Deprecated
    public Long getMinTTL() {
        return this.getDefaultCacheBehavior().getMinTTL();
    }

    @Deprecated
    public boolean hasMinTTL() {
        return this.getDefaultCacheBehavior().hasMinTTL();
    }

    public String toString() {
        return (this.isStreamingDistributionConfig() ? "StreamingDistributionConfig: " : "DistributionConfig: ") + "callerReference=" + this.callerReference + ", origins=" + Arrays.asList(this.origins) + ", comment=" + this.comment + ", enabled=" + this.enabled + ", defaultCacheBehavior=" + this.defaultCacheBehavior + (!this.hasCacheBehaviors() ? "" : ", cacheBehaviors=" + Arrays.toString(this.cacheBehaviors)) + (this.etag != null ? ", etag=" + this.etag : "") + (!this.isLoggingEnabled() ? "" : ", LoggingStatus: bucket=" + this.loggingStatus.getBucket() + ", prefix=" + this.loggingStatus.getPrefix()) + ", CNAMEs=" + Arrays.asList(this.cnames) + ", defaultRootObject=" + this.defaultRootObject;
    }
}

