/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.impl.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.CloudFrontServiceException;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.ServiceException;
import org.jets3t.service.impl.rest.SimpleHandler;
import org.jets3t.service.model.cloudfront.CacheBehavior;
import org.jets3t.service.model.cloudfront.CustomOrigin;
import org.jets3t.service.model.cloudfront.Distribution;
import org.jets3t.service.model.cloudfront.DistributionConfig;
import org.jets3t.service.model.cloudfront.Invalidation;
import org.jets3t.service.model.cloudfront.InvalidationList;
import org.jets3t.service.model.cloudfront.InvalidationSummary;
import org.jets3t.service.model.cloudfront.LoggingStatus;
import org.jets3t.service.model.cloudfront.Origin;
import org.jets3t.service.model.cloudfront.OriginAccessIdentity;
import org.jets3t.service.model.cloudfront.OriginAccessIdentityConfig;
import org.jets3t.service.model.cloudfront.S3Origin;
import org.jets3t.service.model.cloudfront.StreamingDistribution;
import org.jets3t.service.model.cloudfront.StreamingDistributionConfig;
import org.jets3t.service.utils.ServiceUtils;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class CloudFrontXmlResponsesSaxParser {
    private static final Log log = LogFactory.getLog(CloudFrontXmlResponsesSaxParser.class);
    private XMLReader xr = null;
    private Jets3tProperties properties = null;

    public CloudFrontXmlResponsesSaxParser(Jets3tProperties properties) throws ServiceException {
        this.properties = properties;
        this.xr = ServiceUtils.loadXMLReader();
    }

    public Jets3tProperties getProperties() {
        return this.properties;
    }

    protected void parseXmlInputStream(DefaultHandler handler, InputStream inputStream) throws CloudFrontServiceException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsing XML response document with handler: " + handler.getClass()));
            }
            BufferedReader breader = new BufferedReader(new InputStreamReader(inputStream, Constants.DEFAULT_ENCODING));
            this.xr.setContentHandler(handler);
            this.xr.setErrorHandler(handler);
            this.xr.parse(new InputSource(breader));
        }
        catch (Exception t) {
            block5: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error((Object)"Unable to close response InputStream up after XML parse failure", (Throwable)e);
                }
            }
            throw new CloudFrontServiceException("Failed to parse XML document with handler " + handler.getClass(), t);
        }
    }

    public DistributionListHandler parseDistributionListResponse(InputStream inputStream) throws CloudFrontServiceException {
        DistributionListHandler handler = new DistributionListHandler(this.xr);
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public DistributionHandler parseDistributionResponse(InputStream inputStream) throws CloudFrontServiceException {
        DistributionHandler handler = new DistributionHandler(this.xr);
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public DistributionConfigHandler parseDistributionConfigResponse(InputStream inputStream) throws CloudFrontServiceException {
        DistributionConfigHandler handler = new DistributionConfigHandler(this.xr);
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public OriginAccessIdentityHandler parseOriginAccessIdentity(InputStream inputStream) throws CloudFrontServiceException {
        OriginAccessIdentityHandler handler = new OriginAccessIdentityHandler(this.xr);
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public OriginAccessIdentityConfigHandler parseOriginAccessIdentityConfig(InputStream inputStream) throws CloudFrontServiceException {
        OriginAccessIdentityConfigHandler handler = new OriginAccessIdentityConfigHandler(this.xr);
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public OriginAccessIdentityListHandler parseOriginAccessIdentityListResponse(InputStream inputStream) throws CloudFrontServiceException {
        OriginAccessIdentityListHandler handler = new OriginAccessIdentityListHandler(this.xr);
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public InvalidationHandler parseInvalidationResponse(InputStream inputStream) throws CloudFrontServiceException {
        InvalidationHandler handler = new InvalidationHandler(this.xr);
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public InvalidationListHandler parseInvalidationListResponse(InputStream inputStream) throws CloudFrontServiceException {
        InvalidationListHandler handler = new InvalidationListHandler(this.xr);
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public ErrorHandler parseErrorResponse(InputStream inputStream) throws CloudFrontServiceException {
        ErrorHandler handler = new ErrorHandler(this.xr);
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public class DistributionListHandler
    extends SimpleHandler {
        private final List<Distribution> distributions;
        private String marker;
        private String nextMarker;
        private int maxItems;
        private boolean isTruncated;

        public DistributionListHandler(XMLReader xr) {
            super(xr);
            this.distributions = new ArrayList<Distribution>();
            this.marker = null;
            this.nextMarker = null;
            this.maxItems = 100;
            this.isTruncated = false;
        }

        public List<Distribution> getDistributions() {
            return this.distributions;
        }

        public boolean isTruncated() {
            return this.isTruncated;
        }

        public String getMarker() {
            return this.marker;
        }

        public String getNextMarker() {
            return this.nextMarker;
        }

        public int getMaxItems() {
            return this.maxItems;
        }

        public void startDistributionSummary() {
            this.transferControlToHandler(new DistributionSummaryHandler(CloudFrontXmlResponsesSaxParser.this.xr));
        }

        public void startStreamingDistributionSummary() {
            this.transferControlToHandler(new DistributionSummaryHandler(CloudFrontXmlResponsesSaxParser.this.xr));
        }

        @Override
        public void controlReturned(SimpleHandler childHandler) {
            this.distributions.add(((DistributionSummaryHandler)childHandler).getDistribution());
        }

        public void endMarker(String text) {
            this.marker = text;
        }

        public void endNextMarker(String text) {
            this.nextMarker = text;
        }

        public void endMaxItems(String text) {
            this.maxItems = Integer.parseInt(text);
        }

        public void endIsTruncated(String text) {
            this.isTruncated = String.valueOf(true).equalsIgnoreCase(text);
        }
    }

    public class DistributionHandler
    extends SimpleHandler {
        private Distribution distribution;
        private String id;
        private String status;
        private Date lastModifiedTime;
        private String domainName;
        private final Map<String, List<String>> activeTrustedSigners;
        private boolean inSignerElement;
        private String lastSignerIdentifier;

        public DistributionHandler(XMLReader xr) {
            super(xr);
            this.distribution = null;
            this.id = null;
            this.status = null;
            this.lastModifiedTime = null;
            this.domainName = null;
            this.activeTrustedSigners = new HashMap<String, List<String>>();
            this.lastSignerIdentifier = null;
        }

        public Distribution getDistribution() {
            return this.distribution;
        }

        public void endId(String text) {
            this.id = text;
        }

        public void endStatus(String text) {
            this.status = text;
        }

        public void endLastModifiedTime(String text) throws ParseException {
            this.lastModifiedTime = ServiceUtils.parseIso8601Date(text);
        }

        public void endDomainName(String text) {
            this.domainName = text;
        }

        public void startSigner() {
            this.inSignerElement = true;
        }

        public void endSigner(String text) {
            this.inSignerElement = false;
            this.lastSignerIdentifier = null;
        }

        public void endSelf(String text) {
            if (this.inSignerElement) {
                this.lastSignerIdentifier = "Self";
            }
        }

        public void endAwsAccountNumber(String text) {
            if (this.inSignerElement) {
                this.lastSignerIdentifier = text;
            }
        }

        public void endKeyPairId(String text) {
            if (this.inSignerElement) {
                List<String> keypairIdList = this.activeTrustedSigners.get(this.lastSignerIdentifier);
                if (keypairIdList == null) {
                    keypairIdList = new ArrayList<String>();
                    this.activeTrustedSigners.put(this.lastSignerIdentifier, keypairIdList);
                }
                keypairIdList.add(text);
            }
        }

        public void startDistributionConfig() {
            this.transferControlToHandler(new DistributionConfigHandler(CloudFrontXmlResponsesSaxParser.this.xr));
        }

        public void startStreamingDistributionConfig() {
            this.transferControlToHandler(new DistributionConfigHandler(CloudFrontXmlResponsesSaxParser.this.xr));
        }

        @Override
        public void controlReturned(SimpleHandler childHandler) {
            DistributionConfig config = ((DistributionConfigHandler)childHandler).getDistributionConfig();
            this.distribution = config instanceof StreamingDistributionConfig ? new StreamingDistribution(this.id, this.status, this.lastModifiedTime, this.domainName, this.activeTrustedSigners, config) : new Distribution(this.id, this.status, this.lastModifiedTime, 0L, this.domainName, this.activeTrustedSigners, config);
        }

        public void endDistribution(String text) {
            this.returnControlToParentHandler();
        }

        public void endStreamingDistribution(String text) {
            this.returnControlToParentHandler();
        }
    }

    public class DistributionConfigHandler
    extends SimpleHandler {
        private DistributionConfig distributionConfig;
        private String callerReference;
        private List<Origin> origins;
        private final List<String> cnamesList;
        private String comment;
        private boolean enabled;
        private LoggingStatus loggingStatus;
        private String defaultRootObject;
        private CacheBehavior defaultCacheBehavior;
        private List<CacheBehavior> cacheBehaviors;
        List<String> trustedSignerAwsAccountNumberList;
        private boolean inDefaultCacheBehavior;

        public DistributionConfigHandler(XMLReader xr) {
            super(xr);
            this.distributionConfig = null;
            this.callerReference = null;
            this.origins = new ArrayList<Origin>();
            this.cnamesList = new ArrayList<String>();
            this.comment = null;
            this.enabled = false;
            this.loggingStatus = null;
            this.defaultRootObject = null;
            this.cacheBehaviors = new ArrayList<CacheBehavior>();
            this.trustedSignerAwsAccountNumberList = new ArrayList<String>();
            this.inDefaultCacheBehavior = false;
        }

        public DistributionConfig getDistributionConfig() {
            return this.distributionConfig;
        }

        public void endCallerReference(String text) {
            this.callerReference = text;
        }

        public void endCNAME(String text) {
            this.cnamesList.add(text);
        }

        public void endDefaultRootObject(String text) {
            this.defaultRootObject = text;
        }

        public void endComment(String text) {
            this.comment = text;
        }

        public void endEnabled(String text) {
            this.enabled = String.valueOf(true).equalsIgnoreCase(text);
        }

        public void startOrigin() {
            this.transferControlToHandler(new OriginHandler(CloudFrontXmlResponsesSaxParser.this.xr));
        }

        public void startS3Origin() {
            this.transferControlToHandler(new OriginHandler(CloudFrontXmlResponsesSaxParser.this.xr));
        }

        public void startDefaultCacheBehavior() {
            this.inDefaultCacheBehavior = true;
            this.transferControlToHandler(new CacheBehaviorHandler(CloudFrontXmlResponsesSaxParser.this.xr));
        }

        public void startCacheBehavior() {
            this.inDefaultCacheBehavior = false;
            this.transferControlToHandler(new CacheBehaviorHandler(CloudFrontXmlResponsesSaxParser.this.xr));
        }

        public void startLogging() {
            this.transferControlToHandler(new LoggingStatusHandler(CloudFrontXmlResponsesSaxParser.this.xr));
        }

        @Override
        public void controlReturned(SimpleHandler childHandler) {
            if (childHandler instanceof OriginHandler) {
                this.origins.add(((OriginHandler)childHandler).origin);
            } else if (childHandler instanceof CacheBehaviorHandler) {
                if (this.inDefaultCacheBehavior) {
                    this.defaultCacheBehavior = ((CacheBehaviorHandler)childHandler).cacheBehavior;
                } else {
                    this.cacheBehaviors.add(((CacheBehaviorHandler)childHandler).cacheBehavior);
                }
            } else if (childHandler instanceof LoggingStatusHandler) {
                this.loggingStatus = ((LoggingStatusHandler)childHandler).loggingStatus;
            }
        }

        public void endDistributionConfig(String text) {
            this.distributionConfig = new DistributionConfig(this.origins.toArray(new Origin[this.origins.size()]), this.callerReference, this.cnamesList.toArray(new String[this.cnamesList.size()]), this.comment, this.enabled, this.loggingStatus, this.defaultRootObject, this.defaultCacheBehavior, this.cacheBehaviors.toArray(new CacheBehavior[this.cacheBehaviors.size()]));
            this.returnControlToParentHandler();
        }

        public void endStreamingDistributionConfig(String text) {
            this.distributionConfig = new StreamingDistributionConfig(this.origins.toArray(new Origin[this.origins.size()]), this.callerReference, this.cnamesList.toArray(new String[this.cnamesList.size()]), this.comment, this.enabled, this.loggingStatus, this.trustedSignerAwsAccountNumberList.toArray(new String[this.trustedSignerAwsAccountNumberList.size()]));
            this.returnControlToParentHandler();
        }
    }

    public class OriginAccessIdentityHandler
    extends SimpleHandler {
        private String id;
        private String s3CanonicalUserId;
        private String comment;
        private OriginAccessIdentity originAccessIdentity;
        private OriginAccessIdentityConfig originAccessIdentityConfig;

        public OriginAccessIdentityHandler(XMLReader xr) {
            super(xr);
            this.id = null;
            this.s3CanonicalUserId = null;
            this.comment = null;
            this.originAccessIdentity = null;
            this.originAccessIdentityConfig = null;
        }

        public OriginAccessIdentity getOriginAccessIdentity() {
            return this.originAccessIdentity;
        }

        public void endId(String text) {
            this.id = text;
        }

        public void endS3CanonicalUserId(String text) {
            this.s3CanonicalUserId = text;
        }

        public void endComment(String text) {
            this.comment = text;
        }

        public void startCloudFrontOriginAccessIdentityConfig() {
            this.transferControlToHandler(new OriginAccessIdentityConfigHandler(CloudFrontXmlResponsesSaxParser.this.xr));
        }

        @Override
        public void controlReturned(SimpleHandler childHandler) {
            this.originAccessIdentityConfig = ((OriginAccessIdentityConfigHandler)childHandler).getOriginAccessIdentityConfig();
        }

        public void endCloudFrontOriginAccessIdentity(String text) {
            this.originAccessIdentity = new OriginAccessIdentity(this.id, this.s3CanonicalUserId, this.originAccessIdentityConfig);
        }

        public void endCloudFrontOriginAccessIdentitySummary(String text) {
            this.originAccessIdentity = new OriginAccessIdentity(this.id, this.s3CanonicalUserId, this.comment);
            this.returnControlToParentHandler();
        }
    }

    public class OriginAccessIdentityConfigHandler
    extends SimpleHandler {
        private String callerReference;
        private String comment;
        private OriginAccessIdentityConfig config;

        public OriginAccessIdentityConfigHandler(XMLReader xr) {
            super(xr);
            this.callerReference = null;
            this.comment = null;
            this.config = null;
        }

        public OriginAccessIdentityConfig getOriginAccessIdentityConfig() {
            return this.config;
        }

        public void endCallerReference(String text) {
            this.callerReference = text;
        }

        public void endComment(String text) {
            this.comment = text;
        }

        public void endCloudFrontOriginAccessIdentityConfig(String text) {
            this.config = new OriginAccessIdentityConfig(this.callerReference, this.comment);
            this.returnControlToParentHandler();
        }
    }

    public class OriginAccessIdentityListHandler
    extends SimpleHandler {
        private final List<OriginAccessIdentity> originAccessIdentityList;
        private String marker;
        private String nextMarker;
        private int maxItems;
        private boolean isTruncated;

        public OriginAccessIdentityListHandler(XMLReader xr) {
            super(xr);
            this.originAccessIdentityList = new ArrayList<OriginAccessIdentity>();
            this.marker = null;
            this.nextMarker = null;
            this.maxItems = 100;
            this.isTruncated = false;
        }

        public List<OriginAccessIdentity> getOriginAccessIdentityList() {
            return this.originAccessIdentityList;
        }

        public boolean isTruncated() {
            return this.isTruncated;
        }

        public String getMarker() {
            return this.marker;
        }

        public String getNextMarker() {
            return this.nextMarker;
        }

        public int getMaxItems() {
            return this.maxItems;
        }

        public void startCloudFrontOriginAccessIdentitySummary() {
            this.transferControlToHandler(new OriginAccessIdentityHandler(CloudFrontXmlResponsesSaxParser.this.xr));
        }

        @Override
        public void controlReturned(SimpleHandler childHandler) {
            this.originAccessIdentityList.add(((OriginAccessIdentityHandler)childHandler).getOriginAccessIdentity());
        }

        public void endMarker(String text) {
            this.marker = text;
        }

        public void endNextMarker(String text) {
            this.nextMarker = text;
        }

        public void endMaxItems(String text) {
            this.maxItems = Integer.parseInt(text);
        }

        public void endIsTruncated(String text) {
            this.isTruncated = String.valueOf(true).equalsIgnoreCase(text);
        }
    }

    public class InvalidationHandler
    extends SimpleHandler {
        private Invalidation invalidation;

        public InvalidationHandler(XMLReader xr) {
            super(xr);
            this.invalidation = new Invalidation();
        }

        public Invalidation getInvalidation() {
            return this.invalidation;
        }

        public void endId(String text) {
            this.invalidation.setId(text);
        }

        public void endStatus(String text) {
            this.invalidation.setStatus(text);
        }

        public void endCreateTime(String text) throws ParseException {
            this.invalidation.setCreateTime(ServiceUtils.parseIso8601Date(text));
        }

        public void endPath(String text) {
            this.invalidation.getObjectKeys().add(text.substring(1));
        }

        public void endCallerReference(String text) {
            this.invalidation.setCallerReference(text);
        }
    }

    public class InvalidationListHandler
    extends SimpleHandler {
        private String marker;
        private String nextMarker;
        private int maxItems;
        private boolean isTruncated;
        private String invalidationSummaryId;
        private String invalidationSummaryStatus;
        private List<InvalidationSummary> invalidationSummaries;
        private InvalidationList invalidationList;

        public InvalidationListHandler(XMLReader xr) {
            super(xr);
            this.marker = null;
            this.nextMarker = null;
            this.maxItems = 100;
            this.isTruncated = false;
            this.invalidationSummaryId = null;
            this.invalidationSummaryStatus = null;
            this.invalidationSummaries = new ArrayList<InvalidationSummary>();
            this.invalidationList = null;
        }

        public InvalidationList getInvalidationList() {
            return this.invalidationList;
        }

        public boolean isTruncated() {
            return this.isTruncated;
        }

        public String getMarker() {
            return this.marker;
        }

        public String getNextMarker() {
            return this.nextMarker;
        }

        public int getMaxItems() {
            return this.maxItems;
        }

        public void endMarker(String text) {
            this.marker = text;
        }

        public void endNextMarker(String text) {
            this.nextMarker = text;
        }

        public void endMaxItems(String text) {
            this.maxItems = Integer.parseInt(text);
        }

        public void endIsTruncated(String text) {
            this.isTruncated = String.valueOf(true).equalsIgnoreCase(text);
        }

        public void endId(String text) {
            this.invalidationSummaryId = text;
        }

        public void endStatus(String text) {
            this.invalidationSummaryStatus = text;
            this.invalidationSummaries.add(new InvalidationSummary(this.invalidationSummaryId, this.invalidationSummaryStatus));
        }

        public void endInvalidationList(String ignore) {
            this.invalidationList = new InvalidationList(this.marker, this.nextMarker, this.maxItems, this.isTruncated, this.invalidationSummaries);
        }
    }

    public class ErrorHandler
    extends SimpleHandler {
        private String type;
        private String code;
        private String message;
        private String detail;
        private String requestId;

        public ErrorHandler(XMLReader xr) {
            super(xr);
            this.type = null;
            this.code = null;
            this.message = null;
            this.detail = null;
            this.requestId = null;
        }

        public String getCode() {
            return this.code;
        }

        public String getDetail() {
            return this.detail;
        }

        public String getMessage() {
            return this.message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public String getType() {
            return this.type;
        }

        public void endType(String text) {
            this.type = text;
        }

        public void endCode(String text) {
            this.code = text;
        }

        public void endMessage(String text) {
            this.message = text;
        }

        public void endDetail(String text) {
            this.detail = text;
        }

        public void endRequestId(String text) {
            this.requestId = text;
        }

        public void endRequestID(String text) {
            this.requestId = text;
        }
    }

    public class OriginHandler
    extends SimpleHandler {
        protected Origin origin;
        private String id;
        private String domainName;
        private String originAccessIdentity;
        private String httpPort;
        private String httpsPort;
        private String originProtocolPolicy;

        public OriginHandler(XMLReader xr) {
            super(xr);
            this.origin = null;
            this.domainName = null;
            this.originAccessIdentity = null;
            this.httpPort = null;
            this.httpsPort = null;
            this.originProtocolPolicy = null;
        }

        public void endId(String text) {
            this.id = text;
        }

        public void endDomainName(String text) {
            this.domainName = text;
        }

        public void endOriginAccessIdentity(String text) {
            this.originAccessIdentity = text;
        }

        public void endHTTPPort(String text) {
            this.httpPort = text;
        }

        public void endHTTPSPort(String text) {
            this.httpsPort = text;
        }

        public void endOriginProtocolPolicy(String text) {
            this.originProtocolPolicy = text;
        }

        public void endS3OriginConfig(String text) {
            if (this.originAccessIdentity != null && this.originAccessIdentity.length() == 0) {
                this.originAccessIdentity = null;
            }
            this.origin = new S3Origin(this.id, this.domainName, this.originAccessIdentity);
            this.returnControlToParentHandler();
        }

        public void endS3Origin(String text) {
            if (this.originAccessIdentity != null && this.originAccessIdentity.length() == 0) {
                this.originAccessIdentity = null;
            }
            this.origin = new S3Origin(this.id, this.domainName, this.originAccessIdentity);
            this.returnControlToParentHandler();
        }

        public void endCustomOriginConfig(String text) {
            this.origin = new CustomOrigin(this.id, this.domainName, CustomOrigin.OriginProtocolPolicy.fromText(this.originProtocolPolicy), Integer.valueOf(this.httpPort), Integer.valueOf(this.httpsPort));
            this.returnControlToParentHandler();
        }
    }

    public class DistributionSummaryHandler
    extends SimpleHandler {
        private Distribution distribution;
        private String id;
        private String status;
        private Date lastModifiedTime;
        private Long inProgressInvalidationBatches;
        private String domainName;
        private List<Origin> origins;
        private final List<String> cnamesList;
        private String comment;
        private boolean enabled;
        private CacheBehavior defaultCacheBehavior;
        private List<CacheBehavior> cacheBehaviors;
        private boolean inDefaultCacheBehavior;

        public DistributionSummaryHandler(XMLReader xr) {
            super(xr);
            this.distribution = null;
            this.id = null;
            this.status = null;
            this.lastModifiedTime = null;
            this.inProgressInvalidationBatches = 0L;
            this.domainName = null;
            this.origins = new ArrayList<Origin>();
            this.cnamesList = new ArrayList<String>();
            this.comment = null;
            this.enabled = false;
            this.defaultCacheBehavior = null;
            this.cacheBehaviors = new ArrayList<CacheBehavior>();
            this.inDefaultCacheBehavior = false;
        }

        public Distribution getDistribution() {
            return this.distribution;
        }

        public void endId(String text) {
            this.id = text;
        }

        public void endStatus(String text) {
            this.status = text;
        }

        public void endLastModifiedTime(String text) throws ParseException {
            this.lastModifiedTime = ServiceUtils.parseIso8601Date(text);
        }

        public void endInProgressInvalidationBatches(String text) {
            this.inProgressInvalidationBatches = Long.parseLong(text);
        }

        public void endDomainName(String text) {
            this.domainName = text;
        }

        public void endCNAME(String text) {
            this.cnamesList.add(text);
        }

        public void startOrigin() {
            this.transferControlToHandler(new OriginHandler(CloudFrontXmlResponsesSaxParser.this.xr));
        }

        public void startS3Origin() {
            this.transferControlToHandler(new OriginHandler(CloudFrontXmlResponsesSaxParser.this.xr));
        }

        public void startDefaultCacheBehavior() {
            this.inDefaultCacheBehavior = true;
            this.transferControlToHandler(new CacheBehaviorHandler(CloudFrontXmlResponsesSaxParser.this.xr));
        }

        public void startCacheBehavior() {
            this.inDefaultCacheBehavior = false;
            this.transferControlToHandler(new CacheBehaviorHandler(CloudFrontXmlResponsesSaxParser.this.xr));
        }

        @Override
        public void controlReturned(SimpleHandler childHandler) {
            if (childHandler instanceof OriginHandler) {
                this.origins.add(((OriginHandler)childHandler).origin);
            } else if (childHandler instanceof CacheBehaviorHandler) {
                if (this.inDefaultCacheBehavior) {
                    this.defaultCacheBehavior = ((CacheBehaviorHandler)childHandler).cacheBehavior;
                } else {
                    this.cacheBehaviors.add(((CacheBehaviorHandler)childHandler).cacheBehavior);
                }
            }
        }

        public void endComment(String text) {
            this.comment = text;
        }

        public void endEnabled(String text) {
            this.enabled = String.valueOf(true).equalsIgnoreCase(text);
        }

        public void endDistributionSummary(String text) {
            DistributionConfig config = new DistributionConfig(this.origins.toArray(new Origin[this.origins.size()]), null, this.cnamesList.toArray(new String[this.cnamesList.size()]), this.comment, this.enabled, null, null, this.defaultCacheBehavior, this.cacheBehaviors.toArray(new CacheBehavior[this.cacheBehaviors.size()]));
            this.distribution = new Distribution(this.id, this.status, this.lastModifiedTime, this.inProgressInvalidationBatches, this.domainName, null, config);
            this.returnControlToParentHandler();
        }

        public void endStreamingDistributionSummary(String text) {
            StreamingDistributionConfig config = new StreamingDistributionConfig(this.origins.toArray(new Origin[this.origins.size()]), null, this.cnamesList.toArray(new String[this.cnamesList.size()]), this.comment, this.enabled, null, null);
            this.distribution = new StreamingDistribution(this.id, this.status, this.lastModifiedTime, this.domainName, null, config);
            this.returnControlToParentHandler();
        }
    }

    public class CacheBehaviorHandler
    extends SimpleHandler {
        private CacheBehavior cacheBehavior;

        public CacheBehaviorHandler(XMLReader xr) {
            super(xr);
            this.cacheBehavior = new CacheBehavior();
        }

        public CacheBehavior getCacheBehavior() {
            return this.cacheBehavior;
        }

        public void endPathPattern(String text) {
            this.cacheBehavior.setPathPattern(text);
        }

        public void endTargetOriginId(String text) {
            this.cacheBehavior.setTargetOriginId(text);
        }

        public void endQueryString(String text) {
            this.cacheBehavior.setIsForwardQueryString(String.valueOf(true).equals(text));
        }

        public void endViewerProtocolPolicy(String text) {
            this.cacheBehavior.setViewerProtocolPolicy(CacheBehavior.ViewerProtocolPolicy.fromText(text));
        }

        public void endMinTTL(String text) {
            this.cacheBehavior.setMinTTL(new Long(text));
        }

        public void startTrustedSigners() {
            this.transferControlToHandler(new TrustedSignersHandler(CloudFrontXmlResponsesSaxParser.this.xr));
        }

        @Override
        public void controlReturned(SimpleHandler childHandler) {
            this.cacheBehavior.setTrustedSignerAwsAccountNumbers(((TrustedSignersHandler)childHandler).getTrustedSigners());
        }

        public void endDefaultCacheBehavior(String text) {
            this.returnControlToParentHandler();
        }

        public void endCacheBehavior(String text) {
            this.returnControlToParentHandler();
        }
    }

    public class TrustedSignersHandler
    extends SimpleHandler {
        private List<String> trustedSigners;

        public TrustedSignersHandler(XMLReader xr) {
            super(xr);
            this.trustedSigners = new ArrayList<String>();
        }

        public String[] getTrustedSigners() {
            return this.trustedSigners.toArray(new String[this.trustedSigners.size()]);
        }

        public void endAwsAccountNumber(String text) {
            this.trustedSigners.add(text);
        }

        public void endTrustedSigners(String text) {
            this.returnControlToParentHandler();
        }
    }

    public class LoggingStatusHandler
    extends SimpleHandler {
        private LoggingStatus loggingStatus;

        public LoggingStatusHandler(XMLReader xr) {
            super(xr);
            this.loggingStatus = new LoggingStatus(false, null, null);
        }

        public LoggingStatus getLoggingStatus() {
            return this.loggingStatus;
        }

        public void endEnabled(String text) {
            this.loggingStatus.setEnabled(String.valueOf(true).equals(text));
        }

        public void endBucket(String text) {
            this.loggingStatus.setBucket(text);
        }

        public void endPrefix(String text) {
            this.loggingStatus.setPrefix(text);
        }

        public void endLogging(String text) {
            this.returnControlToParentHandler();
        }
    }
}

