/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.samples;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStreamReader;
import org.jets3t.samples.SamplesUtils;
import org.jets3t.service.Constants;
import org.jets3t.service.ServiceException;
import org.jets3t.service.acl.Permission;
import org.jets3t.service.acl.gs.AllUsersGrantee;
import org.jets3t.service.acl.gs.GSAccessControlList;
import org.jets3t.service.acl.gs.GroupByDomainGrantee;
import org.jets3t.service.acl.gs.UserByEmailAddressGrantee;
import org.jets3t.service.acl.gs.UserByIdGrantee;
import org.jets3t.service.impl.rest.httpclient.GoogleStorageService;
import org.jets3t.service.model.GSBucket;
import org.jets3t.service.model.GSObject;
import org.jets3t.service.security.GSCredentials;
import org.jets3t.service.utils.ServiceUtils;

public class GSCodeSamples {
    private static final String BUCKET_NAME = "test-bucket";
    private static final String TEST_OBJECT_NAME = "helloworld.txt";

    public static void main(String[] args) throws Exception {
        String data;
        GSCredentials gsCredentials = SamplesUtils.loadGSCredentials();
        GoogleStorageService gsService = new GoogleStorageService(gsCredentials);
        GSBucket[] myBuckets = gsService.listAllBuckets();
        System.out.println("How many buckets to I have in GS? " + myBuckets.length);
        GSBucket testBucket = gsService.createBucket(BUCKET_NAME);
        System.out.println("Created test bucket: " + testBucket.getName());
        GSObject object = new GSObject("object");
        System.out.println("GSObject before upload: " + object);
        object = gsService.putObject(BUCKET_NAME, object);
        System.out.println("GSObject after upload: " + object);
        String stringData = "Hello World!";
        GSObject stringObject = new GSObject(TEST_OBJECT_NAME, stringData);
        File fileData = new File("src/org/jets3t/samples/GSCodeSamples.java");
        GSObject fileObject = new GSObject(fileData);
        String greeting = "Hello World!";
        GSObject helloWorldObject = new GSObject("HelloWorld2.txt");
        ByteArrayInputStream greetingIS = new ByteArrayInputStream(greeting.getBytes(Constants.DEFAULT_ENCODING));
        helloWorldObject.setDataInputStream(greetingIS);
        helloWorldObject.setContentLength(greeting.getBytes(Constants.DEFAULT_ENCODING).length);
        helloWorldObject.setContentType("text/plain");
        gsService.putObject(BUCKET_NAME, stringObject);
        gsService.putObject(BUCKET_NAME, fileObject);
        gsService.putObject(BUCKET_NAME, helloWorldObject);
        System.out.println("GSObject with data: " + helloWorldObject);
        GSObject objectWithHash = new GSObject(TEST_OBJECT_NAME, stringData);
        System.out.println("Hash value: " + objectWithHash.getMd5HashAsHex());
        ByteArrayInputStream dataIS = new ByteArrayInputStream("Here is my data".getBytes(Constants.DEFAULT_ENCODING));
        byte[] md5Hash = ServiceUtils.computeMD5Hash(dataIS);
        dataIS.reset();
        GSObject hashObject = new GSObject("MyData");
        hashObject.setDataInputStream(dataIS);
        hashObject.setMd5Hash(md5Hash);
        GSObject objectDetailsOnly = gsService.getObjectDetails(BUCKET_NAME, TEST_OBJECT_NAME);
        System.out.println("GSObject, details only: " + objectDetailsOnly);
        GSObject objectComplete = gsService.getObject(BUCKET_NAME, TEST_OBJECT_NAME);
        System.out.println("GSObject, complete: " + objectComplete);
        System.out.println("Greeting:");
        BufferedReader reader = new BufferedReader(new InputStreamReader(objectComplete.getDataInputStream()));
        while ((data = reader.readLine()) != null) {
            System.out.println(data);
        }
        GSObject downloadedObject = gsService.getObject(BUCKET_NAME, TEST_OBJECT_NAME);
        String textData = ServiceUtils.readInputStreamToString(downloadedObject.getDataInputStream(), "UTF-8");
        boolean valid = downloadedObject.verifyData(textData.getBytes("UTF-8"));
        System.out.println("Object verified? " + valid);
        GSBucket[] buckets = gsService.listAllBuckets();
        for (int b = 0; b < buckets.length; ++b) {
            System.out.println("Bucket '" + buckets[b].getName() + "' contains:");
            GSObject[] objects = gsService.listObjects(buckets[b].getName());
            for (int o = 0; o < objects.length; ++o) {
                System.out.println(" " + objects[o].getKey() + " (" + objects[o].getContentLength() + " bytes)");
            }
        }
        String prefix = "Reports";
        String delimiter = null;
        GSObject[] filteredObjects = gsService.listObjects(BUCKET_NAME, prefix, delimiter);
        GSObject targetObject = new GSObject("target-object-with-sources-metadata");
        boolean replaceMetadata = false;
        gsService.copyObject(BUCKET_NAME, TEST_OBJECT_NAME, "target-bucket", targetObject, replaceMetadata);
        targetObject = new GSObject(TEST_OBJECT_NAME);
        targetObject.addMetadata("Content-Type", "text/html");
        replaceMetadata = true;
        gsService.copyObject(BUCKET_NAME, TEST_OBJECT_NAME, BUCKET_NAME, targetObject, replaceMetadata);
        gsService.moveObject(BUCKET_NAME, TEST_OBJECT_NAME, "target-bucket", targetObject, false);
        gsService.moveObject(BUCKET_NAME, TEST_OBJECT_NAME, BUCKET_NAME, new GSObject("newname.txt"), false);
        gsService.renameObject(BUCKET_NAME, TEST_OBJECT_NAME, targetObject);
        try {
            gsService.deleteBucket(BUCKET_NAME);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        gsService.deleteObject(BUCKET_NAME, object.getKey());
        gsService.deleteObject(BUCKET_NAME, helloWorldObject.getKey());
        gsService.deleteObject(BUCKET_NAME, stringObject.getKey());
        gsService.deleteObject(BUCKET_NAME, fileObject.getKey());
        gsService.deleteBucket(BUCKET_NAME);
        System.out.println("Deleted bucket test-bucket");
        String publicBucketName = "test-bucket-public";
        GSBucket publicBucket = new GSBucket(publicBucketName);
        gsService.createBucket(publicBucketName);
        GSAccessControlList bucketAcl = gsService.getBucketAcl(publicBucketName);
        bucketAcl.grantPermission(new AllUsersGrantee(), Permission.PERMISSION_READ);
        publicBucket.setAcl(bucketAcl);
        gsService.putBucketAcl(publicBucket);
        GSObject publicObject = new GSObject("publicObject.txt", "This object is public");
        publicObject.setAcl(bucketAcl);
        gsService.putObject(publicBucketName, publicObject);
        GSAccessControlList acl = new GSAccessControlList();
        acl.grantPermission(new UserByEmailAddressGrantee("someone@somewhere.com"), Permission.PERMISSION_FULL_CONTROL);
        acl.grantPermission(new UserByIdGrantee("Google member's ID"), Permission.PERMISSION_READ);
        acl.grantPermission(new GroupByDomainGrantee("yourdomain.com"), Permission.PERMISSION_WRITE);
    }
}

