/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.jets3t.gui.GuiUtils;
import org.jets3t.gui.JHtmlLabel;
import org.jets3t.gui.TableSorter;
import org.jets3t.gui.skins.SkinsFactory;
import org.jets3t.service.model.S3Object;

public class ObjectsAttributesDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 7306510092130196820L;
    private GuiUtils guiUtils = new GuiUtils();
    private SkinsFactory skinsFactory = null;
    private final Insets insetsZero = new Insets(0, 0, 0, 0);
    private final Insets insetsDefault = new Insets(5, 7, 5, 7);
    private final Insets insetsVerticalSpace = new Insets(5, 0, 5, 0);
    private final Insets insetsHorizontalSpace = new Insets(0, 7, 0, 7);
    private S3Object[] destinationObjects = null;
    private S3Object currentObject = null;
    private int currentObjectIndex = 0;
    private JTextField objectKeyTextField = null;
    private JTextField objectContentLengthTextField = null;
    private JTextField objectLastModifiedTextField = null;
    private JTextField objectETagTextField = null;
    private JTextField bucketLocationTextField = null;
    private JTextField storageClassTextField = null;
    private DefaultTableModel objectMetadataTableModel = null;
    private TableSorter metadataTableSorter = null;
    private JLabel ownerNameLabel = null;
    private JLabel ownerIdLabel = null;
    private JLabel currentObjectLabel = null;
    private JTable metadataTable = null;
    private JButton removeMetadataItemButton = null;
    private JButton addMetadataItemButton = null;
    private JButton previousObjectButton = null;
    private JButton nextObjectButton = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JPanel metadataButtonsContainer = null;
    private JPanel destinationPanel = null;
    private JPanel nextPreviousPanel = null;
    private JTextField ownerNameTextField = null;
    private JTextField ownerIdTextField = null;
    private boolean modifyMode = false;
    private boolean modifyActionApproved = false;

    public ObjectsAttributesDialog(Frame owner, String title, SkinsFactory skinsFactory) {
        super(owner, title, true);
        this.skinsFactory = skinsFactory;
        this.initGui();
    }

    public void displayDialog(S3Object[] objects, boolean modifyMode) {
        int height;
        this.currentObjectIndex = 0;
        this.modifyActionApproved = false;
        this.modifyMode = modifyMode;
        this.destinationObjects = new S3Object[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            this.destinationObjects[i] = (S3Object)objects[i].clone();
        }
        if (modifyMode) {
            this.okButton.setText("Modify Object" + (this.destinationObjects.length > 0 ? "s" : ""));
            this.cancelButton.setVisible(true);
            this.metadataButtonsContainer.setVisible(true);
            this.destinationPanel.setVisible(true);
        } else {
            this.okButton.setText("OK");
            this.cancelButton.setVisible(false);
            this.metadataButtonsContainer.setVisible(false);
            this.destinationPanel.setVisible(false);
        }
        if (this.destinationObjects.length > 1) {
            this.nextPreviousPanel.setVisible(true);
        } else {
            this.nextPreviousPanel.setVisible(false);
        }
        this.displayObjectProperties();
        int n = height = this.isModifyMode() ? 450 : 400;
        if (objects.length > 1) {
            height += 30;
        }
        this.pack();
        this.setSize(new Dimension(450, height));
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
    }

    private void initGui() {
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        JPanel unmodifiableAttributesPanel = this.skinsFactory.createSkinnedJPanel("ObjectStaticAttributesPanel");
        unmodifiableAttributesPanel.setLayout(new GridBagLayout());
        JPanel metadataContainer = this.skinsFactory.createSkinnedJPanel("ObjectPropertiesMetadataPanel");
        metadataContainer.setLayout(new GridBagLayout());
        this.metadataButtonsContainer = this.skinsFactory.createSkinnedJPanel("ObjectPropertiesMetadataButtonsPanel");
        this.metadataButtonsContainer.setLayout(new GridBagLayout());
        JHtmlLabel objectKeyLabel = this.skinsFactory.createSkinnedJHtmlLabel("ObjectKeyLabel");
        objectKeyLabel.setText("Object key:");
        this.objectKeyTextField = this.skinsFactory.createSkinnedJTextField("ObjectKeyTextField");
        this.objectKeyTextField.setEditable(false);
        JHtmlLabel objectContentLengthLabel = this.skinsFactory.createSkinnedJHtmlLabel("ObjectContentLengthLabel");
        objectContentLengthLabel.setText("Size:");
        this.objectContentLengthTextField = this.skinsFactory.createSkinnedJTextField("ObjectContentLengthTextField");
        this.objectContentLengthTextField.setEditable(false);
        JHtmlLabel objectLastModifiedLabel = this.skinsFactory.createSkinnedJHtmlLabel("ObjectLastModifiedLabel");
        objectLastModifiedLabel.setText("Last modified:");
        this.objectLastModifiedTextField = this.skinsFactory.createSkinnedJTextField("ObjectLastModifiedTextField");
        this.objectLastModifiedTextField.setEditable(false);
        JHtmlLabel objectETagLabel = this.skinsFactory.createSkinnedJHtmlLabel("ObjectETagLabel");
        objectETagLabel.setText("ETag:");
        this.objectETagTextField = this.skinsFactory.createSkinnedJTextField("ObjectETagTextField");
        this.objectETagTextField.setEditable(false);
        JHtmlLabel bucketNameLabel = this.skinsFactory.createSkinnedJHtmlLabel("BucketNameLabel");
        bucketNameLabel.setText("Bucket:");
        this.bucketLocationTextField = this.skinsFactory.createSkinnedJTextField("BucketLocationTextField");
        this.bucketLocationTextField.setEditable(false);
        JHtmlLabel storageClassLabel = this.skinsFactory.createSkinnedJHtmlLabel("StorageClassLabel");
        storageClassLabel.setText("Storage Class:");
        this.storageClassTextField = this.skinsFactory.createSkinnedJTextField("StorageClassTextField");
        this.storageClassTextField.setEditable(false);
        this.ownerNameLabel = this.skinsFactory.createSkinnedJHtmlLabel("OwnerNameLabel");
        this.ownerNameLabel.setText("Owner name:");
        this.ownerNameTextField = this.skinsFactory.createSkinnedJTextField("OwnerNameTextField");
        this.ownerNameTextField.setEditable(false);
        this.ownerIdLabel = this.skinsFactory.createSkinnedJHtmlLabel("OwnerIdLabel");
        this.ownerIdLabel.setText("Owner ID:");
        this.ownerIdTextField = this.skinsFactory.createSkinnedJTextField("OwnerIdTextField");
        this.ownerIdTextField.setEditable(false);
        Insets textFieldInsets = new Insets(2, 4, 2, 4);
        int row = 0;
        unmodifiableAttributesPanel.add((Component)objectKeyLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, textFieldInsets, 0, 0));
        unmodifiableAttributesPanel.add((Component)this.objectKeyTextField, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, textFieldInsets, 0, 0));
        unmodifiableAttributesPanel.add((Component)objectContentLengthLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 13, 0, textFieldInsets, 0, 0));
        unmodifiableAttributesPanel.add((Component)this.objectContentLengthTextField, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, textFieldInsets, 0, 0));
        unmodifiableAttributesPanel.add((Component)objectLastModifiedLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 13, 0, textFieldInsets, 0, 0));
        unmodifiableAttributesPanel.add((Component)this.objectLastModifiedTextField, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, textFieldInsets, 0, 0));
        unmodifiableAttributesPanel.add((Component)objectETagLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 13, 0, textFieldInsets, 0, 0));
        unmodifiableAttributesPanel.add((Component)this.objectETagTextField, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, textFieldInsets, 0, 0));
        unmodifiableAttributesPanel.add((Component)this.ownerNameLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 13, 0, textFieldInsets, 0, 0));
        unmodifiableAttributesPanel.add((Component)this.ownerNameTextField, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, textFieldInsets, 0, 0));
        unmodifiableAttributesPanel.add((Component)this.ownerIdLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 13, 0, textFieldInsets, 0, 0));
        unmodifiableAttributesPanel.add((Component)this.ownerIdTextField, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, textFieldInsets, 0, 0));
        unmodifiableAttributesPanel.add((Component)bucketNameLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 13, 0, textFieldInsets, 0, 0));
        unmodifiableAttributesPanel.add((Component)this.bucketLocationTextField, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, textFieldInsets, 0, 0));
        unmodifiableAttributesPanel.add((Component)storageClassLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 13, 0, textFieldInsets, 0, 0));
        unmodifiableAttributesPanel.add((Component)this.storageClassTextField, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 2, textFieldInsets, 0, 0));
        this.objectMetadataTableModel = new DefaultTableModel(new Object[]{"Name", "Value"}, 0){
            private static final long serialVersionUID = -3762866886166776851L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return ObjectsAttributesDialog.this.isModifyMode();
            }
        };
        this.metadataTableSorter = new TableSorter(this.objectMetadataTableModel);
        this.metadataTable = this.skinsFactory.createSkinnedJTable("MetadataTable");
        this.metadataTable.setModel(this.metadataTableSorter);
        this.metadataTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && ObjectsAttributesDialog.this.removeMetadataItemButton != null) {
                    int row = ObjectsAttributesDialog.this.metadataTable.getSelectedRow();
                    ObjectsAttributesDialog.this.removeMetadataItemButton.setEnabled(row >= 0);
                }
            }
        });
        this.metadataTableSorter.setTableHeader(this.metadataTable.getTableHeader());
        this.metadataTableSorter.setSortingStatus(0, 1);
        metadataContainer.add((Component)new JScrollPane(this.metadataTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.insetsHorizontalSpace, 0, 0));
        this.removeMetadataItemButton = this.skinsFactory.createSkinnedJButton("ObjectPropertiesAddMetadataButton");
        this.removeMetadataItemButton.setEnabled(false);
        this.removeMetadataItemButton.setToolTipText("Remove the selected metadata item(s)");
        this.guiUtils.applyIcon(this.removeMetadataItemButton, "/images/nuvola/16x16/actions/viewmag-.png");
        this.removeMetadataItemButton.addActionListener(this);
        this.removeMetadataItemButton.setActionCommand("removeMetadataItem");
        this.addMetadataItemButton = this.skinsFactory.createSkinnedJButton("ObjectPropertiesAddMetadataButton");
        this.addMetadataItemButton.setToolTipText("Add a new metadata item");
        this.guiUtils.applyIcon(this.addMetadataItemButton, "/images/nuvola/16x16/actions/viewmag+.png");
        this.addMetadataItemButton.setActionCommand("addMetadataItem");
        this.addMetadataItemButton.addActionListener(this);
        this.metadataButtonsContainer.add((Component)this.removeMetadataItemButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, this.insetsZero, 0, 0));
        this.metadataButtonsContainer.add((Component)this.addMetadataItemButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, this.insetsZero, 0, 0));
        metadataContainer.add((Component)this.metadataButtonsContainer, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 0, this.insetsHorizontalSpace, 0, 0));
        this.metadataButtonsContainer.setVisible(false);
        this.okButton = this.skinsFactory.createSkinnedJButton("ObjectPropertiesOKButton");
        this.okButton.setText("OK");
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(this);
        this.cancelButton = null;
        this.cancelButton = this.skinsFactory.createSkinnedJButton("ObjectPropertiesCancelButton");
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setVisible(false);
        this.getRootPane().setDefaultButton(this.okButton);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){
            private static final long serialVersionUID = -7768790936535999307L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObjectsAttributesDialog.this.setVisible(false);
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("PAGE_UP"), "PAGE_UP");
        this.getRootPane().getActionMap().put("PAGE_UP", new AbstractAction(){
            private static final long serialVersionUID = -6324229423705756219L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObjectsAttributesDialog.this.previousObjectButton.doClick();
            }
        });
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("PAGE_DOWN"), "PAGE_DOWN");
        this.getRootPane().getActionMap().put("PAGE_DOWN", new AbstractAction(){
            private static final long serialVersionUID = -5808972377672449421L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ObjectsAttributesDialog.this.nextObjectButton.doClick();
            }
        });
        row = 0;
        JPanel container = this.skinsFactory.createSkinnedJPanel("ObjectPropertiesPanel");
        container.setLayout(new GridBagLayout());
        container.add((Component)unmodifiableAttributesPanel, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 2, this.insetsZero, 0, 0));
        this.previousObjectButton = this.skinsFactory.createSkinnedJButton("ObjectPropertiesPreviousButton");
        this.guiUtils.applyIcon(this.previousObjectButton, "/images/nuvola/16x16/actions/1leftarrow.png");
        this.previousObjectButton.addActionListener(this);
        this.previousObjectButton.setEnabled(false);
        this.nextObjectButton = this.skinsFactory.createSkinnedJButton("ObjectPropertiesNextButton");
        this.guiUtils.applyIcon(this.nextObjectButton, "/images/nuvola/16x16/actions/1rightarrow.png");
        this.nextObjectButton.addActionListener(this);
        this.nextObjectButton.setEnabled(false);
        this.currentObjectLabel = this.skinsFactory.createSkinnedJHtmlLabel("ObjectPropertiesCurrentObjectLabel");
        this.currentObjectLabel.setHorizontalAlignment(0);
        this.nextPreviousPanel = this.skinsFactory.createSkinnedJPanel("ObjectPropertiesNextPreviousPanel");
        this.nextPreviousPanel.setLayout(new GridBagLayout());
        this.nextPreviousPanel.add((Component)this.previousObjectButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, this.insetsZero, 0, 0));
        this.nextPreviousPanel.add((Component)this.currentObjectLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, this.insetsHorizontalSpace, 0, 0));
        this.nextPreviousPanel.add((Component)this.nextObjectButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, this.insetsZero, 0, 0));
        container.add((Component)this.nextPreviousPanel, new GridBagConstraints(0, row, 1, 1, 1.0, 0.0, 10, 2, this.insetsZero, 0, 0));
        this.nextPreviousPanel.setVisible(false);
        JHtmlLabel metadataLabel = this.skinsFactory.createSkinnedJHtmlLabel("MetadataLabel");
        metadataLabel.setText("<html><b>Metadata Attributes</b></html>");
        metadataLabel.setHorizontalAlignment(0);
        int n = ++row;
        container.add((Component)metadataLabel, new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 10, 2, this.insetsVerticalSpace, 0, 0));
        int n2 = ++row;
        container.add((Component)metadataContainer, new GridBagConstraints(0, n2, 1, 1, 1.0, 1.0, 10, 1, this.insetsZero, 0, 0));
        this.destinationPanel = this.skinsFactory.createSkinnedJPanel("DestinationPanel");
        this.destinationPanel.setLayout(new GridBagLayout());
        JPanel actionButtonsPanel = this.skinsFactory.createSkinnedJPanel("ObjectPropertiesActionButtonsPanel");
        actionButtonsPanel.setLayout(new GridBagLayout());
        actionButtonsPanel.add((Component)this.cancelButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, this.insetsZero, 0, 0));
        actionButtonsPanel.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, this.insetsZero, 0, 0));
        this.cancelButton.setVisible(false);
        int n3 = ++row;
        ++row;
        container.add((Component)actionButtonsPanel, new GridBagConstraints(0, n3, 3, 1, 0.0, 0.0, 10, 0, this.insetsDefault, 0, 0));
        this.getContentPane().add(container);
        this.pack();
        this.setSize(new Dimension(450, 500));
        this.setLocationRelativeTo(this.getOwner());
    }

    private void displayObjectProperties() {
        this.currentObject = this.destinationObjects[this.currentObjectIndex];
        if (this.destinationObjects.length > 1) {
            this.currentObjectLabel.setText(this.currentObjectIndex + 1 + " of " + this.destinationObjects.length);
            this.previousObjectButton.setEnabled(this.currentObjectIndex > 0);
            this.nextObjectButton.setEnabled(this.currentObjectIndex < this.destinationObjects.length - 1);
        }
        this.objectKeyTextField.setText(this.currentObject.getKey());
        this.objectContentLengthTextField.setText(String.valueOf(this.currentObject.getContentLength()));
        this.objectLastModifiedTextField.setText(String.valueOf(this.currentObject.getLastModifiedDate()));
        this.objectETagTextField.setText(this.currentObject.getETag());
        this.bucketLocationTextField.setText(this.currentObject.getBucketName());
        String storageClass = this.currentObject.getStorageClass() != null ? this.currentObject.getStorageClass() : "STANDARD";
        this.storageClassTextField.setText(storageClass);
        if (this.currentObject.getOwner() != null) {
            this.ownerNameLabel.setVisible(true);
            this.ownerNameTextField.setVisible(true);
            this.ownerIdLabel.setVisible(true);
            this.ownerIdTextField.setVisible(true);
            this.ownerNameTextField.setText(this.currentObject.getOwner().getDisplayName());
            this.ownerIdTextField.setText(this.currentObject.getOwner().getId());
        } else {
            this.ownerNameLabel.setVisible(false);
            this.ownerNameTextField.setVisible(false);
            this.ownerIdLabel.setVisible(false);
            this.ownerIdTextField.setVisible(false);
        }
        while (this.objectMetadataTableModel.getRowCount() > 0) {
            this.objectMetadataTableModel.removeRow(0);
        }
        for (Map.Entry<String, Object> entry : this.currentObject.getModifiableMetadata().entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            this.objectMetadataTableModel.addRow(new Object[]{name, value});
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.metadataTable.isEditing()) {
            this.metadataTable.getCellEditor().stopCellEditing();
        }
        Map<String, Object> currentObjectMetadata = this.currentObject.getModifiableMetadata();
        Set<String> obsoleteMetadataItems = currentObjectMetadata.keySet();
        for (int row = 0; row < this.metadataTable.getRowCount(); ++row) {
            String name = (String)this.objectMetadataTableModel.getValueAt(row, 0);
            String value = (String)this.objectMetadataTableModel.getValueAt(row, 1);
            this.currentObject.addMetadata(name, value);
            obsoleteMetadataItems.remove(name);
        }
        Iterator<String> obsoleteNamesIter = obsoleteMetadataItems.iterator();
        while (obsoleteNamesIter.hasNext()) {
            this.currentObject.removeMetadata(obsoleteNamesIter.next());
        }
        if (e.getSource().equals(this.nextObjectButton)) {
            ++this.currentObjectIndex;
            this.displayObjectProperties();
        } else if (e.getSource().equals(this.previousObjectButton)) {
            --this.currentObjectIndex;
            this.displayObjectProperties();
        } else if ("OK".equals(e.getActionCommand())) {
            this.modifyActionApproved = this.isModifyMode();
            this.setVisible(false);
        } else if ("Cancel".equals(e.getActionCommand())) {
            this.modifyActionApproved = false;
            this.setVisible(false);
        } else if ("addMetadataItem".equals(e.getActionCommand())) {
            int newRowNumber = this.metadataTable.getRowCount() + 1;
            this.objectMetadataTableModel.addRow(new String[]{"name-" + newRowNumber, "value-" + newRowNumber});
        } else if ("removeMetadataItem".equals(e.getActionCommand())) {
            int[] rows = this.metadataTable.getSelectedRows();
            for (int i = rows.length - 1; i >= 0; --i) {
                int modelIndex = this.metadataTableSorter.modelIndex(rows[i]);
                this.objectMetadataTableModel.removeRow(modelIndex);
            }
        }
    }

    public boolean isModifyMode() {
        return this.modifyMode;
    }

    public boolean isModifyActionApproved() {
        return this.modifyActionApproved;
    }

    public String[] getSourceObjectKeys() {
        String[] sourceObjectKeys = new String[this.destinationObjects.length];
        for (int i = 0; i < this.destinationObjects.length; ++i) {
            sourceObjectKeys[i] = this.destinationObjects[i].getKey();
        }
        return sourceObjectKeys;
    }

    public S3Object[] getDestinationObjects() {
        if (!this.isModifyMode()) {
            return null;
        }
        return this.destinationObjects;
    }
}

