/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.apps.cockpitlite;

import contribs.com.centerkey.utils.BareBonesBrowserLaunch;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.InvalidCredentialsException;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.jets3t.apps.cockpitlite.CLObjectTableModel;
import org.jets3t.apps.cockpitlite.ToggleAclDialog;
import org.jets3t.gui.AuthenticationDialog;
import org.jets3t.gui.ErrorDialog;
import org.jets3t.gui.GuiUtils;
import org.jets3t.gui.HyperlinkActivatedListener;
import org.jets3t.gui.ItemPropertiesDialog;
import org.jets3t.gui.JHtmlLabel;
import org.jets3t.gui.ProgressDialog;
import org.jets3t.gui.ProgressPanel;
import org.jets3t.gui.TableSorter;
import org.jets3t.gui.UserInputFields;
import org.jets3t.gui.skins.SkinsFactory;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.acl.GrantAndPermission;
import org.jets3t.service.acl.GroupGrantee;
import org.jets3t.service.acl.Permission;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.io.BytesProgressWatcher;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.multithread.CancelEventTrigger;
import org.jets3t.service.multithread.CopyObjectsEvent;
import org.jets3t.service.multithread.CreateBucketsEvent;
import org.jets3t.service.multithread.CreateObjectsEvent;
import org.jets3t.service.multithread.DeleteObjectsEvent;
import org.jets3t.service.multithread.DeleteVersionedObjectsEvent;
import org.jets3t.service.multithread.DownloadObjectsEvent;
import org.jets3t.service.multithread.DownloadPackage;
import org.jets3t.service.multithread.GetObjectHeadsEvent;
import org.jets3t.service.multithread.GetObjectsEvent;
import org.jets3t.service.multithread.ListObjectsEvent;
import org.jets3t.service.multithread.LookupACLEvent;
import org.jets3t.service.multithread.S3ServiceEventListener;
import org.jets3t.service.multithread.S3ServiceMulti;
import org.jets3t.service.multithread.ThreadWatcher;
import org.jets3t.service.multithread.UpdateACLEvent;
import org.jets3t.service.utils.ByteFormatter;
import org.jets3t.service.utils.FileComparer;
import org.jets3t.service.utils.FileComparerResults;
import org.jets3t.service.utils.ObjectUtils;
import org.jets3t.service.utils.ServiceUtils;
import org.jets3t.service.utils.TimeFormatter;
import org.jets3t.service.utils.gatekeeper.GatekeeperMessage;
import org.jets3t.service.utils.gatekeeper.SignatureRequest;
import org.jets3t.service.utils.signedurl.GatekeeperClientUtils;
import org.jets3t.service.utils.signedurl.SignedUrlAndObject;

public class CockpitLite
extends JApplet
implements S3ServiceEventListener,
ActionListener,
ListSelectionListener,
HyperlinkActivatedListener,
CredentialsProvider {
    private static final long serialVersionUID = 4969295009540293079L;
    private static final Log log = LogFactory.getLog(CockpitLite.class);
    private static final String PROPERTIES_FILENAME = "cockpitlite.properties";
    public static final String APPLICATION_DESCRIPTION = "Cockpit Lite/0.9.4";
    public static final String APPLICATION_TITLE = "JetS3t Cockpit Lite";
    private final Insets insetsZero = new Insets(0, 0, 0, 0);
    private final Insets insetsDefault = new Insets(5, 7, 5, 7);
    private final ByteFormatter byteFormatter = new ByteFormatter();
    private final ByteFormatter byteFormatterTerse = new ByteFormatter("G", "M", "K", "B", 1);
    private final TimeFormatter timeFormatterTerse = new TimeFormatter("h", "h", "m", "m", "s", "s");
    private final SimpleDateFormat yearAndTimeSDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final SimpleDateFormat timeSDF = new SimpleDateFormat("HH:mm:ss");
    private final GuiUtils guiUtils = new GuiUtils();
    private Jets3tProperties cockpitLiteProperties = null;
    private static final String ACL_PRIVATE_DESCRIPTION = "Private";
    private static final String ACL_PUBLIC_DESCRIPTION = "Public";
    private static final String ACL_UNKNOWN_DESCRIPTION = "?";
    private Properties standAloneArgumentProperties = null;
    private final Map progressPanelMap = new HashMap();
    private final Object lock = new Object();
    private S3ServiceMulti s3ServiceMulti = null;
    private GatekeeperClientUtils gkClient = null;
    private final CredentialsProvider mCredentialProvider = new BasicCredentialsProvider();
    private String userBucketName = null;
    private String userVanityHost = null;
    private String userPath = "";
    private boolean userCanUpload = false;
    private boolean userCanDownload = false;
    private boolean userCanDelete = false;
    private boolean userCanACL = false;
    private boolean isRunningAsApplet = false;
    private Frame ownerFrame = null;
    private boolean isStandAloneApplication = false;
    private SkinsFactory skinsFactory = null;
    public static final int HTTP_CONNECTION_TIMEOUT = 60000;
    public static final int SOCKET_CONNECTION_TIMEOUT = 60000;
    public static final int MAX_CONNECTION_RETRIES = 5;
    private JPanel stackPanel = null;
    private CardLayout stackPanelCardLayout = null;
    private JPopupMenu objectActionMenu = null;
    private JMenuItem viewObjectPropertiesMenuItem = null;
    private JMenuItem refreshObjectMenuItem = null;
    private JMenuItem togglePublicMenuItem = null;
    private JMenuItem downloadObjectMenuItem = null;
    private JMenuItem uploadFilesMenuItem = null;
    private JMenuItem generatePublicGetUrl = null;
    private JMenuItem deleteObjectMenuItem = null;
    private JPanel loginPanel = null;
    private JButton loginButton = null;
    private JLabel objectsHeadingLabel = null;
    private JTable objectsTable = null;
    private JScrollPane objectsTableSP = null;
    private CLObjectTableModel objectTableModel = null;
    private TableSorter objectTableModelSorter = null;
    private JPanel progressNotificationPanel = null;
    private JLabel objectsSummaryLabel = null;
    private ProgressDialog progressDialog = null;
    private UserInputFields userInputFields = null;
    private File downloadDirectory = null;
    private Map downloadObjectsToFileMap = null;
    private boolean isDownloadingObjects = false;
    private boolean isUploadingFiles = false;
    private Map filesAlreadyInDownloadDirectoryMap = null;
    private Map s3DownloadObjectsMap = null;
    private Map<String, String> objectKeyToFilepathMap = null;
    private Map s3ExistingObjectsMap = null;
    private File fileChoosersLastUploadDirectory = null;
    private JPanel filterObjectsPanel = null;
    private JCheckBox filterObjectsCheckBox = null;
    private JTextField filterObjectsPrefix = null;
    private static final String UPLOAD_NEW_FILES_ONLY = "Only upload new file(s)";
    private static final String UPLOAD_NEW_AND_CHANGED_FILES = "Upload new and changed file(s)";
    private static final String UPLOAD_ALL_FILES = "Upload all files";
    private static final String DOWNLOAD_NEW_FILES_ONLY = "Only download new file(s)";
    private static final String DOWNLOAD_NEW_AND_CHANGED_FILES = "Download new and changed file(s)";
    private static final String DOWNLOAD_ALL_FILES = "Download all files";
    private boolean isViewingObjectProperties = false;

    public CockpitLite() {
        this.isRunningAsApplet = true;
    }

    public CockpitLite(JFrame ownerFrame, Properties standAloneArgumentProperties) throws S3ServiceException {
        this.ownerFrame = ownerFrame;
        this.standAloneArgumentProperties = standAloneArgumentProperties;
        this.isStandAloneApplication = true;
        this.init();
        ownerFrame.getContentPane().add(this);
        ownerFrame.setBounds(this.getBounds());
        ownerFrame.setVisible(true);
    }

    @Override
    public void init() {
        String gatekeeperUrl;
        super.init();
        if (this.ownerFrame == null) {
            Container c = this;
            while (!(c instanceof Frame) && c.getParent() != null) {
                c = c.getParent();
            }
            this.ownerFrame = !(c instanceof Frame) ? new JFrame() : (Frame)c;
        }
        this.cockpitLiteProperties = Jets3tProperties.getInstance(PROPERTIES_FILENAME);
        boolean isMissingRequiredInitProperty = false;
        if (this.isRunningAsApplet) {
            String appletParamNames = this.cockpitLiteProperties.getStringProperty("applet.params", "");
            StringTokenizer st = new StringTokenizer(appletParamNames, ",");
            while (st.hasMoreTokens()) {
                String paramName = st.nextToken();
                String paramValue = this.getParameter(paramName);
                if (null == paramValue) {
                    log.error((Object)("Missing required applet parameter: " + paramName));
                    isMissingRequiredInitProperty = true;
                    continue;
                }
                log.debug((Object)("Found applet parameter: " + paramName + "='" + paramValue + "'"));
                this.cockpitLiteProperties.setProperty(paramName, paramValue);
            }
        } else if (this.standAloneArgumentProperties != null) {
            Enumeration<Object> e = this.standAloneArgumentProperties.keys();
            while (e.hasMoreElements()) {
                String propName = (String)e.nextElement();
                String propValue = this.standAloneArgumentProperties.getProperty(propName);
                if (null == propValue) {
                    log.error((Object)("Missing required command-line property: " + propName));
                    isMissingRequiredInitProperty = true;
                    continue;
                }
                log.debug((Object)("Using command-line property: " + propName + "='" + propValue + "'"));
                this.cockpitLiteProperties.setProperty(propName, propValue);
            }
        }
        this.initGui();
        if (isMissingRequiredInitProperty) {
            String message = "Missing one or more required application properties";
            log.error((Object)message);
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, this.cockpitLiteProperties.getProperties(), message, null);
            System.exit(1);
        }
        if ((gatekeeperUrl = this.cockpitLiteProperties.getStringProperty("gatekeeperUrl", null)) == null) {
            String message = "Application properties file 'cockpitlite.properties' is not available";
            log.error((Object)message);
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, this.cockpitLiteProperties.getProperties(), message, null);
            System.exit(1);
        }
        this.gkClient = new GatekeeperClientUtils(gatekeeperUrl, APPLICATION_DESCRIPTION, 5, 60000, this);
        this.s3ServiceMulti = new S3ServiceMulti(new RestS3Service(null, APPLICATION_DESCRIPTION, this), this);
    }

    private void initGui() {
        this.skinsFactory = SkinsFactory.getInstance(this.cockpitLiteProperties.getProperties());
        LookAndFeel lookAndFeel = this.skinsFactory.createSkinnedMetalTheme("SkinnedLookAndFeel");
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (UnsupportedLookAndFeelException e) {
            log.error((Object)"Unable to set skinned LookAndFeel", (Throwable)e);
        }
        JPanel primaryPanel = this.skinsFactory.createSkinnedJPanel("PrimaryPanel");
        primaryPanel.setLayout(new GridBagLayout());
        this.getContentPane().add(primaryPanel);
        this.stackPanel = this.skinsFactory.createSkinnedJPanel("StackPanel");
        this.stackPanelCardLayout = new CardLayout();
        this.stackPanel.setLayout(this.stackPanelCardLayout);
        primaryPanel.add((Component)this.stackPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.insetsZero, 0, 0));
        this.progressNotificationPanel = this.skinsFactory.createSkinnedJPanel("ProgressNotificationPanel");
        this.progressNotificationPanel.setLayout(new GridBagLayout());
        primaryPanel.add((Component)this.progressNotificationPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        int row = 0;
        row = 0;
        this.loginPanel = this.skinsFactory.createSkinnedJPanel("LoginPanel");
        this.loginPanel.setLayout(new GridBagLayout());
        this.userInputFields = new UserInputFields(this.insetsDefault, null, this.skinsFactory);
        this.userInputFields.buildFieldsPanel(this.loginPanel, this.cockpitLiteProperties);
        this.loginButton = this.skinsFactory.createSkinnedJButton("LoginButton");
        this.loginButton.setText("Log me in");
        this.loginButton.addActionListener(this);
        this.loginPanel.add((Component)this.loginButton, new GridBagConstraints(0, this.loginPanel.getComponentCount(), 1, 1, 0.0, 0.0, 10, 0, this.insetsDefault, 0, 0));
        this.filterObjectsPanel = this.skinsFactory.createSkinnedJPanel("FilterPanel");
        this.filterObjectsPanel.setLayout(new GridBagLayout());
        this.filterObjectsPrefix = this.skinsFactory.createSkinnedJTextField("FilterPrefix");
        this.filterObjectsPrefix.setToolTipText("Only show files starting with this string");
        this.filterObjectsPrefix.addActionListener(this);
        this.filterObjectsPrefix.setActionCommand("RefreshObjects");
        JHtmlLabel filterPrefixLabel = this.skinsFactory.createSkinnedJHtmlLabel("FilterPrefixLable", this);
        filterPrefixLabel.setText("File name starts with: ");
        this.filterObjectsPanel.add((Component)filterPrefixLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, this.insetsZero, 0, 0));
        this.filterObjectsPanel.add((Component)this.filterObjectsPrefix, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, this.insetsDefault, 0, 0));
        this.filterObjectsPanel.setVisible(false);
        row = 0;
        JPanel objectsPanel = this.skinsFactory.createSkinnedJPanel("ObjectsPanel");
        objectsPanel.setLayout(new GridBagLayout());
        this.filterObjectsCheckBox = this.skinsFactory.createSkinnedJCheckBox("FilterCheckbox");
        this.filterObjectsCheckBox.setText("Search files");
        this.filterObjectsCheckBox.setEnabled(true);
        this.filterObjectsCheckBox.addActionListener(this);
        this.filterObjectsCheckBox.setToolTipText("Check this option to search your files");
        this.objectsHeadingLabel = this.skinsFactory.createSkinnedJHtmlLabel("ObjectsHeadingLabel", this);
        this.objectsHeadingLabel.setText("Not logged in");
        objectsPanel.add((Component)this.objectsHeadingLabel, new GridBagConstraints(0, row, 1, 1, 1.0, 0.0, 17, 2, this.insetsZero, 0, 0));
        objectsPanel.add((Component)this.filterObjectsCheckBox, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 13, 2, this.insetsZero, 0, 0));
        JButton objectActionButton = this.skinsFactory.createSkinnedJButton("ObjectMenuButton");
        objectActionButton.setToolTipText("File actions menu");
        this.guiUtils.applyIcon(objectActionButton, "/images/nuvola/16x16/actions/misc.png");
        objectActionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton sourceButton = (JButton)e.getSource();
                CockpitLite.this.objectActionMenu.show(sourceButton, 0, sourceButton.getHeight());
            }
        });
        objectsPanel.add((Component)objectActionButton, new GridBagConstraints(2, row, 1, 1, 0.0, 0.0, 13, 2, this.insetsZero, 0, 0));
        objectsPanel.add((Component)this.filterObjectsPanel, new GridBagConstraints(0, ++row, 3, 1, 0.0, 0.0, 17, 2, this.insetsZero, 0, 0));
        this.objectsTable = this.skinsFactory.createSkinnedJTable("ObjectsTable");
        this.objectTableModel = new CLObjectTableModel();
        this.objectTableModelSorter = new TableSorter(this.objectTableModel);
        this.objectTableModelSorter.setTableHeader(this.objectsTable.getTableHeader());
        this.objectsTable.setModel(this.objectTableModelSorter);
        this.objectsTable.setDefaultRenderer(Long.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 7229656175879985698L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String formattedSize = CockpitLite.this.byteFormatter.formatByteSize((Long)value);
                return super.getTableCellRendererComponent(table, formattedSize, isSelected, hasFocus, row, column);
            }
        });
        this.objectsTable.setDefaultRenderer(Date.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = -4983176028291916397L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Date date = (Date)value;
                return super.getTableCellRendererComponent(table, CockpitLite.this.yearAndTimeSDF.format(date), isSelected, hasFocus, row, column);
            }
        });
        this.objectsTable.setSelectionMode(2);
        this.objectsTable.getSelectionModel().addListSelectionListener(this);
        this.objectsTable.setShowHorizontalLines(true);
        this.objectsTable.setShowVerticalLines(true);
        this.objectsTable.addMouseListener(new ContextMenuListener());
        this.objectsTableSP = this.skinsFactory.createSkinnedJScrollPane("ObjectsTableSP", this.objectsTable);
        objectsPanel.add((Component)this.objectsTableSP, new GridBagConstraints(0, ++row, 3, 1, 1.0, 1.0, 10, 1, this.insetsZero, 0, 0));
        this.objectsSummaryLabel = this.skinsFactory.createSkinnedJHtmlLabel("ObjectsSummary", this);
        this.objectsSummaryLabel.setHorizontalAlignment(0);
        this.objectsSummaryLabel.setFocusable(false);
        objectsPanel.add((Component)this.objectsSummaryLabel, new GridBagConstraints(0, ++row, 3, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        this.objectActionMenu = this.skinsFactory.createSkinnedJPopupMenu("ObjectPopupMenu");
        this.refreshObjectMenuItem = this.skinsFactory.createSkinnedJMenuItem("RefreshMenuItem");
        this.refreshObjectMenuItem.setText("Refresh file listing");
        this.refreshObjectMenuItem.setActionCommand("RefreshObjects");
        this.refreshObjectMenuItem.addActionListener(this);
        this.guiUtils.applyIcon(this.refreshObjectMenuItem, "/images/nuvola/16x16/actions/reload.png");
        this.objectActionMenu.add(this.refreshObjectMenuItem);
        this.viewObjectPropertiesMenuItem = this.skinsFactory.createSkinnedJMenuItem("PropertiesMenuItem");
        this.viewObjectPropertiesMenuItem.setText("View file properties...");
        this.viewObjectPropertiesMenuItem.setActionCommand("ViewObjectProperties");
        this.viewObjectPropertiesMenuItem.addActionListener(this);
        this.guiUtils.applyIcon(this.viewObjectPropertiesMenuItem, "/images/nuvola/16x16/actions/viewmag.png");
        this.objectActionMenu.add(this.viewObjectPropertiesMenuItem);
        this.downloadObjectMenuItem = this.skinsFactory.createSkinnedJMenuItem("DownloadMenuItem");
        this.downloadObjectMenuItem.setText("Download file(s)...");
        this.downloadObjectMenuItem.setActionCommand("DownloadObjects");
        this.downloadObjectMenuItem.addActionListener(this);
        this.guiUtils.applyIcon(this.downloadObjectMenuItem, "/images/nuvola/16x16/actions/1downarrow.png");
        this.objectActionMenu.add(this.downloadObjectMenuItem);
        this.uploadFilesMenuItem = this.skinsFactory.createSkinnedJMenuItem("UploadMenuItem");
        this.uploadFilesMenuItem.setText("Upload file(s)...");
        this.uploadFilesMenuItem.setActionCommand("UploadFiles");
        this.uploadFilesMenuItem.addActionListener(this);
        this.guiUtils.applyIcon(this.uploadFilesMenuItem, "/images/nuvola/16x16/actions/1uparrow.png");
        this.objectActionMenu.add(this.uploadFilesMenuItem);
        this.objectActionMenu.add(new JSeparator());
        this.togglePublicMenuItem = this.skinsFactory.createSkinnedJMenuItem("AclToggleMenuItem");
        this.togglePublicMenuItem.setText("Change privacy setting...");
        this.togglePublicMenuItem.setActionCommand("TogglePublicPrivate");
        this.togglePublicMenuItem.addActionListener(this);
        this.guiUtils.applyIcon(this.togglePublicMenuItem, "/images/nuvola/16x16/actions/encrypted.png");
        this.objectActionMenu.add(this.togglePublicMenuItem);
        this.generatePublicGetUrl = this.skinsFactory.createSkinnedJMenuItem("PublicUrlMenuItem");
        this.generatePublicGetUrl.setText("Public web link...");
        this.generatePublicGetUrl.setActionCommand("GeneratePublicGetURL");
        this.generatePublicGetUrl.addActionListener(this);
        this.guiUtils.applyIcon(this.generatePublicGetUrl, "/images/nuvola/16x16/actions/wizard.png");
        this.objectActionMenu.add(this.generatePublicGetUrl);
        this.objectActionMenu.add(new JSeparator());
        this.deleteObjectMenuItem = this.skinsFactory.createSkinnedJMenuItem("DeleteMenuItem");
        this.deleteObjectMenuItem.setText("Delete file(s)...");
        this.deleteObjectMenuItem.setActionCommand("DeleteObjects");
        this.deleteObjectMenuItem.addActionListener(this);
        this.guiUtils.applyIcon(this.deleteObjectMenuItem, "/images/nuvola/16x16/actions/cancel.png");
        this.objectActionMenu.add(this.deleteObjectMenuItem);
        this.viewObjectPropertiesMenuItem.setEnabled(false);
        this.refreshObjectMenuItem.setEnabled(false);
        this.togglePublicMenuItem.setEnabled(false);
        this.downloadObjectMenuItem.setEnabled(false);
        this.generatePublicGetUrl.setEnabled(false);
        this.deleteObjectMenuItem.setEnabled(false);
        this.stackPanel.add((Component)this.loginPanel, "LoginPanel");
        this.stackPanel.add((Component)objectsPanel, "ObjectsPanel");
        int preferredWidth = 800;
        int preferredHeight = 600;
        this.setBounds(new Rectangle(new Dimension(preferredWidth, preferredHeight)));
        this.initDropTarget(new JComponent[]{objectsPanel});
        objectsPanel.getDropTarget().setActive(true);
    }

    private void initDropTarget(JComponent[] dropTargetComponents) {
        DropTargetListener dropTargetListener = new DropTargetListener(){

            private boolean checkValidDrag(DropTargetDragEvent dtde) {
                if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && (1 == dtde.getDropAction() || 2 == dtde.getDropAction())) {
                    dtde.acceptDrag(dtde.getDropAction());
                    return true;
                }
                dtde.rejectDrag();
                return false;
            }

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
                if (this.checkValidDrag(dtde)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CockpitLite.this.objectsTable.requestFocusInWindow();
                        }
                    });
                }
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
                this.checkValidDrag(dtde);
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dtde) {
                if (this.checkValidDrag(dtde)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CockpitLite.this.objectsTable.requestFocusInWindow();
                        }
                    });
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CockpitLite.this.ownerFrame.requestFocusInWindow();
                        }
                    });
                }
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CockpitLite.this.ownerFrame.requestFocusInWindow();
                    }
                });
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
                if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && (1 == dtde.getDropAction() || 2 == dtde.getDropAction())) {
                    dtde.acceptDrop(dtde.getDropAction());
                    try {
                        final List fileList = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                        if (fileList != null && fileList.size() > 0) {
                            new Thread(){

                                @Override
                                public void run() {
                                    CockpitLite.this.prepareForFilesUpload(fileList.toArray(new File[fileList.size()]));
                                }
                            }.start();
                        }
                    }
                    catch (Exception e) {
                        String message = "Unable to start accept dropped item(s)";
                        log.error((Object)message, (Throwable)e);
                        ErrorDialog.showDialog(CockpitLite.this.ownerFrame, null, CockpitLite.this.cockpitLiteProperties.getProperties(), message, (Throwable)e);
                    }
                } else {
                    dtde.rejectDrop();
                }
            }
        };
        for (int i = 0; i < dropTargetComponents.length; ++i) {
            new DropTarget(dropTargetComponents[i], 1, dropTargetListener, true);
        }
    }

    private void startProgressDialog(final String statusMessage, final String detailsText, final int minTaskValue, final int maxTaskValue, final String cancelButtonText, final CancelEventTrigger cancelEventListener) {
        if (this.progressDialog == null) {
            this.progressDialog = new ProgressDialog(this.ownerFrame, "Please wait...", this.cockpitLiteProperties.getProperties());
        }
        this.getContentPane().setCursor(new Cursor(3));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CockpitLite.this.progressDialog.startDialog(statusMessage, detailsText, minTaskValue, maxTaskValue, cancelEventListener, cancelButtonText);
            }
        });
    }

    private void updateProgressDialog(final String statusMessage, final String detailsText, final int progressValue) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CockpitLite.this.progressDialog.updateDialog(statusMessage, detailsText, progressValue);
            }
        });
    }

    private void stopProgressDialog() {
        this.getContentPane().setCursor(null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CockpitLite.this.progressDialog.stopDialog();
            }
        });
    }

    protected void startProgressPanel(Object operationId, String statusMessage, int maxCount, CancelEventTrigger cancelEventTrigger) {
        final ProgressPanel progressPanel = new ProgressPanel(this.cockpitLiteProperties.getProperties(), cancelEventTrigger);
        progressPanel.startProgress(statusMessage, 0, maxCount);
        this.progressPanelMap.put(operationId, progressPanel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CockpitLite.this.progressNotificationPanel.add((Component)progressPanel, new GridBagConstraints(0, CockpitLite.this.progressNotificationPanel.getComponents().length, 1, 1, 1.0, 0.0, 10, 2, CockpitLite.this.insetsZero, 0, 0));
                CockpitLite.this.progressNotificationPanel.revalidate();
            }
        });
    }

    protected void updateProgressPanel(Object operationId, final String statusMessage, final int currentCount) {
        final ProgressPanel progressPanel = (ProgressPanel)this.progressPanelMap.get(operationId);
        if (progressPanel != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    progressPanel.updateProgress(statusMessage, currentCount);
                }
            });
        }
    }

    protected void stopProgressPanel(Object operationId) {
        final ProgressPanel progressPanel = (ProgressPanel)this.progressPanelMap.get(operationId);
        if (progressPanel != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CockpitLite.this.progressNotificationPanel.remove(progressPanel);
                    CockpitLite.this.progressNotificationPanel.revalidate();
                    CockpitLite.this.progressPanelMap.remove(progressPanel);
                    progressPanel.dispose();
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.loginButton)) {
            new Thread(){

                @Override
                public void run() {
                    CockpitLite.this.listObjects();
                }
            }.start();
        } else if ("ViewObjectProperties".equals(event.getActionCommand())) {
            this.listObjectProperties();
        } else if ("RefreshObjects".equals(event.getActionCommand())) {
            new Thread(){

                @Override
                public void run() {
                    CockpitLite.this.listObjects();
                }
            }.start();
        } else if ("TogglePublicPrivate".equals(event.getActionCommand())) {
            new Thread(){

                @Override
                public void run() {
                    AccessControlList newAcl;
                    S3Object object = CockpitLite.this.getSelectedObjects()[0];
                    String aclStatus = CockpitLite.this.objectTableModel.getObjectAclStatus(object);
                    boolean originalAclWasPublic = CockpitLite.ACL_PUBLIC_DESCRIPTION.equals(aclStatus);
                    ToggleAclDialog dialog = new ToggleAclDialog(CockpitLite.this.ownerFrame, originalAclWasPublic, null, CockpitLite.this.cockpitLiteProperties.getProperties());
                    dialog.setVisible(true);
                    S3Object minimalObject = new S3Object(object.getKey());
                    AccessControlList accessControlList = newAcl = dialog.isPublicAclSet() ? AccessControlList.REST_CANNED_PUBLIC_READ : AccessControlList.REST_CANNED_PRIVATE;
                    if (newAcl != null) {
                        if (AccessControlList.REST_CANNED_PRIVATE.equals(newAcl)) {
                            minimalObject.addMetadata("x-amz-acl", "private");
                        } else if (AccessControlList.REST_CANNED_PUBLIC_READ.equals(newAcl)) {
                            minimalObject.addMetadata("x-amz-acl", "public-read");
                        }
                    }
                    CockpitLite.this.updateObjectsAccessControlLists(new S3Object[]{minimalObject}, newAcl);
                    dialog.dispose();
                }
            }.start();
        } else if ("GeneratePublicGetURL".equals(event.getActionCommand())) {
            this.generatePublicGetUrl();
        } else if ("DeleteObjects".equals(event.getActionCommand())) {
            this.deleteSelectedObjects();
        } else if ("DownloadObjects".equals(event.getActionCommand())) {
            try {
                this.downloadSelectedObjects();
            }
            catch (Exception ex) {
                String message = "Unable to download objects from S3";
                log.error((Object)message, (Throwable)ex);
                ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, this.cockpitLiteProperties.getProperties(), message, (Throwable)ex);
            }
        } else if ("UploadFiles".equals(event.getActionCommand())) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setMultiSelectionEnabled(true);
            fileChooser.setDialogTitle("Choose file(s) to upload");
            fileChooser.setFileSelectionMode(2);
            fileChooser.setApproveButtonText("Upload files");
            fileChooser.setCurrentDirectory(this.fileChoosersLastUploadDirectory);
            int returnVal = fileChooser.showOpenDialog(this.ownerFrame);
            if (returnVal != 0) {
                return;
            }
            final File[] uploadFiles = fileChooser.getSelectedFiles();
            if (uploadFiles.length == 0) {
                return;
            }
            this.fileChoosersLastUploadDirectory = uploadFiles[0].getParentFile();
            new Thread(){

                @Override
                public void run() {
                    CockpitLite.this.prepareForFilesUpload(uploadFiles);
                }
            }.start();
        } else if (event.getSource().equals(this.filterObjectsCheckBox)) {
            if (this.filterObjectsCheckBox.isSelected()) {
                this.filterObjectsPanel.setVisible(true);
            } else {
                this.filterObjectsPanel.setVisible(false);
                this.filterObjectsPrefix.setText("");
            }
        } else {
            log.warn((Object)("Unrecognised ActionEvent command '" + event.getActionCommand() + "' in " + event));
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (e.getSource().equals(this.objectsTable.getSelectionModel())) {
            this.objectSelectedAction();
        }
    }

    private void listObjects() {
        try {
            Properties loginProperties = this.userInputFields.getUserInputsAsProperties(true);
            for (String string : loginProperties.keySet()) {
                String propertyValue = loginProperties.getProperty(string);
                this.cockpitLiteProperties.setProperty(string, propertyValue);
            }
            this.startProgressPanel(this, "Finding files", 0, null);
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            hashMap.put("list-objects-in-bucket", "");
            hashMap.putAll(this.cockpitLiteProperties.getProperties());
            if (this.filterObjectsCheckBox.isSelected() && this.filterObjectsPrefix.getText().length() > 0) {
                hashMap.put("Prefix", this.filterObjectsPrefix.getText());
            }
            GatekeeperMessage responseMessage = this.gkClient.requestActionThroughGatekeeper(null, null, new S3Object[0], hashMap);
            this.stopProgressPanel(this);
            String gatekeeperErrorCode = responseMessage.getApplicationProperties().getProperty("gatekeeperErrorCode");
            if (gatekeeperErrorCode == null) {
                final S3Object[] objects = this.gkClient.buildS3ObjectsFromSignatureRequests(responseMessage.getSignatureRequests());
                final String accountDescription = responseMessage.getApplicationProperties().getProperty("AccountDescription");
                this.userCanUpload = "true".equalsIgnoreCase(responseMessage.getApplicationProperties().getProperty("UserCanUpload"));
                this.userCanDownload = "true".equalsIgnoreCase(responseMessage.getApplicationProperties().getProperty("UserCanDownload"));
                this.userCanDelete = "true".equalsIgnoreCase(responseMessage.getApplicationProperties().getProperty("UserCanDelete"));
                this.userCanACL = "true".equalsIgnoreCase(responseMessage.getApplicationProperties().getProperty("UserCanACL"));
                this.userBucketName = responseMessage.getApplicationProperties().getProperty("S3BucketName");
                this.userPath = responseMessage.getApplicationProperties().getProperty("UserPath", "");
                this.userVanityHost = responseMessage.getApplicationProperties().getProperty("UserVanityHost");
                this.objectTableModel.setUsersPath(this.userPath);
                this.uploadFilesMenuItem.setEnabled(this.userCanUpload);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CockpitLite.this.objectsHeadingLabel.setText(accountDescription != null ? accountDescription : "Logged in");
                        CockpitLite.this.objectTableModel.removeAllObjects();
                        CockpitLite.this.objectTableModel.addObjects(objects);
                        CockpitLite.this.updateObjectsSummary();
                        CockpitLite.this.refreshObjectMenuItem.setEnabled(true);
                        CockpitLite.this.lookupObjectsAccessControlLists(objects);
                    }
                });
                this.stackPanelCardLayout.show(this.stackPanel, "ObjectsPanel");
            } else {
                ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, this.cockpitLiteProperties.getProperties(), "Your log-in information was not correct, please try again", null);
            }
        }
        catch (Exception e) {
            this.stopProgressPanel(this);
            log.error((Object)("Gatekeeper login failed for URL: " + this.gkClient.getGatekeeperUrl()), (Throwable)e);
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, this.cockpitLiteProperties.getProperties(), "Log-in failed, please try again", (Throwable)e);
        }
    }

    private void listObjectProperties() {
        this.isViewingObjectProperties = true;
        this.retrieveObjectsDetails(this.getSelectedObjects());
    }

    @Override
    public void s3ServiceEventPerformed(GetObjectsEvent event) {
    }

    @Override
    public void s3ServiceEventPerformed(ListObjectsEvent event) {
    }

    @Override
    public void s3ServiceEventPerformed(DeleteVersionedObjectsEvent event) {
    }

    private void objectSelectedAction() {
        S3Object[] selectedObjects = this.getSelectedObjects();
        int count = selectedObjects.length;
        this.togglePublicMenuItem.setEnabled(this.userCanACL && count == 1);
        this.downloadObjectMenuItem.setEnabled(this.userCanDownload && count > 0);
        this.deleteObjectMenuItem.setEnabled(this.userCanDelete && count > 0);
        this.viewObjectPropertiesMenuItem.setEnabled(count > 0);
        this.generatePublicGetUrl.setEnabled(count == 1 && ACL_PUBLIC_DESCRIPTION.equals(this.objectTableModel.getObjectAclStatus(selectedObjects[0])));
    }

    private void updateObjectsSummary() {
        S3Object[] objects = this.objectTableModel.getObjects();
        try {
            String summary = "Please select a bucket";
            long totalBytes = 0L;
            if (objects != null) {
                summary = "<html>" + objects.length + " item" + (objects.length != 1 ? "s" : "");
                for (int i = 0; i < objects.length; ++i) {
                    totalBytes += objects[i].getContentLength();
                }
                if (totalBytes > 0L) {
                    summary = summary + ", " + this.byteFormatter.formatByteSize(totalBytes);
                }
                summary = summary + " @ " + this.timeSDF.format(new Date());
                if (this.isObjectFilteringActive()) {
                    summary = summary + " - <i>Search results</i>";
                }
                summary = summary + "</html>";
            }
            this.objectsSummaryLabel.setText(summary);
        }
        catch (Throwable t) {
            String message = "Unable to update object list summary";
            log.error((Object)message, t);
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, this.cockpitLiteProperties.getProperties(), message, t);
        }
    }

    private void showObjectPopupMenu(JComponent invoker, int xPos, int yPos) {
        if (this.getSelectedObjects().length == 0) {
            return;
        }
        this.objectActionMenu.show(invoker, xPos, yPos);
    }

    private S3Object[] getSelectedObjects() {
        int[] viewRows = this.objectsTable.getSelectedRows();
        if (viewRows.length == 0) {
            return new S3Object[0];
        }
        S3Object[] objects = new S3Object[viewRows.length];
        for (int i = 0; i < viewRows.length; ++i) {
            int modelRow = this.objectTableModelSorter.modelIndex(viewRows[i]);
            objects[i] = this.objectTableModel.getObject(modelRow);
        }
        return objects;
    }

    private void lookupObjectsAccessControlLists(final S3Object[] objects) {
        new Thread(){

            @Override
            public void run() {
                try {
                    SignatureRequest[] signatureRequests = CockpitLite.this.requestSignedRequests("acl-lookup", objects);
                    if (signatureRequests != null) {
                        String[] signedRequests = new String[signatureRequests.length];
                        for (int i = 0; i < signedRequests.length; ++i) {
                            signedRequests[i] = signatureRequests[i].getSignedUrl();
                        }
                        CockpitLite.this.s3ServiceMulti.getObjectsACLs(signedRequests);
                    } else {
                        ErrorDialog.showDialog(CockpitLite.this.ownerFrame, null, CockpitLite.this.cockpitLiteProperties.getProperties(), "Sorry, you do not have the permission to view object privacy settings", null);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Gatekeeper permissions check failed", (Throwable)e);
                    ErrorDialog.showDialog(CockpitLite.this.ownerFrame, null, CockpitLite.this.cockpitLiteProperties.getProperties(), "Permissions check failed, please try again", (Throwable)e);
                }
            }
        }.start();
    }

    @Override
    public void s3ServiceEventPerformed(final LookupACLEvent event) {
        if (1 == event.getEventCode()) {
            int threadCount = (int)event.getThreadWatcher().getThreadCount();
            this.startProgressPanel(event.getUniqueOperationId(), "Privacy lookup 0/" + threadCount, threadCount, event.getThreadWatcher().getCancelEventListener());
        } else if (3 == event.getEventCode()) {
            int threadCount = (int)event.getThreadWatcher().getThreadCount();
            int threadsCompleted = (int)event.getThreadWatcher().getCompletedThreads();
            this.updateProgressPanel(event.getUniqueOperationId(), "Privacy lookup " + threadsCompleted + "/" + threadCount, threadsCompleted);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    S3Object[] objectsWithAcl = event.getObjectsWithACL();
                    for (int i = 0; i < objectsWithAcl.length; ++i) {
                        String aclStatus = CockpitLite.getAclDescription(objectsWithAcl[i].getAcl());
                        CockpitLite.this.objectTableModel.updateObjectAclStatus(objectsWithAcl[i], aclStatus);
                    }
                }
            });
        } else if (2 == event.getEventCode()) {
            this.stopProgressPanel(event.getUniqueOperationId());
        } else if (4 == event.getEventCode()) {
            this.stopProgressPanel(event.getUniqueOperationId());
        } else if (0 == event.getEventCode()) {
            this.stopProgressPanel(event.getUniqueOperationId());
            String message = "Unable to lookup Access Control list for object(s)";
            log.error((Object)message, event.getErrorCause());
        }
    }

    private void updateObjectsAccessControlLists(final S3Object[] objectsToUpdate, final AccessControlList acl) {
        new Thread(){

            @Override
            public void run() {
                try {
                    SignatureRequest[] signatureRequests = CockpitLite.this.requestSignedRequests("acl-update", objectsToUpdate);
                    if (signatureRequests != null) {
                        String[] signedRequests = new String[signatureRequests.length];
                        for (int i = 0; i < signedRequests.length; ++i) {
                            signedRequests[i] = signatureRequests[i].getSignedUrl();
                        }
                        CockpitLite.this.s3ServiceMulti.putObjectsACLs(signedRequests, acl);
                    } else {
                        ErrorDialog.showDialog(CockpitLite.this.ownerFrame, null, CockpitLite.this.cockpitLiteProperties.getProperties(), "Sorry, you do not have the permission to change object privacy settings", null);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Gatekeeper permissions check failed", (Throwable)e);
                    ErrorDialog.showDialog(CockpitLite.this.ownerFrame, null, CockpitLite.this.cockpitLiteProperties.getProperties(), "Permissions check failed, please try again", (Throwable)e);
                }
            }
        }.start();
    }

    @Override
    public void s3ServiceEventPerformed(final UpdateACLEvent event) {
        if (1 == event.getEventCode()) {
            this.startProgressPanel(event.getUniqueOperationId(), "Privacy update 0/" + event.getThreadWatcher().getThreadCount(), (int)event.getThreadWatcher().getThreadCount(), event.getThreadWatcher().getCancelEventListener());
        } else if (3 == event.getEventCode()) {
            ThreadWatcher progressStatus = event.getThreadWatcher();
            String statusText = "Privacy update " + progressStatus.getCompletedThreads() + "/" + progressStatus.getThreadCount();
            this.updateProgressPanel(event.getUniqueOperationId(), statusText, (int)progressStatus.getCompletedThreads());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    S3Object[] objects = event.getObjectsWithUpdatedACL();
                    for (int i = 0; i < objects.length; ++i) {
                        String aclStatus = CockpitLite.getAclDescription(objects[i].getAcl());
                        CockpitLite.this.objectTableModel.updateObjectAclStatus(objects[i], aclStatus);
                        CockpitLite.this.objectSelectedAction();
                    }
                }
            });
        } else if (2 == event.getEventCode()) {
            this.stopProgressPanel(event.getUniqueOperationId());
        } else if (4 == event.getEventCode()) {
            this.stopProgressPanel(event.getUniqueOperationId());
        } else if (0 == event.getEventCode()) {
            this.stopProgressPanel(event.getUniqueOperationId());
            String message = "Unable to update Access Control List(s)";
            log.error((Object)message, event.getErrorCause());
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, this.cockpitLiteProperties.getProperties(), message, event.getErrorCause());
        }
    }

    private void downloadSelectedObjects() throws IOException {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Choose directory to save S3 files in");
        fileChooser.setFileSelectionMode(1);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setSelectedFile(this.downloadDirectory);
        int returnVal = fileChooser.showDialog(this.ownerFrame, "Choose Directory");
        if (returnVal != 0) {
            return;
        }
        this.downloadDirectory = fileChooser.getSelectedFile();
        this.prepareForObjectsDownload();
    }

    private void prepareForObjectsDownload() {
        Map<String, String> objectKeyToFilepathMap = null;
        try {
            boolean storeEmptyDirectories = Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME).getBoolProperty("uploads.storeEmptyDirectories", true);
            objectKeyToFilepathMap = FileComparer.getInstance().buildObjectKeyToFilepathMap(this.downloadDirectory.listFiles(), "", storeEmptyDirectories);
        }
        catch (Exception e) {
            String message = "Unable to review files in targetted download directory";
            log.error((Object)message, (Throwable)e);
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, this.cockpitLiteProperties.getProperties(), message, (Throwable)e);
            return;
        }
        this.filesAlreadyInDownloadDirectoryMap = new HashMap();
        this.s3DownloadObjectsMap = FileComparer.getInstance().populateObjectMap("", this.getSelectedObjects());
        ArrayList<S3Object> potentialClashingObjects = new ArrayList<S3Object>();
        Set<String> existingFilesObjectKeys = objectKeyToFilepathMap.keySet();
        for (Map.Entry entry : this.s3DownloadObjectsMap.entrySet()) {
            String objectKey = (String)entry.getKey();
            S3Object object = (S3Object)entry.getValue();
            if (object.getContentLength() == 0L || existingFilesObjectKeys.contains(objectKey)) {
                potentialClashingObjects.add(object);
            }
            if (!existingFilesObjectKeys.contains(objectKey)) continue;
            this.filesAlreadyInDownloadDirectoryMap.put(objectKey, objectKeyToFilepathMap.get(objectKey));
        }
        if (potentialClashingObjects.size() > 0) {
            final S3Object[] clashingObjects = potentialClashingObjects.toArray(new S3Object[potentialClashingObjects.size()]);
            new Thread(){

                @Override
                public void run() {
                    CockpitLite.this.isDownloadingObjects = true;
                    CockpitLite.this.retrieveObjectsDetails(clashingObjects);
                }
            }.start();
        } else {
            this.compareRemoteAndLocalFiles(this.filesAlreadyInDownloadDirectoryMap, this.s3DownloadObjectsMap, false);
        }
    }

    private void prepareForFilesUpload(File[] uploadFiles) {
        try {
            boolean storeEmptyDirectories = Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME).getBoolProperty("uploads.storeEmptyDirectories", true);
            this.objectKeyToFilepathMap = FileComparer.getInstance().buildObjectKeyToFilepathMap(uploadFiles, "", storeEmptyDirectories);
            ArrayList<S3Object> objectsWithExistingKeys = new ArrayList<S3Object>();
            StorageObject[] existingObjects = this.objectTableModel.getObjects();
            for (int i = 0; i < existingObjects.length; ++i) {
                if (!this.objectKeyToFilepathMap.containsKey(existingObjects[i].getKey())) continue;
                objectsWithExistingKeys.add(existingObjects[i]);
            }
            existingObjects = objectsWithExistingKeys.toArray(new S3Object[objectsWithExistingKeys.size()]);
            this.s3ExistingObjectsMap = FileComparer.getInstance().populateObjectMap("", existingObjects);
            if (existingObjects.length > 0) {
                StorageObject[] clashingObjects = existingObjects;
                new Thread((S3Object[])clashingObjects){
                    final /* synthetic */ S3Object[] val$clashingObjects;
                    {
                        this.val$clashingObjects = s3ObjectArray;
                    }

                    @Override
                    public void run() {
                        CockpitLite.this.isUploadingFiles = true;
                        CockpitLite.this.retrieveObjectsDetails(this.val$clashingObjects);
                    }
                }.start();
            } else {
                this.compareRemoteAndLocalFiles(this.objectKeyToFilepathMap, this.s3ExistingObjectsMap, true);
            }
        }
        catch (Exception e) {
            String message = "Unable to upload objects";
            log.error((Object)message, (Throwable)e);
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, this.cockpitLiteProperties.getProperties(), message, (Throwable)e);
        }
    }

    private void compareRemoteAndLocalFiles(final Map<String, String> objectKeyToFilepathMap, final Map s3ObjectsMap, final boolean upload) {
        final CockpitLite hyperlinkListener = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    final String statusText = "Comparing " + s3ObjectsMap.size() + " object" + (s3ObjectsMap.size() > 1 ? "s" : "") + " in S3 with " + objectKeyToFilepathMap.size() + " local file" + (objectKeyToFilepathMap.size() > 1 ? "s" : "");
                    CockpitLite.this.startProgressDialog(statusText, "", 0, 100, null, null);
                    File[] files = objectKeyToFilepathMap.values().toArray(new File[objectKeyToFilepathMap.size()]);
                    long[] filesSizeTotal = new long[1];
                    for (int i = 0; i < files.length; ++i) {
                        filesSizeTotal[0] = filesSizeTotal[0] + files[i].length();
                    }
                    BytesProgressWatcher progressWatcher = new BytesProgressWatcher(filesSizeTotal[0]){

                        @Override
                        public void updateBytesTransferred(long byteCount) {
                            super.updateBytesTransferred(byteCount);
                            String detailsText = CockpitLite.this.formatBytesProgressWatcherDetails(this, true);
                            int progressValue = (int)((double)this.getBytesTransferred() * 100.0 / (double)this.getBytesToTransfer());
                            CockpitLite.this.updateProgressDialog(statusText, detailsText, progressValue);
                        }
                    };
                    FileComparerResults comparisonResults = FileComparer.getInstance().buildDiscrepancyLists(objectKeyToFilepathMap, s3ObjectsMap, progressWatcher);
                    CockpitLite.this.stopProgressDialog();
                    if (upload) {
                        CockpitLite.this.performFilesUpload(comparisonResults, objectKeyToFilepathMap);
                    } else {
                        CockpitLite.this.performObjectsDownload(comparisonResults, s3ObjectsMap);
                    }
                }
                catch (RuntimeException e) {
                    CockpitLite.this.stopProgressDialog();
                    throw e;
                }
                catch (Exception e) {
                    CockpitLite.this.stopProgressDialog();
                    String message = "Unable to " + (upload ? "upload" : "download") + " objects";
                    log.error((Object)message, (Throwable)e);
                    ErrorDialog.showDialog(CockpitLite.this.ownerFrame, hyperlinkListener, CockpitLite.this.cockpitLiteProperties.getProperties(), message, (Throwable)e);
                }
            }
        }).start();
    }

    private void retrieveObjectsDetails(S3Object[] candidateObjects) {
        ArrayList<S3Object> s3ObjectsIncompleteList = new ArrayList<S3Object>();
        for (int i = 0; i < candidateObjects.length; ++i) {
            if (candidateObjects[i].isMetadataComplete()) continue;
            s3ObjectsIncompleteList.add(candidateObjects[i]);
        }
        log.debug((Object)("Of " + candidateObjects.length + " object candidates for HEAD requests " + s3ObjectsIncompleteList.size() + " are incomplete, performing requests for these only"));
        final S3Object[] incompleteObjects = s3ObjectsIncompleteList.toArray(new S3Object[s3ObjectsIncompleteList.size()]);
        new Thread(){

            @Override
            public void run() {
                try {
                    SignatureRequest[] signatureRequests = CockpitLite.this.requestSignedRequests("head", incompleteObjects);
                    if (signatureRequests != null) {
                        String[] signedRequests = new String[signatureRequests.length];
                        for (int i = 0; i < signedRequests.length; ++i) {
                            signedRequests[i] = signatureRequests[i].getSignedUrl();
                        }
                        CockpitLite.this.s3ServiceMulti.getObjectsHeads(signedRequests);
                    } else {
                        ErrorDialog.showDialog(CockpitLite.this.ownerFrame, null, CockpitLite.this.cockpitLiteProperties.getProperties(), "Sorry, you do not have the permission to view object details", null);
                    }
                }
                catch (Exception e) {
                    CockpitLite.this.stopProgressDialog();
                    log.error((Object)"Gatekeeper permissions check failed", (Throwable)e);
                    ErrorDialog.showDialog(CockpitLite.this.ownerFrame, null, CockpitLite.this.cockpitLiteProperties.getProperties(), "Permissions check failed, please try again", (Throwable)e);
                }
            }
        }.start();
    }

    private void performObjectsDownload(FileComparerResults comparisonResults, Map s3DownloadObjectsMap) {
        try {
            ArrayList<String> objectKeysForDownload = new ArrayList<String>();
            objectKeysForDownload.addAll(comparisonResults.onlyOnServerKeys);
            int newFiles = comparisonResults.onlyOnServerKeys.size();
            int unchangedFiles = comparisonResults.alreadySynchronisedKeys.size();
            int changedFiles = comparisonResults.updatedOnClientKeys.size() + comparisonResults.updatedOnServerKeys.size();
            if (unchangedFiles > 0 || changedFiles > 0) {
                Object response;
                log.debug((Object)"Files for download clash with existing local files, prompting user to choose which files to replace");
                ArrayList<String> options = new ArrayList<String>();
                String message = "Of the " + (newFiles + unchangedFiles + changedFiles) + " object(s) being downloaded:\n\n";
                if (newFiles > 0) {
                    message = message + newFiles + " file(s) are new.\n\n";
                    options.add(DOWNLOAD_NEW_FILES_ONLY);
                }
                if (changedFiles > 0) {
                    message = message + changedFiles + " file(s) have changed.\n\n";
                    options.add(DOWNLOAD_NEW_AND_CHANGED_FILES);
                }
                if (unchangedFiles > 0) {
                    message = message + unchangedFiles + " file(s) already exist and are unchanged.\n\n";
                    options.add(DOWNLOAD_ALL_FILES);
                }
                if ((response = JOptionPane.showInputDialog(this.ownerFrame, message = message + "Please choose which file(s) you wish to download:", "Replace file(s)?", 3, null, options.toArray(), DOWNLOAD_NEW_AND_CHANGED_FILES)) == null) {
                    return;
                }
                if (!DOWNLOAD_NEW_FILES_ONLY.equals(response)) {
                    if (DOWNLOAD_ALL_FILES.equals(response)) {
                        objectKeysForDownload.addAll(comparisonResults.updatedOnClientKeys);
                        objectKeysForDownload.addAll(comparisonResults.updatedOnServerKeys);
                        objectKeysForDownload.addAll(comparisonResults.alreadySynchronisedKeys);
                    } else if (DOWNLOAD_NEW_AND_CHANGED_FILES.equals(response)) {
                        objectKeysForDownload.addAll(comparisonResults.updatedOnClientKeys);
                        objectKeysForDownload.addAll(comparisonResults.updatedOnServerKeys);
                    } else {
                        return;
                    }
                }
            }
            log.debug((Object)("Downloading " + objectKeysForDownload.size() + " objects"));
            if (objectKeysForDownload.size() == 0) {
                return;
            }
            final S3Object[] objects = new S3Object[objectKeysForDownload.size()];
            int objectIndex = 0;
            Iterator iter = objectKeysForDownload.iterator();
            while (iter.hasNext()) {
                objects[objectIndex++] = (S3Object)s3DownloadObjectsMap.get(iter.next());
            }
            new Thread(){

                @Override
                public void run() {
                    try {
                        SignatureRequest[] signedRequests = CockpitLite.this.requestSignedRequests("get", objects);
                        if (signedRequests != null) {
                            CockpitLite.this.downloadObjectsToFileMap = new HashMap();
                            ArrayList<DownloadPackage> downloadPackageList = new ArrayList<DownloadPackage>();
                            for (int i = 0; i < signedRequests.length; ++i) {
                                DownloadPackage downloadPackage;
                                S3Object object = signedRequests[i].buildObject();
                                File file = new File(CockpitLite.this.downloadDirectory, object.getKey());
                                if (object.isDirectoryPlaceholder()) {
                                    file = new File(CockpitLite.this.downloadDirectory, ObjectUtils.convertDirPlaceholderKeyNameToDirName(objects[i].getKey()));
                                    file.mkdirs();
                                }
                                if ((downloadPackage = ObjectUtils.createPackageForDownload(object, file, true, false, null)) == null) continue;
                                downloadPackage.setSignedUrl(signedRequests[i].getSignedUrl());
                                CockpitLite.this.downloadObjectsToFileMap.put(object.getKey(), file);
                                downloadPackageList.add(downloadPackage);
                            }
                            DownloadPackage[] downloadPackagesArray = downloadPackageList.toArray(new DownloadPackage[downloadPackageList.size()]);
                            CockpitLite.this.s3ServiceMulti.downloadObjects(downloadPackagesArray);
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"Download failed", (Throwable)e);
                        ErrorDialog.showDialog(CockpitLite.this.ownerFrame, null, CockpitLite.this.cockpitLiteProperties.getProperties(), "Download failed, please try again", (Throwable)e);
                    }
                }
            }.start();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            String message = "Unable to download objects";
            log.error((Object)message, (Throwable)e);
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, this.cockpitLiteProperties.getProperties(), message, (Throwable)e);
        }
    }

    private SignatureRequest[] requestSignedRequests(String operationType, S3Object[] objects) {
        try {
            this.startProgressPanel(this, "Checking permissions", 0, null);
            GatekeeperMessage responseMessage = this.gkClient.requestActionThroughGatekeeper(operationType, this.userBucketName, objects, this.cockpitLiteProperties.getProperties());
            this.stopProgressPanel(this);
            String gatekeeperErrorCode = responseMessage.getApplicationProperties().getProperty("gatekeeperErrorCode");
            if (gatekeeperErrorCode == null) {
                for (int i = 0; i < responseMessage.getSignatureRequests().length; ++i) {
                    if (responseMessage.getSignatureRequests()[i].getSignedUrl() != null) continue;
                    return null;
                }
                return responseMessage.getSignatureRequests();
            }
            return null;
        }
        catch (Exception e) {
            this.stopProgressPanel(this);
            log.error((Object)"Gatekeeper permissions check failed", (Throwable)e);
            ErrorDialog.showDialog(this.ownerFrame, null, this.cockpitLiteProperties.getProperties(), "Permissions check failed, please try again", (Throwable)e);
            return null;
        }
    }

    @Override
    public void s3ServiceEventPerformed(DownloadObjectsEvent event) {
        if (1 == event.getEventCode()) {
            ThreadWatcher watcher = event.getThreadWatcher();
            if (watcher.isBytesTransferredInfoAvailable()) {
                this.startProgressPanel(event.getUniqueOperationId(), "Download " + this.byteFormatterTerse.formatByteSize(watcher.getBytesTransferred()) + "/" + this.byteFormatterTerse.formatByteSize(watcher.getBytesTotal()), 100, event.getThreadWatcher().getCancelEventListener());
            } else {
                this.startProgressPanel(event.getUniqueOperationId(), "Download " + event.getThreadWatcher().getCompletedThreads() + "/" + event.getThreadWatcher().getThreadCount(), (int)event.getThreadWatcher().getThreadCount(), event.getThreadWatcher().getCancelEventListener());
            }
        } else if (3 == event.getEventCode()) {
            ThreadWatcher watcher = event.getThreadWatcher();
            if (watcher.isBytesTransferredInfoAvailable()) {
                int percentage = (int)((double)watcher.getBytesTransferred() / (double)watcher.getBytesTotal() * 100.0);
                this.updateProgressPanel(event.getUniqueOperationId(), "Download " + this.byteFormatterTerse.formatByteSize(watcher.getBytesTransferred()) + "/" + this.byteFormatterTerse.formatByteSize(watcher.getBytesTotal()) + " (" + this.byteFormatterTerse.formatByteSize(watcher.getBytesPerSecond()) + "/s, " + this.timeFormatterTerse.formatTime(watcher.getTimeRemaining()) + ")", percentage);
            } else {
                ThreadWatcher progressStatus = event.getThreadWatcher();
                String statusText = "Download " + progressStatus.getCompletedThreads() + " of " + progressStatus.getThreadCount() + " objects";
                this.updateProgressPanel(event.getUniqueOperationId(), statusText, (int)progressStatus.getCompletedThreads());
            }
        } else if (2 == event.getEventCode()) {
            this.stopProgressPanel(event.getUniqueOperationId());
        } else if (4 == event.getEventCode()) {
            this.stopProgressPanel(event.getUniqueOperationId());
        } else if (0 == event.getEventCode()) {
            this.stopProgressPanel(event.getUniqueOperationId());
            String message = "Unable to download object(s)";
            log.error((Object)message, event.getErrorCause());
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, this.cockpitLiteProperties.getProperties(), message, event.getErrorCause());
        }
    }

    private void performFilesUpload(FileComparerResults comparisonResults, Map<String, String> objectKeyToFilepathMap) {
        try {
            ArrayList<String> fileKeysForUpload = new ArrayList<String>();
            fileKeysForUpload.addAll(comparisonResults.onlyOnClientKeys);
            int newFiles = comparisonResults.onlyOnClientKeys.size();
            int unchangedFiles = comparisonResults.alreadySynchronisedKeys.size();
            int changedFiles = comparisonResults.updatedOnClientKeys.size() + comparisonResults.updatedOnServerKeys.size();
            if (unchangedFiles > 0 || changedFiles > 0) {
                Object response;
                log.debug((Object)"Files for upload clash with existing S3 objects, prompting user to choose which files to replace");
                ArrayList<String> options = new ArrayList<String>();
                String message = "Of the " + objectKeyToFilepathMap.size() + " file(s) being uploaded:\n\n";
                if (newFiles > 0) {
                    message = message + newFiles + " file(s) are new.\n\n";
                    options.add(UPLOAD_NEW_FILES_ONLY);
                }
                if (changedFiles > 0) {
                    message = message + changedFiles + " file(s) have changed.\n\n";
                    options.add(UPLOAD_NEW_AND_CHANGED_FILES);
                }
                if (unchangedFiles > 0) {
                    message = message + unchangedFiles + " file(s) already exist and are unchanged.\n\n";
                    options.add(UPLOAD_ALL_FILES);
                }
                if ((response = JOptionPane.showInputDialog(this.ownerFrame, message = message + "Please choose which file(s) you wish to upload:", "Replace file(s)?", 3, null, options.toArray(), UPLOAD_NEW_AND_CHANGED_FILES)) == null) {
                    return;
                }
                if (!UPLOAD_NEW_FILES_ONLY.equals(response)) {
                    if (UPLOAD_ALL_FILES.equals(response)) {
                        fileKeysForUpload.addAll(comparisonResults.updatedOnClientKeys);
                        fileKeysForUpload.addAll(comparisonResults.updatedOnServerKeys);
                        fileKeysForUpload.addAll(comparisonResults.alreadySynchronisedKeys);
                    } else if (UPLOAD_NEW_AND_CHANGED_FILES.equals(response)) {
                        fileKeysForUpload.addAll(comparisonResults.updatedOnClientKeys);
                        fileKeysForUpload.addAll(comparisonResults.updatedOnServerKeys);
                    } else {
                        this.stopProgressDialog();
                        return;
                    }
                }
            }
            if (fileKeysForUpload.size() == 0) {
                return;
            }
            final String[] statusText = new String[]{"Prepared 0 of " + fileKeysForUpload.size() + " file(s) for upload"};
            this.startProgressDialog(statusText[0], "", 0, 100, null, null);
            long bytesToProcess = 0L;
            Iterator iter = fileKeysForUpload.iterator();
            while (iter.hasNext()) {
                File file = new File(objectKeyToFilepathMap.get(iter.next().toString()));
                bytesToProcess += file.length();
            }
            BytesProgressWatcher progressWatcher = new BytesProgressWatcher(bytesToProcess){

                @Override
                public void updateBytesTransferred(long byteCount) {
                    super.updateBytesTransferred(byteCount);
                    String detailsText = CockpitLite.this.formatBytesProgressWatcherDetails(this, false);
                    int progressValue = (int)((double)this.getBytesTransferred() * 100.0 / (double)this.getBytesToTransfer());
                    CockpitLite.this.updateProgressDialog(statusText[0], detailsText, progressValue);
                }
            };
            S3Object[] objects = new S3Object[fileKeysForUpload.size()];
            int objectIndex = 0;
            Iterator iter2 = fileKeysForUpload.iterator();
            while (iter2.hasNext()) {
                String fileKey = iter2.next().toString();
                File file = new File(objectKeyToFilepathMap.get(fileKey));
                S3Object newObject = ObjectUtils.createObjectForUpload(fileKey, file, null, false, progressWatcher);
                statusText[0] = "Prepared " + (objectIndex + 1) + " of " + fileKeysForUpload.size() + " file(s) for upload";
                objects[objectIndex++] = newObject;
            }
            this.stopProgressDialog();
            SignatureRequest[] signedRequests = this.requestSignedRequests("put", objects);
            if (signedRequests != null) {
                SignedUrlAndObject[] urlAndObjs = new SignedUrlAndObject[signedRequests.length];
                for (int i = 0; i < signedRequests.length; ++i) {
                    urlAndObjs[i] = new SignedUrlAndObject(signedRequests[i].getSignedUrl(), objects[i]);
                }
                this.s3ServiceMulti.putObjects(urlAndObjs);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.stopProgressDialog();
            String message = "Unable to upload object(s)";
            log.error((Object)message, (Throwable)e);
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, this.cockpitLiteProperties.getProperties(), message, (Throwable)e);
        }
    }

    @Override
    public void s3ServiceEventPerformed(final CreateObjectsEvent event) {
        if (1 == event.getEventCode()) {
            ThreadWatcher watcher = event.getThreadWatcher();
            if (watcher.isBytesTransferredInfoAvailable()) {
                this.startProgressPanel(event.getUniqueOperationId(), "Upload " + this.byteFormatterTerse.formatByteSize(watcher.getBytesTransferred()) + "/" + this.byteFormatterTerse.formatByteSize(watcher.getBytesTotal()), 100, event.getThreadWatcher().getCancelEventListener());
            } else {
                this.startProgressPanel(event.getUniqueOperationId(), "Upload 0/" + watcher.getThreadCount(), (int)watcher.getThreadCount(), event.getThreadWatcher().getCancelEventListener());
            }
        } else if (3 == event.getEventCode()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < event.getCreatedObjects().length; ++i) {
                        CockpitLite.this.objectTableModel.addObject(event.getCreatedObjects()[i]);
                    }
                }
            });
            ThreadWatcher watcher = event.getThreadWatcher();
            if (watcher.isBytesTransferredInfoAvailable()) {
                if (watcher.getBytesTransferred() >= watcher.getBytesTotal()) {
                    this.updateProgressPanel(event.getUniqueOperationId(), "Confirming", 100);
                } else {
                    int percentage = (int)((double)watcher.getBytesTransferred() / (double)watcher.getBytesTotal() * 100.0);
                    this.updateProgressPanel(event.getUniqueOperationId(), "Upload " + this.byteFormatterTerse.formatByteSize(watcher.getBytesTransferred()) + "/" + this.byteFormatterTerse.formatByteSize(watcher.getBytesTotal()) + " (" + this.byteFormatterTerse.formatByteSize(watcher.getBytesPerSecond()) + "/s, " + this.timeFormatterTerse.formatTime(watcher.getTimeRemaining()) + ")", percentage);
                }
            } else {
                ThreadWatcher progressStatus = event.getThreadWatcher();
                this.updateProgressPanel(event.getUniqueOperationId(), "Upload " + progressStatus.getCompletedThreads() + "/" + progressStatus.getThreadCount(), (int)progressStatus.getCompletedThreads());
            }
        } else if (2 == event.getEventCode()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CockpitLite.this.updateObjectsSummary();
                }
            });
            this.stopProgressPanel(event.getUniqueOperationId());
        } else if (4 == event.getEventCode()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CockpitLite.this.updateObjectsSummary();
                }
            });
            this.stopProgressPanel(event.getUniqueOperationId());
        } else if (0 == event.getEventCode()) {
            this.stopProgressPanel(event.getUniqueOperationId());
            String message = "Unable to upload object(s)";
            log.error((Object)message, event.getErrorCause());
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, this.cockpitLiteProperties.getProperties(), message, event.getErrorCause());
        }
    }

    private void generatePublicGetUrl() {
        S3Object[] objects = this.getSelectedObjects();
        if (objects.length != 1) {
            log.warn((Object)"Ignoring Generate Public URL object command, can only operate on a single object");
            return;
        }
        S3Object currentObject = objects[0];
        try {
            String hostAndBucket = null;
            if (this.userVanityHost != null) {
                hostAndBucket = this.userVanityHost;
            } else {
                boolean disableDnsBuckets = false;
                String s3Endpoint = Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME).getStringProperty("s3service.s3-endpoint", Constants.S3_DEFAULT_HOSTNAME);
                hostAndBucket = ServiceUtils.generateS3HostnameForBucket(this.userBucketName, disableDnsBuckets, s3Endpoint);
                if (!ServiceUtils.isBucketNameValidDNSName(this.userBucketName)) {
                    hostAndBucket = hostAndBucket + "/" + this.userBucketName;
                }
            }
            String url = "http://" + hostAndBucket + "/" + this.userPath + currentObject.getKey();
            String dialogText = "Public URL for '" + currentObject.getKey() + "'.";
            if (dialogText.length() < 150) {
                int charsShort = 150 - dialogText.length();
                StringBuffer padding = new StringBuffer();
                for (int i = 0; i < charsShort / 2; ++i) {
                    padding.append(" ");
                }
                dialogText = padding.toString() + dialogText + padding.toString();
            }
            JOptionPane.showInputDialog(this.ownerFrame, dialogText, "URL", 1, null, null, url);
        }
        catch (NumberFormatException e) {
            String message = "Hours must be a valid decimal value; eg 3, 0.1";
            log.error((Object)message, (Throwable)e);
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, this.cockpitLiteProperties.getProperties(), message, (Throwable)e);
        }
        catch (Exception e) {
            String message = "Unable to generate public GET URL";
            log.error((Object)message, (Throwable)e);
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, this.cockpitLiteProperties.getProperties(), message, (Throwable)e);
        }
    }

    private void deleteSelectedObjects() {
        final S3Object[] objects = this.getSelectedObjects();
        if (objects.length == 0) {
            log.warn((Object)"Ignoring delete object(s) command, no currently selected objects");
            return;
        }
        int response = JOptionPane.showConfirmDialog(this.ownerFrame, objects.length == 1 ? "Are you sure you want to delete '" + objects[0].getKey() + "'?" : "Are you sure you want to delete " + objects.length + " object(s)", "Delete Object(s)?", 0);
        if (response == 1) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    SignatureRequest[] signatureRequests = CockpitLite.this.requestSignedRequests("delete", objects);
                    if (signatureRequests != null) {
                        String[] signedRequests = new String[signatureRequests.length];
                        for (int i = 0; i < signedRequests.length; ++i) {
                            signedRequests[i] = signatureRequests[i].getSignedUrl();
                        }
                        CockpitLite.this.s3ServiceMulti.deleteObjects(signedRequests);
                    } else {
                        ErrorDialog.showDialog(CockpitLite.this.ownerFrame, null, CockpitLite.this.cockpitLiteProperties.getProperties(), "Sorry, you do not have the permission to delete files", null);
                    }
                }
                catch (Exception e) {
                    CockpitLite.this.stopProgressDialog();
                    log.error((Object)"Gatekeeper permissions check failed", (Throwable)e);
                    ErrorDialog.showDialog(CockpitLite.this.ownerFrame, null, CockpitLite.this.cockpitLiteProperties.getProperties(), "Permissions check failed, please try again", (Throwable)e);
                }
            }
        }.start();
    }

    @Override
    public void s3ServiceEventPerformed(final DeleteObjectsEvent event) {
        if (1 == event.getEventCode()) {
            this.startProgressDialog("Deleted 0 of " + event.getThreadWatcher().getThreadCount() + " object(s)", "", 0, (int)event.getThreadWatcher().getThreadCount(), "Cancel Delete Objects", event.getThreadWatcher().getCancelEventListener());
        } else if (3 == event.getEventCode()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < event.getDeletedObjects().length; ++i) {
                        CockpitLite.this.objectTableModel.removeObject(event.getDeletedObjects()[i]);
                    }
                }
            });
            ThreadWatcher progressStatus = event.getThreadWatcher();
            String statusText = "Deleted " + progressStatus.getCompletedThreads() + " of " + progressStatus.getThreadCount() + " object(s)";
            this.updateProgressDialog(statusText, "", (int)progressStatus.getCompletedThreads());
        } else if (2 == event.getEventCode()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CockpitLite.this.updateObjectsSummary();
                }
            });
            this.stopProgressDialog();
        } else if (4 == event.getEventCode()) {
            this.stopProgressDialog();
        } else if (0 == event.getEventCode()) {
            this.stopProgressDialog();
            String message = "Unable to delete object(s)";
            log.error((Object)message, event.getErrorCause());
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, this.cockpitLiteProperties.getProperties(), message, event.getErrorCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void s3ServiceEventPerformed(final GetObjectHeadsEvent event) {
        if (1 == event.getEventCode()) {
            if (event.getThreadWatcher().getThreadCount() > 0L) {
                this.startProgressDialog("Retrieved details for 0 of " + event.getThreadWatcher().getThreadCount() + " object(s)", "", 0, (int)event.getThreadWatcher().getThreadCount(), "Cancel Retrieval", event.getThreadWatcher().getCancelEventListener());
            }
        } else if (3 == event.getEventCode()) {
            ThreadWatcher progressStatus = event.getThreadWatcher();
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = CockpitLite.this.lock;
                    synchronized (object) {
                        for (int i = 0; i < event.getCompletedObjects().length; ++i) {
                            S3Object object2 = event.getCompletedObjects()[i];
                            int modelIndex = CockpitLite.this.objectTableModel.addObject(object2);
                            log.debug((Object)("Updated table with " + object2.getKey() + ", content-type=" + object2.getContentType()));
                            if (CockpitLite.this.isDownloadingObjects) {
                                CockpitLite.this.s3DownloadObjectsMap.put(object2.getKey(), object2);
                                log.debug((Object)("Updated object download list with " + object2.getKey() + ", content-type=" + object2.getContentType()));
                            } else if (CockpitLite.this.isUploadingFiles) {
                                CockpitLite.this.s3ExistingObjectsMap.put(object2.getKey(), object2);
                                log.debug((Object)("Updated object upload list with " + object2.getKey() + ", content-type=" + object2.getContentType()));
                            }
                            int viewIndex = CockpitLite.this.objectTableModelSorter.viewIndex(modelIndex);
                            if (!CockpitLite.this.isDownloadingObjects && !CockpitLite.this.isViewingObjectProperties) continue;
                            CockpitLite.this.objectsTable.addRowSelectionInterval(viewIndex, viewIndex);
                        }
                    }
                }
            });
            String statusText = "Retrieved details for " + progressStatus.getCompletedThreads() + " of " + progressStatus.getThreadCount() + " object(s)";
            this.updateProgressDialog(statusText, "", (int)progressStatus.getCompletedThreads());
        } else if (2 == event.getEventCode()) {
            this.stopProgressDialog();
            Object progressStatus = this.lock;
            synchronized (progressStatus) {
                if (this.isDownloadingObjects) {
                    this.compareRemoteAndLocalFiles(this.filesAlreadyInDownloadDirectoryMap, this.s3DownloadObjectsMap, false);
                    this.isDownloadingObjects = false;
                } else if (this.isUploadingFiles) {
                    this.compareRemoteAndLocalFiles(this.objectKeyToFilepathMap, this.s3ExistingObjectsMap, true);
                    this.isUploadingFiles = false;
                } else if (this.isViewingObjectProperties) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ItemPropertiesDialog.showDialog(CockpitLite.this.ownerFrame, CockpitLite.this.getSelectedObjects(), CockpitLite.this.cockpitLiteProperties.getProperties(), CockpitLite.this.userCanUpload && CockpitLite.this.userCanDownload && CockpitLite.this.userCanACL && CockpitLite.this.userCanDelete);
                            CockpitLite.this.isViewingObjectProperties = false;
                        }
                    });
                }
            }
        } else if (4 == event.getEventCode()) {
            this.stopProgressDialog();
        } else if (0 == event.getEventCode()) {
            this.stopProgressDialog();
            String message = "Unable to retrieve object(s) details";
            log.error((Object)message, event.getErrorCause());
            ErrorDialog.showDialog(this.ownerFrame, (HyperlinkActivatedListener)this, this.cockpitLiteProperties.getProperties(), message, event.getErrorCause());
        }
    }

    private String formatTransferDetails(ThreadWatcher watcher) {
        long bytesPerSecond = watcher.getBytesPerSecond();
        String detailsText = this.byteFormatter.formatByteSize(bytesPerSecond) + "/s";
        if (watcher.isTimeRemainingAvailable()) {
            long secondsRemaining = watcher.getTimeRemaining();
            detailsText = detailsText + " - Time remaining: " + this.timeFormatterTerse.formatTime(secondsRemaining);
        }
        return detailsText;
    }

    private String formatBytesProgressWatcherDetails(BytesProgressWatcher watcher, boolean includeBytes) {
        long secondsRemaining = watcher.getRemainingTime();
        String detailsText = (includeBytes ? this.byteFormatter.formatByteSize(watcher.getBytesTransferred()) + " of " + this.byteFormatter.formatByteSize(watcher.getBytesToTransfer()) + " - " : "") + "Time remaining: " + this.timeFormatterTerse.formatTime(secondsRemaining);
        return detailsText;
    }

    @Override
    public void followHyperlink(URL url, String target) {
        if (!this.isStandAloneApplication) {
            if (target == null) {
                this.getAppletContext().showDocument(url);
            } else {
                this.getAppletContext().showDocument(url, target);
            }
        } else {
            BareBonesBrowserLaunch.openURL(url.toString());
        }
    }

    public void setCredentials(AuthScope authscope, Credentials credentials) {
        this.mCredentialProvider.setCredentials(authscope, credentials);
    }

    public void clear() {
        this.mCredentialProvider.clear();
    }

    public Credentials getCredentials(AuthScope scope) {
        if (scope == null || scope.getScheme() == null) {
            return null;
        }
        Credentials credentials = this.mCredentialProvider.getCredentials(scope);
        if (credentials != null) {
            return credentials;
        }
        try {
            if (scope.getScheme().equals("ntlm")) {
                AuthenticationDialog pwDialog = new AuthenticationDialog(this.ownerFrame, "Authentication Required", "<html>Host <b>" + scope.getHost() + ":" + scope.getPort() + "</b> requires Windows authentication</html>", true);
                pwDialog.setVisible(true);
                if (pwDialog.getUser().length() > 0) {
                    credentials = new NTCredentials(pwDialog.getUser(), pwDialog.getPassword(), scope.getHost(), pwDialog.getDomain());
                }
                pwDialog.dispose();
            } else if (scope.getScheme().equals("basic") || scope.getScheme().equals("digest")) {
                AuthenticationDialog pwDialog = new AuthenticationDialog(this.ownerFrame, "Authentication Required", "<html><center>Host <b>" + scope.getHost() + ":" + scope.getPort() + "</b> requires authentication for the realm:<br><b>" + scope.getRealm() + "</b></center></html>", false);
                pwDialog.setVisible(true);
                if (pwDialog.getUser().length() > 0) {
                    credentials = new UsernamePasswordCredentials(pwDialog.getUser(), pwDialog.getPassword());
                }
                pwDialog.dispose();
            } else {
                throw new InvalidCredentialsException("Unsupported authentication scheme: " + scope.getScheme());
            }
            if (credentials != null) {
                this.mCredentialProvider.setCredentials(scope, credentials);
            }
            return credentials;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private boolean isObjectFilteringActive() {
        if (!this.filterObjectsCheckBox.isSelected()) {
            return false;
        }
        return this.filterObjectsPrefix.getText().length() > 0;
    }

    @Override
    public void s3ServiceEventPerformed(CreateBucketsEvent event) {
    }

    @Override
    public void s3ServiceEventPerformed(CopyObjectsEvent event) {
    }

    public static String getAclDescription(AccessControlList acl) {
        if (acl == null) {
            return ACL_UNKNOWN_DESCRIPTION;
        }
        for (GrantAndPermission gap : acl.getGrantAndPermissions()) {
            if (!GroupGrantee.ALL_USERS.equals(gap.getGrantee()) || !Permission.PERMISSION_READ.equals(gap.getPermission())) continue;
            return ACL_PUBLIC_DESCRIPTION;
        }
        if (AccessControlList.REST_CANNED_PUBLIC_READ.equals(acl)) {
            return ACL_PUBLIC_DESCRIPTION;
        }
        return ACL_PRIVATE_DESCRIPTION;
    }

    public static void main(String[] args) throws Exception {
        JFrame ownerFrame = new JFrame("JetS3t Cockpit-Lite");
        ownerFrame.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                e.getWindow().dispose();
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        Properties argumentProperties = new Properties();
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                int delimIndex = arg.indexOf("=");
                if (delimIndex >= 0) {
                    String name = arg.substring(0, delimIndex);
                    String value = arg.substring(delimIndex + 1);
                    argumentProperties.put(name, value);
                    continue;
                }
                System.out.println("Ignoring property argument with incorrect format: " + arg);
            }
        }
        new CockpitLite(ownerFrame, argumentProperties);
    }

    private class ContextMenuListener
    extends MouseAdapter {
        private ContextMenuListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.showContextMenu(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.showContextMenu(e);
        }

        private void showContextMenu(MouseEvent e) {
            if (e.isPopupTrigger()) {
                JTable jTable;
                int rowIndex;
                if (e.getSource() instanceof JList) {
                    JList jList = (JList)e.getSource();
                    int locIndex = jList.locationToIndex(e.getPoint());
                    if (locIndex >= 0) {
                        jList.setSelectedIndex(locIndex);
                    }
                } else if (e.getSource() instanceof JTable && (rowIndex = (jTable = (JTable)e.getSource()).rowAtPoint(e.getPoint())) >= 0) {
                    jTable.addRowSelectionInterval(rowIndex, rowIndex);
                }
                if (e.getSource().equals(CockpitLite.this.objectsTable)) {
                    CockpitLite.this.showObjectPopupMenu((JComponent)e.getSource(), e.getX(), e.getY());
                }
            }
        }
    }
}

