/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Redundancy;
import ch.cyberduck.core.googlestorage.GoogleStorageAttributesFinderFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageExceptionMappingService;
import ch.cyberduck.core.googlestorage.GoogleStoragePathContainerService;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.preferences.PreferencesFactory;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.StorageObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public class GoogleStorageStorageClassFeature
implements Redundancy {
    private final GoogleStorageSession session;
    private final PathContainerService containerService = new GoogleStoragePathContainerService();

    public GoogleStorageStorageClassFeature(GoogleStorageSession session) {
        this.session = session;
    }

    public String getDefault() {
        return PreferencesFactory.get().getProperty("googlestorage.storage.class");
    }

    public Set<String> getClasses() {
        return new LinkedHashSet<String>(Arrays.asList("STANDARD", "MULTI_REGIONAL", "REGIONAL", "NEARLINE", "COLDLINE"));
    }

    public String getClass(Path file) throws BackgroundException {
        return new GoogleStorageAttributesFinderFeature(this.session).find(file).getStorageClass();
    }

    public void setClass(Path file, String redundancy) throws BackgroundException {
        try {
            if (this.containerService.isContainer(file)) {
                ((Storage)this.session.getClient()).buckets().patch(this.containerService.getContainer(file).getName(), new Bucket().setStorageClass(redundancy)).execute();
            } else {
                ((Storage)this.session.getClient()).objects().rewrite(this.containerService.getContainer(file).getName(), this.containerService.getKey(file), this.containerService.getContainer(file).getName(), this.containerService.getKey(file), new StorageObject().setStorageClass(redundancy)).execute();
            }
        }
        catch (IOException e) {
            throw new GoogleStorageExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
    }
}

