/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.googlestorage.GoogleStorageExceptionMappingService;
import ch.cyberduck.core.googlestorage.GoogleStoragePathContainerService;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.googlestorage.GoogleStorageUriEncoder;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.http.HttpMethodReleaseInputStream;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.services.storage.Storage;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.apache.log4j.Logger;

public class GoogleStorageReadFeature
implements Read {
    private static final Logger log = Logger.getLogger(GoogleStorageReadFeature.class);
    private final PathContainerService containerService = new GoogleStoragePathContainerService();
    private final GoogleStorageSession session;

    public GoogleStorageReadFeature(GoogleStorageSession session) {
        this.session = session;
    }

    public boolean offset(Path file) {
        return true;
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            if (0L == status.getLength()) {
                return new NullInputStream(0L);
            }
            StringBuilder uri = new StringBuilder(String.format("%sstorage/v1/b/%s/o/%s?alt=media", ((Storage)this.session.getClient()).getRootUrl(), this.containerService.getContainer(file).getName(), GoogleStorageUriEncoder.encode(this.containerService.getKey(file))));
            if (StringUtils.isNotBlank((CharSequence)file.attributes().getVersionId())) {
                uri.append(String.format("?generation=%s", file.attributes().getVersionId()));
            }
            HttpGet request = new HttpGet(uri.toString());
            request.addHeader("Content-Type", "application/json; charset=UTF-8");
            if (status.isAppend()) {
                HttpRange range = HttpRange.withStatus((TransferStatus)status);
                String header = -1L == range.getEnd() ? String.format("bytes=%d-", range.getStart()) : String.format("bytes=%d-%d", range.getStart(), range.getEnd());
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Add range header %s for file %s", header, file));
                }
                request.addHeader((Header)new BasicHeader("Range", header));
                request.addHeader((Header)new BasicHeader("Accept-Encoding", "identity"));
            }
            HttpClient client = this.session.getHttpClient();
            HttpResponse response = client.execute((HttpUriRequest)request);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: 
                case 206: {
                    return new HttpMethodReleaseInputStream(response);
                }
            }
            throw new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
        }
        catch (IOException e) {
            throw new GoogleStorageExceptionMappingService().map("Download {0} failed", e, file);
        }
    }
}

