/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.googlestorage.GoogleStorageAttributesFinderFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageExceptionMappingService;
import ch.cyberduck.core.googlestorage.GoogleStoragePathContainerService;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.googlestorage.GoogleStorageWriteFeature;
import ch.cyberduck.core.io.DefaultStreamCloser;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Bucket;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;

public class GoogleStorageDirectoryFeature
implements Directory<VersionId> {
    private static final String MIMETYPE = "application/x-directory";
    private final PathContainerService containerService = new GoogleStoragePathContainerService();
    private final GoogleStorageSession session;
    private Write<VersionId> writer;

    public GoogleStorageDirectoryFeature(GoogleStorageSession session) {
        this.session = session;
        this.writer = new GoogleStorageWriteFeature(session);
    }

    public Path mkdir(Path folder, String location, TransferStatus status) throws BackgroundException {
        try {
            if (this.containerService.isContainer(folder)) {
                Bucket bucket = (Bucket)((Storage)this.session.getClient()).buckets().insert(this.session.getHost().getCredentials().getUsername(), new Bucket().setLocation(location).setStorageClass(status.getStorageClass()).setName(new GoogleStoragePathContainerService().getContainer(folder).getName())).execute();
                EnumSet<AbstractPath.Type> type = EnumSet.copyOf(folder.getType());
                type.add(AbstractPath.Type.volume);
                return new Path(folder.getParent(), folder.getName(), type, new GoogleStorageAttributesFinderFeature(this.session).toAttributes(bucket));
            }
            status.setMime(MIMETYPE);
            EnumSet type = EnumSet.copyOf(folder.getType());
            StatusOutputStream out = this.writer.write(new Path(folder.getParent(), folder.getName(), type, new PathAttributes(folder.attributes())), status, (ConnectionCallback)new DisabledConnectionCallback());
            new DefaultStreamCloser().close((OutputStream)out);
            return new Path(folder.getParent(), folder.getName(), type, folder.attributes().withVersionId(((VersionId)out.getStatus()).id));
        }
        catch (IOException e) {
            throw new GoogleStorageExceptionMappingService().map("Cannot create folder {0}", e, folder);
        }
    }

    public Directory<VersionId> withWriter(Write<VersionId> writer) {
        this.writer = writer;
        return this;
    }
}

