/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DescriptiveUrlBag;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.WebUrlProvider;
import ch.cyberduck.core.b2.B2PathContainerService;
import ch.cyberduck.core.b2.B2Session;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Locale;
import synapticloop.b2.B2ApiClient;

public class B2UrlProvider
implements UrlProvider {
    private final PathContainerService containerService = new B2PathContainerService();
    private final B2Session session;

    public B2UrlProvider(B2Session session) {
        this.session = session;
    }

    public DescriptiveUrlBag toUrl(Path file) {
        if (file.isVolume()) {
            return DescriptiveUrlBag.empty();
        }
        DescriptiveUrlBag list = new DescriptiveUrlBag();
        if (file.isFile()) {
            String download = String.format("%s/file/%s/%s", ((B2ApiClient)this.session.getClient()).getDownloadUrl(), URIEncoder.encode((String)this.containerService.getContainer(file).getName()), URIEncoder.encode((String)this.containerService.getKey(file)));
            list.add(new DescriptiveUrl(URI.create(download), DescriptiveUrl.Type.http, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), Scheme.https.name().toUpperCase(Locale.ROOT))));
            list.addAll((Collection)new WebUrlProvider(this.session.getHost()).toUrl(file));
        }
        return list;
    }
}

