/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxPathContainerService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.PromptUrlProvider;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.files.CommitInfo;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class DropboxTemporaryUrlProvider
implements PromptUrlProvider<Void, Void> {
    private static final Logger log = Logger.getLogger(DropboxTemporaryUrlProvider.class);
    private final DropboxSession session;
    private final PathContainerService containerService = new DropboxPathContainerService();

    public DropboxTemporaryUrlProvider(DropboxSession session) {
        this.session = session;
    }

    public DescriptiveUrl toDownloadUrl(Path file, Void options, PasswordCallback callback) throws BackgroundException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Create temporary link for %s", file));
            }
            String link = new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient(file)).getTemporaryLink(this.containerService.getKey(file)).getLink();
            Calendar expiry = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            expiry.add(10, 4);
            return new DescriptiveUrl(URI.create(link), DescriptiveUrl.Type.signed, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Temporary", (String)"S3")) + " (" + MessageFormat.format(LocaleFactory.localizedString((String)"Expires {0}", (String)"S3") + ")", UserDateFormatterFactory.get().getMediumFormat(expiry.getTimeInMillis())));
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map(e);
        }
    }

    public DescriptiveUrl toUploadUrl(Path file, Void options, PasswordCallback callback) throws BackgroundException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Create temporary upload link for %s", file));
            }
            String link = new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient(file)).getTemporaryUploadLink(new CommitInfo(this.containerService.getKey(file))).getLink();
            return new DescriptiveUrl(URI.create(link), DescriptiveUrl.Type.signed, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Temporary", (String)"S3")));
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map(e);
        }
    }

    public boolean isSupported(Path file, PromptUrlProvider.Type type) {
        switch (type) {
            case download: {
                return file.isFile();
            }
        }
        return true;
    }
}

