/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp.openssh;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.local.LocalTouchFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sftp.PreferencesHostKeyVerifier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.transport.verification.OpenSSHKnownHosts;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public abstract class OpenSSHHostKeyVerifier
extends PreferencesHostKeyVerifier {
    private static final Logger log = Logger.getLogger(OpenSSHHostKeyVerifier.class);
    protected OpenSSHKnownHosts database;
    private final Local file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public OpenSSHHostKeyVerifier(Local file) {
        this.file = file;
        InputStream in = null;
        try {
            if (!file.exists()) {
                LocalTouchFactory.get().touch(file);
            }
            in = file.getInputStream();
            this.database = new OpenSSHKnownHosts(new File(file.getAbsolute()));
        }
        catch (IOException | SSHRuntimeException e) {
            log.error((Object)String.format("Cannot read known hosts file %s", file), e);
            IOUtils.closeQuietly((InputStream)in);
        }
        catch (AccessDeniedException e2) {
            log.warn((Object)String.format("Failure reading %s", file));
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    @Override
    public boolean verify(Host host, PublicKey key) throws ConnectionCanceledException, ChecksumException {
        if (null == this.database) {
            log.warn((Object)String.format("Missing database %s", this.database));
            return super.verify(host, key);
        }
        KeyType type = KeyType.fromKey((Key)key);
        if (type == KeyType.UNKNOWN) {
            return false;
        }
        boolean foundApplicableHostEntry = false;
        for (OpenSSHKnownHosts.KnownHostEntry entry : this.database.entries()) {
            try {
                if (!entry.appliesTo(type, OpenSSHHostKeyVerifier.format(host))) continue;
                foundApplicableHostEntry = true;
                if (!entry.verify(key)) continue;
                return true;
            }
            catch (IOException e) {
                log.error((Object)String.format("Failure verifying host key entry %s. %s", entry, e.getMessage()));
                return false;
            }
        }
        if (foundApplicableHostEntry) {
            try {
                return this.isChangedKeyAccepted(host, key);
            }
            catch (ChecksumException | ConnectionCanceledException e) {
                return false;
            }
        }
        try {
            return this.isUnknownKeyAccepted(host, key);
        }
        catch (ChecksumException | ConnectionCanceledException e) {
            return false;
        }
    }

    @Override
    public void allow(Host host, PublicKey key, boolean persist) {
        if (null == this.database) {
            log.warn((Object)String.format("Missing database %s", this.database));
            super.allow(host, key, persist);
        } else {
            try {
                OpenSSHKnownHosts.HostEntry entry = new OpenSSHKnownHosts.HostEntry(null, OpenSSHHostKeyVerifier.format(host), KeyType.fromKey((Key)key), key);
                this.database.entries().add(entry);
                if (persist && this.file.attributes().getPermission().isWritable()) {
                    this.database.write((OpenSSHKnownHosts.KnownHostEntry)entry);
                }
            }
            catch (IOException e) {
                log.error((Object)String.format("Failure adding host key to database: %s", e.getMessage()));
                super.allow(host, key, persist);
            }
        }
    }

    private static String format(Host host) throws IOException {
        String hostname = host.getPort() != 22 ? String.format("[%s]:%d", host.getHostname(), host.getPort()) : host.getHostname();
        return PreferencesFactory.get().getBoolean("ssh.knownhosts.hostname.hash") ? OpenSSHHostKeyVerifier.hash(hostname) : hostname;
    }

    private static String hash(String hostname) throws IOException {
        byte[] hash;
        MessageDigest sha1;
        try {
            sha1 = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        byte[] salt = new byte[sha1.getDigestLength()];
        new SecureRandom().nextBytes(salt);
        try {
            hash = OpenSSHHostKeyVerifier.hmacSha1Hash(salt, hostname);
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        String base64_salt = new String(Base64.encodeBase64((byte[])salt));
        String base64_hash = new String(Base64.encodeBase64((byte[])hash));
        return String.format("|1|%s|%s", base64_salt, base64_hash);
    }

    private static byte[] hmacSha1Hash(byte[] salt, String hostname) throws IOException {
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(salt, 0, salt.length, mac.getAlgorithm()));
            mac.update(hostname.getBytes());
            return mac.doFinal();
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OpenSSHHostKeyVerifier{");
        sb.append("database=").append(this.database);
        sb.append(", file=").append(this.file);
        sb.append('}');
        return sb.toString();
    }
}

