/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp.parser;

import ch.cyberduck.core.ftp.parser.FTPExtendedFile;
import java.text.ParseException;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.parser.ConfigurableFTPFileEntryParserImpl;
import org.apache.log4j.Logger;

public abstract class CommonUnixFTPEntryParser
extends ConfigurableFTPFileEntryParserImpl {
    private static final Logger log = Logger.getLogger(CommonUnixFTPEntryParser.class);

    public CommonUnixFTPEntryParser(String regex) {
        super(regex);
    }

    protected FTPClientConfig getDefaultConfiguration() {
        FTPClientConfig config = new FTPClientConfig("UNIX", "MMM d yyyy", "MMM d HH:mm", null, null, null);
        config.setLenientFutureDates(true);
        return config;
    }

    protected FTPFile parseFTPEntry(String typeStr, String usr, String grp, String filesize, String datestr, String name, String endtoken) {
        try {
            return this.parseFTPEntry(typeStr, usr, grp, Long.parseLong(filesize), datestr, name, endtoken);
        }
        catch (NumberFormatException numberFormatException) {
            return this.parseFTPEntry(typeStr, usr, grp, -1L, datestr, name, endtoken);
        }
    }

    protected FTPFile parseFTPEntry(String typeStr, String usr, String grp, long filesize, String datestr, String name, String endtoken) {
        int type;
        FTPExtendedFile file = new FTPExtendedFile();
        try {
            file.setTimestamp(this.parseTimestamp(datestr));
        }
        catch (ParseException e) {
            log.warn((Object)e.getMessage());
        }
        switch (typeStr.charAt(0)) {
            case 'd': {
                type = 1;
                break;
            }
            case 'l': {
                type = 2;
                break;
            }
            case '-': 
            case 'b': 
            case 'c': 
            case 'f': {
                type = 0;
                break;
            }
            default: {
                type = 3;
            }
        }
        file.setType(type);
        file.setUser(usr);
        file.setGroup(grp);
        int g = 4;
        int access = 0;
        while (access < 3) {
            file.setPermission(access, 0, !this.group(g).equals("-"));
            file.setPermission(access, 1, !this.group(g + 1).equals("-"));
            String execPerm = this.group(g + 2);
            if (execPerm.equals("-")) {
                file.setPermission(access, 2, false);
            } else {
                file.setPermission(access, 2, Character.isLowerCase(execPerm.charAt(0)));
                if (0 == access) {
                    file.setSetuid(execPerm.charAt(0) == 's' || execPerm.charAt(0) == 'S');
                }
                if (1 == access) {
                    file.setSetgid(execPerm.charAt(0) == 's' || execPerm.charAt(0) == 'S');
                }
                if (2 == access) {
                    file.setSticky(execPerm.charAt(0) == 't' || execPerm.charAt(0) == 'T');
                }
            }
            ++access;
            g += 4;
        }
        file.setSize(filesize);
        if (null == endtoken) {
            file.setName(name);
        } else {
            name = name + endtoken;
            if (type == 2) {
                int end = name.indexOf(" -> ");
                if (end == -1) {
                    file.setName(name);
                } else {
                    file.setName(name.substring(0, end));
                    file.setLink(name.substring(end + 4));
                }
            } else {
                file.setName(name);
            }
        }
        return file;
    }
}

