/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Request model for restoring deleted nodes")
public class RestoreDeletedNodesRequest {
    @JsonProperty(value="deletedNodeIds")
    private List<Long> deletedNodeIds = new ArrayList<Long>();
    @JsonProperty(value="resolutionStrategy")
    private ResolutionStrategyEnum resolutionStrategy = ResolutionStrategyEnum.AUTORENAME;
    @JsonProperty(value="keepShareLinks")
    private Boolean keepShareLinks = false;
    @JsonProperty(value="parentId")
    private Long parentId = null;

    public RestoreDeletedNodesRequest deletedNodeIds(List<Long> deletedNodeIds) {
        this.deletedNodeIds = deletedNodeIds;
        return this;
    }

    public RestoreDeletedNodesRequest addDeletedNodeIdsItem(Long deletedNodeIdsItem) {
        this.deletedNodeIds.add(deletedNodeIdsItem);
        return this;
    }

    @Schema(required=true, description="List of deleted node IDs")
    public List<Long> getDeletedNodeIds() {
        return this.deletedNodeIds;
    }

    public void setDeletedNodeIds(List<Long> deletedNodeIds) {
        this.deletedNodeIds = deletedNodeIds;
    }

    public RestoreDeletedNodesRequest resolutionStrategy(ResolutionStrategyEnum resolutionStrategy) {
        this.resolutionStrategy = resolutionStrategy;
        return this;
    }

    @Schema(description="Node conflict resolution strategy:  * `autorename`  * `overwrite`  * `fail`")
    public ResolutionStrategyEnum getResolutionStrategy() {
        return this.resolutionStrategy;
    }

    public void setResolutionStrategy(ResolutionStrategyEnum resolutionStrategy) {
        this.resolutionStrategy = resolutionStrategy;
    }

    public RestoreDeletedNodesRequest keepShareLinks(Boolean keepShareLinks) {
        this.keepShareLinks = keepShareLinks;
        return this;
    }

    @Schema(description="Preserve Download Share Links and point them to the new node.")
    public Boolean isKeepShareLinks() {
        return this.keepShareLinks;
    }

    public void setKeepShareLinks(Boolean keepShareLinks) {
        this.keepShareLinks = keepShareLinks;
    }

    public RestoreDeletedNodesRequest parentId(Long parentId) {
        this.parentId = parentId;
        return this;
    }

    @Schema(description="Node parent ID  (default: previous parent ID)")
    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestoreDeletedNodesRequest restoreDeletedNodesRequest = (RestoreDeletedNodesRequest)o;
        return Objects.equals(this.deletedNodeIds, restoreDeletedNodesRequest.deletedNodeIds) && Objects.equals((Object)this.resolutionStrategy, (Object)restoreDeletedNodesRequest.resolutionStrategy) && Objects.equals(this.keepShareLinks, restoreDeletedNodesRequest.keepShareLinks) && Objects.equals(this.parentId, restoreDeletedNodesRequest.parentId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deletedNodeIds, this.resolutionStrategy, this.keepShareLinks, this.parentId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RestoreDeletedNodesRequest {\n");
        sb.append("    deletedNodeIds: ").append(this.toIndentedString(this.deletedNodeIds)).append("\n");
        sb.append("    resolutionStrategy: ").append(this.toIndentedString((Object)this.resolutionStrategy)).append("\n");
        sb.append("    keepShareLinks: ").append(this.toIndentedString(this.keepShareLinks)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ResolutionStrategyEnum {
        AUTORENAME("autorename"),
        OVERWRITE("overwrite"),
        FAIL("fail");

        private String value;

        private ResolutionStrategyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResolutionStrategyEnum fromValue(String text) {
            for (ResolutionStrategyEnum b : ResolutionStrategyEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

