/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Infrastructure properties")
public class InfrastructureProperties {
    @JsonProperty(value="smsConfigEnabled")
    private Boolean smsConfigEnabled = null;
    @JsonProperty(value="mediaServerConfigEnabled")
    private Boolean mediaServerConfigEnabled = null;
    @JsonProperty(value="s3DefaultRegion")
    private String s3DefaultRegion = null;
    @JsonProperty(value="s3EnforceDirectUpload")
    private Boolean s3EnforceDirectUpload = null;
    @JsonProperty(value="isDracoonCloud")
    private Boolean isDracoonCloud = null;
    @JsonProperty(value="tenantUuid")
    private String tenantUuid = null;

    public InfrastructureProperties smsConfigEnabled(Boolean smsConfigEnabled) {
        this.smsConfigEnabled = smsConfigEnabled;
        return this;
    }

    @Schema(description="Allow sending of share passwords via SMS")
    public Boolean isSmsConfigEnabled() {
        return this.smsConfigEnabled;
    }

    public void setSmsConfigEnabled(Boolean smsConfigEnabled) {
        this.smsConfigEnabled = smsConfigEnabled;
    }

    public InfrastructureProperties mediaServerConfigEnabled(Boolean mediaServerConfigEnabled) {
        this.mediaServerConfigEnabled = mediaServerConfigEnabled;
        return this;
    }

    @Schema(description="Determines if the media server is enabled")
    public Boolean isMediaServerConfigEnabled() {
        return this.mediaServerConfigEnabled;
    }

    public void setMediaServerConfigEnabled(Boolean mediaServerConfigEnabled) {
        this.mediaServerConfigEnabled = mediaServerConfigEnabled;
    }

    public InfrastructureProperties s3DefaultRegion(String s3DefaultRegion) {
        this.s3DefaultRegion = s3DefaultRegion;
        return this;
    }

    @Schema(description="Suggested S3 Region")
    public String getS3DefaultRegion() {
        return this.s3DefaultRegion;
    }

    public void setS3DefaultRegion(String s3DefaultRegion) {
        this.s3DefaultRegion = s3DefaultRegion;
    }

    public InfrastructureProperties s3EnforceDirectUpload(Boolean s3EnforceDirectUpload) {
        this.s3EnforceDirectUpload = s3EnforceDirectUpload;
        return this;
    }

    @Schema(description="&#128640; Since v4.15.0  Enforce direct upload to S3")
    public Boolean isS3EnforceDirectUpload() {
        return this.s3EnforceDirectUpload;
    }

    public void setS3EnforceDirectUpload(Boolean s3EnforceDirectUpload) {
        this.s3EnforceDirectUpload = s3EnforceDirectUpload;
    }

    public InfrastructureProperties isDracoonCloud(Boolean isDracoonCloud) {
        this.isDracoonCloud = isDracoonCloud;
        return this;
    }

    @Schema(description="&#128640; Since v4.21.0  Determines if the DRACOON Core is deployed in the cloud environment")
    public Boolean isIsDracoonCloud() {
        return this.isDracoonCloud;
    }

    public void setIsDracoonCloud(Boolean isDracoonCloud) {
        this.isDracoonCloud = isDracoonCloud;
    }

    public InfrastructureProperties tenantUuid(String tenantUuid) {
        this.tenantUuid = tenantUuid;
        return this;
    }

    @Schema(description="&#128640; Since v4.21.0  Current tenant UUID")
    public String getTenantUuid() {
        return this.tenantUuid;
    }

    public void setTenantUuid(String tenantUuid) {
        this.tenantUuid = tenantUuid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InfrastructureProperties infrastructureProperties = (InfrastructureProperties)o;
        return Objects.equals(this.smsConfigEnabled, infrastructureProperties.smsConfigEnabled) && Objects.equals(this.mediaServerConfigEnabled, infrastructureProperties.mediaServerConfigEnabled) && Objects.equals(this.s3DefaultRegion, infrastructureProperties.s3DefaultRegion) && Objects.equals(this.s3EnforceDirectUpload, infrastructureProperties.s3EnforceDirectUpload) && Objects.equals(this.isDracoonCloud, infrastructureProperties.isDracoonCloud) && Objects.equals(this.tenantUuid, infrastructureProperties.tenantUuid);
    }

    public int hashCode() {
        return Objects.hash(this.smsConfigEnabled, this.mediaServerConfigEnabled, this.s3DefaultRegion, this.s3EnforceDirectUpload, this.isDracoonCloud, this.tenantUuid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InfrastructureProperties {\n");
        sb.append("    smsConfigEnabled: ").append(this.toIndentedString(this.smsConfigEnabled)).append("\n");
        sb.append("    mediaServerConfigEnabled: ").append(this.toIndentedString(this.mediaServerConfigEnabled)).append("\n");
        sb.append("    s3DefaultRegion: ").append(this.toIndentedString(this.s3DefaultRegion)).append("\n");
        sb.append("    s3EnforceDirectUpload: ").append(this.toIndentedString(this.s3EnforceDirectUpload)).append("\n");
        sb.append("    isDracoonCloud: ").append(this.toIndentedString(this.isDracoonCloud)).append("\n");
        sb.append("    tenantUuid: ").append(this.toIndentedString(this.tenantUuid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

