/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Request model for sending an email of a Download Share link")
public class DownloadShareLinkEmail {
    @JsonProperty(value="recipients")
    private List<String> recipients = new ArrayList<String>();
    @JsonProperty(value="body")
    private String body = null;
    @JsonProperty(value="receiverLanguage")
    private String receiverLanguage = null;

    public DownloadShareLinkEmail recipients(List<String> recipients) {
        this.recipients = recipients;
        return this;
    }

    public DownloadShareLinkEmail addRecipientsItem(String recipientsItem) {
        this.recipients.add(recipientsItem);
        return this;
    }

    @Schema(required=true, description="List of recipient email addresses")
    public List<String> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<String> recipients) {
        this.recipients = recipients;
    }

    public DownloadShareLinkEmail body(String body) {
        this.body = body;
        return this;
    }

    @Schema(required=true, description="Notification email content")
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public DownloadShareLinkEmail receiverLanguage(String receiverLanguage) {
        this.receiverLanguage = receiverLanguage;
        return this;
    }

    @Schema(description="Language tag for messages to receiver")
    public String getReceiverLanguage() {
        return this.receiverLanguage;
    }

    public void setReceiverLanguage(String receiverLanguage) {
        this.receiverLanguage = receiverLanguage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownloadShareLinkEmail downloadShareLinkEmail = (DownloadShareLinkEmail)o;
        return Objects.equals(this.recipients, downloadShareLinkEmail.recipients) && Objects.equals(this.body, downloadShareLinkEmail.body) && Objects.equals(this.receiverLanguage, downloadShareLinkEmail.receiverLanguage);
    }

    public int hashCode() {
        return Objects.hash(this.recipients, this.body, this.receiverLanguage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DownloadShareLinkEmail {\n");
        sb.append("    recipients: ").append(this.toIndentedString(this.recipients)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    receiverLanguage: ").append(this.toIndentedString(this.receiverLanguage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

