/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AbstractExceptionMappingService;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.StringAppender;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import java.io.IOException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.client.HttpResponseException;
import org.nuxeo.onedrive.client.OneDriveAPIException;

public class GraphExceptionMappingService
extends AbstractExceptionMappingService<OneDriveAPIException> {
    public BackgroundException map(OneDriveAPIException failure) {
        if (failure.getResponseCode() > 0) {
            StringAppender buffer = new StringAppender();
            buffer.append(failure.getMessage());
            buffer.append(failure.getErrorMessage());
            return new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(failure.getResponseCode(), buffer.toString()));
        }
        if (ExceptionUtils.getRootCause((Throwable)failure) != failure && ExceptionUtils.getRootCause((Throwable)failure) instanceof IOException) {
            return new DefaultIOExceptionMappingService().map((IOException)ExceptionUtils.getRootCause((Throwable)failure));
        }
        return new InteroperabilityException(failure.getMessage(), (Throwable)failure);
    }
}

